/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AnalysisWithGBIFToGBIF
extends AnalysisBase {
    protected Stack<Object[]> rowRecycler = new Stack();
    protected Object[] nullRow = new Object[16];

    public AnalysisWithGBIFToGBIF() {
        int i = 0;
        while (i < this.nullRow.length) {
            this.nullRow[i] = null;
            ++i;
        }
    }

    @Override
    public void process(int type, int options) {
        PrintWriter pw;
        block34: {
            this.calcMaxScore();
            String gbifSQL = "SELECT DISTINCT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num ";
            String fromClause1a = "FROM raw WHERE collector_num LIKE ? AND year = ? AND genus = ?";
            String fromClause1b = "FROM raw WHERE collector_num IS NULL AND year = ? AND genus = ?";
            String postSQL = "FROM raw WHERE collector_num IS NOT NULL GROUP BY collector_num, year, genus";
            String srcSQL = "SELECT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num " + postSQL + " ORDER BY collector_num";
            String grphashSQL = "SELECT name FROM group_hash";
            String gbifgbifInsert = "INSERT INTO gbifgbif (reltype, score, GBIFID, SNIBID) VALUES (?,?,?,?)";
            Statement stmt = null;
            Statement gStmt1a = null;
            Statement gStmt1b = null;
            PreparedStatement gsStmt = null;
            Object[] refRow = new Object[16];
            Object[] cmpRow = new Object[16];
            long totalRecs = BasicSQLUtils.getCount(this.dbSrcConn, "SELECT COUNT(*) FROM group_hash").intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            String blank = "X?";
            pw = null;
            try {
                try {
                    pw = new PrintWriter("scoring_gbifgbif.log");
                    gStmt1a = this.dbGBIFConn.prepareStatement(String.valueOf(gbifSQL) + fromClause1a);
                    gStmt1b = this.dbGBIFConn.prepareStatement(String.valueOf(gbifSQL) + fromClause1b);
                    gsStmt = this.dbDstConn.prepareStatement(gbifgbifInsert);
                    stmt = this.dbSrcConn.createStatement(1000, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    System.out.println("Starting Query... " + totalRecs);
                    pw.println("Starting Query... " + totalRecs);
                    System.out.flush();
                    pw.flush();
                    HashSet<Integer> idHash = new HashSet<Integer>();
                    int writeCnt = 0;
                    ResultSet rs = stmt.executeQuery(grphashSQL);
                    System.out.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    pw.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    System.out.flush();
                    pw.flush();
                    Vector<Object[]> group = new Vector<Object[]>();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    while (rs.next()) {
                        Statement gStmt1;
                        String[] tokens = StringUtils.split((String)rs.getString(1), (char)'_');
                        String colNum = tokens[0].trim();
                        String year = tokens[1].trim();
                        String genus = tokens[2].trim();
                        if (StringUtils.isEmpty((String)colNum) || colNum.equals(blank)) {
                            colNum = null;
                        }
                        if (StringUtils.isEmpty((String)year) || year.equals(blank)) {
                            year = null;
                        }
                        if (StringUtils.isEmpty((String)genus) || genus.equals(blank)) {
                            genus = null;
                        }
                        if (colNum != null) {
                            gStmt1 = gStmt1a;
                            gStmt1.setString(1, "%" + colNum + "%");
                        } else {
                            gStmt1 = gStmt1b;
                            gStmt1.setString(1, null);
                        }
                        gStmt1.setString(2, year);
                        gStmt1.setString(3, genus);
                        ResultSet gRS = gStmt1.executeQuery();
                        ids.clear();
                        int maxNonNullTot = -1;
                        int maxNonNullInx = -1;
                        int inx = 0;
                        while (gRS.next()) {
                            Object[] row = this.getRow();
                            int cnt = this.fillRowWithScore(row, gRS);
                            if (cnt > maxNonNullTot) {
                                maxNonNullInx = inx;
                                maxNonNullTot = cnt;
                            }
                            group.add(row);
                            ids.add(gRS.getInt(1));
                            ++inx;
                        }
                        gRS.close();
                        if (inx < 2) {
                            for (Object[] r : group) {
                                this.recycleRow(r);
                            }
                            group.clear();
                            continue;
                        }
                        System.arraycopy(group.get(maxNonNullInx), 0, refRow, 0, refRow.length);
                        Integer srcId = (Integer)ids.get(maxNonNullInx);
                        int i = 0;
                        while (i < group.size()) {
                            int score;
                            if (i != maxNonNullInx && (score = this.score(refRow, (Object[])group.get(i))) > this.thresholdScore) {
                                ++writeCnt;
                                int gbifID = (Integer)ids.get(i);
                                gsStmt.setInt(1, 1);
                                gsStmt.setInt(2, score);
                                gsStmt.setInt(3, gbifID);
                                gsStmt.setInt(4, srcId);
                                gsStmt.executeUpdate();
                                idHash.add(gbifID);
                            }
                            ++i;
                        }
                        idHash.clear();
                        for (Object[] r : group) {
                            this.recycleRow(r);
                        }
                        group.clear();
                        if (gStmt1 == gStmt1b) continue;
                        gStmt1 = gStmt1b;
                        gStmt1.setString(1, year);
                        gStmt1.setString(2, genus);
                        gRS = gStmt1.executeQuery();
                        while (gRS.next()) {
                            int score;
                            this.fillRowWithScore(cmpRow, gRS);
                            int gbifID = gRS.getInt(1);
                            if (gbifID == srcId || (score = this.score(refRow, cmpRow)) <= this.thresholdScore) continue;
                            ++writeCnt;
                            gsStmt.setInt(1, 1);
                            gsStmt.setInt(2, score);
                            gsStmt.setInt(3, gbifID);
                            gsStmt.setInt(4, srcId);
                            gsStmt.executeUpdate();
                        }
                        gRS.close();
                        if (++procRecs % 500L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double timePerRecord = elapsedTime / procRecs;
                        double hrsLeft = (double)(totalRecs - procRecs) * timePerRecord / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        String msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                    rs.close();
                    System.out.println("Done.");
                    pw.println("Done.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (gStmt1a != null) {
                            gStmt1a.close();
                        }
                        if (gStmt1b != null) {
                            gStmt1b.close();
                        }
                        break block34;
                    }
                    catch (Exception exception) {}
                    break block34;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (gStmt1a != null) {
                        gStmt1a.close();
                    }
                    if (gStmt1b != null) {
                        gStmt1b.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (gStmt1a != null) {
                    gStmt1a.close();
                }
                if (gStmt1b != null) {
                    gStmt1b.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done.");
        pw.println("Done.");
        pw.flush();
        pw.close();
    }

    private Object[] getRow() {
        Object[] row = this.rowRecycler.size() == 0 ? new Object[16] : this.rowRecycler.pop();
        System.arraycopy(this.nullRow, 0, row, 0, row.length);
        return row;
    }

    private void recycleRow(Object[] row) {
        this.rowRecycler.push(row);
    }

    public static void main(String[] args) {
        AnalysisWithGBIFToGBIF awg = new AnalysisWithGBIFToGBIF();
        awg.createDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createSrcDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createDestDBConnection("localhost", "3306", "plants", "root", "root");
        awg.process(1, 32383);
        awg.endLogging();
        awg.cleanup();
    }
}

