/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.toycode.mexconabio.AnalysisBase;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;

public class AnalysisWithGBIF
extends AnalysisBase {
    @Override
    public void process(int type, int options) {
        PrintWriter pw;
        block24: {
            this.calcMaxScore();
            String fromClause1 = "FROM raw WHERE collector_num = ? AND year = ? AND genus = ?";
            String fromClause2 = "FROM raw WHERE collector_num IS NULL AND year = ? AND month = ? AND genus = ?";
            String michSQLFromClause = "FROM conabio WHERE CollNr IS NOT NULL ORDER BY CollNr";
            String gbifsnibInsert = "INSERT INTO gbifsnib (reltype, score, GBIFID, SNIBID) VALUES (?,?,?,?)";
            Statement stmt = null;
            Statement gStmt1 = null;
            Statement gStmt2 = null;
            PreparedStatement gsStmt = null;
            Object[] refRow = new Object[16];
            Object[] cmpRow = new Object[16];
            this.thresholdScore = 0;
            long totalRecs = BasicSQLUtils.getCount(this.dbSrcConn, "SELECT COUNT(*) FROM conabio").intValue();
            long procRecs = 0L;
            long startTime = System.currentTimeMillis();
            int secsThreshold = 0;
            pw = null;
            try {
                try {
                    pw = new PrintWriter("scoring.log");
                    gStmt1 = this.dbGBIFConn.prepareStatement("SELECT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num, institution_code " + fromClause1);
                    gStmt2 = this.dbGBIFConn.prepareStatement("SELECT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num, institution_code " + fromClause2);
                    gsStmt = this.dbDstConn.prepareStatement(gbifsnibInsert);
                    stmt = this.dbSrcConn.createStatement(1000, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    System.out.println("Starting Query... " + totalRecs);
                    pw.println("Starting Query... " + totalRecs);
                    HashSet<Integer> idHash = new HashSet<Integer>();
                    int writeCnt = 0;
                    ResultSet rs = stmt.executeQuery("SELECT BarCD, CollNr, Collectoragent1, GenusName, SpeciesName, SubSpeciesName, LocalityName, Datecollstandrd, COUNTRY, STATE, ID " + michSQLFromClause);
                    System.out.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    pw.println(String.format("Starting Processing... Total Records %d  Max Score: %d  Threshold: %d", totalRecs, this.maxScore, this.thresholdScore));
                    while (rs.next()) {
                        if (procRecs < 140L) {
                            ++procRecs;
                            continue;
                        }
                        this.fillMichRow(refRow, rs);
                        int michId = rs.getInt(11);
                        gStmt1.setString(1, (String)refRow[0]);
                        gStmt1.setString(2, (String)refRow[9]);
                        gStmt1.setString(3, (String)refRow[2]);
                        idHash.clear();
                        ResultSet gRS = gStmt1.executeQuery();
                        while (gRS.next()) {
                            this.fillGBIFRow(cmpRow, gRS);
                            int score = this.score(refRow, cmpRow);
                            if (score <= this.thresholdScore) continue;
                            ++writeCnt;
                            int gbifID = gRS.getInt(1);
                            gsStmt.setInt(1, 1);
                            gsStmt.setInt(2, score);
                            gsStmt.setInt(3, gbifID);
                            gsStmt.setInt(4, michId);
                            gsStmt.executeUpdate();
                            idHash.add(gbifID);
                        }
                        gRS.close();
                        gStmt2.setString(1, (String)refRow[9]);
                        gStmt2.setString(2, (String)refRow[10]);
                        gStmt2.setString(3, (String)refRow[2]);
                        gRS = gStmt2.executeQuery();
                        while (gRS.next()) {
                            int gbifID = gRS.getInt(1);
                            if (idHash.contains(gbifID)) continue;
                            cmpRow[1] = gRS.getString(2);
                            cmpRow[0] = gRS.getString(15);
                            cmpRow[2] = gRS.getString(3);
                            cmpRow[3] = gRS.getString(4);
                            cmpRow[4] = gRS.getString(5);
                            cmpRow[5] = gRS.getString(10);
                            cmpRow[6] = gRS.getString(11);
                            cmpRow[7] = gRS.getString(6);
                            cmpRow[8] = gRS.getString(7);
                            cmpRow[9] = gRS.getString(12);
                            cmpRow[10] = gRS.getString(13);
                            cmpRow[11] = gRS.getString(14);
                            cmpRow[12] = gRS.getString(8);
                            cmpRow[13] = gRS.getString(9);
                            int score = this.score(refRow, cmpRow);
                            if (score <= this.thresholdScore) continue;
                            ++writeCnt;
                            gsStmt.setInt(1, 2);
                            gsStmt.setInt(2, score);
                            gsStmt.setInt(3, gbifID);
                            gsStmt.setInt(4, michId);
                            gsStmt.executeUpdate();
                        }
                        gRS.close();
                        if (++procRecs % 500L != 0L) continue;
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        double timePerRecord = elapsedTime / procRecs;
                        double hrsLeft = (double)(totalRecs - procRecs) * timePerRecord / 3600000.0;
                        int seconds = (int)((double)elapsedTime / 60000.0);
                        if (secsThreshold == seconds) continue;
                        secsThreshold = seconds;
                        String msg = String.format("Elapsed %8.2f hr.mn   Percent: %6.3f  Hours Left: %8.2f ", (double)elapsedTime / 3600000.0, 100.0 * ((double)procRecs / (double)totalRecs), hrsLeft);
                        System.out.println(msg);
                        pw.println(msg);
                        pw.flush();
                    }
                    rs.close();
                    System.out.println("Done.");
                    pw.println("Done.");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (gStmt1 != null) {
                            gStmt1.close();
                        }
                        if (gStmt2 != null) {
                            gStmt2.close();
                        }
                        break block24;
                    }
                    catch (Exception exception) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (gStmt1 != null) {
                        gStmt1.close();
                    }
                    if (gStmt2 != null) {
                        gStmt2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (gStmt1 != null) {
                    gStmt1.close();
                }
                if (gStmt2 != null) {
                    gStmt2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done.");
        pw.println("Done.");
        pw.flush();
        pw.close();
    }

    public static void main(String[] args) {
        AnalysisWithGBIF awg = new AnalysisWithGBIF();
        awg.createDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createSrcDBConnection("localhost", "3306", "plants", "root", "root");
        awg.createDestDBConnection("localhost", "3306", "plants", "root", "root");
        awg.process(0, 0);
        awg.cleanup();
    }
}

