/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.util.AttachmentUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AnalysisBase {
    protected final double HRS = 3600000.0;
    protected final Calendar cal = Calendar.getInstance();
    protected final StringBuilder sb = new StringBuilder();
    public static final int NUM_FIELDS = 16;
    public static final int COLNUM_INX = 0;
    public static final int CATNUM_INX = 1;
    public static final int GENUS_INX = 2;
    public static final int SPECIES_INX = 3;
    public static final int SUBSPECIES_INX = 4;
    public static final int COLLECTOR_INX = 5;
    public static final int LOCALITY_INX = 6;
    public static final int LATITUDE_INX = 7;
    public static final int LONGITUDE_INX = 8;
    public static final int YEAR_INX = 9;
    public static final int MON_INX = 10;
    public static final int DAY_INX = 11;
    public static final int COUNTRY_INX = 12;
    public static final int STATE_INX = 13;
    public static final int INST_INX = 14;
    public static final int SCORE_INX = 15;
    protected static final int DO_COLNUM = 1;
    protected static final int DO_CATNUM = 2;
    protected static final int DO_GENUS = 4;
    protected static final int DO_SPECIES = 8;
    protected static final int DO_SUBSPECIES = 16;
    protected static final int DO_COLLECTOR = 32;
    protected static final int DO_LOCALITY = 64;
    protected static final int DO_LATITUDE = 128;
    protected static final int DO_LONGITUDE = 256;
    protected static final int DO_YEAR = 512;
    protected static final int DO_MON = 1024;
    protected static final int DO_COUNTRY = 8096;
    protected static final int DO_STATE = 16192;
    protected static final int DO_ALL = 32383;
    public static final String snibSQL = "SELECT IdSNIB, CatalogNumber, Genus, Species, Cataegoryinfraspecies, Latitude, Longitude, Country, LastNameFather, LastNameMother, FirstName, State, Locality, `Year`, `Month`, `Day`, CollectorNumber, InstitutionAcronym ";
    public static final String gbifSQL = "SELECT id, catalogue_number, genus, species, subspecies, latitude, longitude, country, state_province, collector_name, locality, year, month, day, collector_num, institution_code ";
    public static final String michSQL = "SELECT BarCD, CollNr, Collectoragent1, GenusName, SpeciesName, SubSpeciesName, LocalityName, Datecollstandrd, COUNTRY, STATE, ID ";
    public static final String CONN_STR = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
    protected String[] titles = new String[]{"Collector<BR>Number", "Catalog<BR>Number", "Genus", "Species", "SubSpecies", "Collector", "Locality", "Latitude", "Longitude", "Year", "Mon", "Day", "Country", "State", "Institution<BR>Code", "Matching<BR>Score"};
    protected int[] MAXSCORES;
    protected int maxScore;
    protected int thresholdScore;
    protected static String BGR = "bgr";
    protected static String GR = "gr";
    protected static String BYW = "byw";
    protected static String YW = "yw";
    protected static String DF = "df";
    protected static String RD = "rd";
    protected static String BL = "bl";
    protected String[] tdColorCodes;
    protected Vector<String> toks;
    protected char[] seps;
    protected ConversionLogger convLogger;
    protected SimpleDateFormat sdf;
    protected TableWriter tblWriter;
    protected String[] strNulls;
    protected String[] objNulls;
    protected HashMap<Integer, String> instHashMap;
    protected Connection dbGBIFConn;
    protected Connection dbSrcConn;
    protected Connection dbDstConn;
    protected Connection dbLMConn;
    static int rowScore = 0;

    public AnalysisBase() {
        int[] nArray = new int[15];
        nArray[2] = 15;
        nArray[3] = 20;
        nArray[4] = 20;
        nArray[5] = 10;
        nArray[6] = 10;
        nArray[9] = 10;
        nArray[10] = 10;
        nArray[11] = 10;
        nArray[12] = 10;
        nArray[13] = 10;
        this.MAXSCORES = nArray;
        this.maxScore = 0;
        this.thresholdScore = 50;
        this.toks = new Vector();
        this.seps = new char[]{'`', '~', '|', '+'};
        this.convLogger = new ConversionLogger();
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.tblWriter = null;
        this.strNulls = new String[16];
        this.objNulls = new String[16];
        this.instHashMap = new HashMap();
        this.dbGBIFConn = null;
        this.dbSrcConn = null;
        this.dbDstConn = null;
        this.dbLMConn = null;
        this.tdColorCodes = new String[16];
        int i = 0;
        while (i < 16) {
            this.strNulls[i] = null;
            this.objNulls[i] = null;
            ++i;
        }
        System.arraycopy(this.strNulls, 0, this.tdColorCodes, 0, 16);
    }

    public String[] getTDColorCodes() {
        return this.tdColorCodes;
    }

    public void startLogging(String baseDirName, String dirName, String fileName, String title) {
        this.convLogger.initialize(baseDirName, dirName);
        this.startNewDocument(fileName, title, true);
    }

    public void startLogging(String baseDirName, String dirName, String fileName, String title, boolean includeTable) {
        this.convLogger.initialize(baseDirName, dirName);
        this.startNewDocument(fileName, title, includeTable);
    }

    public void startLogging(String baseDirName, String dirName, String fileName, String title, boolean includeTable, Integer width) {
        this.convLogger.initialize(baseDirName, dirName);
        this.startNewDocument(fileName, title, includeTable, width);
    }

    public int getMaxScore() {
        return this.maxScore;
    }

    public static int getRowScore() {
        return rowScore;
    }

    protected String getStyle() {
        StringBuilder extraStyle = new StringBuilder();
        extraStyle.append("TD.yw  { color: rgb(200, 200, 0); }\n");
        extraStyle.append("TD.gr  { color: rgb(200, 0, 200); }\n");
        extraStyle.append("TD.bgr { color: rgb(0, 255, 0); }\n");
        extraStyle.append("TD.byw { color: yellow; }\n");
        extraStyle.append("TD.df  { color: rgb(100, 255, 200); }\n");
        extraStyle.append("TD.rd  { color: rgb(255, 0, 0); }\n");
        extraStyle.append("TD.bl  { color: rgb(0, 0, 0); }\n");
        extraStyle.append("TR.od  { background-color: rgb(240, 240, 240); }\n");
        extraStyle.append("TR.ev  { background-color: rgb(232, 242, 254); }\n");
        extraStyle.append("TR.odh { font-weight: bold; background-color: rgb(240, 240, 240); }\n");
        extraStyle.append("TR.evh { font-weight: bold; background-color: rgb(232, 242, 254); }\n");
        extraStyle.append(" TABLE.o tr.hd { border-top: solid 2px rgb(0, 0, 0); border-left: solid 1px rgb(128, 128, 128); }\n");
        return extraStyle.toString();
    }

    public void startNewDocument(String fileName, String title, boolean includeTable) {
        this.startNewDocument(fileName, title, includeTable, null);
    }

    public void startNewDocument(String fileName, String title, boolean includeTable, Integer width) {
        if (this.tblWriter != null) {
            this.tblWriter.close();
        }
        this.tblWriter = this.convLogger.getWriter(fileName, title, this.getStyle());
        if (includeTable) {
            if (width == null) {
                this.tblWriter.startTable();
            } else {
                this.tblWriter.startTable(width);
            }
            this.tblWriter.logHdr(this.titles);
        }
    }

    public void endLogging() {
        this.endLogging(false);
    }

    public void endLogging(boolean byOrderAdded) {
        File indexFile = this.convLogger.closeAll(byOrderAdded);
        try {
            AttachmentUtils.openURI(indexFile.toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void retrieveInstitutionNames() {
        block13: {
            Connection conn = null;
            try {
                try {
                    conn = this.createConnection("lm2gbdb.nhm.ku.edu", "3399", "gbc20100726", "rods", "specify4us");
                    System.out.println("Getting Institutions");
                    for (Object[] row : BasicSQLUtils.query(conn, "SELECT data_provider_id, name FROM data_provider")) {
                        this.instHashMap.put((Integer)row[0], (String)row[0]);
                    }
                    System.out.println("Done Getting Institutions");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (conn == null) break block13;
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected String getStr(ResultSet rs, int colInx) throws SQLException {
        Object obj = rs.getObject(colInx);
        return obj != null ? ((String)obj).trim() : null;
    }

    protected static boolean isOn(int options, int opt) {
        return (options & opt) == opt;
    }

    protected int getInt(String str) {
        if (StringUtils.isNotEmpty((String)str) && StringUtils.isNumeric((String)str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }

    private Object cntObject(Object obj) {
        if (obj != null) {
            ++rowScore;
        }
        return obj;
    }

    protected void clearRowAttrs(Object[] row) {
        System.arraycopy(this.strNulls, 0, this.tdColorCodes, 0, 16);
        if (row != null) {
            System.arraycopy(this.objNulls, 0, row, 0, 16);
        }
    }

    protected String getIntToStr(Object val) {
        if (val != null && val instanceof Integer) {
            return Integer.toString((Integer)val);
        }
        return null;
    }

    public void clearRowAttrs() {
        this.clearRowAttrs(null);
    }

    protected void writeRow(String trClass, Object[] row, String[] colorCodes) {
        this.tblWriter.println(String.format("<TR class=\"%s\">", trClass));
        int i = 0;
        while (i < 16) {
            this.tblWriter.logTDCls(colorCodes != null ? colorCodes[i] : null, row[i] != null ? row[i].toString() : "");
            ++i;
        }
        this.tblWriter.println("</TR>");
    }

    public void fillMichRow(Object[] refRow, ResultSet rs) throws SQLException {
        int day;
        int mon;
        int year;
        String catNum = rs.getString(1);
        String collectorNum = rs.getString(2);
        String collector = rs.getString(3);
        String genus = rs.getString(4);
        String species = rs.getString(5);
        String subspecies = rs.getString(6);
        String locality = rs.getString(7);
        Date collDate = rs.getDate(8);
        String country = rs.getString(9);
        String state = rs.getString(10);
        if (collDate != null) {
            this.cal.setTime(collDate);
            year = this.cal.get(1);
            mon = this.cal.get(2) + 1;
            day = this.cal.get(5);
        } else {
            year = 0;
            mon = 0;
            day = 0;
        }
        refRow[1] = catNum;
        refRow[0] = collectorNum;
        refRow[2] = genus;
        refRow[3] = species;
        refRow[4] = subspecies;
        refRow[5] = collector;
        refRow[6] = locality;
        refRow[7] = null;
        refRow[8] = null;
        refRow[9] = year > 0 ? Integer.toString(year) : null;
        refRow[10] = year > 0 ? Integer.toString(mon) : null;
        refRow[11] = year > 0 ? Integer.toString(day) : null;
        refRow[12] = country;
        refRow[13] = state;
        refRow[14] = "MICH";
        int i = 0;
        while (i < 15) {
            if (refRow[i] != null) {
                refRow[i] = ((String)refRow[i]).trim();
            }
            ++i;
        }
    }

    public void fillSNIBRow(Object[] cmpRow, ResultSet rs) throws SQLException {
        cmpRow[1] = rs.getString(2);
        cmpRow[0] = rs.getString(17);
        cmpRow[2] = rs.getString(3);
        cmpRow[3] = rs.getString(4);
        cmpRow[4] = rs.getString(5);
        cmpRow[6] = rs.getString(13);
        cmpRow[7] = rs.getString(6);
        cmpRow[8] = rs.getString(7);
        cmpRow[9] = this.getIntToStr(rs.getObject(14));
        cmpRow[10] = this.getIntToStr(rs.getObject(15));
        cmpRow[11] = this.getIntToStr(rs.getObject(16));
        cmpRow[12] = rs.getString(16);
        cmpRow[13] = rs.getString(12);
        cmpRow[14] = rs.getString(18);
        String fatherName = rs.getString(9);
        String motherName = rs.getString(10);
        String firstName = rs.getString(11);
        boolean hasFather = StringUtils.isNotEmpty((String)fatherName);
        boolean hasMother = StringUtils.isNotEmpty((String)motherName);
        boolean hasFirst = StringUtils.isNotEmpty((String)firstName);
        this.sb.setLength(0);
        if (hasFather) {
            this.sb.append(fatherName);
        }
        if (hasMother) {
            if (hasFather) {
                this.sb.append(", ");
            }
            this.sb.append(motherName);
        }
        if (hasFirst) {
            if (hasFather || hasMother) {
                this.sb.append(", ");
            }
            this.sb.append(firstName);
        }
        cmpRow[5] = this.sb.toString();
        int i = 0;
        while (i < 15) {
            if (cmpRow[i] != null) {
                cmpRow[i] = ((String)cmpRow[i]).trim();
            }
            ++i;
        }
    }

    public void fillGBIFRow(Object[] cmpRow, ResultSet rs) throws SQLException {
        cmpRow[1] = rs.getString(2);
        cmpRow[0] = rs.getString(15);
        cmpRow[2] = rs.getString(3);
        cmpRow[3] = rs.getString(4);
        cmpRow[4] = rs.getString(5);
        cmpRow[5] = rs.getString(10);
        cmpRow[6] = rs.getString(11);
        cmpRow[7] = rs.getString(6);
        cmpRow[8] = rs.getString(7);
        cmpRow[9] = rs.getString(12);
        cmpRow[10] = rs.getString(13);
        cmpRow[11] = rs.getString(14);
        cmpRow[12] = rs.getString(8);
        cmpRow[13] = rs.getString(9);
        String instCode = rs.getString(16);
        cmpRow[14] = StringUtils.isNotEmpty((String)instCode) && instCode.length() > 8 ? instCode.substring(0, 8) : instCode;
        int i = 0;
        while (i < 15) {
            if (cmpRow[i] != null) {
                cmpRow[i] = ((String)cmpRow[i]).trim();
            }
            ++i;
        }
        if (cmpRow[9] != null && StringUtils.isNotEmpty((String)((String)cmpRow[9]))) {
            cmpRow[10] = null;
        }
        if (cmpRow[10] != null && StringUtils.isNotEmpty((String)((String)cmpRow[10]))) {
            cmpRow[9] = null;
        }
        if (cmpRow[11] != null && StringUtils.isNotEmpty((String)((String)cmpRow[11]))) {
            cmpRow[11] = null;
        }
    }

    public int fillRowWithScore(Object[] cmpRow, ResultSet gRS) throws SQLException {
        rowScore = 0;
        cmpRow[1] = this.cntObject(gRS.getString(2));
        cmpRow[0] = this.cntObject(gRS.getString(15));
        cmpRow[2] = this.cntObject(gRS.getString(3));
        cmpRow[3] = this.cntObject(gRS.getString(4));
        cmpRow[4] = this.cntObject(gRS.getString(5));
        cmpRow[6] = this.cntObject(gRS.getString(11));
        cmpRow[7] = this.cntObject(gRS.getString(6));
        cmpRow[8] = this.cntObject(gRS.getString(7));
        cmpRow[9] = this.cntObject(gRS.getString(12));
        cmpRow[10] = this.cntObject(gRS.getString(13));
        cmpRow[11] = this.cntObject(gRS.getString(14));
        cmpRow[12] = this.cntObject(gRS.getString(8));
        cmpRow[13] = this.cntObject(gRS.getString(9));
        cmpRow[5] = this.cntObject(gRS.getString(10));
        int i = 0;
        while (i < 15) {
            if (cmpRow[i] != null) {
                cmpRow[i] = ((String)cmpRow[i]).trim();
            }
            ++i;
        }
        if (cmpRow[0] != null) {
            rowScore += 15;
        }
        if (cmpRow[2] != null) {
            rowScore += 10;
        }
        if (cmpRow[3] != null) {
            rowScore += 10;
        }
        if (cmpRow[12] != null) {
            rowScore += 8;
        }
        if (cmpRow[9] != null) {
            rowScore += 10;
        }
        if (cmpRow[10] != null) {
            rowScore += 5;
        }
        return rowScore;
    }

    protected void colorCode(Object[] row, int[] scores, String[] codes) {
    }

    protected int compareDate(String yearStr, String monStr, String dayStr, String refYearStr, String refMonStr, String refDayStr) {
        int year = this.getInt(yearStr);
        int mon = this.getInt(monStr);
        int day = this.getInt(dayStr);
        int refYear = this.getInt(refYearStr);
        int refMon = this.getInt(refMonStr);
        int refDay = this.getInt(refDayStr);
        int score = 0;
        if (year == refYear && mon == refMon && day == refDay && year != 0 && mon != 0 && day != 0) {
            score = 30;
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = BGR;
            this.tdColorCodes[11] = BGR;
        } else if (year == refYear && mon == refMon && year != 0 && mon != 0) {
            score = 20;
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = BGR;
            this.tdColorCodes[11] = RD;
        } else if (year == refYear) {
            score = 10;
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = RD;
            this.tdColorCodes[11] = RD;
        }
        return score;
    }

    protected int compareDate(int year, int mon, int day, int refYear, int refMon, int refDay) {
        int score = 0;
        if (year == refYear && mon == refMon && day == refDay && year != 0 && mon != 0 && day != 0) {
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = BGR;
            this.tdColorCodes[11] = BGR;
            score = 30;
        } else if (year == refYear && mon == refMon && year != 0 && mon != 0) {
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = BGR;
            this.tdColorCodes[11] = RD;
            score = 20;
        } else if (year == refYear) {
            this.tdColorCodes[9] = BGR;
            this.tdColorCodes[10] = RD;
            this.tdColorCodes[11] = RD;
            score = 10;
        }
        return score;
    }

    protected void calcMaxScore() {
        this.maxScore = 0;
        int[] nArray = this.MAXSCORES;
        int n = this.MAXSCORES.length;
        int n2 = 0;
        while (n2 < n) {
            int sc = nArray[n2];
            this.maxScore += sc;
            ++n2;
        }
        this.thresholdScore = this.maxScore / 2;
    }

    public int score(Object[] refRow, Object[] compareRow) {
        if (this.maxScore == 0) {
            this.calcMaxScore();
        }
        String refCollectorNum = (String)refRow[0];
        String refGenus = (String)refRow[2];
        String refSpecies = (String)refRow[3];
        String refSubSpecies = (String)refRow[4];
        String refCollector = (String)refRow[5];
        String refLocality = (String)refRow[6];
        String refYear = (String)refRow[9];
        String refMon = (String)refRow[10];
        String refDay = (String)refRow[11];
        String refCountry = (String)refRow[12];
        String refState = (String)refRow[13];
        String collectorNum = (String)compareRow[0];
        String genus = (String)compareRow[2];
        String species = (String)compareRow[3];
        String subSpecies = (String)compareRow[4];
        String collector = (String)compareRow[5];
        String locality = (String)compareRow[6];
        String year = (String)compareRow[9];
        String mon = (String)compareRow[10];
        String day = (String)compareRow[11];
        String country = (String)compareRow[12];
        String state = (String)compareRow[13];
        if (country != null && country.toLowerCase().equals("mexico")) {
            country = "M\u00e9xico";
        }
        if (refCountry != null && refCountry.toLowerCase().equals("mexico")) {
            refCountry = "M\u00e9xico";
        }
        if (StringUtils.isNotEmpty((String)refCollector)) {
            refCollector = StringUtils.replaceChars((String)refCollector, (char)',', (char)' ');
        }
        if (StringUtils.isNotEmpty((String)collector)) {
            collector = StringUtils.replaceChars((String)collector, (char)',', (char)' ');
        }
        int score = 0;
        score += this.compareDate(year, mon, day, refYear, refMon, refDay);
        String refCollectorStr = refCollector != null ? refCollector.toLowerCase() : "";
        String collectorStr = collector != null ? collector.toLowerCase() : "";
        String refLocStr = refLocality != null ? refLocality.toLowerCase() : "";
        String locStr = locality != null ? locality.toLowerCase() : "";
        double ratingLoc = this.longStringCompare(refLocStr, locStr, false, true);
        double ratingColtr = this.longStringCompare(refCollectorStr, collectorStr, false, true);
        if (ratingLoc > 50.0) {
            score += 10;
            this.tdColorCodes[6] = BGR;
        } else if (ratingLoc > 30.0) {
            score += 6;
            this.tdColorCodes[6] = GR;
        } else if (ratingLoc > 0.0) {
            score += 3;
            this.tdColorCodes[6] = YW;
        }
        if (ratingColtr > 50.0) {
            score += 10;
            this.tdColorCodes[5] = BGR;
        } else if (ratingColtr > 30.0) {
            score += 6;
            this.tdColorCodes[5] = GR;
        } else if (ratingColtr > 0.0) {
            score += 3;
            this.tdColorCodes[5] = YW;
        }
        boolean genusMatches = false;
        if (refGenus != null && genus != null) {
            if (refGenus.equals(genus)) {
                score += 15;
                genusMatches = true;
                this.tdColorCodes[2] = GR;
            } else if (StringUtils.getLevenshteinDistance((String)genus, (String)refGenus) < 3) {
                score += 7;
                this.tdColorCodes[2] = YW;
            }
        }
        boolean speciesMatches = false;
        if (refSpecies != null && species != null) {
            if (refSpecies.equals(species)) {
                score += 20;
                speciesMatches = true;
                if (genusMatches) {
                    this.tdColorCodes[2] = BGR;
                    this.tdColorCodes[3] = BGR;
                } else {
                    this.tdColorCodes[3] = GR;
                }
            } else if (StringUtils.getLevenshteinDistance((String)species, (String)refSpecies) < 3) {
                score += 10;
                this.tdColorCodes[3] = YW;
            }
        }
        if (refSubSpecies != null && subSpecies != null) {
            if (refSubSpecies.equals(subSpecies)) {
                score += 20;
                if (genusMatches && speciesMatches) {
                    this.tdColorCodes[2] = BGR;
                    this.tdColorCodes[3] = BGR;
                    this.tdColorCodes[4] = BGR;
                } else if (speciesMatches) {
                    this.tdColorCodes[3] = BGR;
                    this.tdColorCodes[4] = BGR;
                } else {
                    this.tdColorCodes[4] = GR;
                }
            } else if (StringUtils.getLevenshteinDistance((String)subSpecies, (String)refSubSpecies) < 3) {
                score += 10;
                this.tdColorCodes[4] = YW;
            }
        }
        if (refCountry != null && country != null) {
            if ((refCountry = refCountry.toLowerCase()).equals(country = country.toLowerCase())) {
                score += 10;
                this.tdColorCodes[12] = BGR;
            } else if (StringUtils.getLevenshteinDistance((String)country, (String)refCountry) < 3) {
                score += 5;
                this.tdColorCodes[12] = YW;
            }
        }
        if (refState != null && state != null) {
            if ((refState = refState.toLowerCase()).equals(state = state.toLowerCase())) {
                score += 10;
                this.tdColorCodes[13] = BGR;
            } else if (StringUtils.getLevenshteinDistance((String)state, (String)refState) < 3) {
                score += 5;
                this.tdColorCodes[13] = YW;
            }
        }
        if (collectorNum != null && refCollectorNum != null && collectorNum.equals(refCollectorNum)) {
            score += 10;
            this.tdColorCodes[0] = BGR;
        }
        return score;
    }

    protected String cleanString(String str, boolean usePeriods, boolean replaceWithSpaces) {
        String s = StringUtils.remove((String)str, (char)':');
        if (!usePeriods) {
            s = replaceWithSpaces ? StringUtils.replaceChars((String)s, (char)'.', (char)' ') : StringUtils.remove((String)s, (char)'.');
        }
        s = StringUtils.remove((String)s, (char)'-');
        s = StringUtils.remove((String)s, (char)',');
        return s;
    }

    protected double longStringCompare(String str1, String str2, boolean usePeriods, boolean replaceWithSpaces) {
        String[] shortToks;
        String shortStr;
        String longStr;
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        if (str1.length() >= str2.length()) {
            longStr = str1;
            shortStr = str2;
        } else {
            longStr = str2;
            shortStr = str1;
        }
        longStr = this.cleanString(longStr, usePeriods, replaceWithSpaces);
        shortStr = this.cleanString(shortStr, usePeriods, replaceWithSpaces);
        int score = 0;
        String[] longToks = StringUtils.split((String)longStr, (String)" ");
        String[] stringArray = shortToks = StringUtils.split((String)shortStr, (String)" ");
        int n = shortToks.length;
        int n2 = 0;
        while (n2 < n) {
            String sStr = stringArray[n2];
            String[] stringArray2 = longToks;
            int n3 = longToks.length;
            int n4 = 0;
            while (n4 < n3) {
                String lStr = stringArray2[n4];
                if (lStr.equals(sStr) || sStr.length() > 2 && StringUtils.getLevenshteinDistance((String)lStr, (String)sStr) < 3) {
                    ++score;
                }
                ++n4;
            }
            ++n2;
        }
        double rating = (double)score / (double)shortToks.length * 100.0;
        return rating;
    }

    public void setColorsForJTable() {
        BGR = "0, 100, 0";
        GR = "200, 0, 200";
        BYW = "255, 255, 0";
        YW = "184, 134, 11";
        DF = "100, 255, 200";
        RD = "255, 0, 0";
        BL = "128, 128, 128";
    }

    protected Connection createConnection(String server, String port, String dbName, String username, String pwd) {
        try {
            return DriverManager.getConnection(String.format(CONN_STR, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createDBConnection(String server, String port, String dbName, String username, String pwd) {
        this.dbGBIFConn = this.createConnection(server, port, dbName, username, pwd);
    }

    public void createSrcDBConnection(String server, String port, String dbName, String username, String pwd) {
        this.dbSrcConn = this.createConnection(server, port, dbName, username, pwd);
    }

    public void createDestDBConnection(String server, String port, String dbName, String username, String pwd) {
        this.dbDstConn = this.createConnection(server, port, dbName, username, pwd);
    }

    public void createLMDBConnection(String server, String port, String dbName, String username, String pwd) {
        this.dbLMConn = this.createConnection(server, port, dbName, username, pwd);
    }

    public void process(int type, int options) {
    }

    public void cleanup() {
        try {
            if (this.dbGBIFConn != null) {
                this.dbGBIFConn.close();
            }
            if (this.dbSrcConn != null) {
                this.dbSrcConn.close();
            }
            if (this.dbDstConn != null) {
                this.dbDstConn.close();
            }
            if (this.dbLMConn != null) {
                this.dbLMConn.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Connection getGBIFDBConn() {
        return this.dbGBIFConn;
    }

    public Connection getSrcDBConn() {
        return this.dbSrcConn;
    }

    public Connection getDstDBConn() {
        return this.dbDstConn;
    }

    public Connection getLMDBConn() {
        return this.dbLMConn;
    }
}

