/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode.mexconabio;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AgentNames {
    private static final String connStr = "jdbc:mysql://localhost/%s?characterEncoding=UTF-8&autoReconnect=true";
    private Connection oldDBConn = null;
    private Connection newDBConn = null;
    private String oldDBName;
    private String newDBName;

    public AgentNames(String oldDBName, String newDBName) {
        this.oldDBName = oldDBName;
        this.newDBName = newDBName;
        try {
            this.oldDBConn = DriverManager.getConnection(String.format(connStr, oldDBName), "root", "root");
            this.newDBConn = DriverManager.getConnection(String.format(connStr, newDBName), "root", "root");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.oldDBConn.close();
            this.newDBConn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void parseForFirstLastName(String str) {
        if (StringUtils.contains((String)str, (char)',')) {
            String[] toks = StringUtils.split((String)str, (char)',');
            String lastName = toks[0].trim();
            String first = "";
            if (toks.length > 1) {
                first = toks[1].trim();
            }
            System.out.println("    [" + first + "][" + lastName + "] " + (StringUtils.contains((String)first, (char)'.') ? "*" : ""));
        } else {
            System.out.println("    [" + str.trim() + "]");
        }
    }

    private void parseForNames(String nameStr) {
        String str = nameStr;
        if (StringUtils.contains((String)str, (char)'\"')) {
            str = StringUtils.remove((String)str, (char)'\"');
        }
        if (StringUtils.contains((String)str, (char)';')) {
            String[] toks;
            String[] stringArray = toks = StringUtils.split((String)str, (char)';');
            int n = toks.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.parseForFirstLastName(s);
                ++n2;
            }
        } else {
            this.parseForFirstLastName(str);
        }
        System.out.println();
    }

    public void process() {
        String sql = "SELECT collector_name FROM raw WHERE collector_name IS NOT NULL limit 4000,1000";
        try {
            Statement stmt = this.oldDBConn.createStatement(1000, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String str = rs.getString(1);
                System.out.println("\n" + str);
                this.parseForNames(str);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Vector<String> getDatabases() {
        Vector<String> names = new Vector<String>();
        String sql = "SELECT `TABLES`.TABLE_SCHEMA FROM `TABLES` WHERE `TABLES`.TABLE_NAME = 'agent'";
        for (Object dbName : BasicSQLUtils.querySingleCol(this.oldDBConn, sql)) {
            sql = "SELECT COUNT(*) FROM `TABLES` WHERE `TABLES`.TABLE_NAME = 'spversion' AND `TABLES`.TABLE_SCHEMA = '" + dbName + "'";
            if (BasicSQLUtils.getCount(this.oldDBConn, sql) != 1 || dbName.equals("information_schema")) continue;
            names.add(dbName.toString());
            System.out.println(dbName.toString());
        }
        return names;
    }

    protected void findBadAgents() {
        Connection dbConn = null;
        try {
            Vector<String> names = this.getDatabases();
            System.out.println("-------------- Bad Agent Databases ------------------");
            for (String dbName : names) {
                String sql;
                dbConn = DriverManager.getConnection(String.format(connStr, dbName), "root", "root");
                int cnt = BasicSQLUtils.getCountAsInt(dbConn, sql = "SELECT COUNT(*) FROM agent WHERE LastName IS NOT NULL AND (LastName LIKE '%;%' OR LastName LIKE '%,%')");
                if (cnt > 1) {
                    System.out.println(String.valueOf(dbName) + " " + cnt);
                    if (cnt > 1) {
                        sql = "SELECT LastName, FirstName, MiddleInitial FROM agent WHERE LastName IS NOT NULL AND (LastName LIKE '%;%' OR LastName LIKE '%,%') LIMIT 0,10";
                        for (Object[] row : BasicSQLUtils.query(dbConn, sql)) {
                            String lastName = (String)row[0];
                            String firstName = (String)row[1];
                            String middleInit = (String)row[1];
                            lastName = StringUtils.replaceChars((String)lastName, (char)'\n', (char)' ');
                            System.out.println("  [" + lastName + "][" + (firstName == null ? "" : firstName) + "][" + (middleInit == null ? "" : middleInit) + "]");
                            this.parseForNames(lastName);
                        }
                    }
                }
                dbConn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void test() {
        String[] lastNames = new String[]{"White, Siri & Lichtw.", "Valle, White and Cafaro", "Luttrell, Davis, and Abe", "J.E.T., T.A.P., & R.E.N.", "Fenwick, Mark & Stevens, Darren", "Fautin, D. & Cox, S.", "Bruce, N.L. & Thiel, M.", "G. E. Crow, with Barry Hammel, Francisco Morales", "G. E. Crow, D. I. Rivera, C. Charpentier]", "F. Smith, V. Grant & R. Rukavina", "C.A. Taylor, Jr.", "Brad G. Millen, Susan M. Woodward (ROM)", "Continental Shelf Associates, Inc."};
    }

    public static void main(String[] args) {
        AgentNames an = new AgentNames("information_schema", "kui_fish_dbo_6");
        an.findBadAgents();
        an.shutdown();
    }
}

