/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.BrowseBtnPanel;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.toycode.UpdateDescriptor;
import edu.ku.brc.specify.toycode.UpdateEntry;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class UpdatesApp
extends JPanel {
    protected static boolean doingCmdLine = false;
    protected BrowseBtnPanel baseBBP = null;
    protected BrowseBtnPanel baseUpBBP = null;
    protected BrowseBtnPanel macFullBBP = null;
    protected BrowseBtnPanel macUpBBP = null;
    protected BrowseBtnPanel outBBP = null;
    protected JTextField baseTF = new JTextField(40);
    protected JTextField baseUpTF = new JTextField(40);
    protected JTextField macFullTF = new JTextField(40);
    protected JTextField macUpTF = new JTextField(40);
    protected JTextField outTF = new JTextField(40);
    protected JTextField statusTF = new JTextField();
    protected JTextField versionTF = new JTextField(2);
    protected JTextField updateBaseTF = new JTextField();
    protected JButton mergeBtn = new JButton("Merge");
    protected JSpinner verSub1;
    protected JSpinner verSub2;
    protected UpdateDescriptor baseUpdateDesc;
    protected UpdateDescriptor baseUpdateUpDesc;
    protected UpdateDescriptor maxFullUpdateDesc;
    protected UpdateDescriptor maxUpUpdateDesc;
    protected Properties props = null;

    public UpdatesApp() {
        if (!doingCmdLine) {
            this.createUI();
        }
    }

    protected void createUI() {
        this.baseBBP = new BrowseBtnPanel(this.baseTF, false, true);
        this.baseUpBBP = new BrowseBtnPanel(this.baseUpTF, false, true);
        this.macFullBBP = new BrowseBtnPanel(this.macFullTF, false, true);
        this.macUpBBP = new BrowseBtnPanel(this.macUpTF, false, true);
        this.outBBP = new BrowseBtnPanel(this.outTF, false, true);
        this.verSub1 = new JSpinner();
        this.verSub2 = new JSpinner();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g,p", UIHelper.createDuplicateJGoodiesDef("p:g", "4px", 7)));
        CellConstraints cc = new CellConstraints();
        int y = 1;
        pb.add((Component)UIHelper.createLabel("Linux/Win Full:", 4), cc.xy(1, y));
        pb.add((Component)this.baseBBP, cc.xyw(3, y, 3));
        pb.add((Component)UIHelper.createLabel("Linux/Win Update:", 4), cc.xy(1, y += 2));
        pb.add((Component)this.baseUpBBP, cc.xyw(3, y, 3));
        pb.add((Component)UIHelper.createLabel("Mac Full:", 4), cc.xy(1, y += 2));
        pb.add((Component)this.macFullBBP, cc.xyw(3, y, 3));
        pb.add((Component)UIHelper.createLabel("Mac Update:", 4), cc.xy(1, y += 2));
        pb.add((Component)this.macUpBBP, cc.xyw(3, y, 3));
        pb.add((Component)UIHelper.createLabel("Output:", 4), cc.xy(1, y += 2));
        pb.add((Component)this.outBBP, cc.xyw(3, y, 3));
        this.updateBaseTF.setText("6.0.0");
        pb.add((Component)UIHelper.createLabel("Update Base Version:", 4), cc.xy(1, y += 2));
        pb.add((Component)this.updateBaseTF, cc.xy(3, y));
        y += 2;
        this.versionTF.setText("6");
        this.verSub1.setValue(99);
        this.verSub2.setValue(99);
        PanelBuilder vpb = new PanelBuilder(new FormLayout("p,p,p:g,p,p:g,f:p:g", "p"));
        vpb.add((Component)this.versionTF, cc.xy(1, 1));
        vpb.add((Component)UIHelper.createLabel("."), cc.xy(2, 1));
        vpb.add((Component)this.verSub1, cc.xy(3, 1));
        vpb.add((Component)UIHelper.createLabel("."), cc.xy(4, 1));
        vpb.add((Component)this.verSub2, cc.xy(5, 1));
        pb.add((Component)UIHelper.createLabel("New Version:", 4), cc.xy(1, y));
        pb.add((Component)vpb.getPanel(), cc.xyw(3, y, 1));
        y += 2;
        PanelBuilder pb2 = new PanelBuilder(new FormLayout("p,2px,p,f:p:g,p", "p"));
        this.statusTF.setBackground(this.getBackground());
        pb2.add((Component)this.statusTF, cc.xyw(1, 1, 4));
        pb2.add((Component)this.mergeBtn, cc.xy(5, 1));
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(14, 14, 1, 14));
        this.setLayout(new BorderLayout());
        this.add((Component)pb.getPanel(), "Center");
        this.add((Component)pb2.getPanel(), "South");
        try {
            XStream xstream = new XStream();
            this.props = (Properties)xstream.fromXML(FileUtils.readFileToString((File)new File("props.init")));
        }
        catch (Exception ex) {
            this.props = new Properties();
        }
        this.baseTF.setText(this.props.getProperty("baseTF", "MacMedia/updates.xml.winlinfull.6.1.17"));
        this.baseUpTF.setText(this.props.getProperty("baseUpTF", "MacMedia/updates.xml.winlinupdate.6.1.17"));
        this.macFullTF.setText(this.props.getProperty("macFullTF", "MacMedia/updates_mac.xml"));
        this.macUpTF.setText(this.props.getProperty("macUpTF", "MacMedia/updates_mac_update.xml"));
        this.outTF.setText(this.props.getProperty("outTF", "MacMedia/updates.xml"));
        this.updateBaseTF.setText(this.props.getProperty("updateBaseTF", "6.0.0"));
        this.versionTF.setText(this.props.getProperty("versionTF", "6"));
        this.verSub1.setValue(Integer.parseInt(this.props.getProperty("subVer1", "1")));
        this.verSub2.setValue(Integer.parseInt(this.props.getProperty("subVer2", "11")));
        this.mergeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdatesApp.this.merge(UpdatesApp.this.baseTF.getText(), UpdatesApp.this.baseUpTF.getText(), UpdatesApp.this.macFullTF.getText(), UpdatesApp.this.macUpTF.getText(), UpdatesApp.this.outTF.getText(), UpdatesApp.this.updateBaseTF.getText(), UpdatesApp.this.versionTF.getText(), Integer.toString((Integer)UpdatesApp.this.verSub1.getValue()), Integer.toString((Integer)UpdatesApp.this.verSub2.getValue()));
                UpdatesApp.this.doSave(UpdatesApp.this.outTF.getText());
            }
        });
    }

    protected void merge(String baseStr, String baseUpStr, String macFullStr, String macUpStr, String outStr, String baseVerStr, String versionStr, String verSub1Str, String verSub2Str) {
        if (!doingCmdLine) {
            try {
                this.props.setProperty("baseTF", baseStr);
                this.props.setProperty("baseUpTF", baseUpStr);
                this.props.setProperty("macFullTF", macFullStr);
                this.props.setProperty("macUpTF", macUpStr);
                this.props.setProperty("outTF", outStr);
                this.props.setProperty("versionTF", versionStr);
                this.props.setProperty("subVer1", verSub1Str);
                this.props.setProperty("subVer2", verSub2Str);
                XStream xstream = new XStream();
                FileUtils.writeStringToFile((File)new File("props.init"), (String)xstream.toXML((Object)this.props));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UpdatesApp.class, ex);
                ex.printStackTrace();
            }
        }
        String msg = "Merging...";
        if (doingCmdLine) {
            System.err.println(msg);
        } else {
            this.statusTF.setText(msg);
        }
        this.baseUpdateDesc = UpdatesApp.read(new File(baseStr));
        this.baseUpdateUpDesc = UpdatesApp.read(new File(baseUpStr));
        this.maxFullUpdateDesc = UpdatesApp.read(new File(macFullStr));
        this.maxUpUpdateDesc = UpdatesApp.read(new File(macUpStr));
        this.setAsFull(this.baseUpdateDesc, baseVerStr, versionStr, verSub1Str, verSub2Str);
        this.setAsUpdate(this.baseUpdateUpDesc, versionStr, verSub1Str, verSub2Str);
        this.setAsFull(this.maxFullUpdateDesc, baseVerStr, versionStr, verSub1Str, verSub2Str);
        this.setAsUpdate(this.maxUpUpdateDesc, versionStr, verSub1Str, verSub2Str);
        this.baseUpdateDesc.getEntries().addAll(this.baseUpdateUpDesc.getEntries());
        this.baseUpdateDesc.getEntries().addAll(this.maxFullUpdateDesc.getEntries());
        this.baseUpdateDesc.getEntries().addAll(this.maxUpUpdateDesc.getEntries());
        msg = "Merged.";
        if (doingCmdLine) {
            System.err.println(msg);
        } else {
            this.statusTF.setText(msg);
        }
        this.doSave(outStr);
    }

    protected void setAsFull(UpdateDescriptor upDesc, String baseVer, String ver, String vs1, String vs2) {
        int i2 = Integer.parseInt(vs2) - 2;
        if (i2 < 0) {
            i2 += 100;
        }
        String newVersion = String.valueOf(ver) + "." + vs1 + "." + vs2;
        String verMax = String.valueOf(ver) + "." + vs1 + "." + i2;
        try {
            for (UpdateEntry entry : upDesc.getEntries()) {
                if (!entry.getNewVersion().equals(newVersion)) {
                    String msg = String.format("The Full entry '%s'\n has the wrong version number '%s'\nThe version should be '%s'!", entry.getFileName(), entry.getNewVersion(), newVersion);
                    if (doingCmdLine) {
                        System.err.println(msg);
                    } else {
                        JOptionPane.showConfirmDialog(null, msg, "Version Mismatch", 0);
                    }
                }
                entry.setUpdatableVersionMax(verMax);
                entry.setUpdatableVersionMin(baseVer);
            }
        }
        catch (NullPointerException ex) {
            System.err.println("****UpdateDescriptor has no entries.");
        }
    }

    protected void setAsUpdate(UpdateDescriptor upDesc, String ver, String vs1, String vs2) {
        int i2 = Integer.parseInt(vs2) - 1;
        if (i2 < 0) {
            i2 += 100;
        }
        String newVersion = String.valueOf(ver) + "." + vs1 + "." + vs2;
        String verMin = String.valueOf(ver) + "." + vs1 + "." + i2;
        try {
            for (UpdateEntry entry : upDesc.getEntries()) {
                if (!entry.getNewVersion().equals(newVersion)) {
                    String msg = String.format("The Update entry '%s'\n has the wrong version number '%s'\nThe version should be '%s'!", entry.getFileName(), entry.getNewVersion(), newVersion);
                    if (doingCmdLine) {
                        System.err.println(msg);
                    } else {
                        JOptionPane.showConfirmDialog(null, msg, "Version Mismatch", 0);
                    }
                }
                entry.setUpdatableVersionMax(verMin);
                entry.setUpdatableVersionMin(verMin);
            }
        }
        catch (NullPointerException ex) {
            System.err.println("****UpdateDescriptor has no entries.");
        }
    }

    protected void doSave(String outStr) {
        UpdatesApp.write(this.baseUpdateDesc, outStr);
        this.statusTF.setText("Saved.");
    }

    protected void shutdown() {
        System.exit(0);
    }

    protected static UpdateDescriptor read(File file) {
        XStream xstream = new XStream();
        UpdateDescriptor.config(xstream);
        UpdateEntry.config(xstream);
        if (file.exists()) {
            try {
                UpdateDescriptor update = (UpdateDescriptor)xstream.fromXML(FileUtils.readFileToString((File)file));
                return update;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UpdatesApp.class, ex);
                ex.printStackTrace();
            }
        } else {
            try {
                System.err.println("File: " + file.getCanonicalPath() + " doesn't exist.");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected static void write(UpdateDescriptor update, String outPath) {
        XStream xstream = new XStream();
        UpdateDescriptor.config(xstream);
        UpdateEntry.config(xstream);
        System.out.println("Start");
        File file = new File(outPath);
        try {
            FileUtils.writeStringToFile((File)file, (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xstream.toXML((Object)update)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("Stop");
    }

    public static void setMnemonic(AbstractButton btn, String mnemonic) {
        if (StringUtils.isNotEmpty((String)mnemonic) && btn != null) {
            btn.setMnemonic(mnemonic.charAt(0));
        }
    }

    public static JMenu createMenu(JMenuBar menuBar, String label, String mneu) {
        JMenu menu = null;
        try {
            menu = menuBar.add(new JMenu(label));
            UpdatesApp.setMnemonic(menu, mneu);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return menu;
    }

    public JMenuBar createMenus() {
        JMenuBar menuBar = null;
        if (!UIHelper.isMacOS()) {
            menuBar = new JMenuBar();
            JMenu fileMenu = UpdatesApp.createMenu(menuBar, "File", "F");
            fileMenu.addSeparator();
            UIHelper.createMenuItemWithAction(fileMenu, "Exit", "x", "", true, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdatesApp.this.shutdown();
                }
            });
        }
        return menuBar;
    }

    public static void main(String[] args) {
        if (args.length == 9) {
            int i = 0;
            while (i < args.length) {
                System.out.println(String.valueOf(i) + "=" + args[i]);
                ++i;
            }
            doingCmdLine = true;
            UpdatesApp updateApp = new UpdatesApp();
            try {
                updateApp.merge(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            }
            catch (NullPointerException ex) {
                System.err.println("****The merge process failed:  check for errors above.");
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIHelper.OSTYPE osType = UIHelper.getOSType();
                        if (osType == UIHelper.OSTYPE.Windows) {
                            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                        } else if (osType == UIHelper.OSTYPE.Linux) {
                            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        }
                    }
                    catch (Exception e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(UpdatesApp.class, e);
                        System.err.println("Can't change L&F: " + e);
                    }
                    UpdatesApp panel = new UpdatesApp();
                    JFrame frame = new JFrame();
                    frame.setTitle("Install4J XML Updater");
                    frame.setContentPane(panel);
                    JMenuBar menuBar = panel.createMenus();
                    if (menuBar != null) {
                        frame.setJMenuBar(menuBar);
                    }
                    frame.pack();
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
            });
        }
    }
}

