/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResFileCompare {
    private static final Logger log = Logger.getLogger(ResFileCompare.class);

    public void fixPropertiesFiles(String baseFileName, String lang, boolean doBranch) {
        File lngFile;
        File engFile;
        boolean doWrite = false;
        System.out.println("-------------------- " + baseFileName + " --------------------");
        String engName = String.format("src/%s_en.properties", baseFileName);
        String langName = String.format("src/%s_%s.properties", baseFileName, lang);
        if (doBranch) {
            engFile = new File(String.format("/home/rods/workspace/Specify_6202SF/src/%s_en.properties", baseFileName));
            lngFile = new File(String.format("/home/rods/workspace/Specify_6202SF/src/%s_%s.properties", baseFileName, lang));
        } else {
            engFile = new File(engName);
            lngFile = new File(langName);
        }
        try {
            List engList = FileUtils.readLines((File)engFile, (String)"UTF8");
            List lngListTmp = FileUtils.readLines((File)lngFile, (String)"UTF8");
            int lineCnt = -1;
            HashMap<String, String> transHash = new HashMap<String, String>();
            for (String line : lngListTmp) {
                ++lineCnt;
                if (line.startsWith("#") || StringUtils.deleteWhitespace((String)line).length() < 3 || line.indexOf(61) == -1) continue;
                String[] toks = StringUtils.split((String)line, (char)'=');
                if (toks.length > 1) {
                    if (toks.length == 2) {
                        transHash.put(toks[0], toks[1]);
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    int i = 1;
                    while (i < toks.length) {
                        sb.append(String.format("%s=", toks[i]));
                        ++i;
                    }
                    sb.setLength(sb.length() - 1);
                    transHash.put(toks[0], sb.toString());
                    continue;
                }
                log.error((Object)("Skipping:[" + line + "] Line:" + lineCnt));
            }
            log.info((Object)String.format("Lines Eng: %d;  Terms Hash size: %s: %d", engList.size(), lang, transHash.size()));
            File dir = new File("translations");
            if (!dir.exists() && !dir.mkdir()) {
                log.error((Object)("Unable to create directory[" + dir.getAbsolutePath() + "]"));
                return;
            }
            File transFile = new File(String.valueOf(dir.getPath()) + File.separator + langName.substring(4));
            PrintWriter transFileOutput = new PrintWriter(transFile, "UTF8");
            for (String line : engList) {
                if (line.startsWith("#") || StringUtils.deleteWhitespace((String)line).length() < 3 || line.indexOf(61) == -1) {
                    transFileOutput.println(line);
                    continue;
                }
                boolean doMove = true;
                String[] toks = StringUtils.split((String)line, (char)'=');
                if (toks.length > 1) {
                    String key = null;
                    String value = null;
                    if (toks.length == 2) {
                        key = toks[0];
                        value = toks[1];
                    } else {
                        key = toks[0];
                        StringBuilder sb = new StringBuilder();
                        int i = 1;
                        while (i < toks.length) {
                            sb.append(String.format("%s=", toks[i]));
                            ++i;
                        }
                        sb.setLength(sb.length() - 1);
                        value = sb.toString();
                    }
                    if (key != null) {
                        String text = (String)transHash.get(key);
                        transFileOutput.println(String.format("%s=%s", key, text != null ? text : value));
                        if (text == null) {
                            log.info((Object)("Adding new term: " + key));
                        }
                        doMove = false;
                    } else {
                        log.info((Object)("Adding new term: " + key));
                    }
                }
                if (!doMove) continue;
                transFileOutput.println(line);
            }
            transFileOutput.flush();
            transFileOutput.close();
            log.info((Object)String.format("Write file: %s", transFile.getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean save(File file, Vector<String> list) {
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(file);
            dos = new DataOutputStream(fos);
            for (String line : list) {
                String str = String.valueOf(line) + '\n';
                dos.writeBytes(str);
            }
            dos.flush();
            dos.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("e: " + e);
            return false;
        }
    }

    public static void main(String[] args) {
        String[] fileNames = new String[]{"backuprestore", "common", "expresssearch", "global_views", "masterusrpwd", "preferences", "resources", "specify_plugins", "specifydbsetupwiz", "stats", "system_setup", "views"};
        String lang = "pt";
        ResFileCompare resFileFix = new ResFileCompare();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String baseFileName = stringArray[n2];
            resFileFix.fixPropertiesFiles(baseFileName, lang, false);
            ++n2;
        }
    }
}

