/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.helpers.HTTPGetter;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.util.Pair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class RegPivot {
    protected DBConnection colDBConn = null;
    protected Connection connection = null;
    protected String dbName = "stats";
    protected String itUsername = "root";
    protected String itPassword = "root";

    public RegPivot() {
        try {
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, "localhost", this.dbName, this.itUsername, this.itPassword, driverInfo.getName());
            System.err.println(connStr);
            this.colDBConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), this.dbName, connStr, this.itUsername, this.itPassword);
            this.connection = this.colDBConn.createConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process(String newTblName, String tblName, String keyName, String defSQL, String fillSQL, boolean isRegBuild) {
        String sql = String.format("SELECT DISTINCT Name FROM %s", tblName);
        String sql2 = "SELECT MAX(LENGTH(Value)) FROM " + tblName + " WHERE Name = '%s'";
        int instCnt = 0;
        Statement stmt = null;
        try {
            boolean doIP;
            stmt = this.connection.createStatement();
            BasicSQLUtils.setDBConnection(this.connection);
            boolean doBuild = true;
            if (doBuild) {
                StringBuilder tblSQL = new StringBuilder(String.format("CREATE TABLE %s (`%s` INT(11) NOT NULL AUTO_INCREMENT, \n", newTblName, keyName));
                Vector<String> dbFieldNames = new Vector<String>();
                Vector<Integer> dbFieldTypes = new Vector<Integer>();
                if (defSQL != null) {
                    ResultSet rs = stmt.executeQuery(defSQL);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        if (i > 1) {
                            tblSQL.append(",\n ");
                        }
                        String name = rsmd.getColumnName(i);
                        dbFieldNames.add(rsmd.getColumnName(i));
                        dbFieldTypes.add(rsmd.getColumnType(i));
                        switch (rsmd.getColumnType(i)) {
                            case 4: {
                                tblSQL.append(String.format("`%s` INT(11) DEFAULT NULL", name));
                                break;
                            }
                            case 12: {
                                tblSQL.append(String.format("`%s` VARCHAR(%s) DEFAULT NULL", name, 64));
                                break;
                            }
                            case 93: {
                                tblSQL.append(String.format("`%s` DATETIME DEFAULT NULL", name));
                                break;
                            }
                            default: {
                                System.err.println(String.format("No case for %s %d", name, rsmd.getColumnType(i)));
                            }
                        }
                        ++i;
                    }
                    rs.close();
                }
                int secInx = dbFieldNames.size() + 1;
                System.out.println("secInx: " + secInx + "  " + tblSQL.toString());
                HashSet<String> nameSet = new HashSet<String>();
                int cnt = 0;
                for (Object nmObj : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    String name = nmObj.toString();
                    if (name.endsWith("ID")) continue;
                    name = StringUtils.replace((String)name, (String)"(", (String)"_");
                    if (nameSet.contains(name = StringUtils.replace((String)name, (String)")", (String)"_"))) continue;
                    nameSet.add(name);
                    tblSQL.append(",\n ");
                    if (name.startsWith("num_") || name.startsWith("Usage_")) {
                        tblSQL.append(String.format("`%s` INT(11) DEFAULT NULL", name));
                        dbFieldNames.add(name);
                        dbFieldTypes.add(4);
                    } else if (name.endsWith("_number")) {
                        tblSQL.append(String.format("`%s` VARCHAR(16) DEFAULT NULL", name));
                        dbFieldNames.add(name);
                        dbFieldTypes.add(12);
                    } else {
                        int maxLen = BasicSQLUtils.getCountAsInt(this.connection, String.format(sql2, name));
                        tblSQL.append(String.format("`%s` VARCHAR(%s) DEFAULT NULL", name, maxLen + 1));
                        dbFieldNames.add(name);
                        dbFieldTypes.add(12);
                    }
                    ++cnt;
                }
                if (isRegBuild) {
                    tblSQL.append(String.format(",\n`RecordType`INT(11) DEFAULT NULL", new Object[0]));
                }
                tblSQL.append(String.format(",\n PRIMARY KEY (`%s`)) ENGINE=InnoDB DEFAULT CHARSET=UTF8", keyName));
                System.out.println(tblSQL.toString());
                DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
                dbMgr.setConnection(this.connection);
                if (dbMgr.doesDBHaveTable(newTblName)) {
                    BasicSQLUtils.update(this.connection, "DROP TABLE " + newTblName);
                }
                BasicSQLUtils.update(this.connection, tblSQL.toString());
                HashMap<Integer, String> inxToName = new HashMap<Integer, String>();
                StringBuilder fields = new StringBuilder();
                StringBuilder vals = new StringBuilder();
                int inx = 0;
                for (String nm : dbFieldNames) {
                    if (fields.length() > 0) {
                        fields.append(",");
                    }
                    fields.append(nm);
                    if (vals.length() > 0) {
                        vals.append(",");
                    }
                    vals.append('?');
                    inxToName.put(inx, nm);
                    ++inx;
                }
                if (isRegBuild) {
                    if (fields.length() > 0) {
                        fields.append(",");
                    }
                    fields.append("RecordType");
                    if (vals.length() > 0) {
                        vals.append(",");
                    }
                    vals.append('?');
                }
                String insertSQL = String.format("INSERT INTO %s (%s) VALUES(%s)", newTblName, fields.toString(), vals.toString());
                System.out.println(insertSQL);
                PreparedStatement pStmt = this.connection.prepareStatement(insertSQL);
                if (isRegBuild) {
                    this.fillRegisterTable(newTblName, stmt, pStmt, fillSQL, secInx, dbFieldTypes, dbFieldNames, inxToName);
                } else {
                    this.fillTrackTable(newTblName, stmt, pStmt, fillSQL, secInx, dbFieldTypes, dbFieldNames, inxToName);
                }
                System.out.println("InstCnt: " + instCnt);
                pStmt.close();
            }
            if (doIP = false) {
                HTTPGetter httpGetter = new HTTPGetter();
                sql = "SELECT RegID, IP from reg";
                PreparedStatement pStmt = this.connection.prepareStatement(String.format("UPDATE %s SET lookup=?, Country=?, City=? WHERE %s = ?", newTblName, keyName));
                HashMap<String, String> ipHash = new HashMap<String, String>();
                HashMap<String, Pair<String, String>> ccHash = new HashMap<String, Pair<String, String>>();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int regId = rs.getInt(1);
                    String ip = rs.getString(2);
                    String hostName = (String)ipHash.get(ip);
                    String country = null;
                    String city = null;
                    if (hostName == null) {
                        String rvStr = new String(httpGetter.doHTTPRequest("http://api.hostip.info/get_html.php?ip=" + ip));
                        country = this.parse(rvStr, "Country:");
                        city = this.parse(rvStr, "City:");
                        System.out.println(String.valueOf(rvStr) + "[" + country + "][" + city + "]");
                        try {
                            InetAddress addr = InetAddress.getByName(ip);
                            hostName = addr.getHostName();
                            ipHash.put(ip, hostName);
                            ccHash.put(ip, new Pair<String, String>(country, city));
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Pair p = (Pair)ccHash.get(ip);
                        if (p != null) {
                            country = (String)p.first;
                            city = (String)p.second;
                        }
                    }
                    pStmt.setString(1, hostName);
                    pStmt.setString(2, country);
                    pStmt.setString(3, city);
                    pStmt.setInt(4, regId);
                    pStmt.executeUpdate();
                }
                pStmt.close();
            }
            stmt.close();
            this.colDBConn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Done.");
    }

    private int fillRegisterTable(String newTblName, Statement stmt, PreparedStatement pStmt, String fillSQL, int secInx, Vector<Integer> dbFieldTypes, Vector<String> dbFieldNames, HashMap<Integer, String> inxToName) throws SQLException {
        System.out.println("Filling Register Table.");
        int instCnt = 0;
        System.out.println(fillSQL);
        ResultSet rs = stmt.executeQuery(fillSQL);
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        int c = 1;
        while (c <= rsmd.getColumnCount()) {
            nameToIndex.put(rsmd.getColumnName(c), c);
            System.out.println(String.valueOf(c) + " - " + rsmd.getColumnName(c));
            ++c;
        }
        boolean debug = false;
        String prevRegId = null;
        HashMap<String, HashMap<String, Object>> instHash = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, HashMap<String, Object>> divHash = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, HashMap<String, Object>> dspHash = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, HashMap<String, Object>> colHash = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> nameToVals = new HashMap<String, Object>();
        while (rs.next()) {
            String regId = rs.getString(1);
            if (prevRegId == null) {
                prevRegId = regId;
            }
            int i = 1;
            while (i < secInx) {
                if (debug) {
                    System.out.println("Put: " + dbFieldNames.get(i - 1) + "  " + dbFieldTypes.get(i - 1) + "  = " + rs.getObject(i));
                }
                nameToVals.put(dbFieldNames.get(i - 1), rs.getObject(i));
                ++i;
            }
            String name = rs.getString(secInx);
            name = StringUtils.replace((String)name, (String)"(", (String)"_");
            if ((name = StringUtils.replace((String)name, (String)")", (String)"_")).equals("reg_type")) {
                String strVal = (String)rs.getObject(secInx + 2);
                name = String.valueOf(strVal) + "_number";
                nameToVals.put(name, regId);
                if (debug) {
                    System.out.println("Put: " + name + " = " + regId);
                }
            } else {
                Integer intVal = (Integer)rs.getObject(secInx + 1);
                String strVal = (String)rs.getObject(secInx + 2);
                nameToVals.put(name, strVal != null ? strVal : intVal);
                if (debug) {
                    System.out.println("Put: " + name + " = " + intVal + " / " + strVal);
                }
            }
            if (debug) {
                System.out.println("-------------------------------------------");
            }
            if (prevRegId.equals(regId)) continue;
            String instNum = (String)nameToVals.get("Institution_number");
            String divNum = (String)nameToVals.get("Division_number");
            String dspNum = (String)nameToVals.get("Discipline_number");
            String colNum = (String)nameToVals.get("Collection_number");
            if (StringUtils.isNotEmpty((String)instNum)) {
                this.copyHash(instNum, instHash, nameToVals);
            }
            if (StringUtils.isNotEmpty((String)divNum)) {
                this.copyHash(divNum, divHash, nameToVals);
            }
            if (StringUtils.isNotEmpty((String)dspNum)) {
                this.copyHash(dspNum, dspHash, nameToVals);
            }
            if (StringUtils.isNotEmpty((String)colNum)) {
                String cn = (String)nameToVals.get("Collection_number");
                this.copyHash(colNum, colHash, nameToVals);
            }
            prevRegId = regId;
            nameToVals.clear();
        }
        this.writeHash(instHash, 0, pStmt, dbFieldTypes, dbFieldNames, inxToName);
        this.writeHash(divHash, 1, pStmt, dbFieldTypes, dbFieldNames, inxToName);
        this.writeHash(dspHash, 2, pStmt, dbFieldTypes, dbFieldNames, inxToName);
        this.writeHash(colHash, 3, pStmt, dbFieldTypes, dbFieldNames, inxToName);
        String alterSQL = "ALTER TABLE " + newTblName + " ADD Lookup VARCHAR(64) AFTER IP";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD Country VARCHAR(64) AFTER Lookup";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD City VARCHAR(64) AFTER Country";
        BasicSQLUtils.update(this.connection, alterSQL);
        return instCnt;
    }

    private void copyHash(String numId, HashMap<String, HashMap<String, Object>> hash, HashMap<String, Object> data) {
        HashMap<String, Object> dataHash = hash.get(numId);
        if (dataHash == null) {
            dataHash = new HashMap<String, Object>(data);
            hash.put(numId, dataHash);
        } else {
            for (String key : data.keySet()) {
                dataHash.put(key, data.get(key));
            }
        }
    }

    private void writeHash(HashMap<String, HashMap<String, Object>> hash, Integer recordType, PreparedStatement pStmt, Vector<Integer> dbFieldTypes, Vector<String> dbFieldNames, HashMap<Integer, String> inxToName) throws SQLException {
        int totalCnt = hash.size();
        int cnt = 0;
        for (String idKey : hash.keySet()) {
            if (++cnt % 500 == 0) {
                System.out.println(String.valueOf(cnt) + " / " + totalCnt);
            }
            HashMap<String, Object> nameToVals = hash.get(idKey);
            if (recordType != null) {
                pStmt.setInt(dbFieldNames.size() + 1, recordType);
            }
            int i = 0;
            while (i < dbFieldNames.size()) {
                int fInx = i + 1;
                String name = inxToName.get(i);
                Object value = nameToVals.get(name);
                pStmt.setObject(fInx, null);
                int typ = dbFieldTypes.get(i);
                if (value != null) {
                    if (value instanceof Integer) {
                        pStmt.setInt(fInx, (Integer)value);
                    } else if (value instanceof String) {
                        pStmt.setString(fInx, (String)value);
                    } else if (value instanceof Timestamp) {
                        pStmt.setTimestamp(fInx, (Timestamp)value);
                    } else {
                        System.err.println("Unhandled class: " + value.getClass().getName());
                    }
                } else {
                    pStmt.setObject(fInx, null);
                }
                ++i;
            }
            pStmt.executeUpdate();
        }
    }

    private int fillTrackTable(String newTblName, Statement stmt, PreparedStatement pStmt, String fillSQL, int secInx, Vector<Integer> dbFieldTypes, Vector<String> dbFieldNames, HashMap<Integer, String> inxToName) throws SQLException {
        System.out.println("Filling Track Table.");
        int instCnt = 0;
        System.out.println(fillSQL);
        ResultSet rs = stmt.executeQuery(fillSQL);
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        int c = 1;
        while (c <= rsmd.getColumnCount()) {
            nameToIndex.put(rsmd.getColumnName(c), c);
            System.out.println(String.valueOf(c) + " - " + rsmd.getColumnName(c));
            ++c;
        }
        boolean debug = false;
        String prevRegId = null;
        HashMap<String, HashMap<String, Object>> colHash = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> nameToVals = new HashMap<String, Object>();
        while (rs.next()) {
            String regId = rs.getString(1);
            if (prevRegId == null) {
                prevRegId = regId;
            }
            int i = 1;
            while (i < secInx) {
                if (debug) {
                    System.out.println("Put: " + dbFieldNames.get(i - 1) + "  " + dbFieldTypes.get(i - 1) + "  = " + rs.getObject(i));
                }
                if (dbFieldTypes.get(i - 1) == 93) {
                    try {
                        String ts = rs.getString(i);
                        if (StringUtils.isNotEmpty((String)ts) && ts.equals("0000-00-00 00:00:00")) {
                        }
                    }
                    catch (Exception ex) {}
                } else {
                    nameToVals.put(dbFieldNames.get(i - 1), rs.getObject(i));
                }
                ++i;
            }
            String name = rs.getString(secInx);
            name = StringUtils.replace((String)name, (String)"(", (String)"_");
            if ((name = StringUtils.replace((String)name, (String)")", (String)"_")).equals("reg_type")) {
                String strVal = (String)rs.getObject(secInx + 2);
                name = String.valueOf(strVal) + "_number";
                nameToVals.put(name, regId);
                if (debug) {
                    System.out.println("Put: " + name + " = " + regId);
                }
            } else {
                Integer intVal = (Integer)rs.getObject(secInx + 1);
                String strVal = (String)rs.getObject(secInx + 2);
                nameToVals.put(name, strVal != null ? strVal : intVal);
                if (debug) {
                    System.out.println("Put: " + name + " = " + intVal + " / " + strVal);
                }
            }
            if (debug) {
                System.out.println("-------------------------------------------");
            }
            if (prevRegId.equals(regId)) continue;
            String colNum = (String)nameToVals.get("Collection_number");
            if (StringUtils.isNotEmpty((String)colNum)) {
                this.copyHash(colNum, colHash, nameToVals);
            }
            prevRegId = regId;
            nameToVals.clear();
        }
        this.writeHash(colHash, null, pStmt, dbFieldTypes, dbFieldNames, inxToName);
        String alterSQL = "ALTER TABLE " + newTblName + " ADD Lookup VARCHAR(64) AFTER IP";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD Country VARCHAR(64) AFTER Lookup";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD City VARCHAR(64) AFTER Country";
        BasicSQLUtils.update(this.connection, alterSQL);
        return instCnt;
    }

    /*
     * Unable to fully structure code
     */
    private int fillTrackTableX(String newTblName, Statement stmt, PreparedStatement pStmt, String fillSQL, int secInx, Vector<Integer> dbFieldTypes, Vector<String> dbFieldNames, HashMap<Integer, String> inxToName) throws SQLException {
        System.out.println("Filling Track Table.");
        instCnt = 0;
        nameToVals = new HashMap<String, Object>();
        System.out.println(fillSQL);
        prevId = null;
        rs = stmt.executeQuery(fillSQL);
        rsmd = rs.getMetaData();
        nameToIndex = new HashMap<String, Integer>();
        c = 1;
        while (c <= rsmd.getColumnCount()) {
            nameToIndex.put(rsmd.getColumnName(c), c);
            System.out.println(String.valueOf(c) + " - " + rsmd.getColumnName(c));
            ++c;
        }
        while (rs.next()) {
            block21: {
                id = rs.getString(1);
                if (prevId == null) {
                    prevId = id;
                }
                if (prevId.equals(id)) break block21;
                i = 1;
                while (i < secInx) {
                    if (dbFieldTypes.get(i - 1) == 93) {
                        try {
                            ts = rs.getString(i);
                            if (StringUtils.isNotEmpty((String)ts) && ts.equals("0000-00-00 00:00:00")) {
                            }
                            ** break block20
                        }
                        catch (Exception ex) {
                            nameToVals.put(dbFieldNames.get(i - 1), null);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        nameToVals.put(dbFieldNames.get(i - 1), rs.getObject(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < dbFieldNames.size()) {
                    block23: {
                        block22: {
                            fInx = i + 1;
                            name = inxToName.get(i);
                            value = nameToVals.get(name);
                            pStmt.setObject(fInx, null);
                            typ = dbFieldTypes.get(i);
                            if (value == null) break block22;
                            switch (typ) {
                                case 4: {
                                    if (value instanceof Integer) {
                                        pStmt.setInt(fInx, (Integer)value);
                                        break;
                                    }
                                    break block23;
                                }
                                case 12: {
                                    if (value instanceof String) {
                                        pStmt.setString(fInx, (String)value);
                                        break;
                                    }
                                    break block23;
                                }
                                case 93: {
                                    if (!(value instanceof Timestamp)) break block23;
                                    pStmt.setTimestamp(fInx, (Timestamp)value);
                                }
                                default: {
                                    break;
                                }
                                {
                                }
                            }
                            break block23;
                        }
                        pStmt.setObject(fInx, null);
                    }
                    ++i;
                }
                pStmt.executeUpdate();
                prevId = id;
                nameToVals.clear();
            }
            name = rs.getString(secInx);
            name = StringUtils.replace((String)name, (String)"(", (String)"_");
            name = StringUtils.replace((String)name, (String)")", (String)"_");
            intVal = (Integer)rs.getObject(secInx + 1);
            strVal = (String)rs.getObject(secInx + 2);
            nameToVals.put(name, strVal != null ? strVal : intVal);
        }
        alterSQL = "ALTER TABLE " + newTblName + " ADD Lookup VARCHAR(64) AFTER IP";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD Country VARCHAR(64) AFTER Lookup";
        BasicSQLUtils.update(this.connection, alterSQL);
        alterSQL = "ALTER TABLE " + newTblName + " ADD City VARCHAR(64) AFTER Country";
        BasicSQLUtils.update(this.connection, alterSQL);
        return instCnt;
    }

    public void fillCountryCity(String tblName, String keyName) {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            BasicSQLUtils.setDBConnection(this.connection);
            HTTPGetter httpGetter = new HTTPGetter();
            String sql = String.format("SELECT %s, IP, Lookup, Country, City FROM %s WHERE Country IS NULL", keyName, tblName);
            PreparedStatement pStmt = this.connection.prepareStatement(String.format("UPDATE %s SET lookup=?, Country=?, City=? WHERE %s = ?", tblName, keyName));
            HashMap<String, String> ipHash = new HashMap<String, String>();
            HashMap<String, Pair<String, String>> ccHash = new HashMap<String, Pair<String, String>>();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int regId = rs.getInt(1);
                String ip = rs.getString(2);
                String lookup = rs.getString(3);
                String country = rs.getString(4);
                String city = rs.getString(5);
                boolean allEmpty = StringUtils.isEmpty((String)lookup) && StringUtils.isEmpty((String)country) && StringUtils.isEmpty((String)city);
                String hostName = (String)ipHash.get(ip);
                if (allEmpty && hostName == null) {
                    String rvStr = new String(httpGetter.doHTTPRequest("http://api.hostip.info/get_html.php?ip=" + ip));
                    country = this.parse(rvStr, "Country:");
                    city = this.parse(rvStr, "City:");
                    System.out.println(String.valueOf(rvStr) + "[" + country + "][" + city + "]");
                    try {
                        InetAddress addr = InetAddress.getByName(ip);
                        hostName = addr.getHostName();
                        ipHash.put(ip, hostName);
                        ccHash.put(ip, new Pair<String, String>(country, city));
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                } else {
                    Pair p = (Pair)ccHash.get(ip);
                    if (p != null) {
                        country = (String)p.first;
                        city = (String)p.second;
                    }
                }
                pStmt.setString(1, hostName);
                pStmt.setString(2, country);
                pStmt.setString(3, city);
                pStmt.setInt(4, regId);
                pStmt.executeUpdate();
            }
            pStmt.close();
            stmt.close();
            this.colDBConn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Done.");
    }

    public void crossMapCC() {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            BasicSQLUtils.setDBConnection(this.connection);
            String sql = "SELECT TrkID, id from trk";
            String lkSQL = "SELECT lookup, Country, City FROM reg WHERE id = '%s'";
            PreparedStatement pStmt = this.connection.prepareStatement(String.format("UPDATE %s SET lookup=?, Country=?, City=? WHERE %s = ?", "trk", "TrkID"));
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int trkId = rs.getInt(1);
                String idStr = rs.getString(2);
                Vector<Object[]> rows = BasicSQLUtils.query(String.format(lkSQL, idStr));
                if (rows == null || rows.size() <= 0) continue;
                Object[] row = rows.get(0);
                pStmt.setString(1, (String)row[0]);
                pStmt.setString(2, (String)row[1]);
                pStmt.setString(3, (String)row[2]);
                pStmt.setInt(4, trkId);
                pStmt.executeUpdate();
            }
            pStmt.close();
            stmt.close();
            System.out.println("Done.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String parse(String str, String sym) {
        int eInx;
        int sInx;
        if (StringUtils.isNotEmpty((String)str) && (sInx = str.indexOf(sym)) > -1 && (eInx = str.indexOf(10, sInx)) > -1) {
            return str.substring(sInx + sym.length(), eInx);
        }
        return null;
    }

    public void shutdown() {
        try {
            this.colDBConn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doProcess(ProcessType processType) {
        switch (processType) {
            case eBuildReg: {
                String defSQL = "SELECT r.RegNumber, r.RegType, r.IP, r.TimestampCreated FROM register r WHERE r.RegNumber IS NULL";
                String fillSQL = "SELECT r.RegNumber, r.RegType, r.IP, r.TimestampCreated, i.Name, i.CountAmt, i.Value FROM register r INNER JOIN registeritem i ON r.RegisterID = i.RegisterID";
                this.process("reg", "registeritem", "RegID", defSQL, fillSQL, true);
                break;
            }
            case eBuildTrack: {
                String defSQL = "SELECT t.CountAmt, t.IP, t.TimestampCreated, t.TimestampModified FROM track t WHERE t.Id IS NULL";
                String fillSQL = "SELECT t.CountAmt, t.IP, t.TimestampCreated, t.TimestampModified, i.Name, i.CountAmt, i.Value FROM track t INNER JOIN trackitem i ON t.TrackID = i.TrackID ORDER BY TimestampCreated";
                this.process("trk", "trackitem", "TrkID", defSQL, fillSQL, false);
                break;
            }
            case eBuildRegCC: {
                this.fillCountryCity("reg", "RegID");
                break;
            }
            case eBuildTrkCC: {
                this.fillCountryCity("trk", "TrkID");
                break;
            }
            case eCrossMapRegToTrk: {
                this.crossMapCC();
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        RegPivot rp = new RegPivot();
        rp.doProcess(ProcessType.eBuildReg);
        rp.shutdown();
        System.out.println("App Done.");
    }

    static enum ProcessType {
        eBuildReg,
        eBuildTrack,
        eBuildRegCC,
        eBuildTrkCC,
        eCrossMapRegToTrk;

    }
}

