/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RegAdder {
    protected static final Logger log = Logger.getLogger(RegAdder.class);
    private static final int STR_SIZE = 128;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private Timestamp ts = new Timestamp(Calendar.getInstance().getTime().getTime());
    private long startDate;
    private int cnt = 0;
    private int lineNo = 0;
    private Statement stmt = null;
    private PreparedStatement trkStmt1;
    private PreparedStatement trkStmt2;
    private PreparedStatement trkStmt3;
    private PreparedStatement trkStmt4;
    private PreparedStatement regStmt1;
    private PreparedStatement regStmt2;

    public RegAdder(Connection connection) {
        try {
            this.stmt = connection.createStatement();
            this.trkStmt1 = connection.prepareStatement("INSERT INTO track (TimestampCreated, Id, CountAmt) VALUES(?, ?, ?)");
            this.trkStmt2 = connection.prepareStatement("INSERT INTO trackitem (Name, CountAmt, Value, TrackID) VALUES(?, ?, ?, ?)");
            this.trkStmt3 = connection.prepareStatement("UPDATE trackitem SET CountAmt=?, Value=? WHERE TrackItemID=?");
            this.trkStmt4 = connection.prepareStatement("UPDATE track SET CountAmt=? WHERE TrackID=?");
            this.regStmt1 = connection.prepareStatement("INSERT INTO register (TimestampCreated, RegNumber, RegType, IP) VALUES(?, ?, ?, ?)");
            this.regStmt2 = connection.prepareStatement("INSERT INTO registeritem (Name, CountAmt, Value, RegisterID) VALUES(?, ?, ?, ?)");
            this.startDate = this.sdf.parse("2009-04-12 00:00:00").getTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doTrackInserts(int trackId, HashMap<String, String> mv, PreparedStatement pStmt) throws SQLException {
        for (String key : mv.keySet()) {
            String value = mv.get(key);
            pStmt.setString(1, key);
            if (!StringUtils.contains((String)value, (String)".") && StringUtils.isNumeric((String)value) && value.length() < 10) {
                pStmt.setInt(2, Integer.parseInt(value));
                pStmt.setNull(3, 12);
            } else if (value.length() < 129) {
                pStmt.setNull(2, 4);
                pStmt.setString(3, value);
            } else {
                String v = value.substring(0, 128);
                System.err.println("Error - On line " + this.lineNo + " Value[" + value + "] too big trunccating to[" + v + "]");
                pStmt.setNull(2, 4);
                pStmt.setString(3, v);
            }
            pStmt.setInt(4, trackId);
            int rv = pStmt.executeUpdate();
            if (rv == 1) continue;
            for (String k : mv.keySet()) {
                System.out.println("[" + k + "][" + mv.get(k) + "]");
            }
            System.err.println("------------------------ Line No: " + this.lineNo);
            throw new RuntimeException("Error insert trackitem for Id: " + trackId);
        }
    }

    private void doTrackUpdate(int trackItemId, String value, PreparedStatement pStmt) throws SQLException {
        if (!StringUtils.contains((String)value, (String)".") && StringUtils.isNumeric((String)value) && value.length() < 10) {
            pStmt.setInt(1, Integer.parseInt(value));
            pStmt.setNull(2, 12);
        } else if (value.length() < 129) {
            pStmt.setNull(1, 4);
            pStmt.setString(2, value);
        } else {
            String v = value.substring(0, 128);
            System.err.println("Error - On line " + this.lineNo + " Value[" + value + "] too big trunccating to[" + v + "]");
            pStmt.setNull(1, 4);
            pStmt.setString(2, v);
        }
        pStmt.setInt(3, trackItemId);
        int rv = pStmt.executeUpdate();
        if (rv != 1) {
            throw new RuntimeException("Error insert trackitem for Id: " + trackItemId);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertTrack(HashMap<String, String> mv) {
        block13: {
            if (mv.size() <= 0) break block13;
            try {
                id = mv.get("id");
                ip = mv.get("IP");
                if (!StringUtils.isNotEmpty((String)id) || ip != null && ip.startsWith("129.237.201")) break block13;
                ++this.cnt;
                if (this.cnt % 100 == 0) {
                    System.out.println(this.cnt);
                }
                if ((recCnt = BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM track WHERE Id = '%s'", new Object[]{id}))) != 0) ** GOTO lbl23
                timeStamp = this.getTimestamp(mv.get("date"));
                if (timeStamp.getTime() < this.startDate) {
                    return;
                }
                this.trkStmt1.setTimestamp(1, timeStamp);
                this.trkStmt1.setString(2, id);
                this.trkStmt1.setInt(3, 1);
                if (this.trkStmt1.executeUpdate() == 1) {
                    if (++recCnt % 100 == 0) {
                        System.out.println(recCnt);
                    }
                    trkId = BasicSQLUtils.getInsertedId(this.trkStmt1);
                    this.doTrackInserts(trkId, mv, this.trkStmt2);
                } else {
                    throw new RuntimeException("Error insert track for ID: " + id);
lbl23:
                    // 1 sources

                    recCnt = BasicSQLUtils.getCountAsInt(String.format("SELECT CountAmt FROM track WHERE Id = '%s'", new Object[]{id})) + 1;
                    trackId = BasicSQLUtils.getCount(String.format("SELECT TrackID FROM track WHERE Id = '%s'", new Object[]{id}));
                    if (trackId != null) {
                        this.trkStmt4.setInt(1, recCnt);
                        this.trkStmt4.setInt(2, trackId);
                        if (this.trkStmt4.executeUpdate() == 1) {
                            for (String key : mv.keySet()) {
                                sql = String.format("SELECT TrackItemID FROM trackitem WHERE TrackID = %d AND Name ='%s'", new Object[]{trackId, key});
                                trackItemId = BasicSQLUtils.getCount(sql);
                                if (trackItemId == null) {
                                    this.doTrackInserts(trackId, mv, this.trkStmt2);
                                    continue;
                                }
                                this.doTrackUpdate(trackItemId, mv.get(key), this.trkStmt3);
                            }
                        } else {
                            RegAdder.log.error((Object)this.trkStmt4.toString());
                            RegAdder.log.error((Object)("Error updating " + id));
                        }
                    }
                }
                break block13;
            }
            catch (SQLException ex) {
                ** for (k : mv.keySet())
            }
lbl-1000:
            // 1 sources

            {
                System.out.println("[" + k + "][" + mv.get(k) + "]");
                continue;
            }
lbl45:
            // 1 sources

            System.err.println("------------------------ Line No: " + this.lineNo);
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertReg(HashMap<String, String> mv) {
        block15: {
            if (mv.size() <= 0) break block15;
            try {
                type = mv.get("reg_type");
                num = mv.get("reg_number");
                ip = mv.get("ip");
                v0 = isNotLocalIP = ip == null || ip.startsWith("129.237.201") == false && ip.startsWith("24.124") == false;
                if (!StringUtils.isNotEmpty((String)type) || !StringUtils.isNotEmpty((String)num) || !isNotLocalIP) ** GOTO lbl48
                numRegNum = BasicSQLUtils.getCountAsInt(String.format("SELECT COUNT(*) FROM register WHERE RegNumber = '%s'", new Object[]{num}));
                if (numRegNum > 0) {
                    return;
                }
                timeStamp = this.getTimestamp(mv.get("date"));
                if (timeStamp.getTime() < this.startDate) {
                    return;
                }
                this.regStmt1.setTimestamp(1, timeStamp);
                this.regStmt1.setString(2, num);
                this.regStmt1.setString(3, type);
                this.regStmt1.setString(4, ip);
                if (this.regStmt1.executeUpdate() == 1) {
                    ++this.cnt;
                    if (this.cnt % 100 == 0) {
                        System.out.println(this.cnt);
                    }
                    regId = BasicSQLUtils.getInsertedId(this.regStmt1);
                    for (String key : mv.keySet()) {
                        value = mv.get(key);
                        this.regStmt2.setString(1, key);
                        if (!StringUtils.contains((String)value, (String)".") && StringUtils.isNumeric((String)value) && value.length() < 10) {
                            this.regStmt2.setInt(2, value.isEmpty() != false ? 0 : Integer.parseInt(value));
                            this.regStmt2.setNull(3, 12);
                        } else if (value.length() < 129) {
                            this.regStmt2.setNull(2, 4);
                            this.regStmt2.setString(3, value);
                        } else {
                            v = value.substring(0, 128);
                            System.err.println("Error - On line " + this.lineNo + " Value[" + value + "] too big trunccating to[" + v + "]");
                            this.regStmt2.setNull(2, 4);
                            this.regStmt2.setString(3, v);
                        }
                        this.regStmt2.setInt(4, regId);
                        rv = this.regStmt2.executeUpdate();
                        if (rv == 1) continue;
                        for (String k : mv.keySet()) {
                            System.out.println("[" + k + "][" + mv.get(k) + "]");
                        }
                        System.err.println("------------------------ Line No: " + this.lineNo);
                        throw new RuntimeException("Error insert registeritem for Reg Id: " + regId);
                    }
                } else {
                    throw new RuntimeException("Error insert register for Reg Type: " + type + "  Num: " + num);
lbl48:
                    // 1 sources

                    if (isNotLocalIP) {
                        System.err.println("------------------------ Line No: " + this.lineNo);
                        System.err.println("Error for Reg Type: [" + type + "]  or Num: [" + num + "] is null.");
                    }
                }
                break block15;
            }
            catch (SQLException ex) {
                ** for (k : mv.keySet())
            }
lbl-1000:
            // 1 sources

            {
                System.out.println("[" + k + "][" + mv.get(k) + "]");
                continue;
            }
lbl56:
            // 1 sources

            System.err.println("------------------------ Line No: " + this.lineNo);
            ex.printStackTrace();
        }
    }

    private Timestamp getTimestamp(String dateStr) {
        if (dateStr != null && dateStr.length() == 17) {
            String[] pair = StringUtils.split((String)dateStr, (String)" ");
            String[] dStr = StringUtils.split((String)dateStr, (String)"/");
            String str = "20" + dStr[0] + '-' + dStr[1] + '-' + dStr[2].substring(0, 2) + " " + pair[1];
            try {
                Date date = this.sdf.parse(str);
                return new Timestamp(date.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.ts;
    }

    public void process(String dataFileName, String dbName, boolean doClear) {
        File file = new File(dataFileName);
        BufferedReader reader = null;
        boolean isReg = dbName.startsWith("reg");
        if (doClear) {
            if (isReg) {
                BasicSQLUtils.deleteAllRecordsFromTable("register", BasicSQLUtils.SERVERTYPE.MySQL);
                BasicSQLUtils.deleteAllRecordsFromTable("registeritem", BasicSQLUtils.SERVERTYPE.MySQL);
            } else {
                BasicSQLUtils.deleteAllRecordsFromTable("track", BasicSQLUtils.SERVERTYPE.MySQL);
                BasicSQLUtils.deleteAllRecordsFromTable("trackitem", BasicSQLUtils.SERVERTYPE.MySQL);
            }
        }
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                HashMap<String, String> mappedValues = new HashMap<String, String>();
                while ((text = reader.readLine()) != null) {
                    if (text.startsWith("-----------")) {
                        if (isReg) {
                            this.insertReg(mappedValues);
                        } else {
                            this.insertTrack(mappedValues);
                        }
                        mappedValues.clear();
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)text)) {
                        String[] pair = StringUtils.split((String)text, (String)"=");
                        if (pair.length == 2) {
                            mappedValues.put(pair[0].trim(), pair[1].trim());
                        } else if (pair.length != 1) {
                            System.err.println("Error pairs " + pair.length + " [" + text + "]");
                        }
                    }
                    ++this.lineNo;
                }
                System.out.println("Cnt: " + this.cnt);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                    if (this.trkStmt1 != null) {
                        this.trkStmt1.close();
                    }
                    if (this.trkStmt2 != null) {
                        this.trkStmt2.close();
                    }
                    if (this.trkStmt3 != null) {
                        this.trkStmt3.close();
                    }
                    if (this.trkStmt4 != null) {
                        this.trkStmt4.close();
                    }
                    if (this.regStmt1 != null) {
                        this.regStmt1.close();
                    }
                    if (this.regStmt2 != null) {
                        this.regStmt2.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                    if (this.trkStmt1 != null) {
                        this.trkStmt1.close();
                    }
                    if (this.trkStmt2 != null) {
                        this.trkStmt2.close();
                    }
                    if (this.trkStmt3 != null) {
                        this.trkStmt3.close();
                    }
                    if (this.trkStmt4 != null) {
                        this.trkStmt4.close();
                    }
                    if (this.regStmt1 != null) {
                        this.regStmt1.close();
                    }
                    if (this.regStmt2 != null) {
                        this.regStmt2.close();
                    }
                }
                catch (SQLException e4) {
                    e4.printStackTrace();
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                if (this.trkStmt1 != null) {
                    this.trkStmt1.close();
                }
                if (this.trkStmt2 != null) {
                    this.trkStmt2.close();
                }
                if (this.trkStmt3 != null) {
                    this.trkStmt3.close();
                }
                if (this.trkStmt4 != null) {
                    this.trkStmt4.close();
                }
                if (this.regStmt1 != null) {
                    this.regStmt1.close();
                }
                if (this.regStmt2 != null) {
                    this.regStmt2.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        block13: {
            String dbName = "stats";
            String itUsername = "root";
            String itPassword = "root";
            DBConnection colDBConn = null;
            Connection connection = null;
            try {
                try {
                    DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
                    String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, "localhost", dbName, itUsername, itPassword, driverInfo.getName());
                    System.err.println(connStr);
                    colDBConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, itUsername, itPassword);
                    connection = colDBConn.createConnection();
                    BasicSQLUtils.setDBConnection(connection);
                    RegAdder ra = new RegAdder(connection);
                    boolean doReg = false;
                    if (doReg) {
                        ra.process("/Users/rods/reg.dat", "register", true);
                        break block13;
                    }
                    ra.process("/Users/rods/track.dat", "track", true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (connection == null) break block13;
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

