/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import com.google.api.translate.Language;
import com.google.api.translate.Translate;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class L18NStringResApp {
    private static final String[] langs = new String[]{"es", "pt", "de", "se", "fr", "it"};
    private static final String RES_PATH = "/Users/rods/workspace/SpecifyDroidSF/res/";
    private static final String SRCFILE_NAME = "values/strings.xml";
    private static final String ENGFILE_NAME = "/Users/rods/workspace/SpecifyDroidSF/res/values/strings.xml";
    protected HashMap<String, Pair<String, String>> baseHash = new HashMap();
    protected Locale englishLocale = Locale.US;
    protected Locale destLocale = new Locale("se");

    private Language getLangFromCode(String code) {
        if (code.equals("es")) {
            return Language.SPANISH;
        }
        if (code.equals("pt")) {
            return Language.PORTUGUESE;
        }
        if (code.equals("de")) {
            return Language.GERMAN;
        }
        if (code.equals("se")) {
            return Language.SWEDISH;
        }
        if (code.equals("fr")) {
            return Language.FRENCH;
        }
        if (code.equals("it")) {
            return Language.ITALIAN;
        }
        return Language.ENGLISH;
    }

    protected String translate(String inputText) {
        if (inputText.isEmpty()) {
            return "";
        }
        Translate.setHttpReferrer((String)"http://www.specifysoftware.org");
        try {
            String text = inputText;
            boolean hasSpecialChars = false;
            while (StringUtils.contains((String)text, (String)"%d") || StringUtils.contains((String)text, (String)"%s") || StringUtils.contains((String)text, (String)"\\n")) {
                text = StringUtils.replace((String)text, (String)"%d", (String)"99");
                text = StringUtils.replace((String)text, (String)"%s", (String)"88");
                text = StringUtils.replace((String)text, (String)"\\n", (String)" 77 ");
                hasSpecialChars = true;
            }
            Language lang = this.getLangFromCode(this.destLocale.getLanguage());
            String newText = Translate.execute((String)text, (Language)Language.ENGLISH, (Language)lang);
            if (hasSpecialChars) {
                while (StringUtils.contains((String)newText, (String)"77") || StringUtils.contains((String)newText, (String)"88") || StringUtils.contains((String)newText, (String)"99")) {
                    newText = StringUtils.replace((String)newText, (String)"99", (String)"%d");
                    newText = StringUtils.replace((String)newText, (String)"88", (String)"%s");
                    newText = StringUtils.replace((String)newText, (String)" 77 ", (String)" \\n ");
                    newText = StringUtils.replace((String)newText, (String)"77 ", (String)"\\n ");
                    newText = StringUtils.replace((String)newText, (String)" 77", (String)" \\n");
                }
            }
            return newText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document readFileToDOM4J(FileInputStream fileinputStream) throws Exception {
        SAXReader saxReader = new SAXReader();
        saxReader.setValidation(false);
        saxReader.setStripWhitespaceText(true);
        saxReader.setFeature("http://xml.org/sax/features/namespaces", false);
        saxReader.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
        return saxReader.read((InputStream)fileinputStream);
    }

    public void process(File fileArg, boolean doDiffs) {
        try {
            String dirName = "/Users/rods/workspace/SpecifyDroidSF/res/values-" + this.destLocale.getLanguage();
            String path = String.valueOf(dirName) + File.separator + fileArg.getName();
            File file = fileArg;
            if (doDiffs) {
                file = new File(path);
            }
            Document doc = L18NStringResApp.readFileToDOM4J(new FileInputStream(file));
            Element root = doc.getRootElement();
            for (Object nodeObj : root.selectNodes("/resources/string")) {
                Node node = (Node)nodeObj;
                String name = XMLHelper.getAttr((Element)node, "name", null);
                if (doDiffs && this.baseHash.get(name) != null) continue;
                String text = node.getText();
                String transText = this.translate(text);
                if (transText != null) {
                    node.setText(transText);
                }
                System.out.println(String.valueOf(name) + "[" + text + "][" + transText + "]");
            }
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileOutputStream fos = new FileOutputStream(path);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(doc);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void moveFile(File file) {
        String dirName = "/Users/rods/workspace/SpecifyDroidSF/res/values-" + this.destLocale.getLanguage();
        String srcPath = String.valueOf(FilenameUtils.getBaseName((String)file.getName())) + "_" + this.destLocale.getLanguage() + ".xml";
        String path = String.valueOf(dirName) + File.separator + file.getName();
        try {
            FileUtils.copyFile((File)new File(srcPath), (File)new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void moveAll() {
        File file = new File(ENGFILE_NAME);
        String[] stringArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            System.out.println("Processing " + lang);
            this.destLocale = new Locale(lang);
            this.moveFile(file);
            ++n2;
        }
    }

    private String getKey(String line) {
        int sInx = line.indexOf("name=");
        if (sInx > -1) {
            int eInx = line.indexOf(34, sInx += 6);
            return line.substring(sInx, eInx);
        }
        return null;
    }

    private String getText(String line) {
        int sInx = line.indexOf(">");
        if (sInx > -1) {
            int eInx = line.indexOf(60, ++sInx);
            return line.substring(sInx, eInx);
        }
        return null;
    }

    protected void copyNewLines(File file) {
        String dirName = "/Users/rods/workspace/SpecifyDroidSF/res/values-" + this.destLocale.getLanguage();
        String dstPath = String.valueOf(dirName) + File.separator + file.getName();
        try {
            String dstLine;
            String srcLine;
            List srcLines = FileUtils.readLines((File)file, (String)"UTF8");
            Vector<String> dstLines = new Vector<String>(FileUtils.readLines((File)new File(dstPath), (String)"UTF8"));
            int dstCnt = 0;
            int i = 0;
            while (i < srcLines.size()) {
                srcLine = (String)srcLines.get(i);
                dstLine = (String)dstLines.get(dstCnt++);
                if (!(StringUtils.contains((String)srcLine, (String)"<?xml") && StringUtils.contains((String)dstLine, (String)"<?xml") || StringUtils.contains((String)srcLine, (String)"<res") && StringUtils.contains((String)dstLine, (String)"<res") || StringUtils.contains((String)srcLine, (String)"</res") && StringUtils.contains((String)dstLine, (String)"</res"))) {
                    srcLine = StringUtils.replace((String)srcLine, (String)"\\ '", (String)"\\'");
                    srcLine = StringUtils.replace((String)srcLine, (String)"s \\'", (String)"s\\'");
                    dstLine = StringUtils.replace((String)dstLine, (String)"\\ '", (String)"\\'");
                    dstLine = StringUtils.replace((String)dstLine, (String)"s \\ '", (String)"s\\'");
                    System.out.println("--- [" + srcLine + "][" + dstLine + "] -- ");
                    if (!srcLine.equals(dstLine)) {
                        String dstKey;
                        boolean isSrcComment = StringUtils.contains((String)srcLine, (String)"<!--");
                        boolean isDstComment = StringUtils.contains((String)dstLine, (String)"<!--");
                        String srcKey = !isSrcComment ? this.getKey(srcLine) : "";
                        String string = dstKey = !isDstComment ? this.getKey(dstLine) : "";
                        if (srcKey == null || dstKey == null || !srcKey.equals(dstKey) || srcKey.length() <= 0) {
                            dstLines.insertElementAt(srcLine, dstCnt++);
                        }
                    }
                }
                ++i;
            }
            System.out.println("----------------------------");
            i = 0;
            while (i < srcLines.size()) {
                srcLine = (String)srcLines.get(i);
                dstLine = (String)dstLines.get(i);
                srcLine = StringUtils.replace((String)srcLine, (String)"\\ '", (String)"\\'");
                srcLine = StringUtils.replace((String)srcLine, (String)"s \\'", (String)"s\\'");
                dstLine = StringUtils.replace((String)dstLine, (String)"\\ '", (String)"\\'");
                dstLine = StringUtils.replace((String)dstLine, (String)"s \\ '", (String)"s\\'");
                System.out.println("--- [" + srcLine + "] " + srcLine.length() + "  [" + dstLine + "] " + dstLine.length() + " -- ");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void copyNewLinesAll() {
        File file = new File(ENGFILE_NAME);
        String[] stringArray = langs;
        if (langs.length != 0) {
            String lang = stringArray[0];
            System.out.println("Copying new lines " + lang);
            this.destLocale = new Locale(lang);
            this.copyNewLines(file);
        }
    }

    protected void mergeFile(File file, File dstFile, HashMap<String, Pair<String, String>> hash) {
        try {
            List srcLines = FileUtils.readLines((File)file, (String)"UTF8");
            Vector<String> dstLines = new Vector<String>();
            int i = 0;
            while (i < srcLines.size()) {
                String line = (String)srcLines.get(i);
                if (StringUtils.contains((String)line, (String)"<string")) {
                    String key = this.getKey(line);
                    String text = null;
                    if (key != null && hash.get(key) != null) {
                        text = (String)hash.get((Object)key).first;
                    } else {
                        String txt = this.getText(line);
                        text = this.translate(txt);
                        System.out.println("[" + txt + "][" + text + "]");
                    }
                    line = String.format("    <string name=\"%s\">%s</string>", key, text);
                }
                if (line.endsWith("\n")) {
                    line = StringUtils.chomp((String)line);
                }
                dstLines.add(line);
                ++i;
            }
            FileUtils.writeLines((File)dstFile, (String)"UTF8", dstLines);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void mergeAll() {
        HashMap<String, Pair<String, String>> hash = new HashMap<String, Pair<String, String>>();
        File file = new File(ENGFILE_NAME);
        String[] stringArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            hash.clear();
            System.out.println("-------------------------------------------------");
            System.out.println("Merge new lines " + lang);
            this.destLocale = new Locale(lang);
            String dirName = "/Users/rods/workspace/SpecifyDroidSF/res/values-" + this.destLocale.getLanguage();
            String dstPath = String.valueOf(dirName) + File.separator + file.getName();
            File dstFile = new File(dstPath);
            this.process(dstFile, hash, 0);
            this.mergeFile(file, dstFile, hash);
            ++n2;
        }
    }

    public void process(File file, HashMap<String, Pair<String, String>> hash, int index) {
        try {
            Pair<String, String> p;
            Document doc = L18NStringResApp.readFileToDOM4J(new FileInputStream(file));
            Element root = doc.getRootElement();
            for (Object nodeObj : root.selectNodes("/resources/string")) {
                Node node = (Node)nodeObj;
                String name = XMLHelper.getAttr((Element)node, "name", null);
                String text = node.getText();
                p = hash.get(name);
                if (p == null) {
                    p = new Pair();
                    hash.put(name, p);
                }
                if (index == 0) {
                    p.first = text;
                    continue;
                }
                p.second = text;
            }
            if (index == 1) {
                FileOutputStream fos = new FileOutputStream(String.valueOf(FilenameUtils.getBaseName((String)file.getName())) + "_compare" + this.destLocale.getLanguage() + ".txt");
                PrintWriter pw = new PrintWriter(fos);
                Vector<String> keys = new Vector<String>(hash.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    p = hash.get(key);
                    pw.println(String.format("\n---- %s -----\n%s\n%s", key, this.chk((String)p.first), this.chk((String)p.second)));
                }
                pw.flush();
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String chk(String str) {
        return StringUtils.isEmpty((String)str) ? "<No Translation>" : str;
    }

    public void processAll(boolean doDiffs) {
        if (doDiffs) {
            this.loadBaseFile();
        }
        File file = new File(ENGFILE_NAME);
        String[] stringArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            System.out.println("Processing " + lang);
            this.destLocale = new Locale(lang);
            this.process(file, doDiffs);
            ++n2;
        }
    }

    public void loadBaseFile() {
        File file = new File("/Users/rods/workspace/SpecifyDroidSF/res/../strings.xml");
        this.baseHash.clear();
        this.process(file, this.baseHash, 0);
    }

    public void checkAll() {
        HashMap<String, Pair<String, String>> hash = new HashMap<String, Pair<String, String>>();
        File file = new File(ENGFILE_NAME);
        String[] stringArray = langs;
        int n = langs.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            hash.clear();
            System.out.println("Processing " + lang);
            this.destLocale = new Locale(lang);
            this.process(file, hash, 0);
            String fName = String.valueOf(FilenameUtils.getBaseName((String)file.getName())) + "_" + this.destLocale.getLanguage() + ".xml";
            this.process(new File(fName), hash, 1);
            ++n2;
        }
    }

    public static void main(String[] args) {
        L18NStringResApp app = new L18NStringResApp();
        app.mergeAll();
        app.checkAll();
    }
}

