/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.dom4j.Element;

public class HelpTargetFinder {
    protected FileDocument fileDoc = new FileDocument();
    protected File INDEX_DIR = new File("index");
    protected IndexReader reader;
    protected Searcher searcher;
    protected Analyzer analyzer;

    private void initLucene() {
        try {
            this.reader = IndexReader.open((Directory)FSDirectory.open((File)this.INDEX_DIR), (boolean)true);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.searcher = new IndexSearcher(this.reader);
        this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
    }

    protected int getTotalHits(Query query, int hitsPerPage) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)(5 * hitsPerPage), (boolean)false);
        this.searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        int numTotalHits = collector.getTotalHits();
        return numTotalHits;
    }

    public void processProperties() {
        this.initLucene();
        try {
            ArrayList<String> terms = new ArrayList<String>();
            HashSet<String> tocTargets = new HashSet<String>();
            Element root = XMLHelper.readFileToDOM4J(new File("help/SpecifyHelpTOC.xml"));
            if (root != null) {
                List mapIds;
                String path = "/toc/tocitem";
                while ((mapIds = root.selectNodes(path)).size() != 0) {
                    for (Iterator obj : mapIds) {
                        Element mapElement = (Element)obj;
                        String target = XMLHelper.getAttr(mapElement, "target", null);
                        if (target == null) continue;
                        tocTargets.add(target);
                        System.out.println(target);
                    }
                    path = String.valueOf(path) + "/tocitem";
                }
            } else {
                System.err.println("Couldn't open DOM for uiformatters.xml");
            }
            root = XMLHelper.readFileToDOM4J(new File("help/SpecifyHelp.jhm"));
            if (root != null) {
                List mapIds = root.selectNodes("/map/mapID");
                for (Object obj : mapIds) {
                    Element mapElement = (Element)obj;
                    String target = XMLHelper.getAttr(mapElement, "target", null);
                    if (target == null || tocTargets.contains(target)) continue;
                    terms.add(target);
                }
            } else {
                System.err.println("Couldn't open DOM for uiformatters.xml");
            }
            Vector<Pair<String, Object>> notFoundList = new Vector<Pair<String, Object>>();
            String field = "contents";
            QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, field, this.analyzer);
            int unFoundCnt = 0;
            for (String term : terms) {
                try {
                    Query query = parser.parse(term);
                    String string = null;
                    int hits = this.getTotalHits(query, 10);
                    if (hits != 0) continue;
                    notFoundList.add(new Pair<String, Object>(term, string));
                    System.out.println("'" + term + "' was not found " + (string != null ? "SubTerm[" + string + "]" : ""));
                    ++unFoundCnt;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            System.out.println("Unfound Count: " + unFoundCnt + " / " + terms.size());
            ConversionLogger convLogger = new ConversionLogger();
            convLogger.initialize("resources", "Resources");
            TableWriter tblWriter = convLogger.getWriter("resources.html", "Resources");
            tblWriter.startTable();
            tblWriter.logHdr("Id", "Full Key", "Sub Key");
            int cnt = 1;
            for (Pair pair : notFoundList) {
                tblWriter.log(Integer.toString(cnt++), (String)pair.first, pair.second != null ? (String)pair.second : "&nbsp;");
            }
            tblWriter.endTable();
            convLogger.closeAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void indexSourceFiles() {
        File SRC_DIR;
        if (this.INDEX_DIR.exists()) {
            System.out.println("Cannot save index to '" + this.INDEX_DIR + "' directory, please delete it first");
            System.exit(1);
        }
        if (!(SRC_DIR = new File("src")).exists()) {
            System.out.println("Source directory doesn't exist '" + SRC_DIR);
            System.exit(1);
        }
        Date start = new Date();
        try {
            IndexWriter writer = new IndexWriter((Directory)FSDirectory.open((File)this.INDEX_DIR), (Analyzer)new StandardAnalyzer(Version.LUCENE_CURRENT), true, IndexWriter.MaxFieldLength.LIMITED);
            System.out.println("Indexing to directory '" + this.INDEX_DIR + "'...");
            this.indexDocs(writer, SRC_DIR);
            this.indexDocs(writer, new File("config"));
            System.out.println("Optimizing...");
            writer.optimize();
            writer.close();
            Date end = new Date();
            System.out.println(String.valueOf(end.getTime() - start.getTime()) + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    void indexDocs(IndexWriter writer, File file) throws IOException {
        block3: {
            String fileName;
            block4: {
                fileName = file.getName();
                System.out.println("Parsing " + fileName);
                if (!file.canRead()) break block3;
                if (!file.isDirectory()) break block4;
                String[] files = file.list();
                if (files == null) break block3;
                int i = 0;
                while (i < files.length) {
                    this.indexDocs(writer, new File(file, files[i]));
                    ++i;
                }
                break block3;
            }
            if (!fileName.endsWith(".java") && !fileName.endsWith(".xml") && !fileName.endsWith(".html")) break block3;
            System.out.println("adding " + file);
            try {
                writer.addDocument(this.fileDoc.loadDocument(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        HelpTargetFinder fd = new HelpTargetFinder();
        fd.processProperties();
        System.out.println("App Done.");
    }

    public class FileDocument {
        public Document loadDocument(File f) throws FileNotFoundException {
            Document doc = new Document();
            doc.add((Fieldable)new Field("path", f.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("contents", (Reader)new FileReader(f)));
            return doc;
        }

        private FileDocument() {
        }
    }
}

