/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.utilapps.DataModelClassGenerator;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;

public class FixSQLString
extends CustomDialog {
    private JTextArea srcTA;
    private JTextArea dstTA;

    public FixSQLString() throws HeadlessException {
        super((Dialog)null, "SQL Fix", false, 1, (Component)null);
    }

    @Override
    public void createUI() {
        super.createUI();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,10px,f:p:g"));
        CellConstraints cc = new CellConstraints();
        this.srcTA = new JTextArea(10, 80);
        this.dstTA = new JTextArea(10, 80);
        pb.add((Component)UIHelper.createScrollPane(this.srcTA, true), cc.xy(1, 1));
        pb.add((Component)UIHelper.createScrollPane(this.dstTA, true), cc.xy(1, 3));
        this.srcTA.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                String str = FixSQLString.this.srcTA.getText();
                if (str.length() > 0) {
                    if (StringUtils.contains((String)str, (String)"\"")) {
                        FixSQLString.this.fixFromtextToSQL();
                    } else {
                        FixSQLString.this.fix();
                    }
                } else {
                    FixSQLString.this.dstTA.setText("");
                }
            }
        });
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.pack();
    }

    private void fixFromtextToSQL() {
        String srcStr = this.srcTA.getText();
        srcStr = StringUtils.replace((String)srcStr, (String)"\"", (String)"");
        srcStr = StringUtils.replace((String)srcStr, (String)"+", (String)"");
        srcStr = StringUtils.replace((String)srcStr, (String)";", (String)"");
        this.dstTA.setText(srcStr);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FixSQLString.this.dstTA.requestFocus();
                FixSQLString.this.dstTA.selectAll();
                UIHelper.setTextToClipboard(FixSQLString.this.dstTA.getText());
            }
        });
    }

    private void fix() {
        StringBuilder sb = new StringBuilder("sql = \"");
        String srcStr = this.srcTA.getText();
        boolean wasInner = false;
        String[] stringArray = StringUtils.split((String)srcStr, (String)"\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String str = StringUtils.deleteWhitespace((String)line);
            if (str.toUpperCase().startsWith("INNER") || str.toUpperCase().startsWith("ORDER") || str.toUpperCase().startsWith("GROUP")) {
                if (!wasInner) {
                    sb.append(" \" +");
                    wasInner = false;
                }
                sb.append("\n    \"" + line.trim() + " \" +");
                wasInner = true;
            } else {
                if (wasInner) {
                    sb.append("    \"");
                    wasInner = false;
                }
                sb.append(' ');
                sb.append(StringUtils.replace((String)line.trim(), (String)"\n", (String)" "));
            }
            ++n2;
        }
        if (wasInner) {
            sb.setLength(sb.length() - 3);
            sb.append("\";");
        } else {
            sb.append("\";");
        }
        this.dstTA.setText(sb.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FixSQLString.this.dstTA.requestFocus();
                FixSQLString.this.dstTA.selectAll();
                UIHelper.setTextToClipboard(FixSQLString.this.dstTA.getText());
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DataModelClassGenerator.class, e);
                }
                FixSQLString fix = new FixSQLString();
                fix.setVisible(true);
            }
        });
    }
}

