/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;

public class COLTaxaMaker {
    protected String[] levelNames = new String[]{"Kingdom", "Phylum", "Class", "Superfamily", "Order", "Family", "Genus", "Infraspecies", "Species"};
    protected Connection connection = null;
    protected PrintWriter pw;
    protected Stack<String> tree = new Stack();
    protected int total = 0;

    protected void build() {
        String dbName = "CoL2008AC";
        String itUsername = "root";
        String itPassword = "root";
        DBConnection colDBConn = null;
        Statement stmt = null;
        try {
            this.pw = new PrintWriter(new File("taxa.csv"));
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, "localhost", dbName, itUsername, itPassword, driverInfo.getName());
            colDBConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, itUsername, itPassword);
            this.connection = colDBConn.createConnection();
            stmt = this.connection.createStatement();
            this.doLevel(0, 0);
            stmt.close();
            colDBConn.close();
            this.pw.close();
            System.out.println("Done " + this.total);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void printSpaces(int level) {
        int i = 0;
        while (i < level) {
            System.out.print("  ");
            ++i;
        }
    }

    protected void doLevel(int parentId, int level) throws SQLException {
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT record_id, taxon, name FROM taxa WHERE parent_id = " + parentId);
        int cnt = 0;
        while (rs.next()) {
            this.printSpaces(level);
            this.tree.push(rs.getString(3));
            this.doLevel(rs.getInt(1), level + 1);
            this.tree.pop();
            ++cnt;
        }
        if (cnt == 0) {
            int i = 0;
            while (i < this.tree.size()) {
                this.pw.append((CharSequence)this.tree.get(i));
                if (i < this.tree.size() - 1) {
                    this.pw.append(',');
                }
                ++i;
            }
            this.pw.append('\n');
            ++this.total;
            if (this.total % 10000 == 0) {
                System.out.println(this.total);
                this.pw.flush();
            }
            if (this.total == -1) {
                this.pw.close();
                System.exit(0);
            }
        }
        rs.close();
        stmt.close();
    }

    public static void main(String[] args) {
        COLTaxaMaker maker = new COLTaxaMaker();
        maker.build();
    }
}

