/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class BuildSearchIndex {
    private static final int FAMILY_RANKID = 140;
    private static final int COUNTRY_RANKID = 200;
    private Connection dbConn = null;
    private Connection dbConn2 = null;
    private Connection dbConn3 = null;
    protected int INDEX_DIR = 0;
    protected int INDEX_DIR_COL = 1;
    protected int INDEX_DIR_GEO = 2;
    protected int INDEX_DIR_LOC = 3;
    protected int INDEX_DIR_TXN = 4;
    protected String[] fileNames = new String[]{"index-specify"};
    protected File[] files = new File[this.fileNames.length];
    protected Analyzer[] analyzers = new Analyzer[this.fileNames.length];
    protected IndexReader[] readers = new IndexReader[this.fileNames.length];
    protected Searcher searcher;
    protected String dbName;

    public void createDBConnection(String server, String port, String dbName, String username, String pwd) {
        this.dbName = dbName;
        String connStr = "jdbc:mysql://%s:%s/%s?characterEncoding=UTF-8&autoReconnect=true";
        try {
            this.dbConn = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
            this.dbConn2 = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
            this.dbConn3 = DriverManager.getConnection(String.format(connStr, server, port, dbName), username, pwd);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        try {
            if (this.dbConn != null) {
                this.dbConn.close();
            }
            if (this.dbConn2 != null) {
                this.dbConn2.close();
            }
            if (this.dbConn3 != null) {
                this.dbConn3.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Connection getDBConn() {
        return this.dbConn;
    }

    private String createQuery() {
        String sqlStr = "SELECT co.CatalogNumber, co.CountAmt, ce.StartDate, ce.StationFieldNumber, det.TypeStatusName, tx.FullName, tx.Name, tx.RankID, loc.Latitude1, loc.Longitude1, loc.LocalityName, loc.MaxElevation, loc.MinElevation, geo.FullName, geo.Name, geo.RankID, ag.LastName, ag.FirstName, ag.MiddleInitial, co.Text1, co.collectionObjectId, det.DeterminationID, tx.TaxonID, ce.CollectingEventID, loc.LocalityID, geo.GeographyID, ag.AgentID, tx.ParentID, geo.ParentID FROM collectionobject AS co LEFT JOIN determination AS det ON co.CollectionObjectID = det.CollectionObjectID LEFT JOIN taxon AS tx ON det.TaxonID = tx.TaxonID LEFT JOIN collectingevent AS ce ON co.CollectingEventID = ce.CollectingEventID LEFT JOIN collector AS col ON ce.CollectingEventID = col.CollectingEventID LEFT JOIN agent AS ag ON col.AgentID = ag.AgentID LEFT JOIN locality AS loc ON ce.LocalityID = loc.LocalityID LEFT JOIN geography AS geo ON loc.GeographyID = geo.GeographyID WHERE det.isCurrent <> 0 AND co.collectionMemberId = 4 AND col.OrderNumber = 1 ORDER BY co.collectionObjectId";
        return sqlStr;
    }

    private String buildStr(ResultSet rs, StringBuilder sb, int ... indexes) throws SQLException {
        sb.setLength(0);
        int i = 0;
        while (i < indexes.length) {
            String val = rs.getString(indexes[i]);
            if (StringUtils.isNotEmpty((String)val)) {
                sb.append(val);
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void index() {
        block62: {
            block61: {
                colToTblId = new int[]{1, 1, 10, 10, 4, 4, 4, 4, 2, 2, 2, 2, 2, 3, 3, 3, 5, 5, 5, 1, 1, 9, 4, 10, 2, 3, 5, 4, 3};
                v0 = new int[29];
                v0[0] = 1;
                v0[2] = 1;
                v0[3] = 1;
                v0[4] = 1;
                v0[5] = 1;
                v0[8] = 1;
                v0[9] = 1;
                v0[10] = 1;
                v0[13] = 1;
                v0[16] = 1;
                v0[17] = 1;
                v0[18] = 1;
                includeCol = v0;
                idIndex = 20;
                taxIndex = 23;
                geoIndex = 26;
                ceIndex = 24;
                geoNameIndex = 15;
                taxNameIndex = 7;
                collDateIndex = 3;
                taxParentIndex = 28;
                geoParentIndex = 29;
                cal = Calendar.getInstance();
                startTime = System.currentTimeMillis();
                writers = null;
                try {
                    try {
                        i = 0;
                        while (i < this.analyzers.length) {
                            this.files[i] = new File(this.fileNames[i]);
                            this.analyzers[i] = new StandardAnalyzer(Version.LUCENE_30);
                            FileUtils.deleteDirectory((File)this.files[i]);
                            ++i;
                        }
                        System.out.println("Indexing to directory '" + this.INDEX_DIR + "'...");
                        totalRecs = BasicSQLUtils.getCount(this.dbConn, "SELECT COUNT(*) FROM collectionobject").intValue();
                        procRecs = 0L;
                        stmt = null;
                        stmt2 = null;
                        stmt3 = null;
                        try {
                            writers = new IndexWriter[this.analyzers.length];
                            i = 0;
                            while (i < this.files.length) {
                                writers[i] = new IndexWriter((Directory)FSDirectory.open((File)this.files[i]), this.analyzers[i], true, IndexWriter.MaxFieldLength.LIMITED);
                                ++i;
                            }
                            System.out.println("Total Records: " + totalRecs);
                            stmt = this.dbConn.createStatement(1003, 1007);
                            stmt.setFetchSize(-2147483648);
                            stmt2 = this.dbConn2.createStatement();
                            stmt3 = this.dbConn3.createStatement();
                            stmt3.setFetchSize(-2147483648);
                            sql = this.createQuery();
                            System.out.println(sql);
                            rs = stmt.executeQuery(sql);
                            md = rs.getMetaData();
                            indexStr = new StringBuilder();
                            contents = new StringBuilder();
                            sb = new StringBuilder();
                            while (rs.next()) {
                                id = rs.getString(idIndex + 1);
                                doc = new Document();
                                doc.add((Fieldable)new Field("id", id.toString(), Field.Store.YES, Field.Index.ANALYZED));
                                indexStr.setLength(0);
                                contents.setLength(0);
                                sb.setLength(0);
                                cnt = 0;
                                i = 0;
                                while (i < idIndex) {
                                    if (includeCol[i] == 1) {
                                        val = rs.getString(i + 1);
                                        if (i == 0) {
                                            val = val.replaceFirst("^0+(?!$)", "");
                                        }
                                        contents.append(StringUtils.isNotEmpty((String)val) != false ? val : " ");
                                        contents.append('\t');
                                        ++cnt;
                                    }
                                    ++i;
                                }
                                indexStr.append((CharSequence)contents);
                                collDate = rs.getDate(collDateIndex);
                                if (collDate != null) {
                                    cal.setTime(collDate);
                                    yearStr = Integer.toString(cal.get(1));
                                    indexStr.append(yearStr);
                                    indexStr.append('\t');
                                    doc.add((Fieldable)new Field("yr", yearStr, Field.Store.YES, Field.Index.ANALYZED));
                                }
                                sb.setLength(0);
                                i = idIndex;
                                while (i < colToTblId.length) {
                                    doc.add((Fieldable)new Field(Integer.toString(colToTblId[i]), Integer.toString(rs.getInt(i + 1)), Field.Store.YES, Field.Index.NOT_ANALYZED));
                                    ++i;
                                }
                                doc.add((Fieldable)new Field("xref", sb.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                                catNum = rs.getString(1);
                                if (StringUtils.isNotEmpty((String)catNum)) {
                                    doc.add((Fieldable)new Field("cn", catNum, Field.Store.YES, Field.Index.ANALYZED));
                                }
                                if (!(hasName = false)) {
                                    contents.append(" ");
                                }
                                contents.append('\t');
                                dataStr = this.buildStr(rs, sb, new int[]{17, 18, 19});
                                if (StringUtils.isNotEmpty((String)dataStr)) {
                                    doc.add((Fieldable)new Field("ag", dataStr, Field.Store.NO, Field.Index.ANALYZED));
                                }
                                if (StringUtils.isNotEmpty((String)(dataStr = this.buildStr(rs, sb, new int[]{9, 10, 11, 12, 13, 14})))) {
                                    doc.add((Fieldable)new Field("lc", dataStr, Field.Store.NO, Field.Index.ANALYZED));
                                }
                                if (StringUtils.isNotEmpty((String)(dataStr = this.buildStr(rs, sb, new int[]{5, 6})))) {
                                    doc.add((Fieldable)new Field("tx", dataStr, Field.Store.NO, Field.Index.ANALYZED));
                                }
                                taxId = rs.getInt(taxIndex);
                                taxOK = rs.wasNull() == false;
                                taxPId = rs.getInt(taxParentIndex);
                                taxOK = taxOK != false && rs.wasNull() == false;
                                geoId = rs.getInt(geoIndex);
                                geoOK = rs.wasNull() == false;
                                geoPId = rs.getInt(geoParentIndex);
                                geoOK = geoOK != false && rs.wasNull() == false;
                                ceId = rs.getInt(ceIndex);
                                v1 = ceOK = rs.wasNull() == false;
                                if (taxOK) {
                                    this.addHigherTaxa(stmt2, doc, indexStr, taxId, taxPId, rs.getInt(taxNameIndex + 1), rs.getString(taxNameIndex));
                                    this.addAuthor(stmt2, doc, indexStr, taxId);
                                }
                                if (geoOK) {
                                    this.addCountry(stmt2, doc, indexStr, geoId, geoPId, rs.getInt(geoNameIndex + 1), rs.getString(geoNameIndex));
                                }
                                if (ceOK) {
                                    this.addHost(stmt2, doc, indexStr, ceId);
                                }
                                doc.add((Fieldable)new Field("cs", indexStr.toString(), Field.Store.NO, Field.Index.ANALYZED));
                                writers[0].addDocument(doc);
                                if (++procRecs % 1000L == 0L) {
                                    System.out.println(procRecs);
                                }
                                if (procRecs % 100000L != 0L) continue;
                                System.out.println("Optimizing...");
                                writers[0].optimize();
                            }
                            rs.close();
                        }
                        catch (SQLException sqlex) {
                            sqlex.printStackTrace();
                            if (stmt == null) break block61;
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                if (stmt2 != null) {
                                    stmt2.close();
                                }
                                if (stmt3 != null) {
                                    stmt3.close();
                                }
                                break block61;
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            break block61;
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                                System.out.println("IOException adding Lucene Document: " + e.getMessage());
                                break block61;
                            }
                            catch (Throwable var44_53) {
                                throw var44_53;
                            }
                            finally {
                                if (stmt != null) {
                                    try {
                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                        if (stmt2 != null) {
                                            stmt2.close();
                                        }
                                        if (stmt3 != null) {
                                            stmt3.close();
                                        }
                                    }
                                    catch (SQLException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        if (stmt == null) break block61;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (stmt2 != null) {
                                stmt2.close();
                            }
                            if (stmt3 != null) {
                                stmt3.close();
                            }
                            break block61;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        break block61;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
                        var50_54 = this.analyzers;
                        var49_57 = this.analyzers.length;
                        var48_60 = 0;
                        ** while (var48_60 < var49_57)
                    }
                }
                catch (Throwable var46_78) {
                    var50_55 = this.analyzers;
                    var49_58 = this.analyzers.length;
                    var48_61 = 0;
                    ** while (var48_61 < var49_58)
                }
lbl-1000:
                // 1 sources

                {
                    a = var50_54[var48_60];
                    a.close();
                    ++var48_60;
                    continue;
                }
lbl204:
                // 1 sources

                this.analyzers = null;
                var50_54 = writers;
                var49_57 = writers.length;
                var48_60 = 0;
                while (var48_60 < var49_57) {
                    writer = var50_54[var48_60];
                    try {
                        System.out.println("Optimizing...");
                        writer.optimize();
                        writer.close();
                        System.out.println("Done Optimizing.");
                    }
                    catch (CorruptIndexException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    writer = null;
                    ++var48_60;
                }
                endTime = System.currentTimeMillis();
                System.out.println("Time: " + (endTime - startTime) / 1000L);
                break block62;
lbl-1000:
                // 1 sources

                {
                    a = var50_55[var48_61];
                    a.close();
                    ++var48_61;
                    continue;
                }
lbl236:
                // 1 sources

                this.analyzers = null;
                var50_55 = writers;
                var49_58 = writers.length;
                var48_61 = 0;
                while (var48_61 < var49_58) {
                    writer = var50_55[var48_61];
                    try {
                        System.out.println("Optimizing...");
                        writer.optimize();
                        writer.close();
                        System.out.println("Done Optimizing.");
                    }
                    catch (CorruptIndexException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    writer = null;
                    ++var48_61;
                }
                endTime = System.currentTimeMillis();
                System.out.println("Time: " + (endTime - startTime) / 1000L);
                throw var46_78;
            }
            var50_56 = this.analyzers;
            var49_59 = this.analyzers.length;
            var48_62 = 0;
            while (var48_62 < var49_59) {
                a = var50_56[var48_62];
                a.close();
                ++var48_62;
            }
            this.analyzers = null;
            var50_56 = writers;
            var49_59 = writers.length;
            var48_62 = 0;
            while (var48_62 < var49_59) {
                writer = var50_56[var48_62];
                try {
                    System.out.println("Optimizing...");
                    writer.optimize();
                    writer.close();
                    System.out.println("Done Optimizing.");
                }
                catch (CorruptIndexException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                writer = null;
                ++var48_62;
            }
            endTime = System.currentTimeMillis();
            System.out.println("Time: " + (endTime - startTime) / 1000L);
        }
    }

    private void appendStr(StringBuilder sb, String val, boolean doSep, String sep) {
        if (StringUtils.isNotEmpty((String)val)) {
            if (doSep) {
                sb.append(sep);
            }
            sb.append(val);
        }
    }

    /*
     * Exception decompiling
     */
    private void addHigherTaxa(Statement stmt, Document doc, StringBuilder indexStr, int taxonId, int taxonParentId, int rankId, String taxName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addAuthor(Statement stmt, Document doc, StringBuilder indexStr, int taxId) {
        StringBuilder sb;
        block22: {
            sb = null;
            String sql = "SELECT t.TaxonID, t.Author, r.ReferenceWorkType, r.Title, r.WorkDate, j.JournalName, ag.LastName, ag.FirstName, ag.MiddleInitial, a.OrderNumber FROM taxon AS t Left Join taxoncitation AS tc ON t.TaxonID = tc.TaxonID Left Join referencework AS r ON tc.ReferenceWorkID = r.ReferenceWorkID Left Join journal AS j ON r.JournalID = j.JournalID Left Join author AS a ON r.ReferenceWorkID = a.ReferenceWorkID Inner Join agent AS ag ON a.AgentID = ag.AgentID WHERE t.TaxonID = " + taxId;
            ResultSet rs = null;
            try {
                try {
                    boolean first = true;
                    StringBuilder authors = null;
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        if (first) {
                            sb = new StringBuilder();
                            String auth = rs.getString(2);
                            String title = rs.getString(4);
                            String wrkDate = rs.getString(5);
                            String jName = rs.getString(6);
                            if (StringUtils.isNotEmpty((String)wrkDate)) {
                                doc.add((Fieldable)new Field("yb", wrkDate, Field.Store.YES, Field.Index.ANALYZED));
                            }
                            this.appendStr(sb, auth, false, null);
                            this.appendStr(sb, title, sb.length() > 0, "; ");
                            this.appendStr(sb, jName, sb.length() > 0, "; ");
                            this.appendStr(sb, wrkDate, sb.length() > 0, "; ");
                            first = false;
                        }
                        String lName = rs.getString(7);
                        String fName = rs.getString(8);
                        String mName = rs.getString(9);
                        if (authors == null) {
                            authors = new StringBuilder();
                        }
                        this.appendStr(authors, lName, authors.length() > 0, "; ");
                        this.appendStr(authors, fName, authors.length() > 0, ", ");
                        this.appendStr(authors, mName, authors.length() > 0, ", ");
                    }
                    if (authors != null && authors.length() > 0) {
                        if (sb == null) {
                            sb = new StringBuilder();
                        }
                        sb.append("(");
                        sb.append((CharSequence)authors);
                        sb.append(")");
                    }
                    if (sb != null) {
                        doc.add((Fieldable)new Field("au", sb.toString(), Field.Store.YES, Field.Index.ANALYZED));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block22;
                    }
                    catch (SQLException sQLException2) {}
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (sb != null && sb.length() > 0) {
            indexStr.append('\t');
            indexStr.append(sb.toString());
        }
    }

    private void addCountry(Statement stmt, Document doc, StringBuilder indexStr, int geographyId, int geographyParentId, int rankId, String geoName) {
        String country;
        block22: {
            country = null;
            if (rankId == 200) {
                if (StringUtils.isNotEmpty((String)geoName)) {
                    country = geoName;
                }
            } else if (rankId > 200) {
                int geoPId = geographyParentId;
                ResultSet rs = null;
                int rId = rankId;
                try {
                    try {
                        int prevRankId = rankId;
                        boolean isParentNull = false;
                        while (rId > 200) {
                            rs = stmt.executeQuery("SELECT GeographyID, RankID, Name, ParentID FROM geography WHERE GeographyID = " + geoPId);
                            if (rs.next() && !isParentNull) {
                                rId = rs.getInt(2);
                                country = rs.getString(3);
                                geoPId = rs.getInt(4);
                                isParentNull = rs.wasNull();
                                if (rId >= prevRankId) break;
                                prevRankId = rId;
                            } else {
                                isParentNull = true;
                            }
                            rs.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            break block22;
                        }
                        catch (SQLException sQLException) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isNotEmpty((String)country)) {
            indexStr.append('\t');
            indexStr.append(country);
            doc.add((Fieldable)new Field("cy", country, Field.Store.YES, Field.Index.ANALYZED));
        }
    }

    private void addHost(Statement stmt, Document doc, StringBuilder indexStr, int ceId) {
        String sql = "SELECT t.FullName FROM collectingevent AS ce Inner Join collectingeventattribute AS a ON ce.CollectingEventAttributeID = a.CollectingEventAttributeID Inner Join taxon AS t ON a.HostTaxonID = t.TaxonID WHERE ce.CollectingEventID = " + ceId;
        ResultSet rs = null;
        String name = null;
        try {
            try {
                rs = stmt.executeQuery(sql);
                if (rs.next() && StringUtils.isNotEmpty((String)(name = rs.getString(1)))) {
                    indexStr.append('\t');
                    indexStr.append(name);
                    doc.add((Fieldable)new Field("hs", name, Field.Store.YES, Field.Index.ANALYZED));
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSearch() {
        Statement stmt = null;
        String querystr = "23033";
        String term = "1";
        try {
            try {
                this.analyzers = new Analyzer[this.fileNames.length];
                int i = 0;
                while (i < this.analyzers.length) {
                    this.files[i] = new File(this.fileNames[i]);
                    this.analyzers[i] = new StandardAnalyzer(Version.LUCENE_30);
                    this.readers[i] = IndexReader.open((Directory)FSDirectory.open((File)this.files[i]), (boolean)true);
                    ++i;
                }
                HashMap tblIdHash = new HashMap();
                int inx = 0;
                while (inx < this.analyzers.length) {
                    long startTime = System.currentTimeMillis();
                    QueryParser queryParser = new QueryParser(Version.LUCENE_30, term, this.analyzers[inx]);
                    Query query = queryParser.parse(querystr);
                    int hitsPerPage = 10;
                    this.searcher = new IndexSearcher(this.readers[inx]);
                    TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
                    this.searcher.search(query, (Collector)collector);
                    ScoreDoc[] hits = collector.topDocs().scoreDocs;
                    System.out.println("\n------------- " + this.fileNames[inx] + " - Found: " + hits.length + " hits.");
                    int i2 = 0;
                    while (i2 < hits.length) {
                        int docId = hits[i2].doc;
                        Document d = this.searcher.doc(docId);
                        System.out.println(String.valueOf(i2 + 1) + ". " + d.get("1"));
                        ++i2;
                    }
                    System.out.println(String.format("Time: %8.2f", (double)(System.currentTimeMillis() - startTime) / 1000.0));
                    this.searcher.close();
                    ++inx;
                }
                int i3 = 0;
                while (i3 < this.analyzers.length) {
                    this.readers[i3].close();
                    this.analyzers[i3].close();
                    ++i3;
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (stmt == null) return;
                try {
                    stmt.close();
                    return;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (ParseException e) {
                e.printStackTrace();
                if (stmt == null) return;
                try {
                    stmt.close();
                    return;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        BuildSearchIndex bsi = new BuildSearchIndex();
        bsi.testSearch();
    }
}

