/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.toycode;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BugParse {
    protected Hashtable<Integer, Hashtable<Integer, Integer>> hashNew = new Hashtable();
    protected Hashtable<Integer, Hashtable<Integer, Integer>> hashRes = new Hashtable();
    protected Hashtable<Integer, Hashtable<Integer, Integer>> hashDif = new Hashtable();
    protected Hashtable<Integer, Bug> bugHash = new Hashtable();

    public BugParse() {
        this.parse("20060901_.txt");
        this.parse("20070901_.txt");
        this.parse("20080301_.txt");
        this.parse("20080701_.txt");
        this.parse("Now_.txt");
        String eng = "meg";
        boolean doPriority = false;
        int cnt = 0;
        Vector<Integer> keys = new Vector<Integer>(this.bugHash.keySet());
        Collections.sort(keys);
        for (Bug bug : this.bugHash.values()) {
            if (eng != null && !bug.getEngineer().startsWith(eng) || doPriority && !bug.getPriority().equals("P1") && !bug.getPriority().equals("P1")) continue;
            this.process(this.hashNew, bug.getOpenYear(), bug.getOpenMon());
            if (bug.isClosed) {
                this.process(this.hashRes, bug.getModYear(), bug.getModMon());
            }
            System.out.println(String.valueOf(bug.getNumber()) + "  " + bug.getOpenDate() + "  " + bug.getModDate() + "  " + bug.isClosed());
            ++cnt;
        }
        System.err.println(cnt);
        StringBuilder yearStr = new StringBuilder();
        StringBuilder dataStr = new StringBuilder();
        int year = 2005;
        while (year < 2009) {
            int start = year == 2005 ? 7 : 1;
            int end = year == 2008 ? 11 : 13;
            Hashtable<Integer, Integer> yearHashNew = this.hashNew.get(year);
            int mon = start;
            while (mon < end) {
                Integer monNew;
                Integer n = monNew = yearHashNew != null ? yearHashNew.get(mon) : null;
                if (monNew == null) {
                    monNew = 0;
                }
                if (yearStr.length() > 0) {
                    yearStr.append(',');
                }
                yearStr.append(String.valueOf(mon) + "/" + Integer.toString(year - 2000));
                if (dataStr.length() > 0) {
                    dataStr.append(',');
                }
                dataStr.append(monNew);
                ++mon;
            }
            ++year;
        }
        Vector<String> dataLines = new Vector<String>();
        dataLines.add(yearStr.toString());
        dataLines.add(dataStr.toString());
        System.out.println(yearStr.toString());
        System.out.println(dataStr.toString());
        yearStr = new StringBuilder();
        dataStr = new StringBuilder();
        StringBuilder dataStrDif = new StringBuilder();
        int diffTotal = 0;
        int year2 = 2005;
        while (year2 < 2009) {
            int start = year2 == 2005 ? 7 : 1;
            int end = year2 == 2008 ? 11 : 13;
            Hashtable<Integer, Integer> yearHashNew = this.hashNew.get(year2);
            Hashtable<Integer, Integer> yearHashRes = this.hashRes.get(year2);
            int mon = start;
            while (mon < end) {
                Integer monRes;
                Integer monNew;
                Integer n = monNew = yearHashNew != null ? yearHashNew.get(mon) : null;
                if (monNew == null) {
                    monNew = 0;
                }
                Integer n2 = monRes = yearHashRes != null ? yearHashRes.get(mon) : null;
                if (monRes == null) {
                    monRes = 0;
                }
                if (yearStr.length() > 0) {
                    yearStr.append(',');
                }
                yearStr.append(String.valueOf(mon) + "/" + Integer.toString(year2 - 2000));
                if (dataStr.length() > 0) {
                    dataStr.append(',');
                }
                dataStr.append(monRes);
                System.out.println("> " + (diffTotal += monNew - monRes) + "  " + year2 + "  " + mon + " " + monNew + "  " + monRes);
                if (dataStrDif.length() > 0) {
                    dataStrDif.append(',');
                }
                dataStrDif.append(diffTotal);
                ++mon;
            }
            ++year2;
        }
        System.out.println(dataStr.toString());
        System.out.println(dataStrDif.toString());
        dataLines.add(dataStr.toString());
        dataLines.add(dataStrDif.toString());
        this.createChart(dataLines, eng == null ? "All" : eng);
    }

    protected static void fill(DefaultCategoryDataset ds, double[] vals, String[] col, String cat) {
        double total = 0.0;
        int i = 0;
        double[] dArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            total += d;
            ds.addValue(d, (Comparable)((Object)col[i++]), (Comparable)((Object)cat));
            ++n2;
        }
    }

    protected void createChart(List<String> lines, String engineer) {
        int inx;
        int[] mins = new int[lines.size() - 1];
        int index = 1;
        while (index < lines.size()) {
            String line = lines.get(index);
            String[] values = StringUtils.splitPreserveAllTokens((String)line, (String)",");
            inx = 0;
            while (inx < values.length && values[inx].equals("0")) {
                ++inx;
            }
            mins[index - 1] = inx < values.length ? inx : Integer.MAX_VALUE;
            System.err.println(mins[index - 1]);
            ++index;
        }
        int startInx = Integer.MAX_VALUE;
        int[] nArray = mins;
        inx = mins.length;
        int values = 0;
        while (values < inx) {
            int min = nArray[values];
            startInx = Math.min(startInx, min);
            System.out.println(String.valueOf(min) + "  " + startInx);
            ++values;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String[] headers = StringUtils.split((String)lines.get(0), (String)",");
        int len = headers.length - startInx;
        System.out.println(String.valueOf(headers.length) + "  " + len);
        Vector<double[]> valArray = new Vector<double[]>();
        int i = 1;
        while (i < lines.size()) {
            String[] values2 = StringUtils.splitPreserveAllTokens((String)lines.get(i), (String)",");
            double[] vals = new double[len];
            int inx2 = 0;
            double prev = -1.0;
            int j = startInx;
            while (j < headers.length) {
                if (StringUtils.isNotEmpty((String)values2[j])) {
                    prev = Double.parseDouble(values2[j]);
                    vals[inx2++] = prev;
                } else {
                    vals[inx2++] = 0.0;
                }
                ++j;
            }
            valArray.add(vals);
            ++i;
        }
        double[] vals = (double[])valArray.get(0);
        int i2 = 0;
        while (i2 < vals.length) {
            dataset.addValue(vals[i2], (Comparable)((Object)"Bugs"), (Comparable)((Object)headers[i2 + startInx]));
            ++i2;
        }
        vals = (double[])valArray.get(1);
        i2 = 0;
        while (i2 < vals.length) {
            dataset.addValue(vals[i2], (Comparable)((Object)"Resolved"), (Comparable)((Object)headers[i2 + startInx]));
            ++i2;
        }
        vals = (double[])valArray.get(2);
        i2 = 0;
        while (i2 < vals.length) {
            dataset.addValue(vals[i2], (Comparable)((Object)"Open"), (Comparable)((Object)headers[i2 + startInx]));
            ++i2;
        }
        JFreeChart chart = ChartFactory.createLineChart((String)("Bugs - " + engineer), (String)"Time", (String)"Bugs", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setAxisLineVisible(true);
        CategoryAxis catAxis = plot.getDomainAxis();
        catAxis.setAxisLineVisible(true);
        catAxis.setTickMarksVisible(true);
        ChartFrame frame = new ChartFrame("", chart, false);
        frame.setBackground(Color.WHITE);
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    protected void process(Hashtable<Integer, Hashtable<Integer, Integer>> hash, int year, int mon) {
        Integer monTotal;
        Hashtable<Integer, Integer> yearHashDif;
        Hashtable<Integer, Integer> yearHash = hash.get(year);
        if (yearHash == null) {
            yearHash = new Hashtable();
            hash.put(year, yearHash);
        }
        if ((yearHashDif = this.hashDif.get(year)) == null) {
            yearHashDif = new Hashtable();
            this.hashDif.put(year, yearHashDif);
        }
        int tot = (monTotal = yearHash.get(mon)) == null ? 0 : monTotal;
        yearHash.put(mon, ++tot);
        yearHashDif.put(mon, 0);
    }

    protected void parse(String fileName) {
        try {
            List lines = FileUtils.readLines((File)new File("/Users/rod/Downloads/" + fileName));
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.get(i);
                if (StringUtils.contains((String)line, (String)"show_bug.cgi?id")) {
                    String line2 = (String)lines.get(++i);
                    String[] tokens1 = StringUtils.split((String)line);
                    String[] tokens2 = StringUtils.split((String)line2);
                    int number = Integer.parseInt(tokens1[0]);
                    Bug bug = new Bug(number, tokens1[2], tokens1[3], tokens2[0], tokens1[4], tokens1[5]);
                    bug.setClosed(!tokens2[1].equals("ASSI") && !tokens2[1].equals("NEW"));
                    this.bugHash.put(number, bug);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BugParse.class, ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new BugParse();
    }

    class Bug {
        protected int number;
        protected String openDate;
        protected String modDate;
        protected String engineer;
        protected String severity;
        protected String priority;
        protected boolean isClosed;

        public Bug(int number, String openDate, String modDate, String engineer, String severity, String priority) {
            this.number = number;
            this.openDate = openDate;
            this.modDate = modDate;
            this.engineer = engineer;
            this.severity = severity;
            this.priority = priority;
        }

        protected int getOpenYear() {
            if (this.openDate.length() != 10) {
                this.openDate = "2008-10-10";
            }
            return Integer.parseInt(this.openDate.substring(0, 4));
        }

        protected int getOpenMon() {
            return Integer.parseInt(this.openDate.substring(5, 7));
        }

        protected int getModYear() {
            if (this.modDate.length() != 10) {
                this.modDate = "2008-10-10";
            }
            return Integer.parseInt(this.modDate.substring(0, 4));
        }

        protected int getModMon() {
            return Integer.parseInt(this.modDate.substring(5, 7));
        }

        public int getNumber() {
            return this.number;
        }

        public String getOpenDate() {
            return this.openDate;
        }

        public String getModDate() {
            return this.modDate;
        }

        public String getEngineer() {
            return this.engineer;
        }

        public String getSeverity() {
            return this.severity;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public void setClosed(boolean isClosed) {
            this.isClosed = isClosed;
        }

        public String getPriority() {
            return this.priority;
        }
    }
}

