/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.schemalocale.DisplayLocale;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerDlg;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.lang.StringUtils;

public class SchemaToolsDlg
extends CustomDialog {
    private static final String SL_CHS_LOC = "SL_CHS_LOC";
    private static final String SL_CHS_IMP = "SL_CHS_IMP";
    protected JButton editSchemaBtn = UIHelper.createI18NButton("SL_EDIT_SCHEMA");
    protected JButton removeLocaleBtn = UIHelper.createI18NButton("SL_REMOVE_SCHEMA_LOC");
    protected JButton exportSchemaLocBtn = UIHelper.createI18NButton("SL_EXPORT_SCHEMA_LOC");
    protected JButton importSchemaLocBtn = UIHelper.createI18NButton("SL_IMPORT_SCHEMA_LOC");
    protected JList localeList;
    protected Byte schemaType;
    protected DBTableIdMgr tableMgr;

    public SchemaToolsDlg(Frame frame, Byte schemaType, DBTableIdMgr tableMgr) throws HeadlessException {
        super(frame, UIRegistry.getResourceString("SL_TOOLS_TITLE"), true, 5, null);
        this.schemaType = schemaType;
        this.tableMgr = tableMgr;
        this.helpContext = "SL_TOOLS_HELP_CONTEXT";
    }

    @Override
    public void createUI() {
        this.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        super.createUI();
        this.setDefaultCloseOperation(0);
        Vector<DisplayLocale> localeDisplays = new Vector<DisplayLocale>();
        for (Locale locale : SchemaLocalizerDlg.getLocalesInUseInDB(this.schemaType)) {
            localeDisplays.add(new DisplayLocale(locale));
        }
        this.localeList = new JList(localeDisplays);
        JScrollPane sp = UIHelper.createScrollPane(this.localeList, true);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,2px,p,16px,p,4px,p,8px,p,10px"));
        builder.addSeparator(UIRegistry.getResourceString("SL_LOCALES_IN_USE"), cc.xywh(1, 1, 3, 1));
        builder.add((Component)sp, cc.xywh(1, 3, 3, 1));
        builder.addSeparator(UIRegistry.getResourceString("SL_TASKS"), cc.xywh(1, 5, 3, 1));
        builder.add((Component)this.editSchemaBtn, cc.xy(1, 7));
        builder.add((Component)this.removeLocaleBtn, cc.xy(3, 7));
        builder.add((Component)this.exportSchemaLocBtn, cc.xy(1, 9));
        builder.add((Component)this.importSchemaLocBtn, cc.xy(3, 9));
        builder.setDefaultDialogBorder();
        this.contentPanel = builder.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.enableBtns(false);
        this.localeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SchemaToolsDlg.this.localeSelected();
            }
        });
        this.localeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    SchemaToolsDlg.this.editSchema();
                }
            }
        });
        this.editSchemaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaToolsDlg.this.editSchema();
            }
        });
        this.removeLocaleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaToolsDlg.this.removeSchemaLocale();
            }
        });
        this.exportSchemaLocBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaToolsDlg.this.exportSchemaLocales();
            }
        });
        this.importSchemaLocBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SchemaToolsDlg.this.chooseImportType();
            }
        });
        this.pack();
    }

    protected void enableBtns(boolean enable) {
        this.editSchemaBtn.setEnabled(enable);
        this.removeLocaleBtn.setEnabled(false);
        this.exportSchemaLocBtn.setEnabled(enable);
    }

    protected void localeSelected() {
        DisplayLocale dispLocale = (DisplayLocale)this.localeList.getSelectedValue();
        if (dispLocale != null) {
            this.enableBtns(true);
        } else {
            this.enableBtns(false);
        }
    }

    protected void editSchema() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaToolsDlg.this.okButtonPressed();
                DisplayLocale dispLocale = (DisplayLocale)SchemaToolsDlg.this.localeList.getSelectedValue();
                if (dispLocale != null) {
                    Locale currLocale = SchemaI18NService.getCurrentLocale();
                    SchemaI18NService.setCurrentLocale(dispLocale.getLocale());
                    SchemaLocalizerDlg dlg = new SchemaLocalizerDlg((Frame)UIRegistry.getTopWindow(), SchemaToolsDlg.this.schemaType, SchemaToolsDlg.this.tableMgr);
                    dlg.setVisible(true);
                    SchemaI18NService.setCurrentLocale(currLocale);
                    SchemaToolsDlg.this.isCancelled = true;
                    ContextMgr.getTaskByName("Startup").requestContext();
                }
            }
        });
    }

    private void chooseImportType() {
        int rv = UIRegistry.askYesNoLocalized(SL_CHS_IMP, SL_CHS_LOC, UIRegistry.getResourceString("SL_CHOOSEIMPMSG"), "SL_CHOOSEIMPMSG_TITLE");
        if (rv == 0 || rv == 1) {
            this.importSchema(rv == 1);
        }
    }

    private void importSchema(final boolean doLocalization) {
        FileDialog fileDlg = new FileDialog(null);
        fileDlg.setTitle(UIRegistry.getResourceString(doLocalization ? SL_CHS_LOC : SL_CHS_IMP));
        UIHelper.centerAndShow(fileDlg);
        String fileName = fileDlg.getFile();
        if (StringUtils.isNotEmpty((String)fileName)) {
            String title = UIRegistry.getResourceString(doLocalization ? "SL_L10N_SCHEMA" : "SL_IMPORT_SCHEMA");
            final File file = new File(String.valueOf(fileDlg.getDirectory()) + File.separator + fileName);
            final SimpleGlassPane glassPane = new SimpleGlassPane(title, 18);
            glassPane.setBarHeight(12);
            glassPane.setFillColor(new Color(0, 0, 0, 85));
            this.setGlassPane(glassPane);
            glassPane.setVisible(true);
            SwingWorker<Integer, Integer> importWorker = new SwingWorker<Integer, Integer>(){
                private boolean isOK = false;

                @Override
                protected Integer doInBackground() throws Exception {
                    block8: {
                        DataProviderSessionIFace localSession = null;
                        try {
                            try {
                                localSession = DataProviderFactory.getInstance().createSession();
                                localSession.beginTransaction();
                                BuildSampleDatabase bsd = new BuildSampleDatabase();
                                Discipline discipline = localSession.get(Discipline.class, AppContextMgr.getInstance().getClassObject(Discipline.class).getId());
                                this.isOK = bsd.loadSchemaLocalization(discipline, SchemaToolsDlg.this.schemaType, DBTableIdMgr.getInstance(), null, null, doLocalization ? BuildSampleDatabase.UpdateType.eLocalize : BuildSampleDatabase.UpdateType.eImport, file, glassPane, localSession);
                                if (this.isOK) {
                                    localSession.commit();
                                    break block8;
                                }
                                localSession.rollback();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                ExceptionTracker.getInstance().capture(BuildSampleDatabase.class, ex);
                                if (localSession != null) {
                                    localSession.close();
                                }
                            }
                        }
                        finally {
                            if (localSession != null) {
                                localSession.close();
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    glassPane.setVisible(false);
                    if (this.isOK) {
                        UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
                        CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                    }
                }
            };
            importWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("progress")) {
                        glassPane.setProgress((Integer)evt.getNewValue());
                    }
                }
            });
            importWorker.execute();
        }
    }

    protected void removeSchemaLocale() {
    }

    protected void exportSchemaLocales() {
        FileDialog dlg = new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("Save"), 1);
        dlg.setVisible(true);
        String fileName = dlg.getFile();
        if (fileName != null) {
            final File outFile = new File(String.valueOf(dlg.getDirectory()) + File.separator + fileName);
            final SimpleGlassPane glassPane = new SimpleGlassPane(UIRegistry.getResourceString("SL_EXPORT_SCHEMA"), 18);
            glassPane.setBarHeight(12);
            glassPane.setFillColor(new Color(0, 0, 0, 85));
            this.setGlassPane(glassPane);
            glassPane.setVisible(true);
            SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){

                @Override
                protected Integer doInBackground() throws Exception {
                    DataProviderSessionIFace session = null;
                    try {
                        try {
                            session = DataProviderFactory.getInstance().createSession();
                            int dispId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
                            String sql = String.format("FROM SpLocaleContainer WHERE disciplineId = %d AND schemaType = %d", dispId, SchemaToolsDlg.this.schemaType);
                            List<?> spContainers = session.getDataList(sql);
                            try {
                                FileWriter fw = new FileWriter(outFile);
                                fw.write("<vector>\n");
                                BeanWriter beanWriter = new BeanWriter((Writer)fw);
                                XMLIntrospector introspector = beanWriter.getXMLIntrospector();
                                introspector.getConfiguration().setWrapCollectionsInElement(true);
                                beanWriter.getBindingConfiguration().setMapIDs(false);
                                beanWriter.setWriteEmptyElements(false);
                                beanWriter.enablePrettyPrint();
                                double step = 100.0 / (double)spContainers.size();
                                double total = 0.0;
                                for (SpLocaleContainer container : spContainers) {
                                    container.getDescs().size();
                                    container.getNames().size();
                                    beanWriter.write((Object)container);
                                    this.firePropertyChange("progress", 0, (int)(total += step));
                                }
                                fw.write("</vector>\n");
                                fw.close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, e);
                            e.printStackTrace();
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    glassPane.setVisible(false);
                }
            };
            backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("progress")) {
                        glassPane.setProgress((Integer)evt.getNewValue());
                    }
                }
            });
            backupWorker.execute();
        }
    }
}

