/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BldrPickList;
import edu.ku.brc.specify.config.init.BldrPickListItem;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.SpLocaleBase;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedContainer;
import edu.ku.brc.specify.tools.schemalocale.DisplayLocale;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFaceListener;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableJListItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrFactory;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SchemaLocalizerXMLHelper
implements LocalizableIOIFace {
    private static final Logger log = Logger.getLogger(SchemaLocalizerXMLHelper.class);
    protected static String[] fileName = new String[]{"schema_localization.xml", "wbschema_localization.xml"};
    protected static boolean doFixNames = true;
    protected static LocalizableStrFactory localizableStrFactory;
    protected Byte schemaType;
    protected DBTableIdMgr tableMgr;
    protected List<Locale> availLocales = new ArrayList<Locale>();
    protected Vector<DisciplineBasedContainer> tables = new Vector();
    protected Hashtable<String, LocalizableContainerIFace> tableHash = new Hashtable();
    protected Vector<LocalizableJListItem> tableDisplayItems;
    protected Hashtable<String, LocalizableJListItem> tableDisplayItemsHash = new Hashtable();
    protected Hashtable<LocalizableJListItem, Vector<LocalizableJListItem>> itemJListItemsHash = new Hashtable();
    protected boolean hasTableInfoChanged = false;
    protected boolean changesMadeDuringStartup = false;
    protected File inputFile = null;
    protected Vector<LocalizableStrIFace> namesList = new Vector();
    protected Vector<LocalizableStrIFace> descsList = new Vector();
    protected StringBuilder changesBuffer = new StringBuilder();

    public SchemaLocalizerXMLHelper(Byte schemaType, DBTableIdMgr tableMgr) {
        this.schemaType = schemaType;
        this.tableMgr = tableMgr;
    }

    public static LocalizableStrFactory getLocalizableStrFactory() {
        return localizableStrFactory;
    }

    public static void setLocalizableStrFactory(LocalizableStrFactory localizableStrFactory) {
        SchemaLocalizerXMLHelper.localizableStrFactory = localizableStrFactory;
    }

    public Vector<DisciplineBasedContainer> getSpLocaleContainers() {
        return this.tables;
    }

    @Override
    public boolean load(boolean useCurrentLocaleOnly) {
        return this.loadWithExternalFile(null, useCurrentLocaleOnly);
    }

    public boolean loadWithExternalFile(File externalFile, boolean useCurrentLocaleOnly) {
        boolean loadedOk;
        this.tables = this.load(null, externalFile, useCurrentLocaleOnly);
        boolean bl = loadedOk = this.tables != null;
        if (loadedOk && externalFile == null) {
            for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
                Vector<DisciplineBasedContainer> dispContainers = this.load(disciplineType.getName(), null, useCurrentLocaleOnly);
                this.addDisplineBasedContainers(disciplineType.getName(), dispContainers);
            }
        }
        return loadedOk;
    }

    protected void addDisplineBasedContainers(String discipline, Vector<DisciplineBasedContainer> dispContainers) {
        if (dispContainers != null && dispContainers.size() > 0) {
            for (DisciplineBasedContainer dspContainer : dispContainers) {
                DisciplineBasedContainer container = (DisciplineBasedContainer)this.tableHash.get(dspContainer.getName());
                if (container != null) {
                    for (SpLocaleContainerItem item : dspContainer.getItems()) {
                        container.add(discipline, item);
                    }
                    continue;
                }
                log.info((Object)("Couldn't find continer [" + dspContainer.getName() + "]"));
            }
        }
    }

    private void discoverLocalesFromData(Vector<DisciplineBasedContainer> containers) {
        HashSet<String> hash = new HashSet<String>();
        for (DisciplineBasedContainer container : containers) {
            for (SpLocaleItemStr str : container.getNames()) {
                String language = str.getLanguage();
                String country = str.getCountry();
                String variant = str.getVariant();
                String key = String.format("%s_%s_%s", language, country != null ? country : "", variant != null ? variant : "");
                if (hash.contains(key)) continue;
                Locale locale = null;
                if (StringUtils.isNotBlank((String)language) && StringUtils.isNotBlank((String)country) && StringUtils.isNotBlank((String)variant)) {
                    locale = new Locale(language, country, variant);
                } else if (StringUtils.isNotBlank((String)language) && StringUtils.isNotBlank((String)country)) {
                    locale = new Locale(language, country);
                } else if (StringUtils.isNotBlank((String)language)) {
                    locale = new Locale(language);
                }
                if (locale == null) continue;
                System.err.println("[" + key + "] " + locale);
                this.availLocales.add(locale);
                hash.add(key);
            }
        }
    }

    public List<Locale> getAvailLocales() {
        return this.availLocales;
    }

    public void addMissingTranslations(String language, Vector<DisciplineBasedContainer> containers) {
        int containerCnt = 0;
        int itemCnt = 0;
        for (DisciplineBasedContainer container : containers) {
            SpLocaleItemStr str2;
            if (container.getNamesSet().size() == 0) {
                log.debug((Object)("Container: " + container.getName() + " nameSet is empty."));
                str2 = new SpLocaleItemStr();
                str2.initialize();
                str2.setLanguage(language);
                str2.setText(container.getName());
                str2.setContainerDesc(container);
                container.getNamesSet().add(str2);
                ++containerCnt;
            } else {
                for (SpLocaleItemStr str2 : container.getNamesSet()) {
                    if (!StringUtils.isEmpty((String)str2.getText())) continue;
                    str2.setText(container.getName());
                    ++containerCnt;
                }
            }
            if (container.getDescsSet().size() == 0) {
                log.debug((Object)("Container: " + container.getName() + " descSet is empty."));
                str2 = new SpLocaleItemStr();
                str2.initialize();
                str2.setLanguage(language);
                str2.setText(container.getName());
                str2.setContainerDesc(container);
                container.getDescsSet().add(str2);
                ++containerCnt;
            } else {
                for (SpLocaleItemStr str2 : container.getDescsSet()) {
                    if (!StringUtils.isEmpty((String)str2.getText())) continue;
                    str2.setText(container.getName());
                    ++containerCnt;
                }
            }
            for (SpLocaleContainerItem sci : container.getItems()) {
                SpLocaleItemStr str32;
                if (sci.getNamesSet().size() == 0) {
                    log.debug((Object)(String.valueOf(container.getName()) + " Item: " + sci.getName() + " nameSet is empty."));
                    str32 = new SpLocaleItemStr();
                    str32.initialize();
                    str32.setLanguage(language);
                    str32.setText(sci.getName());
                    str32.setItemDesc(sci);
                    sci.getNamesSet().add(str32);
                    ++itemCnt;
                } else {
                    for (SpLocaleItemStr str32 : sci.getNamesSet()) {
                        if (!StringUtils.isEmpty((String)str32.getText())) continue;
                        str32.setText(sci.getName());
                        ++itemCnt;
                    }
                }
                if (sci.getDescsSet().size() == 0) {
                    str32 = new SpLocaleItemStr();
                    str32.initialize();
                    str32.setLanguage(language);
                    str32.setText(sci.getName());
                    str32.setItemDesc(sci);
                    sci.getDescsSet().add(str32);
                    ++itemCnt;
                    continue;
                }
                for (SpLocaleItemStr str32 : sci.getDescsSet()) {
                    if (!StringUtils.isEmpty((String)str32.getText())) continue;
                    str32.setText(sci.getName());
                    ++itemCnt;
                }
            }
        }
        log.debug((Object)String.format("Added %d container strings, %d item strings.", containerCnt, itemCnt));
        if (containerCnt > 0 || itemCnt > 0) {
            this.changesMadeDuringStartup = true;
        }
    }

    private void stripMergeLocale(String language, Set<SpLocaleItemStr> itemsSet) {
        if (itemsSet.size() == 1) {
            SpLocaleItemStr item = itemsSet.iterator().next();
            if (item.getLanguage().equals("en")) {
                item.setLanguage(language);
            }
        } else if (itemsSet.size() == 2) {
            Iterator<SpLocaleItemStr> iter = itemsSet.iterator();
            SpLocaleItemStr item1 = iter.next();
            SpLocaleItemStr item2 = iter.next();
            if (item1.getLanguage().equals(language)) {
                itemsSet.remove(item2);
            } else {
                itemsSet.remove(item1);
            }
        } else if (itemsSet.size() > 2) {
            log.error((Object)("The size [" + itemsSet.size() + "] is not on or two!"));
        } else {
            log.error((Object)("The size [" + itemsSet.size() + "] ************** "));
        }
    }

    private void stripToSingleLocale(String language, Vector<DisciplineBasedContainer> containers) {
        for (DisciplineBasedContainer container : containers) {
            this.stripMergeLocale(language, container.getNamesSet());
            this.stripMergeLocale(language, container.getDescsSet());
            for (SpLocaleContainerItem sci : container.getItems()) {
                this.stripMergeLocale(language, sci.getNamesSet());
                this.stripMergeLocale(language, sci.getDescsSet());
            }
        }
    }

    protected Vector<DisciplineBasedContainer> load(String discipline, File extFile, boolean useCurrentLocaleOnly) {
        Vector containers;
        block29: {
            containers = null;
            XStream xstream = new XStream();
            this.configXStream(xstream);
            try {
                File file;
                String fullPath = String.valueOf(discipline != null ? String.valueOf(discipline) + File.separator : "") + fileName[this.schemaType];
                File file2 = file = extFile != null ? extFile : XMLHelper.getConfigDir(fullPath);
                if (file.exists()) {
                    if (discipline == null) {
                        this.inputFile = file;
                    }
                    InputStreamReader inpStrmReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
                    containers = (Vector)xstream.fromXML((Reader)inpStrmReader);
                    if (discipline != null) {
                        return containers;
                    }
                }
                if (useCurrentLocaleOnly && containers != null && containers.size() > 0) {
                    String language = Locale.getDefault().getLanguage();
                    this.addMissingTranslations(language, containers);
                    this.stripToSingleLocale(language, containers);
                }
                if (containers != null) {
                    SpLocaleContainerItem item;
                    for (SpLocaleContainer ct : containers) {
                        Hashtable<String, Boolean> hash = new Hashtable<String, Boolean>();
                        for (SpLocaleContainerItem spLocaleContainerItem : new Vector<SpLocaleContainerItem>(ct.getItems())) {
                            if (hash.get(spLocaleContainerItem.getName()) == null) {
                                hash.put(spLocaleContainerItem.getName(), true);
                                continue;
                            }
                            log.debug((Object)("Removing Duplicate[" + spLocaleContainerItem.getName() + "]"));
                            ct.getItems().remove(spLocaleContainerItem);
                        }
                    }
                    this.tableDisplayItems = new Vector();
                    for (SpLocaleContainer cont : containers) {
                        LocalizableJListItem item3 = new LocalizableJListItem(cont.getName(), cont.getId(), null);
                        this.tableDisplayItems.add(item3);
                        this.tableDisplayItemsHash.put(cont.getName(), item3);
                        this.tableHash.put(cont.getName(), cont);
                    }
                    Collections.sort(this.tableDisplayItems);
                    log.info((Object)"Syncing with Datamodel.... (ignore errors)");
                    this.changesBuffer.append("<Center><table border=\"1\">");
                    String lang = SchemaI18NService.getCurrentLocale().getLanguage();
                    this.discoverLocalesFromData(containers);
                    if (this.availLocales.size() == 1) {
                        lang = this.availLocales.get(0).getLanguage();
                    } else {
                        Vector<DisplayLocale> list = new Vector<DisplayLocale>();
                        for (Locale locale : this.availLocales) {
                            list.add(new DisplayLocale(locale));
                        }
                        Collections.sort(list);
                        boolean cont = false;
                        while (cont) {
                            ToggleButtonChooserDlg toggleButtonChooserDlg = new ToggleButtonChooserDlg(null, "CHOOSE_LOCALE", list, ToggleButtonChooserPanel.Type.RadioButton);
                            toggleButtonChooserDlg.setUseScrollPane(true);
                            toggleButtonChooserDlg.setVisible(true);
                            cont = toggleButtonChooserDlg.isCancelled();
                            if (cont) continue;
                            lang = ((DisplayLocale)toggleButtonChooserDlg.getSelectedObject()).getLocale().getLanguage();
                        }
                    }
                    log.info((Object)"Adding New Tables and fields....");
                    for (DBTableInfo ti : this.tableMgr.getTables()) {
                        SpLocaleItemStr nameStr;
                        DisciplineBasedContainer disciplineBasedContainer = (DisciplineBasedContainer)this.tableHash.get(ti.getName());
                        if (disciplineBasedContainer == null) {
                            DisciplineBasedContainer disciplineBasedContainer2 = new DisciplineBasedContainer();
                            disciplineBasedContainer2.initialize();
                            disciplineBasedContainer2.setName(ti.getName());
                            SpLocaleItemStr nameStr2 = new SpLocaleItemStr();
                            nameStr2.initialize();
                            nameStr2.setText(UIHelper.makeNamePretty(ti.getShortClassName()));
                            nameStr2.setLanguage(lang);
                            disciplineBasedContainer2.addName(nameStr2);
                            log.info((Object)("Adding Table [" + ti.getName() + "]"));
                            this.changesMadeDuringStartup = true;
                            this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                            this.changesBuffer.append("<td align=\"center\">");
                            this.changesBuffer.append(ti.getName());
                            this.changesBuffer.append("</td><td>&nbsp;</td></tr>");
                            this.tableHash.put(disciplineBasedContainer2.getName(), disciplineBasedContainer2);
                            containers.add(disciplineBasedContainer2);
                            LocalizableJListItem jItem = new LocalizableJListItem(disciplineBasedContainer2.getName(), disciplineBasedContainer2.getId(), null);
                            this.tableDisplayItems.add(jItem);
                            this.tableDisplayItemsHash.put(disciplineBasedContainer2.getName(), jItem);
                            for (DBFieldInfo fi : ti.getFields()) {
                                SpLocaleContainerItem item4 = new SpLocaleContainerItem();
                                item4.initialize();
                                item4.setName(fi.getName());
                                item4.setWebLinkName(fi.getWebLinkName());
                                item4.setIsRequired(fi.isRequired());
                                item4.setIsHidden(fi.isHidden());
                                nameStr2 = new SpLocaleItemStr();
                                nameStr2.initialize();
                                nameStr2.setText(UIHelper.makeNamePretty(fi.getName()));
                                nameStr2.setLanguage(lang);
                                item4.addName(nameStr2);
                                log.info((Object)("  Adding Field [" + fi.getName() + "]"));
                                this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                                this.changesBuffer.append("<td align=\"center\">&nbsp;</td><td align=\"center\">");
                                this.changesBuffer.append(fi.getName());
                                this.changesBuffer.append("</td></tr>");
                                item4.setIsRequired(fi.isRequired());
                                disciplineBasedContainer2.addItem(item4);
                            }
                            for (DBRelationshipInfo ri : ti.getRelationships()) {
                                SpLocaleContainerItem item2 = new SpLocaleContainerItem();
                                item2.initialize();
                                item2.setName(ri.getName());
                                item2.setIsRequired(false);
                                log.info((Object)("  Adding Field [" + ri.getName() + "]"));
                                this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                                this.changesBuffer.append("<td align=\"center\">&nbsp;</td><td align=\"center\">");
                                this.changesBuffer.append(ri.getName());
                                this.changesBuffer.append("</td></tr>");
                                disciplineBasedContainer2.addItem(item2);
                            }
                            continue;
                        }
                        for (DBFieldInfo fi : ti.getFields()) {
                            item = (SpLocaleContainerItem)disciplineBasedContainer.getItemByName(fi.getName());
                            if (item == null) {
                                item = new SpLocaleContainerItem();
                                item.initialize();
                                item.setName(fi.getName());
                                item.setIsRequired(fi.isRequired());
                                item.setIsHidden(fi.isHidden());
                                nameStr = new SpLocaleItemStr();
                                nameStr.initialize();
                                nameStr.setText(UIHelper.makeNamePretty(fi.getName()));
                                nameStr.setLanguage(lang);
                                item.addName(nameStr);
                                disciplineBasedContainer.addItem(item);
                                log.info((Object)("For Table[" + ti.getName() + "] Adding Field [" + fi.getName() + "]"));
                                this.changesMadeDuringStartup = true;
                                this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                                this.changesBuffer.append("<td align=\"center\">" + ti.getName() + "</td><td align=\"center\">");
                                this.changesBuffer.append(fi.getName());
                                this.changesBuffer.append("</td></tr>");
                                continue;
                            }
                            if (!doFixNames) continue;
                            Class<?> cls = fi.getDataClass();
                            if (cls != null) {
                                String name = UIHelper.makeNamePretty(fi.getDataClass().getSimpleName());
                                for (SpLocaleItemStr str : item.getNames()) {
                                    if (!name.equals(str.getText())) continue;
                                    str.setText(UIHelper.makeNamePretty(fi.getName()));
                                    this.changesMadeDuringStartup = true;
                                    this.changesBuffer.append("<tr><td align=\"center\">Fixed Name</td>");
                                    this.changesBuffer.append("<td align=\"center\">" + ti.getName() + "</td><td align=\"center\">");
                                    this.changesBuffer.append(fi.getName());
                                    this.changesBuffer.append("</td></tr>");
                                }
                                continue;
                            }
                            log.error((Object)("Data Class is null for field[" + fi.getColumn() + "]"));
                        }
                        for (DBRelationshipInfo ri : ti.getRelationships()) {
                            item = (SpLocaleContainerItem)disciplineBasedContainer.getItemByName(ri.getName());
                            if (item == null) {
                                item = new SpLocaleContainerItem();
                                item.initialize();
                                item.setName(ri.getName());
                                disciplineBasedContainer.addItem(item);
                                nameStr = new SpLocaleItemStr();
                                nameStr.initialize();
                                nameStr.setText(UIHelper.makeNamePretty(ri.getName()));
                                nameStr.setLanguage(lang);
                                item.addName(nameStr);
                                log.info((Object)("For Table[" + ti.getName() + "] Adding Rel [" + ri.getName() + "]"));
                                this.changesMadeDuringStartup = true;
                                this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                                this.changesBuffer.append("<td align=\"center\">" + ti.getName() + "</td><td align=\"center\">");
                                this.changesBuffer.append(ri.getName());
                                this.changesBuffer.append("</td></tr>");
                                continue;
                            }
                            if (item.getNames().size() != 0) continue;
                            nameStr = new SpLocaleItemStr();
                            nameStr.initialize();
                            nameStr.setText(UIHelper.makeNamePretty(ri.getName()));
                            nameStr.setLanguage(lang);
                            item.addName(nameStr);
                            this.changesMadeDuringStartup = true;
                            this.changesBuffer.append("<tr><td align=\"center\">Added</td>");
                            this.changesBuffer.append("<td align=\"center\">" + ti.getName() + "</td><td align=\"center\">");
                            this.changesBuffer.append(ri.getName());
                            this.changesBuffer.append("</td></tr>");
                        }
                    }
                    log.info((Object)"Removing Old Tables and fields....");
                    for (SpLocaleContainer container : new Vector(containers)) {
                        DBTableInfo dBTableInfo = this.tableMgr.getInfoByTableName(container.getName());
                        if (dBTableInfo == null) {
                            log.info((Object)("Removing Table [" + container.getName() + "] from Schema"));
                            containers.remove(container);
                            this.tableHash.remove(container.getName());
                            this.changesMadeDuringStartup = true;
                            this.changesBuffer.append("<tr><td align=\"center\">Removed</td>");
                            this.changesBuffer.append("<td align=\"center\">");
                            this.changesBuffer.append(container.getName());
                            this.changesBuffer.append("</td><td>&nbsp;</td></tr>");
                            continue;
                        }
                        for (LocalizableItemIFace itemIF : new Vector<LocalizableItemIFace>(container.getContainerItems())) {
                            item = (SpLocaleContainerItem)itemIF;
                            DBTableChildIFace tblChild = dBTableInfo.getItemByName(item.getName());
                            if (tblChild != null) continue;
                            container.removeItem(item);
                            this.changesMadeDuringStartup = true;
                            this.changesBuffer.append("<tr><td align=\"center\" color=\"red\">Removed</td>");
                            this.changesBuffer.append("<td align=\"center\">" + dBTableInfo.getName() + "</td><td align=\"center\">");
                            this.changesBuffer.append(item.getName());
                            this.changesBuffer.append("</td></tr>");
                        }
                    }
                    this.changesBuffer.append("</table>");
                    break block29;
                }
                log.info((Object)("There were no containers for [" + file.getAbsolutePath() + "]"));
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerXMLHelper.class, ex);
                ex.printStackTrace();
            }
            catch (Exception ex) {
                UIRegistry.showError("There was a problem reading the XML in the file.");
            }
        }
        return containers;
    }

    public String getChangesBuffer() {
        return this.changesBuffer.toString();
    }

    @Override
    public boolean didModelChangeDuringLoad() {
        return this.changesMadeDuringStartup;
    }

    public LocalizableContainerIFace getContainer(String name) {
        return this.tableHash.get(name);
    }

    protected void escapeForXML() {
        for (SpLocaleContainer spLocaleContainer : this.tables) {
            spLocaleContainer.setName(StringEscapeUtils.escapeXml((String)spLocaleContainer.getName()));
            for (SpLocaleItemStr str : spLocaleContainer.getNames()) {
                str.setText(StringEscapeUtils.escapeXml((String)str.getText()));
            }
            for (SpLocaleItemStr str : spLocaleContainer.getDescs()) {
                str.setText(StringEscapeUtils.escapeXml((String)str.getText()));
            }
            for (SpLocaleContainerItem item : spLocaleContainer.getItems()) {
                item.setName(StringEscapeUtils.escapeXml((String)item.getName()));
                for (SpLocaleItemStr str : item.getNames()) {
                    str.setText(StringEscapeUtils.escapeXml((String)str.getText()));
                }
                for (SpLocaleItemStr str : item.getDescs()) {
                    str.setText(StringEscapeUtils.escapeXml((String)str.getText()));
                }
            }
        }
    }

    protected void configXStream(XStream xstream) {
        xstream.alias("container", DisciplineBasedContainer.class);
        xstream.alias("item", SpLocaleContainerItem.class);
        xstream.alias("names", SpLocaleContainerItem.class);
        xstream.alias("desc", SpLocaleContainerItem.class);
        xstream.alias("str", SpLocaleItemStr.class);
        xstream.useAttributeFor(SpLocaleBase.class, "name");
        xstream.useAttributeFor(SpLocaleBase.class, "type");
        xstream.useAttributeFor(SpLocaleBase.class, "format");
        xstream.useAttributeFor(SpLocaleBase.class, "isUIFormatter");
        xstream.useAttributeFor(SpLocaleBase.class, "pickListName");
        xstream.useAttributeFor(SpLocaleBase.class, "isHidden");
        xstream.useAttributeFor(SpLocaleItemStr.class, "country");
        xstream.useAttributeFor(SpLocaleItemStr.class, "language");
        xstream.useAttributeFor(SpLocaleItemStr.class, "variant");
        xstream.useAttributeFor(SpLocaleContainerItem.class, "isRequired");
        xstream.omitField(DisciplineBasedContainer.class, "disciplineHashItems");
        xstream.omitField(SpLocaleContainer.class, "spLocaleContainerId");
        xstream.omitField(SpLocaleContainer.class, "containerItems");
        xstream.omitField(SpLocaleContainerItem.class, "spLocaleContainerItemId");
        xstream.omitField(SpLocaleContainerItem.class, "container");
        xstream.omitField(SpLocaleItemStr.class, "spLocaleItemStrId");
        xstream.omitField(DataModelObjBase.class, "timestampCreated");
        xstream.omitField(DataModelObjBase.class, "timestampModified");
        xstream.omitField(DataModelObjBase.class, "lastEditedBy");
    }

    @Override
    public boolean save() {
        return this.save(XMLHelper.getConfigDirPath(null));
    }

    public boolean save(String basePath) {
        boolean savedOk = this.save(basePath, null, this.tables);
        if (savedOk) {
            this.changesMadeDuringStartup = false;
            this.hasTableInfoChanged = false;
            for (DisciplineType disciplineType : DisciplineType.getDisciplineList()) {
                this.save(basePath, disciplineType.getName(), null);
            }
        }
        return savedOk;
    }

    protected boolean save(String baseDir, String discipline, Vector<DisciplineBasedContainer> containers) {
        Vector<DisciplineBasedContainer> localeContainers = containers;
        String fullPath = String.valueOf(baseDir) + (discipline != null ? String.valueOf(discipline) + File.separator : "") + fileName[this.schemaType];
        File file = new File(fullPath);
        if (discipline != null) {
            localeContainers = this.filterForDisplineContainers(discipline);
        }
        return this.saveContainers(file, localeContainers);
    }

    protected boolean saveContainers(File outFile, Vector<DisciplineBasedContainer> containers) {
        block4: {
            try {
                if (containers != null) break block4;
                log.error((Object)"Datamodel information is null - datamodel file will not be written!!");
                return false;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerXMLHelper.class, ex);
                log.error((Object)"error writing writeTree", (Throwable)ex);
                return false;
            }
        }
        if (containers.size() > 0) {
            log.info((Object)("Writing descriptions to file: " + outFile.getAbsolutePath()));
            XStream xstream = new XStream();
            this.configXStream(xstream);
            OutputStreamWriter outputStrmWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF8");
            xstream.toXML(containers, (Writer)outputStrmWriter);
        }
        return true;
    }

    protected Vector<DisciplineBasedContainer> filterForDisplineContainers(String discipline) {
        Vector<DisciplineBasedContainer> disciplineContainers = new Vector<DisciplineBasedContainer>();
        for (DisciplineBasedContainer container : this.tables) {
            if (!container.hasDiscipline(discipline)) continue;
            DisciplineBasedContainer dbc = (DisciplineBasedContainer)container.clone();
            dbc.getItems().addAll(container.getDisciplineItems(discipline));
            disciplineContainers.add(dbc);
        }
        return disciplineContainers;
    }

    protected void printLocales(PrintWriter pw, LocalizableItemIFace parent, LocalizableItemIFace lndi, String lang, String country) {
        lndi.fillNames(this.namesList);
        lndi.fillNames(this.descsList);
        for (LocalizableStrIFace nm : this.namesList) {
            if (!nm.getLanguage().equals(lang) || !nm.getCountry().equals(country)) continue;
            if (parent != null) {
                pw.write(String.valueOf(parent.getName()) + "_");
            }
            pw.write(lndi.getName());
            pw.write("=");
            pw.write(nm.getText());
            pw.write("\n");
        }
        for (LocalizableStrIFace d : this.descsList) {
            if (parent != null) {
                pw.write(String.valueOf(parent.getName()) + "_");
            }
            pw.write(lndi.getName());
            pw.write("_desc");
            pw.write("=");
            pw.write(d.getText());
            pw.write("\n");
        }
    }

    @Override
    public boolean createResourceFiles() {
        Hashtable<String, Boolean> localeHash = new Hashtable<String, Boolean>();
        for (LocalizableContainerIFace localizableContainerIFace : this.tables) {
            SchemaLocalizerXMLHelper.checkForLocales(localizableContainerIFace, localeHash);
            for (LocalizableItemIFace f : localizableContainerIFace.getContainerItems()) {
                SchemaLocalizerXMLHelper.checkForLocales(f, localeHash);
            }
        }
        for (String string : localeHash.keySet()) {
            String[] toks = StringUtils.split((String)string, (char)'_');
            String lang = toks[0];
            String country = toks.length > 1 && StringUtils.isNotEmpty((String)toks[1]) ? toks[1] : "";
            File resFile = new File("db_resources" + (StringUtils.isNotEmpty((String)lang) ? "_" + lang : "") + (StringUtils.isNotEmpty((String)country) ? "_" + country : "") + ".properties");
            try {
                PrintWriter pw = new PrintWriter(resFile);
                for (LocalizableContainerIFace localizableContainerIFace : this.tables) {
                    this.printLocales(pw, null, localizableContainerIFace, lang, country);
                    for (LocalizableItemIFace f : localizableContainerIFace.getContainerItems()) {
                        this.printLocales(pw, localizableContainerIFace, f, lang, country);
                    }
                }
                pw.close();
                return true;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerXMLHelper.class, ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public LocalizableContainerIFace getContainer(LocalizableJListItem item, LocalizableIOIFaceListener l) {
        if (l != null) {
            l.containterRetrieved(this.tableHash.get(item.getName()));
            return this.tableHash.get(item.getName());
        }
        return null;
    }

    @Override
    public Vector<LocalizableJListItem> getContainerDisplayItems() {
        return this.tableDisplayItems;
    }

    @Override
    public LocalizableItemIFace getItem(LocalizableContainerIFace container, LocalizableJListItem item) {
        for (LocalizableItemIFace cItem : container.getContainerItems()) {
            if (!cItem.getName().equals(item.getName())) continue;
            return cItem;
        }
        return null;
    }

    @Override
    public Vector<LocalizableJListItem> getDisplayItems(LocalizableJListItem container) {
        Vector<LocalizableJListItem> items = this.itemJListItemsHash.get(container);
        if (items == null) {
            LocalizableContainerIFace cont = this.tableHash.get(container.getName());
            if (cont != null) {
                items = new Vector();
                for (LocalizableItemIFace item : cont.getContainerItems()) {
                    SpLocaleContainerItem cItem = (SpLocaleContainerItem)item;
                    items.add(new LocalizableJListItem(cItem.getName(), cItem.getId(), null));
                }
                this.itemJListItemsHash.put(container, items);
                Collections.sort(items);
            } else {
                log.error((Object)("Couldn't find container [" + container.getName() + "]"));
            }
        }
        return items;
    }

    @Override
    public void containerChanged(LocalizableContainerIFace container) {
        this.hasTableInfoChanged = true;
    }

    public static String makeLocaleKey(String lang, String country, String variant) {
        StringBuilder sb = new StringBuilder();
        sb.append(lang);
        sb.append(StringUtils.isNotEmpty((String)country) ? "_" + country : "");
        sb.append(StringUtils.isNotEmpty((String)variant) ? "_" + variant : "");
        return sb.toString();
    }

    protected static String makeLocaleKey(Locale locale) {
        return SchemaLocalizerXMLHelper.makeLocaleKey(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static void checkForLocales(LocalizableItemIFace lndi, Hashtable<String, Boolean> localeHash) {
        Vector<LocalizableStrIFace> namesList = new Vector<LocalizableStrIFace>();
        Vector<LocalizableStrIFace> descsList = new Vector<LocalizableStrIFace>();
        lndi.fillDescs(descsList);
        lndi.fillNames(namesList);
        for (LocalizableStrIFace nm : namesList) {
            localeHash.put(SchemaLocalizerXMLHelper.makeLocaleKey(nm.getLanguage(), nm.getCountry(), nm.getVariant()), true);
        }
        for (LocalizableStrIFace d : descsList) {
            localeHash.put(SchemaLocalizerXMLHelper.makeLocaleKey(d.getLanguage(), d.getCountry(), d.getVariant()), true);
        }
    }

    @Override
    public boolean isLocaleInUse(Locale locale) {
        Hashtable<String, Boolean> localeHash = new Hashtable<String, Boolean>();
        for (SpLocaleContainer spLocaleContainer : this.tables) {
            SchemaLocalizerXMLHelper.checkForLocales(spLocaleContainer, localeHash);
            for (LocalizableItemIFace f : spLocaleContainer.getContainerItems()) {
                SchemaLocalizerXMLHelper.checkForLocales(f, localeHash);
            }
        }
        return localeHash.get(SchemaLocalizerXMLHelper.makeLocaleKey(locale)) != null;
    }

    @Override
    public Vector<Locale> getLocalesInUse() {
        Hashtable<String, Boolean> localeHash = new Hashtable<String, Boolean>();
        for (SpLocaleContainer spLocaleContainer : this.tables) {
            SchemaLocalizerXMLHelper.checkForLocales(spLocaleContainer, localeHash);
            for (LocalizableItemIFace f : spLocaleContainer.getContainerItems()) {
                SchemaLocalizerXMLHelper.checkForLocales(f, localeHash);
            }
        }
        Vector<Locale> vector = new Vector<Locale>(localeHash.keySet().size() + 10);
        for (String key : localeHash.keySet()) {
            String[] toks = StringUtils.split((String)key, (String)"_");
            vector.add(new Locale(toks[0], "", ""));
        }
        return vector;
    }

    public void copyLocale(LocalizableItemIFace item, Locale srcLocale, Locale dstLocale) {
        item.fillDescs(this.descsList);
        item.fillNames(this.namesList);
        LocalizableStrIFace srcName = null;
        for (LocalizableStrIFace nm : this.namesList) {
            if (!nm.isLocale(srcLocale)) continue;
            srcName = nm;
            break;
        }
        if (srcName != null) {
            LocalizableStrIFace name = localizableStrFactory.create(srcName.getText(), dstLocale);
            item.addName(name);
        }
        LocalizableStrIFace srcDesc = null;
        for (LocalizableStrIFace d : this.descsList) {
            if (!d.isLocale(srcLocale)) continue;
            srcDesc = d;
            break;
        }
        if (srcDesc != null) {
            LocalizableStrIFace desc = localizableStrFactory.create(srcDesc.getText(), dstLocale);
            item.addDesc(desc);
        }
    }

    @Override
    public void copyLocale(LocalizableIOIFaceListener lclIOListener, Locale srcLocale, Locale dstLocale, PropertyChangeListener pcl) {
        double cnt = 0.0;
        Vector<LocalizableJListItem> items = this.getContainerDisplayItems();
        double inc = 100.0 / (double)items.size();
        for (LocalizableJListItem listItem : items) {
            LocalizableContainerIFace table = this.getContainer(listItem, lclIOListener);
            this.copyLocale(table, srcLocale, dstLocale);
            for (LocalizableItemIFace field : table.getContainerItems()) {
                this.copyLocale(field, srcLocale, dstLocale);
            }
            if (pcl != null) {
                pcl.propertyChange(new PropertyChangeEvent(listItem, "count", -1, (int)cnt));
            }
            cnt += inc;
        }
        if (pcl != null) {
            pcl.propertyChange(new PropertyChangeEvent(this, "count", -1, 100));
        }
    }

    @Override
    public boolean exportToDirectory(File exportDirectory) {
        return this.save(String.valueOf(exportDirectory.getAbsolutePath()) + File.separator);
    }

    @Override
    public boolean exportSingleLanguageToDirectory(File exportDirectory, Locale locale) {
        boolean isOK = false;
        if (this.inputFile != null) {
            Locale cachedLocale = Locale.getDefault();
            try {
                Locale.setDefault(locale);
                Vector<DisciplineBasedContainer> tmpTables = this.load(null, this.inputFile, true);
                isOK = this.saveContainers(exportDirectory, tmpTables);
            }
            finally {
                Locale.setDefault(cachedLocale);
            }
        }
        return isOK;
    }

    @Override
    public List<PickList> getPickLists(String disciplineName) {
        List<BldrPickList> bdlrPickLists;
        Vector<PickList> pickLists = new Vector<PickList>();
        if (disciplineName == null) {
            bdlrPickLists = DataBuilder.getBldrPickLists("common");
            Hashtable<String, Boolean> nameHash = new Hashtable<String, Boolean>();
            for (DisciplineType dt : DisciplineType.getDisciplineList()) {
                List<BldrPickList> list = DataBuilder.getBldrPickLists(dt.getName());
                if (list == null) continue;
                for (BldrPickList bpl : list) {
                    if (nameHash.get(bpl.getName()) != null) continue;
                    nameHash.put(bpl.getName(), true);
                    bdlrPickLists.add(bpl);
                }
            }
        } else {
            bdlrPickLists = DataBuilder.getBldrPickLists(disciplineName != null ? disciplineName : "common");
        }
        for (BldrPickList pl : bdlrPickLists) {
            PickList pickList = DataBuilder.createPickList(pl.getName(), pl.getType(), pl.getTableName(), pl.getFieldName(), pl.getFormatter(), pl.getReadOnly(), pl.getSizeLimit(), pl.getIsSystem(), pl.getSortType(), null);
            for (BldrPickListItem item : pl.getItems()) {
                pickList.addItem(item.getTitle(), item.getValue());
            }
            pickLists.add(pickList);
        }
        return pickLists;
    }

    @Override
    public boolean hasUpdatablePickLists() {
        return false;
    }

    @Override
    public boolean shouldIncludeAppTables() {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return this.changesMadeDuringStartup || this.hasTableInfoChanged;
    }

    protected SpLocaleItemStr getNameForLocale(Set<SpLocaleItemStr> itemStrs, Locale locale) {
        for (SpLocaleItemStr itemStr : itemStrs) {
            if (!itemStr.isLocale(locale)) continue;
            return itemStr;
        }
        return null;
    }

    public void setTitlesIntoSchema() {
        Locale locale = Locale.getDefault();
        for (DBTableInfo ti : this.tableMgr.getTables()) {
            DisciplineBasedContainer container = (DisciplineBasedContainer)this.tableHash.get(ti.getName());
            SpLocaleItemStr itemStr = this.getNameForLocale(container.getNames(), locale);
            if (itemStr != null) {
                ti.setTitle(itemStr.getText());
            }
            Set<SpLocaleContainerItem> fieldContainers = container.getItems();
            for (DBFieldInfo fi : ti.getFields()) {
                for (SpLocaleContainerItem item : fieldContainers) {
                    if (!item.getName().equals(fi.getName())) continue;
                    itemStr = this.getNameForLocale(item.getNames(), locale);
                    if (itemStr != null) {
                        fi.setTitle(itemStr.getText());
                    }
                    if ((itemStr = this.getNameForLocale(item.getDescs(), locale)) == null) continue;
                    fi.setDescription(itemStr.getText());
                }
            }
        }
    }
}

