/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggListEdtDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjAggregator;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFmtListEdtDlg;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjSwitchFormatter;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.weblink.WebLinkConfigDlg;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedContainer;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedPanel;
import edu.ku.brc.specify.tools.schemalocale.FieldItemPanel;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFaceListener;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableJListItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizerBasePanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.ComparatorByStringRepresentation;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class SchemaLocalizerPanel
extends LocalizerBasePanel
implements PropertyChangeListener,
LocalizableIOIFaceListener {
    private static final Logger log = Logger.getLogger(SchemaLocalizerPanel.class);
    protected LocalizableIOIFace localizableIO = null;
    protected DBTableInfo tableInfo = null;
    protected LocalizableContainerIFace currContainer = null;
    protected boolean includeHiddenUI = true;
    protected boolean isDBSchema = true;
    protected boolean useDisciplines = false;
    protected DisciplineBasedPanel disciplineBasedPanel = null;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache;
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache;
    protected WebLinkMgr webLinkMgrCache;
    protected FieldItemPanel fieldPanel;
    protected JList tablesList;
    protected JTextArea tblDescText = UIHelper.createTextArea(5, 40);
    protected JTextField tblNameText = UIHelper.createTextField();
    protected JLabel tblDescLbl;
    protected JLabel tblNameLbl;
    protected JCheckBox tblHideChk = UIHelper.createCheckBox(UIRegistry.getResourceString("SL_TABLE_HIDE_CHK"));
    protected boolean hasTableInfoChanged = false;
    protected LocalizableItemIFace prevTable = null;
    protected JStatusBar statusBar = null;
    protected JButton tblSpellChkBtn = null;
    protected JLabel dataObjFmtLbl = null;
    protected JComboBox dataObjFmtCbo = null;
    protected JButton dataObjFmtBtn = null;
    protected JLabel aggregatorLbl = null;
    protected JComboBox aggregatorCbo = null;
    protected JButton aggregatorBtn = null;
    protected JLabel webLinkLbl = null;
    protected JButton webLinkBtn = null;
    protected Hashtable<String, String> resHash = new Hashtable();
    protected Hashtable<String, Boolean> nameHash = new Hashtable();
    protected PropertyChangeListener listener = null;
    protected Byte schemaType;

    public SchemaLocalizerPanel(PropertyChangeListener pcListener, DataObjFieldFormatMgr dataObjFieldFormatMgrCache, UIFieldFormatterMgr uiFieldFormatterMgrCache, WebLinkMgr webLinkMgrCache, Byte schemaType) {
        this.listener = pcListener;
        this.dataObjFieldFormatMgrCache = dataObjFieldFormatMgrCache;
        this.uiFieldFormatterMgrCache = uiFieldFormatterMgrCache;
        this.webLinkMgrCache = webLinkMgrCache;
        this.schemaType = schemaType;
        this.init();
    }

    public void buildUI() {
        this.setIgnoreChanges(true);
        this.tablesList = UIHelper.createList(this.localizableIO.getContainerDisplayItems());
        this.tablesList.setVisibleRowCount(14);
        this.tablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SchemaLocalizerPanel.this.startTableSelected();
                }
            }
        });
        CellConstraints cc = new CellConstraints();
        JScrollPane sp = new JScrollPane(this.tblDescText, 20, 30);
        this.tblDescText.setLineWrap(true);
        this.tblDescText.setWrapStyleWord(true);
        this.tblDescText.addKeyListener(new LengthWatcher(255));
        this.tblNameText.addKeyListener(new LengthWatcher(64));
        this.dataObjFmtLbl = UIHelper.createI18NFormLabel("DOF_DISPLAY_FORMAT");
        this.dataObjFmtCbo = UIHelper.createComboBox();
        this.dataObjFmtBtn = UIHelper.createButton("...");
        this.fillDataObjFormatterCombo();
        this.addFormatterActionListener();
        this.aggregatorLbl = UIHelper.createI18NFormLabel("DOA_AGGREGATION");
        this.aggregatorCbo = UIHelper.createComboBox();
        this.aggregatorBtn = UIHelper.createButton("...");
        this.fillAggregatorCombo();
        this.addAggregatorActionListener();
        this.webLinkLbl = UIHelper.createI18NFormLabel("SL_WEBLINKS");
        this.webLinkBtn = UIHelper.createButton("...");
        this.addWebLinkActionListener();
        int y = 1;
        PanelBuilder topInner = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,2px," + (this.includeHiddenUI ? "p,2px," : "") + "p,2px,p" + (this.useDisciplines ? ",2px,p" : "") + ",6px,p,2px,p,2px,p"));
        this.tblDescLbl = UIHelper.createI18NFormLabel("SL_LABEL", 4);
        topInner.add((Component)this.tblDescLbl, cc.xy(1, y));
        topInner.add((Component)this.tblNameText, cc.xy(3, y));
        y += 2;
        if (this.includeHiddenUI) {
            topInner.add((Component)this.tblHideChk, cc.xy(3, y));
            y += 2;
        }
        this.tblNameLbl = UIHelper.createI18NFormLabel("SL_DESC", 4);
        topInner.add((Component)this.tblNameLbl, cc.xy(1, y));
        topInner.add((Component)sp, cc.xy(3, y));
        y += 2;
        PanelBuilder fmtPanel = new PanelBuilder(new FormLayout("200px,r:m", "p"));
        fmtPanel.add((Component)this.dataObjFmtCbo, cc.xy(1, 1));
        fmtPanel.add((Component)this.dataObjFmtBtn, cc.xy(2, 1));
        PanelBuilder aggPanel = new PanelBuilder(new FormLayout("200px,r:m", "p"));
        aggPanel.add((Component)this.aggregatorCbo, cc.xy(1, 1));
        aggPanel.add((Component)this.aggregatorBtn, cc.xy(2, 1));
        PanelBuilder wlPanel = new PanelBuilder(new FormLayout("p,f:p:g", "p"));
        wlPanel.add((Component)this.webLinkBtn, cc.xy(1, 1));
        topInner.add((Component)this.dataObjFmtLbl, cc.xy(1, y));
        topInner.add((Component)fmtPanel.getPanel(), cc.xy(3, y));
        topInner.add((Component)this.aggregatorLbl, cc.xy(1, y += 2));
        topInner.add((Component)aggPanel.getPanel(), cc.xy(3, y));
        topInner.add((Component)this.webLinkLbl, cc.xy(1, y += 2));
        topInner.add((Component)wlPanel.getPanel(), cc.xy(3, y));
        y += 2;
        JScrollPane tblsp = UIHelper.createScrollPane(this.tablesList);
        this.fieldPanel = new FieldItemPanel(this, this.webLinkMgrCache, this.includeHiddenUI, true, this.isDBSchema, this, this.schemaType);
        this.fieldPanel.setStatusBar(this.statusBar);
        this.fieldPanel.setLocalizableIO(this.localizableIO);
        PanelBuilder pb = new PanelBuilder(new FormLayout("max(200px;p),4px,f:p:g", "p,4px,t:p,4px,p,4px,f:p:g,4px,p,4px,p"), (JPanel)this);
        pb.addSeparator(UIRegistry.getResourceString("SL_TABLES"), cc.xywh(1, 1, 3, 1));
        pb.add((Component)tblsp, cc.xy(1, 3));
        pb.add((Component)topInner.getPanel(), cc.xy(3, 3));
        pb.addSeparator(UIRegistry.getResourceString("SL_FIELDS"), cc.xywh(1, 5, 3, 1));
        pb.add((Component)this.fieldPanel, cc.xywh(1, 7, 3, 1));
        if (this.useDisciplines) {
            this.disciplineBasedPanel = new DisciplineBasedPanel(this, this.webLinkMgrCache);
            pb.add((Component)this.disciplineBasedPanel, cc.xywh(1, 9, 3, 1));
        }
        pb.getPanel().setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.tblHideChk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SchemaLocalizerPanel.this.setHasChanged(true);
                SchemaLocalizerPanel.this.setTableInfoChanged(true);
            }
        });
        ActionListener comboAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaLocalizerPanel.this.setHasChanged(true);
                SchemaLocalizerPanel.this.setTableInfoChanged(true);
                this.setDefaultFormatterOrAggregator(e);
            }

            private void setDefaultFormatterOrAggregator(ActionEvent e) {
                Object src = e.getSource();
                if (src instanceof JComboBox) {
                    JComboBox combo = (JComboBox)src;
                    int n = combo.getModel().getSize();
                    int i = 0;
                    while (i < n) {
                        Object value = combo.getModel().getElementAt(i);
                        if (value instanceof DataObjAggregator) {
                            DataObjAggregator agg;
                            agg.setDefault((agg = (DataObjAggregator)value) == combo.getModel().getSelectedItem());
                        } else if (value instanceof DataObjSwitchFormatter) {
                            DataObjSwitchFormatter fmt;
                            fmt.setDefault((fmt = (DataObjSwitchFormatter)value) == combo.getModel().getSelectedItem());
                        }
                        ++i;
                    }
                }
            }
        };
        this.dataObjFmtCbo.addActionListener(comboAL);
        this.aggregatorCbo.addActionListener(comboAL);
        DocumentListener dl = new DocumentListener(){

            protected void changed() {
                if (!SchemaLocalizerPanel.this.hasTableInfoChanged) {
                    SchemaLocalizerPanel.this.setTableInfoChanged(true);
                    SchemaLocalizerPanel.this.setHasChanged(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }
        };
        this.tblNameText.getDocument().addDocumentListener(dl);
        this.tblDescText.getDocument().addDocumentListener(dl);
        SchemaI18NService.getInstance().checkCurrentLocaleMenu();
        this.enableUIControls(false);
        this.setIgnoreChanges(false);
    }

    public void setTableInfoChanged(boolean hasChanged) {
        if (!this.isIgnoreChanges()) {
            this.hasTableInfoChanged = hasChanged;
            if (this.currContainer != null) {
                this.localizableIO.containerChanged(this.currContainer);
            }
        }
    }

    public boolean hasTableInfoChanged() {
        return this.hasTableInfoChanged;
    }

    private void fillDataObjFormatterCombo() {
        List<Object> fList;
        if (this.tableInfo != null) {
            fList = this.dataObjFieldFormatMgrCache.getFormatterList(this.tableInfo.getClassObj());
            Collections.sort(fList, new ComparatorByStringRepresentation());
        } else {
            fList = new Vector(0);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.dataObjFmtCbo.getModel();
        model.removeAllElements();
        if (this.currContainer == null) {
            return;
        }
        String contatinerFmtName = this.currContainer.getFormat();
        int selectedInx = -1;
        Integer curFmtInx = null;
        int inx = 0;
        for (DataObjSwitchFormatter dataObjSwitchFormatter : fList) {
            model.addElement(dataObjSwitchFormatter);
            if (dataObjSwitchFormatter.isDefault()) {
                selectedInx = model.getSize() - 1;
            }
            if (contatinerFmtName != null && dataObjSwitchFormatter.getName().equals(contatinerFmtName)) {
                curFmtInx = inx;
            }
            ++inx;
        }
        this.dataObjFmtCbo.setSelectedIndex(curFmtInx != null ? curFmtInx : selectedInx);
    }

    private void fillAggregatorCombo() {
        List<Object> fList;
        if (this.tableInfo != null) {
            fList = this.dataObjFieldFormatMgrCache.getAggregatorList(this.tableInfo.getClassObj());
            Collections.sort(fList, new ComparatorByStringRepresentation());
        } else {
            fList = new Vector(0);
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.aggregatorCbo.getModel();
        model.removeAllElements();
        if (this.currContainer == null) {
            return;
        }
        String contatinerAggName = this.currContainer.getAggregator();
        int selectedInx = -1;
        Integer curAggInx = null;
        int inx = 0;
        for (DataObjAggregator dataObjAggregator : fList) {
            model.addElement(dataObjAggregator);
            if (dataObjAggregator.isDefault()) {
                selectedInx = model.getSize() - 1;
            }
            if (contatinerAggName != null && dataObjAggregator.getName().equals(contatinerAggName)) {
                curAggInx = inx;
            }
            ++inx;
        }
        this.aggregatorCbo.setSelectedIndex(curAggInx != null ? curAggInx : selectedInx);
    }

    private void addFormatterActionListener() {
        ActionListener dataObjFmtBtnAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = (Frame)UIRegistry.getTopWindow();
                DataObjFieldFmtListEdtDlg dlg = new DataObjFieldFmtListEdtDlg(frame, SchemaLocalizerPanel.this.tableInfo, SchemaLocalizerPanel.this.dataObjFieldFormatMgrCache, SchemaLocalizerPanel.this.uiFieldFormatterMgrCache);
                dlg.setVisible(true);
                if (!dlg.isCancelled() && dlg.hasChanged()) {
                    SchemaLocalizerPanel.this.setTableInfoChanged(true);
                    SchemaLocalizerPanel.this.setHasChanged(true);
                    SchemaLocalizerPanel.this.fillDataObjFormatterCombo();
                }
            }
        };
        this.dataObjFmtBtn.addActionListener(dataObjFmtBtnAL);
    }

    private void addAggregatorActionListener() {
        ActionListener aggregatorBtnAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = (Frame)UIRegistry.getTopWindow();
                DataObjAggListEdtDlg dlg = new DataObjAggListEdtDlg(frame, SchemaLocalizerPanel.this.tableInfo, SchemaLocalizerPanel.this.dataObjFieldFormatMgrCache, SchemaLocalizerPanel.this.uiFieldFormatterMgrCache);
                dlg.setVisible(true);
                if (dlg.getBtnPressed() == 1 && dlg.hasChanged()) {
                    SchemaLocalizerPanel.this.setTableInfoChanged(true);
                    SchemaLocalizerPanel.this.setHasChanged(true);
                    SchemaLocalizerPanel.this.fillAggregatorCombo();
                    SchemaLocalizerPanel.this.fillDataObjFormatterCombo();
                }
            }
        };
        this.aggregatorBtn.addActionListener(aggregatorBtnAL);
    }

    private void addWebLinkActionListener() {
        ActionListener wbFmtBtnAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebLinkConfigDlg dlg = SchemaLocalizerPanel.this.webLinkMgrCache.editWebLinks(SchemaLocalizerPanel.this.tableInfo, true);
                if (dlg.getBtnPressed() == 1 && dlg.hasChanged()) {
                    SchemaLocalizerPanel.this.setTableInfoChanged(true);
                    SchemaLocalizerPanel.this.setHasChanged(true);
                }
            }
        };
        this.webLinkBtn.addActionListener(wbFmtBtnAL);
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setIncludeHiddenUI(boolean includeHiddenUI) {
        this.includeHiddenUI = includeHiddenUI;
    }

    public void setUseDisciplines(boolean useDisciplines) {
        this.useDisciplines = useDisciplines;
    }

    public LocalizableIOIFace getLocalizableIO() {
        return this.localizableIO;
    }

    public void setLocalizableIO(LocalizableIOIFace localizableIO) {
        this.localizableIO = localizableIO;
    }

    public JList getContainerList() {
        return this.tablesList;
    }

    protected void enableUIControls(boolean enable) {
        this.tblDescText.setEnabled(enable);
        this.tblNameText.setEnabled(enable);
        this.tblNameLbl.setEnabled(enable);
        this.tblDescLbl.setEnabled(enable);
        this.tblHideChk.setEnabled(enable);
        if (enable) {
            this.enableSpellCheck();
        }
        this.dataObjFmtLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.dataObjFmtCbo.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.dataObjFmtBtn.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.aggregatorLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.aggregatorCbo.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.aggregatorBtn.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.webLinkLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.webLinkBtn.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
    }

    public LocalizableContainerIFace getCurrentContainer() {
        return this.currContainer;
    }

    protected void startTableSelected() {
        log.debug((Object)("Changed " + this.hasTableInfoChanged + " " + (this.currContainer != null ? this.currContainer.getName() : "null")));
        this.getAllDataFromUI();
        if (this.hasTableInfoChanged) {
            this.localizableIO.containerChanged(this.currContainer);
        }
        this.setIgnoreChanges(true);
        LocalizableJListItem jlistItem = (LocalizableJListItem)this.tablesList.getSelectedValue();
        if (jlistItem != null) {
            this.localizableIO.getContainer(jlistItem, this);
        } else {
            this.currContainer = null;
            this.tableInfo = null;
            this.enableUIControls(false);
            this.fieldPanel.fieldSelected();
            this.noTableSelected();
            this.setIgnoreChanges(false);
            this.setTableInfoChanged(false);
        }
    }

    public void setStatusBar(JStatusBar statusBar) {
        this.statusBar = statusBar;
    }

    protected void startLocaleCopy(final Locale srcLocale, final Locale dstLocale) {
        this.enableUIControls(false);
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("COPYING_LOCALE"));
        this.tablesList.setEnabled(false);
        this.fieldPanel.setEnabled(false);
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "copyStart", null, null));
        }
        final String progressName = this.getClass().getSimpleName();
        UIRegistry.getStatusBar().setIndeterminate(progressName, true);
        final Window parentWin = UIRegistry.getMostRecentWindow();
        final SimpleGlassPane glassPane = new SimpleGlassPane("Copying Locale...", 18);
        glassPane.setVisible(true);
        if (parentWin instanceof JFrame) {
            JFrame parentDlg = (JFrame)UIRegistry.getMostRecentWindow();
            parentDlg.setGlassPane(glassPane);
        } else {
            CustomDialog parentFrm = (CustomDialog)UIRegistry.getMostRecentWindow();
            parentFrm.setGlassPane(glassPane);
            parentFrm.getOkBtn().setEnabled(false);
        }
        SwingWorker workerThread = new SwingWorker(){

            @Override
            public Object construct() {
                SchemaLocalizerPanel.this.localizableIO.copyLocale(SchemaLocalizerPanel.this, srcLocale, dstLocale, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(final PropertyChangeEvent evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                glassPane.setProgress((Integer)evt.getNewValue());
                            }
                        });
                    }
                });
                return null;
            }

            @Override
            public void finished() {
                SchemaLocalizerPanel.this.enableUIControls(true);
                SchemaLocalizerPanel.this.tablesList.setEnabled(true);
                SchemaLocalizerPanel.this.fieldPanel.setEnabled(true);
                if (SchemaLocalizerPanel.this.listener != null) {
                    SchemaLocalizerPanel.this.listener.propertyChange(new PropertyChangeEvent(this, "copyEnd", null, null));
                }
                glassPane.setVisible(false);
                if (!(parentWin instanceof JFrame)) {
                    CustomDialog parentFrm = (CustomDialog)UIRegistry.getMostRecentWindow();
                    parentFrm.getOkBtn().setEnabled(true);
                }
                UIRegistry.getStatusBar().setProgressDone(progressName);
                UIRegistry.getStatusBar().setText("");
                SchemaLocalizerPanel.this.setTableInfoChanged(true);
            }
        };
        workerThread.start();
    }

    protected void getAllDataFromUI() {
        this.getContainerDataFromUI();
        if (this.fieldPanel.getItemDataFromUI()) {
            this.hasTableInfoChanged = true;
        }
    }

    protected void getContainerDataFromUI() {
        if (this.prevTable != null && this.hasTableInfoChanged) {
            this.prevTable.setIsHidden(this.tblHideChk.isSelected());
            boolean formatterChanged = false;
            DataObjSwitchFormatter dataObjFmt = (DataObjSwitchFormatter)this.dataObjFmtCbo.getSelectedItem();
            if (dataObjFmt != null) {
                String fName = this.prevTable.getFormat();
                formatterChanged = fName == null || !fName.equals(dataObjFmt.getName());
                this.prevTable.setFormat(dataObjFmt.getName());
                formatterChanged = true;
            } else {
                this.prevTable.setFormat(null);
            }
            boolean aggChanged = false;
            DataObjAggregator dataObjAgg = (DataObjAggregator)this.aggregatorCbo.getSelectedItem();
            if (dataObjAgg != null) {
                SpLocaleContainer container = (SpLocaleContainer)this.prevTable;
                String aggName = container.getAggregator();
                aggChanged = aggName == null || !aggName.equals(dataObjAgg.getName());
                container.setAggregator(dataObjAgg.getName());
                aggChanged = true;
            } else {
                ((SpLocaleContainer)this.prevTable).setAggregator(null);
            }
            boolean nameChanged = SchemaLocalizerPanel.setNameDescStrForCurrLocale(this.prevTable, this.tblNameText.getText());
            boolean descChanged = SchemaLocalizerPanel.setDescStrForCurrLocale(this.prevTable, this.tblDescText.getText());
            if (nameChanged || descChanged || formatterChanged || aggChanged) {
                this.setHasChanged(true);
            }
            if (this.disciplineBasedPanel != null) {
                this.disciplineBasedPanel.getDataFromUI();
            }
            this.prevTable = null;
        }
        this.setTableInfoChanged(false);
    }

    @Override
    public void localeChanged(Locale newLocale) {
        int tableInx = this.tablesList.getSelectedIndex();
        int fieldInx = this.fieldPanel.getSelectedIndex();
        this.tablesList.getSelectionModel().clearSelection();
        Locale oldLocale = SchemaI18NService.getCurrentLocale();
        SchemaI18NService.setCurrentLocale(newLocale);
        SchemaI18NService.getInstance().checkCurrentLocaleMenu();
        if (!this.localizableIO.isLocaleInUse(newLocale)) {
            int rv = JOptionPane.showConfirmDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("SL_WISH_CHANGE_LOCALE"), UIRegistry.getResourceString("SL_LOCALE_EMPTY"), 0);
            if (rv == 0) {
                Locale localeToCopy = this.chooseNewLocale(this.localizableIO.getLocalesInUse());
                if (localeToCopy != null) {
                    this.startLocaleCopy(localeToCopy, newLocale);
                    this.setHasChanged(true);
                }
            } else {
                SchemaI18NService.setCurrentLocale(oldLocale);
                SchemaI18NService.getInstance().checkCurrentLocaleMenu();
            }
        } else {
            log.debug((Object)("Locale[" + newLocale + "] was in use."));
        }
        if (tableInx != -1) {
            this.tablesList.setSelectedIndex(tableInx);
        }
        if (fieldInx != -1) {
            this.fieldPanel.setSelectedIndex(fieldInx);
        }
        this.statusBar.setSectionText(0, newLocale.getDisplayName());
        this.enableSpellCheck();
    }

    @Override
    protected void enableSpellCheck() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.disciplineBasedPanel != null) {
            this.disciplineBasedPanel.setItem((SpLocaleContainerItem)evt.getNewValue());
        }
    }

    public UIFieldFormatterMgr getUiFieldFormatterMgrCache() {
        return this.uiFieldFormatterMgrCache;
    }

    protected void noTableSelected() {
        this.tblDescText.setText("");
        this.tblNameText.setText("");
        this.fieldPanel.setContainer(null, null);
        if (this.disciplineBasedPanel != null) {
            this.disciplineBasedPanel.set(null, null);
        }
        this.tblHideChk.setSelected(false);
    }

    @Override
    public void containterRetrieved(LocalizableContainerIFace container) {
        LocalizableJListItem jlistItem = (LocalizableJListItem)this.tablesList.getSelectedValue();
        this.currContainer = container;
        if (this.currContainer != null) {
            this.tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(this.currContainer.getName());
            this.tblDescText.setText(SchemaLocalizerPanel.getDescStrForCurrLocale(this.currContainer));
            this.tblNameText.setText(SchemaLocalizerPanel.getNameDescStrForCurrLocale(this.currContainer));
            this.tblHideChk.setSelected(this.currContainer.getIsHidden());
            this.fillDataObjFormatterCombo();
            this.fillAggregatorCombo();
            if (this.doAutoSpellCheck) {
                this.checker.spellCheck((JTextComponent)this.tblNameText);
                this.checker.spellCheck((JTextComponent)this.tblDescText);
            }
            if (this.disciplineBasedPanel != null && this.currContainer instanceof DisciplineBasedContainer) {
                this.disciplineBasedPanel.set((DisciplineBasedContainer)this.currContainer, jlistItem);
            }
            this.fieldPanel.setContainer(this.currContainer, jlistItem);
            this.prevTable = this.currContainer;
            this.enableUIControls(this.currContainer != null);
        } else {
            UIRegistry.showError("Couldn't load container[" + (jlistItem != null ? jlistItem.getId() : "null") + "]");
        }
        this.setIgnoreChanges(false);
        this.setTableInfoChanged(false);
    }

    class LengthWatcher
    extends KeyAdapter {
        protected int maxLength;

        public LengthWatcher(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            final JTextComponent tc = (JTextComponent)e.getSource();
            String text = tc.getText();
            if (text.length() > this.maxLength) {
                SchemaLocalizerPanel.this.statusBar.setErrorMessage(String.valueOf(UIRegistry.getResourceString("SL_MAX_LENGTH_ERROR")) + ": " + this.maxLength);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tc.setText(tc.getText().substring(0, LengthWatcher.this.maxLength));
                    }
                });
            }
        }
    }
}

