/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.jgoodies.looks.plastic.theme.SkyKrupp;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr;
import edu.ku.brc.specify.config.SpecifyWebLinkMgr;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.DisplayLocale;
import edu.ku.brc.specify.tools.schemalocale.LocalizableBaseApp;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrFactory;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizerBasePanel;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerPanel;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SchemaLocalizerFrame
extends LocalizableBaseApp {
    private static final Logger log = Logger.getLogger(SchemaLocalizerFrame.class);
    protected SchemaLocalizerPanel schemaLocPanel;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache = new DataObjFieldFormatMgr(DataObjFieldFormatMgr.getInstance());
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache = new UIFieldFormatterMgr(UIFieldFormatterMgr.getInstance());
    protected SpecifyWebLinkMgr webLinkMgrCache = new SpecifyWebLinkMgr((SpecifyWebLinkMgr)SpecifyWebLinkMgr.getInstance());
    protected JStatusBar statusBar = new JStatusBar(new int[]{5, 5});
    protected LocalizableIOIFace localizableIO;
    protected Byte schemaType;
    protected DBTableIdMgr tableMgr;

    public SchemaLocalizerFrame(Byte schemaType, DBTableIdMgr tableMgr) {
        this.schemaType = schemaType;
        this.tableMgr = tableMgr;
        new MacOSAppHandler(this);
        this.appName = "Schema Localizer";
        this.appVersion = UIRegistry.getAppVersion();
        if (this.appVersion == null) {
            this.appVersion = "Unknown";
        }
        UIRegistry.loadAndPushResourceBundle("bld");
        this.appBuildVersion = UIRegistry.getResourceString("buildtime");
        UIRegistry.popResourceBundle();
        this.setTitle(String.valueOf(this.appName) + " " + this.appVersion);
    }

    public void createDisplay() {
        this.buildUI();
    }

    protected void buildUI() {
        SchemaLocalizerXMLHelper slxh = new SchemaLocalizerXMLHelper(this.schemaType, this.tableMgr);
        this.localizableIO = slxh;
        this.localizableIO.load(false);
        LocalizableStrFactory localizableStrFactory = new LocalizableStrFactory(){

            @Override
            public LocalizableStrIFace create() {
                SpLocaleItemStr str = new SpLocaleItemStr();
                str.initialize();
                return str;
            }

            @Override
            public LocalizableStrIFace create(String text, Locale locale) {
                return new SpLocaleItemStr(text, locale);
            }
        };
        LocalizerBasePanel.setLocalizableStrFactory(localizableStrFactory);
        SchemaLocalizerXMLHelper.setLocalizableStrFactory(localizableStrFactory);
        this.schemaLocPanel = new SchemaLocalizerPanel(null, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, this.webLinkMgrCache, this.schemaType);
        this.schemaLocPanel.setLocalizableIO(this.localizableIO);
        this.schemaLocPanel.setStatusBar(this.statusBar);
        boolean useDisciplines = AppPreferences.getLocalPrefs().getBoolean("SCHEMA_DISP", false);
        this.schemaLocPanel.setUseDisciplines(useDisciplines);
        this.schemaLocPanel.buildUI();
        this.schemaLocPanel.setHasChanged(this.localizableIO.didModelChangeDuringLoad());
        this.statusBar.setSectionText(1, this.schemaType == SpLocaleContainer.CORE_SCHEMA ? UIRegistry.getResourceString("SchemaLocalizerFrame.FULL_SCHEMA") : UIRegistry.getResourceString("SchemaLocalizerFrame.WB_SCHEMA"));
        UIRegistry.setStatusBar(this.statusBar);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        String title = "File";
        String mneu = "F";
        JMenu fileMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
        title = "Save";
        mneu = "S";
        JMenuItem saveMenuItem = UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaLocalizerFrame.this.write();
            }
        });
        saveMenuItem.setEnabled(false);
        title = "Export";
        mneu = "E";
        UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaLocalizerFrame.this.export();
            }
        });
        title = "SchemaLocalizerFrame.ExportLOCALE";
        mneu = "SchemaLocalizerFrame.ExportLOCALEMnu";
        UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemaLocalizerFrame.this.exportSingleLocale();
            }
        });
        title = "Exit";
        mneu = "x";
        if (!UIHelper.isMacOS()) {
            fileMenu.addSeparator();
            UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemaLocalizerFrame.this.shutdown();
                }
            });
        }
        menuBar.add(SchemaI18NService.getInstance().createLocaleMenu(this, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("locale")) {
                    SchemaLocalizerFrame.this.schemaLocPanel.localeChanged((Locale)evt.getNewValue());
                }
            }
        }));
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.schemaLocPanel, "Center");
        mainPanel.add((Component)this.statusBar, "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setContentPane(mainPanel);
        this.statusBar.setSectionText(0, SchemaI18NService.getCurrentLocale().getDisplayName());
        this.schemaLocPanel.setSaveMenuItem(saveMenuItem);
        this.schemaLocPanel.getContainerList().setEnabled(true);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        ImageIcon helpIcon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        AppPrefsCache.setUseLocalOnly(true);
        SpecifyAppPrefs.loadColorAndFormatPrefs();
        if (this.localizableIO.didModelChangeDuringLoad()) {
            saveMenuItem.setEnabled(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame(UIRegistry.getResourceString("SchemaLocalizerFrame.CHG_TO_SCHEMA"));
                    frame.setDefaultCloseOperation(2);
                    JTextPane tp = new JTextPane();
                    JScrollPane js = new JScrollPane();
                    js.getViewport().add(tp);
                    tp.setContentType("text/html");
                    tp.setText(((SchemaLocalizerXMLHelper)SchemaLocalizerFrame.this.localizableIO).getChangesBuffer());
                    frame.setContentPane(js);
                    frame.pack();
                    frame.setSize(400, 500);
                    frame.setVisible(true);
                }
            });
        }
    }

    protected void shutdown() {
        int rv;
        if (this.schemaLocPanel.hasChanged() && (rv = JOptionPane.showConfirmDialog(this, UIRegistry.getResourceString("SchemaLocalizerFrame.SV_CHNGES"), UIRegistry.getResourceString("SchemaLocalizerFrame.CHGS_SAVED"), 0)) == 0) {
            this.write();
        }
        this.setVisible(false);
        System.exit(0);
    }

    protected void write() {
        this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.SAVING"));
        this.statusBar.paintImmediately(this.statusBar.getBounds());
        this.schemaLocPanel.getAllDataFromUI();
        DataObjFieldFormatMgr.getInstance().applyChanges(this.dataObjFieldFormatMgrCache);
        UIFieldFormatterMgr.getInstance().applyChanges(this.uiFieldFormatterMgrCache);
        if (this.localizableIO.save()) {
            this.schemaLocPanel.setHasChanged(false);
            this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.SAVED"));
        } else {
            this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.ERROR_SAVING"));
        }
    }

    protected void export() {
        this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.EXPORTING"));
        this.statusBar.paintImmediately(this.statusBar.getBounds());
        this.schemaLocPanel.getAllDataFromUI();
        File outDir = new File(String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "schemas");
        if (outDir.exists()) {
            if (!outDir.isDirectory()) {
                JOptionPane.showMessageDialog(this, UIRegistry.getFormattedResStr("SchemaLocalizerFrame.FILE_AT_ERR", outDir.getAbsolutePath()), UIRegistry.getResourceString("SchemaLocalizerFrame.FILE_EXP"), 1);
                return;
            }
        } else if (!outDir.mkdir()) {
            JOptionPane.showMessageDialog(this, UIRegistry.getFormattedResStr("SchemaLocalizerFrame.FILE_PROBLEM", outDir.getAbsolutePath()), UIRegistry.getResourceString("SchemaLocalizerFrame.FILE_EXP"), 1);
            return;
        }
        if (this.localizableIO.exportToDirectory(outDir)) {
            JOptionPane.showMessageDialog(this, UIRegistry.getFormattedResStr("SchemaLocalizerFrame.EXPORTED_TO", outDir.getAbsolutePath()), UIRegistry.getResourceString("SchemaLocalizerFrame.EXPORTED"), 1);
            this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.EXPORTED"));
        } else {
            this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.EXPORTING_ERR"));
        }
    }

    protected void exportSingleLocale() {
        Locale locale;
        this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.EXPORTING"));
        this.statusBar.paintImmediately(this.statusBar.getBounds());
        this.schemaLocPanel.getAllDataFromUI();
        if (this.localizableIO.hasChanged()) {
            if (UIRegistry.askYesNoLocalized("SAVE", "CANCEL", UIRegistry.getResourceString("SchemaLocalizerFrame.NEEDS_SAVING"), "SAVE") == 0) {
                this.localizableIO.save();
            } else {
                return;
            }
        }
        Vector<Locale> stdLocales = SchemaI18NService.getInstance().getStdLocaleList(false);
        final JList<Locale> list = new JList<Locale>(stdLocales);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Locale)value).getDisplayName());
                }
                return this;
            }
        });
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        pb.add((Component)UIHelper.createScrollPane(list), new CellConstraints().xy(1, 1));
        pb.setDefaultDialogBorder();
        final CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("SchemaLocalizerFrame.CHOOSE_LOCALE"), true, pb.getPanel());
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    dlg.getOkBtn().setEnabled(list.getSelectedValue() != null);
                }
            }
        });
        dlg.createUI();
        dlg.getOkBtn().setEnabled(false);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled() && (locale = list.getSelectedValue()) != null) {
            FileDialog fileDlg = new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("SchemaLocalizerFrame.SVFILENAME"), 1);
            fileDlg.setVisible(true);
            String fileName = fileDlg.getFile();
            if (StringUtils.isNotEmpty((String)fileName)) {
                File outFile = new File(String.valueOf(fileDlg.getDirectory()) + File.separator + fileName);
                boolean savedOK = this.localizableIO.exportSingleLanguageToDirectory(outFile, locale);
                if (savedOK) {
                    String msg = UIRegistry.getLocalizedMessage("SchemaLocalizerFrame.EXPORTEDTO", locale.getDisplayName(), outFile.getAbsolutePath());
                    UIRegistry.displayInfoMsgDlg(msg);
                } else {
                    String msg = UIRegistry.getLocalizedMessage("SchemaLocalizerFrame.EXPORTING_ERR", outFile.getAbsolutePath());
                    UIRegistry.showError(msg);
                }
            }
        }
    }

    protected void createResourceFiles() {
        this.localizableIO.createResourceFiles();
        this.statusBar.setText(UIRegistry.getResourceString("SchemaLocalizerFrame.DONE_WRT_RES_FILES"));
    }

    private void chooseCurrentLocale() {
        List<Locale> locales = ((SchemaLocalizerXMLHelper)this.localizableIO).getAvailLocales();
        Locale locale = null;
        if (locales.size() == 1) {
            locale = locales.get(0);
        } else {
            DisplayLocale dl;
            ArrayList<DisplayLocale> dspLocales = new ArrayList<DisplayLocale>();
            for (Locale l : locales) {
                dspLocales.add(new DisplayLocale(l));
            }
            ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg(null, "Choose", dspLocales, ToggleButtonChooserPanel.Type.RadioButton);
            dlg.setUseScrollPane(true);
            UIHelper.centerAndShow(dlg);
            if (!dlg.isCancelled() && (dl = (DisplayLocale)dlg.getSelectedObject()) != null) {
                locale = dl.getLocale();
            }
        }
        if (locale != null) {
            SchemaI18NService.setCurrentLocale(locale);
            this.statusBar.setSectionText(0, SchemaI18NService.getCurrentLocale().getDisplayName());
        }
    }

    public static void main(String[] args) {
        String appdatadir;
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                log.debug((Object)("[" + pairs[0] + "][" + pairs[1] + "]"));
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SchemaLocalizerFrame sla;
                UIRegistry.setAppName("Specify");
                IconManager.setApplicationClass(Specify.class);
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
                IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new SkyKrupp());
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SchemaLocalizerFrame.class, e);
                    e.printStackTrace();
                }
                AppPreferences localPrefs = AppPreferences.getLocalPrefs();
                localPrefs.setDirPath(UIRegistry.getAppDataDir());
                System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
                System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
                System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
                System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
                System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
                SpecifyDataObjFieldFormatMgr.setDoingLocal(true);
                SpecifyUIFieldFormatterMgr.setDoingLocal(true);
                SpecifyWebLinkMgr.setDoingLocal(true);
                Object[] options = new Object[]{UIRegistry.getResourceString("SchemaLocalizerFrame.FULL_SCHEMA"), UIRegistry.getResourceString("SchemaLocalizerFrame.WB_SCHEMA")};
                int retVal = JOptionPane.showOptionDialog(null, UIRegistry.getResourceString("SchemaLocalizerFrame.WHICH_SCHEMA"), UIRegistry.getResourceString("SchemaLocalizerFrame.CHOOSE_SCHEMA"), 1, 3, null, options, options[0]);
                if (retVal == 1) {
                    DBTableIdMgr schema = new DBTableIdMgr(false);
                    schema.initialize(new File(XMLHelper.getConfigDirPath("specify_workbench_datamodel.xml")));
                    sla = new SchemaLocalizerFrame(SpLocaleContainer.WORKBENCH_SCHEMA, schema);
                } else {
                    sla = new SchemaLocalizerFrame(SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance());
                }
                AppContextMgr.getInstance().setHasContext(true);
                sla.createDisplay();
                sla.pack();
                Dimension size = sla.getSize();
                size.width += 250;
                sla.setSize(size);
                UIHelper.centerAndShow(sla);
                final SchemaLocalizerFrame slaf = sla;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        slaf.chooseCurrentLocale();
                    }
                });
            }
        });
    }

    public class MacOSAppHandler
    extends Application {
        protected WeakReference<SchemaLocalizerFrame> app;

        public MacOSAppHandler(SchemaLocalizerFrame app) {
            this.app = new WeakReference<SchemaLocalizerFrame>(app);
            this.addApplicationListener(new AppHandler());
            this.setEnabledPreferencesMenu(false);
        }

        class AppHandler
        extends ApplicationAdapter {
            AppHandler() {
            }

            public void handleAbout(ApplicationEvent event) {
                ((SchemaLocalizerFrame)MacOSAppHandler.this.app.get()).doAbout();
                event.setHandled(true);
            }

            public void handleAppPrefsMgr(ApplicationEvent event) {
                event.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent event) {
                event.setHandled(true);
            }

            public void handleQuit(ApplicationEvent event) {
                ((SchemaLocalizerFrame)MacOSAppHandler.this.app.get()).shutdown();
                event.setHandled(false);
            }
        }
    }
}

