/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.config.SpecifyWebLinkMgr;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.DisplayLocale;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFaceListener;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableJListItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrFactory;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizerBasePanel;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerPanel;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class SchemaLocalizerDlg
extends CustomDialog
implements LocalizableIOIFace,
PropertyChangeListener {
    private static final Logger log = Logger.getLogger(SchemaLocalizerDlg.class);
    public static final String SCHEMA_LOCALIZER = "SCHEMA_LOCALIZER";
    private static String SCHEMALOCDLG = "SchemaLocalizerDlg";
    protected Byte schemaType;
    protected DBTableIdMgr tableMgr;
    protected DataObjFieldFormatMgr dataObjFieldFormatMgrCache = new DataObjFieldFormatMgr(DataObjFieldFormatMgr.getInstance());
    protected UIFieldFormatterMgr uiFieldFormatterMgrCache = new UIFieldFormatterMgr(UIFieldFormatterMgr.getInstance());
    protected SpecifyWebLinkMgr webLinkMgrCache = new SpecifyWebLinkMgr((SpecifyWebLinkMgr)WebLinkMgr.getInstance());
    protected SchemaLocalizerPanel schemaLocPanel;
    protected LocalizableIOIFace localizableIOIFace;
    protected LocalizableStrFactory localizableStrFactory;
    protected Vector<SpLocaleContainer> tables = new Vector();
    protected Hashtable<Integer, LocalizableContainerIFace> tableHash = new Hashtable();
    protected Vector<SpLocaleContainer> changedTables = new Vector();
    protected Hashtable<Integer, LocalizableContainerIFace> changedTableHash = new Hashtable();
    protected Vector<LocalizableJListItem> tableDisplayItems;
    protected Hashtable<String, LocalizableJListItem> tableDisplayItemsHash = new Hashtable();
    protected Hashtable<LocalizableJListItem, Vector<LocalizableJListItem>> itemJListItemsHash = new Hashtable();
    protected Vector<LocalizableStrIFace> namesList = new Vector();
    protected Vector<LocalizableStrIFace> descsList = new Vector();
    protected List<PickList> pickLists = null;
    protected boolean wasSaved = false;

    public SchemaLocalizerDlg(Frame frame, Byte schemaType, DBTableIdMgr tableMgr) throws HeadlessException {
        super(frame, "", true, 15, null);
        this.schemaType = schemaType;
        this.tableMgr = tableMgr;
        this.helpContext = schemaType == SpLocaleContainer.WORKBENCH_SCHEMA ? "wb_schema_config" : "SL_HELP_CONTEXT";
    }

    @Override
    public void createUI() {
        this.setApplyLabel(UIRegistry.getResourceString("SL_CHANGE_LOCALE"));
        super.createUI();
        this.localizableStrFactory = new LocalizableStrFactory(){

            @Override
            public LocalizableStrIFace create() {
                SpLocaleItemStr str = new SpLocaleItemStr();
                str.initialize();
                return str;
            }

            @Override
            public LocalizableStrIFace create(String text, Locale locale) {
                return new SpLocaleItemStr(text, locale);
            }
        };
        LocalizerBasePanel.setLocalizableStrFactory(this.localizableStrFactory);
        this.localizableIOIFace = this;
        this.localizableIOIFace.load(true);
        this.schemaLocPanel = new SchemaLocalizerPanel(this, this.dataObjFieldFormatMgrCache, this.uiFieldFormatterMgrCache, this.webLinkMgrCache, this.schemaType);
        this.schemaLocPanel.setLocalizableIO(this.localizableIOIFace);
        this.schemaLocPanel.setUseDisciplines(false);
        this.okBtn.setEnabled(false);
        this.schemaLocPanel.setSaveBtn(this.okBtn);
        this.schemaLocPanel.setStatusBar(UIRegistry.getStatusBar());
        this.schemaLocPanel.buildUI();
        this.schemaLocPanel.setHasChanged(this.localizableIOIFace.didModelChangeDuringLoad());
        this.contentPanel = this.schemaLocPanel;
        this.mainPanel.add(this.contentPanel, "Center");
        this.setTitle();
        this.pack();
    }

    public void setTitle() {
        if (this.schemaType == SpLocaleContainer.WORKBENCH_SCHEMA) {
            super.setTitle(String.valueOf(UIRegistry.getResourceString("WBSCHEMA_CONFIG")) + " - " + SchemaI18NService.getCurrentLocale().getDisplayName());
        } else {
            super.setTitle(String.valueOf(UIRegistry.getResourceString("SCHEMA_CONFIG")) + " - " + SchemaI18NService.getCurrentLocale().getDisplayName());
        }
    }

    @Override
    protected void okButtonPressed() {
        this.saveAndShutdown();
    }

    protected void finishedSaving() {
        super.okButtonPressed();
    }

    protected void saveAndShutdown() {
        if (this.schemaLocPanel.hasTableInfoChanged() && this.schemaLocPanel.getCurrentContainer() != null) {
            this.localizableIOIFace.containerChanged(this.schemaLocPanel.getCurrentContainer());
        }
        this.schemaLocPanel.setSaveBtn(null);
        this.enabledDlgBtns(false);
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("SL_SAVING_SCHEMA_LOC"));
        UIRegistry.getStatusBar().setIndeterminate(SCHEMALOCDLG, true);
        final SimpleGlassPane glassPane = new SimpleGlassPane(UIRegistry.getResourceString("SchemaLocalizerFrame.SAVING"), 18);
        this.setGlassPane(glassPane);
        glassPane.setVisible(true);
        this.getOkBtn().setEnabled(false);
        SwingWorker workerThread = new SwingWorker(){

            @Override
            public Object construct() {
                SchemaLocalizerDlg.this.save();
                int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
                SchemaI18NService.getInstance().loadWithLocale(SchemaLocalizerDlg.this.schemaType, disciplineeId, SchemaLocalizerDlg.this.tableMgr, Locale.getDefault());
                SpecifyAppContextMgr.getInstance().setForceReloadViews(true);
                UIFieldFormatterMgr.getInstance().load();
                WebLinkMgr.getInstance().reload();
                DataObjFieldFormatMgr.getInstance().load();
                return null;
            }

            @Override
            public void finished() {
                glassPane.setVisible(false);
                SchemaLocalizerDlg.this.enabledDlgBtns(true);
                UIRegistry.getStatusBar().setProgressDone(SCHEMALOCDLG);
                UIRegistry.getStatusBar().setText("");
                SchemaLocalizerDlg.this.finishedSaving();
            }
        };
        workerThread.start();
    }

    public boolean wasSaved() {
        return this.wasSaved;
    }

    @Override
    protected void applyButtonPressed() {
        Vector<DisplayLocale> list = new Vector<DisplayLocale>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (StringUtils.isEmpty((String)locale.getCountry())) {
                list.add(new DisplayLocale(locale));
            }
            ++n2;
        }
        Collections.sort(list);
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg(null, "CHOOSE_LOCALE", list, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.schemaLocPanel.localeChanged(((DisplayLocale)dlg.getSelectedObject()).getLocale());
            this.setTitle();
        }
    }

    @Override
    public boolean createResourceFiles() {
        return false;
    }

    @Override
    public boolean didModelChangeDuringLoad() {
        return false;
    }

    @Override
    public Vector<LocalizableJListItem> getContainerDisplayItems() {
        String ATTACHMENT = "attachment";
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                this.tableDisplayItems = new Vector();
                int dispId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
                String sql = String.format("SELECT SpLocaleContainerID, Name FROM splocalecontainer WHERE DisciplineID = %d AND SchemaType = %d ORDER BY Name", dispId, this.schemaType);
                connection = DBConnection.getInstance().createConnection();
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String tblName = rs.getString(2);
                    boolean isAttachment = (tblName.startsWith("attachment") || tblName.endsWith("attachment")) && !tblName.equals("attachment");
                    System.out.println(String.valueOf(tblName) + " " + isAttachment);
                    if (!this.shouldIncludeAppTables() && (tblName.startsWith("sp") || isAttachment || tblName.startsWith("autonum") || tblName.equals("picklist") || tblName.equals("attributedef") || tblName.equals("recordset") || tblName.equals("inforequest") || tblName.startsWith("workbench") || tblName.endsWith("treedef") || tblName.endsWith("treedefitem") || tblName.endsWith("attr") || tblName.endsWith("reltype"))) continue;
                    this.tableDisplayItems.add(new LocalizableJListItem(rs.getString(2), rs.getInt(1), null));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, e);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, e);
            }
        }
        return this.tableDisplayItems;
    }

    @Override
    public LocalizableContainerIFace getContainer(LocalizableJListItem item, LocalizableIOIFaceListener l) {
        this.loadTable(item.getId(), item.getName(), l);
        return null;
    }

    @Override
    public Vector<LocalizableJListItem> getDisplayItems(LocalizableJListItem containerArg) {
        Vector<LocalizableJListItem> items = this.itemJListItemsHash.get(containerArg);
        if (items == null) {
            LocalizableContainerIFace cont = this.tableHash.get(containerArg.getId());
            if (cont != null) {
                SpLocaleContainer container = (SpLocaleContainer)cont;
                items = new Vector();
                for (LocalizableItemIFace item : container.getContainerItems()) {
                    SpLocaleContainerItem cItem = (SpLocaleContainerItem)item;
                    cItem.getNames();
                    cItem.getDescs();
                    items.add(new LocalizableJListItem(cItem.getName(), cItem.getId(), null));
                }
                this.itemJListItemsHash.put(containerArg, items);
                Collections.sort(items);
            } else {
                log.error((Object)("Couldn't find container [" + containerArg.getName() + "]"));
            }
        }
        return items;
    }

    @Override
    public LocalizableItemIFace getItem(LocalizableContainerIFace containerArg, LocalizableJListItem item) {
        SpLocaleContainer container = (SpLocaleContainer)containerArg;
        if (container != null) {
            for (LocalizableItemIFace localizableItemIFace : container.getItems()) {
                if (!localizableItemIFace.getName().equals(item.getName())) continue;
                return localizableItemIFace;
            }
        } else {
            log.error((Object)("Couldn't merge container [" + containerArg.getName() + "]"));
        }
        return null;
    }

    @Override
    public boolean load(boolean useCurrentLocaleOnly) {
        this.enabledDlgBtns(true);
        return true;
    }

    protected SpLocaleContainer loadTable(DataProviderSessionIFace sessionArg, int containerId) {
        SpLocaleContainer container = null;
        DataProviderSessionIFace session = null;
        try {
            session = sessionArg != null ? sessionArg : DataProviderFactory.getInstance().createSession();
            int dispId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
            String sql = String.format("FROM SpLocaleContainer WHERE disciplineId = %d AND spLocaleContainerId = %d", dispId, containerId);
            container = (SpLocaleContainer)session.getData(sql);
            this.tables.add(container);
            this.tableHash.put(container.getId(), container);
            for (SpLocaleContainerItem item : container.getItems()) {
                container.getDescs().size();
                container.getNames().size();
                item.getDescs().size();
                item.getNames().size();
            }
            SpLocaleContainer spLocaleContainer = container;
            return spLocaleContainer;
        }
        catch (Exception e) {
            e.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, e);
        }
        finally {
            if (session != null && sessionArg == null) {
                session.close();
            }
        }
        return null;
    }

    protected void loadTable(final int containerId, final String name, final LocalizableIOIFaceListener l) {
        LocalizableContainerIFace cntr = this.tableHash.get(containerId);
        if (cntr != null) {
            l.containterRetrieved(cntr);
            return;
        }
        UIRegistry.getStatusBar().setIndeterminate(name, true);
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString("LOADING_SCHEMA"));
        this.enabledDlgBtns(false);
        this.schemaLocPanel.enableUIControls(false);
        SwingWorker workerThread = new SwingWorker(){
            protected SpLocaleContainer container = null;

            @Override
            public Object construct() {
                this.container = SchemaLocalizerDlg.this.loadTable(null, containerId);
                return null;
            }

            @Override
            public void finished() {
                l.containterRetrieved(this.container);
                SchemaLocalizerDlg.this.enabledDlgBtns(true);
                UIRegistry.getStatusBar().setProgressDone(name);
                UIRegistry.getStatusBar().setText("");
                SchemaLocalizerDlg.this.schemaLocPanel.getContainerList().setEnabled(true);
            }
        };
        workerThread.start();
    }

    @Override
    public boolean save() {
        this.schemaLocPanel.getAllDataFromUI();
        SimpleGlassPane glassPane = (SimpleGlassPane)this.getGlassPane();
        if (glassPane != null) {
            glassPane.setProgress(0);
        }
        DataObjFieldFormatMgr.getInstance().applyChanges(this.dataObjFieldFormatMgrCache);
        UIFieldFormatterMgr.getInstance().applyChanges(this.uiFieldFormatterMgrCache);
        WebLinkMgr.getInstance().applyChanges(this.webLinkMgrCache);
        if (this.changedTables.size() > 0) {
            block18: {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        double step = 100.0 / (double)this.changedTables.size();
                        double total = 0.0;
                        session.beginTransaction();
                        for (SpLocaleContainer container : this.changedTables) {
                            SpLocaleContainer dbContainer = session.merge(container);
                            session.saveOrUpdate(dbContainer);
                            for (SpLocaleItemStr str : dbContainer.getNames()) {
                                session.saveOrUpdate(session.merge(str));
                            }
                            for (SpLocaleItemStr str : dbContainer.getDescs()) {
                                session.saveOrUpdate(session.merge(str));
                            }
                            for (SpLocaleContainerItem item : dbContainer.getItems()) {
                                SpLocaleContainerItem i = session.merge(item);
                                session.saveOrUpdate(i);
                                for (SpLocaleItemStr str : i.getNames()) {
                                    session.saveOrUpdate(session.merge(str));
                                }
                                for (SpLocaleItemStr str : i.getDescs()) {
                                    session.saveOrUpdate(session.merge(str));
                                }
                            }
                            System.err.println(String.valueOf(total += step) + "  " + step);
                            if (glassPane == null) continue;
                            glassPane.setProgress((int)total);
                        }
                        session.commit();
                        session.flush();
                        if (glassPane != null) {
                            glassPane.setProgress(100);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
                        if (session != null) {
                            session.close();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.close();
                }
            }
            CommandAction cmd = new CommandAction(SCHEMA_LOCALIZER, SCHEMA_LOCALIZER, null);
            CommandDispatcher.dispatch(cmd);
        } else {
            log.warn((Object)"No Changes were saved!");
        }
        return true;
    }

    @Override
    public void containerChanged(LocalizableContainerIFace container) {
        if (container instanceof SpLocaleContainer && this.changedTableHash.get(container.getId()) == null) {
            this.changedTables.add((SpLocaleContainer)container);
            this.changedTableHash.put(container.getId(), container);
        }
    }

    @Override
    public boolean isLocaleInUse(Locale locale) {
        if (this.isLocaleInUseInDB(this.schemaType, locale)) {
            return true;
        }
        Hashtable<String, Boolean> localeHash = new Hashtable<String, Boolean>();
        for (SpLocaleContainer container : this.tables) {
            SchemaLocalizerXMLHelper.checkForLocales(container, localeHash);
            for (LocalizableItemIFace f : container.getContainerItems()) {
                SchemaLocalizerXMLHelper.checkForLocales(f, localeHash);
            }
        }
        return localeHash.get(SchemaLocalizerXMLHelper.makeLocaleKey(locale)) != null;
    }

    @Override
    public Vector<Locale> getLocalesInUse() {
        Hashtable<String, Boolean> localeHash = new Hashtable<String, Boolean>();
        Vector<Locale> localeList = SchemaLocalizerDlg.getLocalesInUseInDB(this.schemaType);
        for (Locale locale : localeList) {
            localeHash.put(SchemaLocalizerXMLHelper.makeLocaleKey(locale.getLanguage(), locale.getCountry(), locale.getVariant()), true);
        }
        for (SpLocaleContainer container : this.tables) {
            SchemaLocalizerXMLHelper.checkForLocales(container, localeHash);
            for (LocalizableItemIFace f : container.getContainerItems()) {
                SchemaLocalizerXMLHelper.checkForLocales(f, localeHash);
            }
        }
        localeList.clear();
        for (String key : localeHash.keySet()) {
            String[] toks = StringUtils.split((String)key, (String)"_");
            localeList.add(new Locale(toks[0], "", ""));
        }
        return localeList;
    }

    @Override
    public boolean shouldIncludeAppTables() {
        return false;
    }

    public static Vector<Locale> getLocalesInUseInDB(Byte schemaType) {
        Vector<Locale> locales = new Vector<Locale>();
        Session session = HibernateUtil.getNewSession();
        try {
            try {
                String sql = "SELECT DISTINCT nms.language FROM SpLocaleContainer as ctn INNER JOIN ctn.items as itm INNER JOIN itm.names nms INNER JOIN ctn.discipline as d WHERE d.userGroupScopeId = DSPLNID AND nms.language IS NOT NULL AND ctn.schemaType = " + schemaType;
                sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                log.debug((Object)sql);
                Query query = session.createQuery(sql);
                List list = query.list();
                for (Object lang : list) {
                    locales.add(new Locale(lang.toString(), "", ""));
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
                ex.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return locales;
    }

    public boolean isLocaleInUseInDB(Byte schemaTypeArg, Locale locale) {
        Session session = HibernateUtil.getNewSession();
        try {
            String sql = String.format("SELECT DISTINCT nms.language FROM SpLocaleContainer as ctn INNER JOIN ctn.items as itm INNER JOIN itm.names nms INNER JOIN ctn.discipline as d WHERE  d.userGroupScopeId = DSPLNID AND nms.language = '%s' AND ctn.schemaType = %d", locale.getLanguage(), schemaTypeArg);
            sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
            Query query = session.createQuery(sql);
            List list = query.list();
            boolean bl = list.size() > 0;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
        }
        finally {
            session.close();
        }
        return false;
    }

    protected void enabledDlgBtns(boolean enable) {
        this.okBtn.setEnabled(enable ? (this.schemaLocPanel != null ? this.schemaLocPanel.hasChanged() : false) : false);
        this.cancelBtn.setEnabled(enable);
        this.applyBtn.setEnabled(enable);
        this.helpBtn.setEnabled(enable);
    }

    public void copyLocale(LocalizableItemIFace item, Locale srcLocale, Locale dstLocale) {
        item.fillNames(this.namesList);
        LocalizableStrIFace srcName = null;
        for (LocalizableStrIFace nm : this.namesList) {
            if (!nm.isLocale(srcLocale)) continue;
            srcName = nm;
            break;
        }
        if (srcName != null) {
            LocalizableStrIFace name = this.localizableStrFactory.create(srcName.getText(), dstLocale);
            item.addName(name);
        }
        item.fillDescs(this.descsList);
        LocalizableStrIFace srcDesc = null;
        for (LocalizableStrIFace d : this.descsList) {
            if (!d.isLocale(srcLocale)) continue;
            srcDesc = d;
            break;
        }
        if (srcDesc != null) {
            LocalizableStrIFace desc = this.localizableStrFactory.create(srcDesc.getText(), dstLocale);
            item.addDesc(desc);
        }
    }

    @Override
    public void copyLocale(LocalizableIOIFaceListener lcl, Locale srcLocale, Locale dstLocale, PropertyChangeListener pcl) {
        block11: {
            UIRegistry.getStatusBar().setProgressRange(SCHEMALOCDLG, 0, this.getContainerDisplayItems().size());
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                try {
                    double step = 100.0 / (double)this.tableDisplayItems.size();
                    double total = 0.0;
                    for (LocalizableJListItem listItem : this.tableDisplayItems) {
                        SpLocaleContainer container = (SpLocaleContainer)this.tableHash.get(listItem.getId());
                        if (container == null) {
                            container = this.loadTable(session, listItem.getId());
                            this.tableHash.put(listItem.getId(), container);
                        }
                        if (container != null) {
                            this.copyLocale(container, srcLocale, dstLocale);
                            for (LocalizableItemIFace localizableItemIFace : container.getItems()) {
                                this.copyLocale(localizableItemIFace, srcLocale, dstLocale);
                            }
                            this.containerChanged(container);
                            if (pcl != null) {
                                pcl.propertyChange(new PropertyChangeEvent(this, "progress", total, (int)(total + step)));
                            }
                        } else {
                            log.error((Object)("Couldn't find Container[" + listItem.getId() + "]"));
                        }
                        total += step;
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
                    ex.printStackTrace();
                    session.close();
                    UIRegistry.getStatusBar().setProgressDone(SCHEMALOCDLG);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                session.close();
                UIRegistry.getStatusBar().setProgressDone(SCHEMALOCDLG);
                throw throwable;
            }
            session.close();
            UIRegistry.getStatusBar().setProgressDone(SCHEMALOCDLG);
        }
        pcl.propertyChange(new PropertyChangeEvent(this, "progress", 99, 100));
    }

    @Override
    public List<PickList> getPickLists(String disciplineName) {
        if (StringUtils.isNotEmpty((String)disciplineName)) {
            return null;
        }
        if (this.pickLists == null) {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    this.pickLists = new Vector<PickList>();
                    String sql = "SELECT name, type, tableName, fieldName, pickListId FROM PickList WHERE collectionId = " + AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionId() + " ORDER BY name";
                    List<?> list = session.getDataList(sql);
                    for (Object row : list) {
                        Object[] data = (Object[])row;
                        PickList pl = new PickList();
                        pl.initialize();
                        pl.setName((String)data[0]);
                        pl.setType((Byte)data[1]);
                        pl.setTableName((String)data[2]);
                        pl.setFieldName((String)data[3]);
                        pl.setPickListId((Integer)data[4]);
                        this.pickLists.add(pl);
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SchemaLocalizerDlg.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return this.pickLists;
    }

    @Override
    public boolean exportToDirectory(File expportDir) {
        throw new RuntimeException("Export is not implemented.");
    }

    @Override
    public boolean hasUpdatablePickLists() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("copyStart")) {
            this.enabledDlgBtns(false);
        } else if (evt.getPropertyName().equals("copyEnd")) {
            this.enabledDlgBtns(true);
        }
    }

    @Override
    public boolean exportSingleLanguageToDirectory(File expportFile, Locale locale) {
        throw new RuntimeException("Not Impl");
    }

    @Override
    public boolean hasChanged() {
        throw new RuntimeException("Not Impl");
    }
}

