/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesOkDeleteIFace;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.busrules.PickListBusRules;
import edu.ku.brc.specify.tasks.services.PickListUtils;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PickListEditorDlg
extends CustomDialog
implements BusinessRulesOkDeleteIFace {
    protected LocalizableIOIFace localizableIO;
    protected JList sysPLList;
    protected EditDeleteAddPanel sysEDAPanel;
    protected JList plList;
    protected EditDeleteAddPanel edaPanel;
    protected PickListBusRules plBusRules = new PickListBusRules();
    protected Collection collection = null;
    protected JList pickListCache = null;
    protected boolean doAddRemove;
    protected DBTableInfo tableInfo = null;
    protected DBFieldInfo fieldInfo = null;
    protected boolean isChanged = false;
    protected Vector<PickList> newPickLists = new Vector();

    public PickListEditorDlg(LocalizableIOIFace localizableIO, boolean doAddRemoveArg, boolean doAddImpExp) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("PICKLIST_EDITOR"), true, doAddRemoveArg ? 15 : 5, null, 1);
        this.localizableIO = localizableIO;
        this.helpContext = "PL_HELP_CONTEXT";
        this.okLabel = UIRegistry.getResourceString("CLOSE");
        this.doAddRemove = doAddRemoveArg;
        if (doAddImpExp) {
            this.cancelLabel = UIRegistry.getResourceString("Export");
            this.applyLabel = UIRegistry.getResourceString("Import");
        }
    }

    @Override
    public void createUI() {
        super.createUI();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g", "p,2px,f:p:g,2px,p, 10px, p,2px,f:p:g,2px,p,10px"));
        CellConstraints cc = new CellConstraints();
        this.plList = new JList();
        this.edaPanel = this.configureList(this.plList, false, this.doAddRemove);
        this.sysPLList = new JList();
        this.sysEDAPanel = this.configureList(this.sysPLList, true, false);
        int y = 1;
        pb.add((Component)UIHelper.createI18NLabel("PL_PICKLISTS_SYS", 0), cc.xy(1, y));
        pb.add((Component)UIHelper.createScrollPane(this.sysPLList), cc.xy(1, y += 2));
        pb.add((Component)this.sysEDAPanel, cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createI18NLabel("PL_PICKLISTS_USR", 0), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(this.plList), cc.xy(1, y += 2));
        pb.add((Component)this.edaPanel, cc.xy(1, y += 2));
        y += 2;
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    public boolean hasChanged() {
        return this.isChanged;
    }

    public void setTableInfo(DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setFieldInfo(DBFieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public Vector<PickList> getNewPickLists() {
        return this.newPickLists;
    }

    protected boolean loadList(JList list, boolean isSystemPL) {
        List<PickList> items = this.getPickLists(false, isSystemPL);
        if (items == null) {
            return false;
        }
        DefaultListModel<PickList> model = new DefaultListModel<PickList>();
        for (PickList pl : items) {
            model.addElement(pl);
        }
        list.setModel(model);
        return true;
    }

    protected EditDeleteAddPanel configureList(final JList list, boolean isSystemPL, boolean doAddRemoveArg) {
        ActionListener edtAL;
        EditDeleteAddPanel edaPnl;
        ActionListener addAL = null;
        ActionListener delAL = null;
        if (!isSystemPL && doAddRemoveArg) {
            addAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickListEditorDlg.this.addPL(list);
                }
            };
            delAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickListEditorDlg.this.delPL(list);
                }
            };
        }
        if ((edaPnl = new EditDeleteAddPanel(edtAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PickListEditorDlg.this.editPL(list);
            }
        }, delAL, addAL)).getAddBtn() != null) {
            edaPnl.getAddBtn().setEnabled(true);
        }
        this.loadList(list, isSystemPL);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    PickListEditorDlg.this.editPL(list);
                }
            }
        });
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (edaPnl.getDelBtn() != null) {
                        edaPnl.getDelBtn().setEnabled(list.getSelectedIndex() > -1);
                    }
                    edaPnl.getEditBtn().setEnabled(list.getSelectedIndex() > -1);
                }
            }
        });
        return edaPnl;
    }

    protected List<PickList> getPickLists(boolean doAll, boolean isSystemPL) {
        List<PickList> items = PickListUtils.getPickLists(this.localizableIO, doAll, isSystemPL);
        if (items != null) {
            this.collection = PickListUtils.getCollectionFromAppContext();
        }
        return items;
    }

    protected void addPL(JList list) {
        PickList pickList = new PickList();
        pickList.initialize();
        this.collection.addReference(pickList, "pickLists");
        PickList savedPickList = this.editPL(pickList);
        if (savedPickList != null) {
            ((DefaultListModel)list.getModel()).addElement(savedPickList);
            this.newPickLists.add(pickList);
        }
    }

    protected void delPL(JList list) {
        PickList pickList = (PickList)list.getSelectedValue();
        if (pickList != null) {
            DataProviderSessionIFace session = null;
            try {
                this.pickListCache = list;
                session = DataProviderFactory.getInstance().createSession();
                this.plBusRules.okToDelete(pickList, session, this);
                this.isChanged = true;
                this.newPickLists.remove(pickList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PickListEditorDlg.class, ex);
                this.pickListCache = null;
            }
        }
    }

    protected boolean importPL(JList listArg) {
        this.isChanged = true;
        return true;
    }

    protected boolean exportPL(JList listArg) {
        return true;
    }

    protected PickList editPL(PickList pickList) {
        ValTextField.JFormattedDoc doc;
        ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "SystemSetup", "PickList", null, UIRegistry.getResourceString("PL_EDT_TITLE"), UIRegistry.getResourceString("SAVE"), null, null, true, 8);
        dlg.setHelpContext("PL_ITEM_EDITOR");
        BusinessRulesIFace busRules = dlg.getMultiView().getCurrentViewAsFormViewObj().getBusinessRules();
        if (busRules instanceof FormPane.FormPaneAdjusterIFace) {
            dlg.setFormAdjuster((FormPane.FormPaneAdjusterIFace)((Object)busRules));
        }
        MultiView multiView = dlg.getMultiView();
        ValTextField tf = (ValTextField)multiView.getKids().get(0).getCurrentViewAsFormViewObj().getCompById("value");
        ArrayList<DocumentListener> listeners = new ArrayList<DocumentListener>();
        DocumentListener[] documentListenerArray = ((ValPlainTextDocument)tf.getDocument()).getDocumentListeners();
        int n = documentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentListener dl = documentListenerArray[n2];
            listeners.add(dl);
            ++n2;
        }
        if (this.fieldInfo != null && this.fieldInfo.getType().equals("java.lang.Byte")) {
            ValTextField valTextField = tf;
            valTextField.getClass();
            doc = valTextField.new ValTextField.JFormattedDoc(tf, 3, 0, 255);
        } else {
            ValTextField valTextField = tf;
            valTextField.getClass();
            doc = valTextField.new ValTextField.JFormattedDoc(tf, UIFieldFormatterField.FieldType.anychar, 64);
        }
        tf.setDocument(doc);
        for (DocumentListener dl : listeners) {
            doc.addDocumentListener(dl);
        }
        dlg.setData(pickList);
        dlg.setModal(true);
        UIHelper.centerAndShow(dlg);
        if (dlg.getBtnPressed() == 1) {
            dlg.getMultiView().getCurrentViewAsFormViewObj().traverseToGetDataFromForms();
            boolean isOK = multiView.getCurrentViewAsFormViewObj().saveObject();
            PickList savedPL = (PickList)multiView.getCurrentViewAsFormViewObj().getDataObj();
            if (isOK) {
                this.isChanged = true;
                this.dispatchChangeNotification(pickList);
            }
            return !isOK ? null : savedPL;
        }
        return null;
    }

    private void dispatchChangeNotification(PickList pickList) {
        CommandDispatcher.dispatch(new CommandAction("PICKLIST", "CLEAR", pickList.getName()));
    }

    protected void editPL(JList list) {
        PickList savedPickList;
        PickList pickList;
        PickList selectedPL = (PickList)list.getSelectedValue();
        if (selectedPL != null && (pickList = selectedPL.getId() != null ? (PickList)DataModelObjBase.getDataObj(PickList.class, selectedPL.getId()) : selectedPL) != null && (savedPickList = this.editPL(pickList)) != null) {
            DefaultListModel model = (DefaultListModel)list.getModel();
            int inx = model.indexOf(selectedPL);
            ((DefaultListModel)list.getModel()).removeElement(selectedPL);
            model.insertElementAt(savedPickList, inx);
        }
    }

    @Override
    protected void applyButtonPressed() {
        if (PickListUtils.importPickLists(this.localizableIO, this.collection)) {
            this.collection = PickListUtils.getCollectionFromAppContext();
            AppContextMgr.getInstance().setClassObject(Collection.class, this.collection);
            this.loadList(this.sysPLList, true);
            this.loadList(this.plList, false);
        }
    }

    private void fillFromModel(JList list, HashSet<String> hash) {
        ListModel model = list.getModel();
        int[] nArray = list.getSelectedIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int inx = nArray[n2];
            hash.add(model.getElementAt(inx).toString());
            ++n2;
        }
    }

    @Override
    protected void cancelButtonPressed() {
        HashSet<String> hash = new HashSet<String>();
        this.fillFromModel(this.sysPLList, hash);
        this.fillFromModel(this.plList, hash);
        PickListUtils.exportPickList(this.localizableIO, hash);
    }

    @Override
    public void doDeleteDataObj(Object dataObj, DataProviderSessionIFace session, boolean doDelete) {
        if (doDelete) {
            try {
                try {
                    PickList pickList = (PickList)dataObj;
                    pickList = session.merge(pickList);
                    pickList.getCollection().removeReference(pickList, "pickLists");
                    session.beginTransaction();
                    session.delete(pickList);
                    session.commit();
                    if (this.pickListCache != null) {
                        ((DefaultListModel)this.pickListCache.getModel()).remove(this.pickListCache.getSelectedIndex());
                        this.pickListCache = null;
                    }
                    this.dispatchChangeNotification(pickList);
                    UIRegistry.displayLocalizedStatusBarText("PL_DELETED", pickList.getName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PickListEditorDlg.class, ex);
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }
}

