/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.specify.tools.schemalocale.DisplayLocale;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrFactory;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public abstract class LocalizerBasePanel
extends JPanel {
    protected static LocalizableStrFactory localizableStrFactory;
    protected static Vector<LocalizableStrIFace> namesList;
    protected static Vector<LocalizableStrIFace> descsList;
    protected boolean doAutoSpellCheck = false;
    protected SpellDictionary dictionary = null;
    protected String phoneticFileName = "phonet.en";
    protected String dictionaryFileName = "english.0.zip";
    protected String userFileName = "user.dict";
    protected JTextComponentSpellChecker checker = null;
    protected SpellDictionary userDict;
    protected boolean spellCheckLoaded = false;
    protected boolean hasChanged = false;
    private boolean ignoreChanges = false;
    protected JButton saveBtn = null;
    protected JMenuItem saveMenuItem = null;

    static {
        namesList = new Vector();
        descsList = new Vector();
    }

    public LocalizerBasePanel() {
        SchemaI18NService.initializeLocales();
    }

    public static LocalizableStrFactory getLocalizableStrFactory() {
        return localizableStrFactory;
    }

    public static void setLocalizableStrFactory(LocalizableStrFactory localizableStrFactory) {
        LocalizerBasePanel.localizableStrFactory = localizableStrFactory;
    }

    public void init() {
    }

    protected void enableSpellCheck() {
    }

    protected Locale getLocaleByName(String displayName) {
        for (Locale locale : SchemaI18NService.getInstance().getLocales()) {
            if (!locale.getDisplayName().equals(displayName)) continue;
            return locale;
        }
        return null;
    }

    protected Locale chooseNewLocale(Vector<Locale> inUseLocales) {
        Vector<DisplayLocale> list = new Vector<DisplayLocale>();
        for (Locale l : inUseLocales) {
            list.add(new DisplayLocale(l));
        }
        Collections.sort(list);
        ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg(null, "CHOOSE_LOCALE", list, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            return ((DisplayLocale)dlg.getSelectedObject()).getLocale();
        }
        return null;
    }

    public static boolean setDescStrForCurrLocale(LocalizableItemIFace lndi, String text) {
        LocalizableStrIFace desc = LocalizerBasePanel.getDescForCurrLocale(lndi);
        if (desc == null) {
            if (StringUtils.isNotEmpty((String)text)) {
                desc = localizableStrFactory.create(text, SchemaI18NService.getCurrentLocale());
                lndi.addDesc(desc);
                return true;
            }
        } else if (!text.equals(desc.getText())) {
            desc.setText(text);
            return true;
        }
        return false;
    }

    public static String getDescStrForCurrLocale(LocalizableItemIFace lndi) {
        LocalizableStrIFace desc = LocalizerBasePanel.getDescForCurrLocale(lndi);
        if (desc == null) {
            return "";
        }
        return desc.getText();
    }

    public static LocalizableStrIFace getDescForCurrLocale(LocalizableItemIFace lndi) {
        lndi.fillDescs(descsList);
        for (LocalizableStrIFace d : descsList) {
            if (!d.isLocale(SchemaI18NService.getCurrentLocale())) continue;
            return d;
        }
        return null;
    }

    public static boolean setNameDescStrForCurrLocale(LocalizableItemIFace lndi, String text) {
        LocalizableStrIFace nameDesc = LocalizerBasePanel.getNameDescForCurrLocale(lndi);
        if (nameDesc == null) {
            if (StringUtils.isNotEmpty((String)text)) {
                nameDesc = localizableStrFactory.create(text, SchemaI18NService.getCurrentLocale());
                lndi.addName(nameDesc);
                return true;
            }
        } else if (!text.equals(nameDesc.getText())) {
            nameDesc.setText(text);
            return true;
        }
        return false;
    }

    public static String getNameDescStrForCurrLocale(LocalizableItemIFace lndi) {
        LocalizableStrIFace nameDesc = LocalizerBasePanel.getNameDescForCurrLocale(lndi);
        if (nameDesc == null) {
            return "";
        }
        return nameDesc.getText();
    }

    public static LocalizableStrIFace getNameDescForCurrLocale(LocalizableItemIFace lndi) {
        lndi.fillNames(namesList);
        for (LocalizableStrIFace n : namesList) {
            if (!n.isLocale(SchemaI18NService.getCurrentLocale())) continue;
            return n;
        }
        return null;
    }

    public boolean isIgnoreChanges() {
        return this.ignoreChanges;
    }

    public void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges = ignoreChanges;
    }

    protected void setHasChanged(boolean changed) {
        if (!this.ignoreChanges) {
            this.hasChanged = changed;
            if (this.saveBtn != null) {
                this.saveBtn.setEnabled(changed);
            }
            if (this.saveMenuItem != null) {
                this.saveMenuItem.setEnabled(changed);
            }
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setSaveBtn(JButton saveBtn) {
        this.saveBtn = saveBtn;
    }

    public void setSaveMenuItem(JMenuItem saveMenuItem) {
        this.saveMenuItem = saveMenuItem;
    }

    public JMenuItem getSaveMenuItem() {
        return this.saveMenuItem;
    }

    public abstract void localeChanged(Locale var1);
}

