/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.tools.schemalocale.LocalizableBaseApp;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LocalizerApp
extends LocalizableBaseApp {
    protected FileDocument fileDoc = new FileDocument();
    protected File INDEX_DIR = new File("index");
    protected IndexReader reader;
    protected Searcher searcher;
    protected Analyzer analyzer;

    public LocalizerApp() {
        new MacOSAppHandler(this);
        this.appName = "Schema Localizer";
        this.appVersion = "6.0";
        this.appBuildVersion = "200706111309 (SVN: 2291)";
        this.setTitle(String.valueOf(this.appName) + " " + this.appVersion);
    }

    private void initLucene() {
        try {
            this.reader = IndexReader.open((Directory)FSDirectory.open((File)this.INDEX_DIR), (boolean)true);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.searcher = new IndexSearcher(this.reader);
        this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
    }

    /*
     * WARNING - void declaration
     */
    public void processProperties() {
        this.initLucene();
        try {
            Locale currLocale = Locale.getDefault();
            Vector<String> terms = new Vector<String>();
            File resFile = new File("src/resources_" + currLocale.getLanguage() + ".properties");
            List lines = FileUtils.readLines((File)resFile);
            for (String line : lines) {
                String[] toks;
                int inx;
                if (line.startsWith("#") || (inx = line.indexOf("=")) <= -1 || (toks = StringUtils.split((String)line, (String)"=")).length <= 1) continue;
                terms.add(toks[0]);
            }
            Vector<Pair<String, void>> notFoundList = new Vector<Pair<String, void>>();
            String field = "contents";
            QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, field, this.analyzer);
            for (String term : terms) {
                try {
                    void var11_18;
                    int lastInx;
                    String string;
                    int inx;
                    if (term.equals("AND") || term.equals("OR")) continue;
                    Query query = parser.parse(term);
                    Object var11_15 = null;
                    int hits = this.getTotalHits(query, 10);
                    if (hits == 0 && (inx = term.indexOf(46)) > -1 && (hits = this.getTotalHits(parser.parse(string = term.substring(inx + 1)), 10)) == 0 && (lastInx = term.lastIndexOf(46)) > -1 && lastInx != inx) {
                        String string2 = term.substring(lastInx + 1);
                        hits = this.getTotalHits(parser.parse(string2), 10);
                    }
                    if (hits != 0) continue;
                    notFoundList.add(new Pair<String, void>(term, var11_18));
                    System.out.println("'" + term + "' was not found " + (var11_18 != null ? "SubTerm[" + (String)var11_18 + "]" : ""));
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            ConversionLogger convLogger = new ConversionLogger();
            convLogger.initialize("resources", "Resources");
            TableWriter tblWriter = convLogger.getWriter("resources.html", "Resources");
            tblWriter.startTable();
            tblWriter.logHdr("Id", "Full Key", "Sub Key");
            int cnt = 1;
            for (Pair pair : notFoundList) {
                tblWriter.log(Integer.toString(cnt++), (String)pair.first, pair.second != null ? (String)pair.second : "&nbsp;");
            }
            tblWriter.endTable();
            convLogger.closeAll();
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LocalizerApp.class, ex);
            ex.printStackTrace();
        }
    }

    protected void indexSourceFiles() {
        File SRC_DIR;
        if (this.INDEX_DIR.exists()) {
            System.out.println("Cannot save index to '" + this.INDEX_DIR + "' directory, please delete it first");
            System.exit(1);
        }
        if (!(SRC_DIR = new File("src")).exists()) {
            System.out.println("Source directory doesn't exist '" + SRC_DIR);
            System.exit(1);
        }
        Date start = new Date();
        try {
            IndexWriter writer = new IndexWriter((Directory)FSDirectory.open((File)this.INDEX_DIR), (Analyzer)new StandardAnalyzer(Version.LUCENE_CURRENT), true, IndexWriter.MaxFieldLength.LIMITED);
            System.out.println("Indexing to directory '" + this.INDEX_DIR + "'...");
            this.indexDocs(writer, SRC_DIR);
            System.out.println("Optimizing...");
            writer.optimize();
            writer.close();
            Date end = new Date();
            System.out.println(String.valueOf(end.getTime() - start.getTime()) + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    public void doInteractiveSearch() {
        try {
            String field = "contents";
            String queries = null;
            int repeat = 0;
            boolean raw = false;
            boolean paging = true;
            int hitsPerPage = 10;
            BufferedReader in = null;
            in = queries != null ? new BufferedReader(new FileReader(queries)) : new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, field, this.analyzer);
            while (true) {
                String line;
                if (queries == null) {
                    System.out.println("Enter query: ");
                }
                if ((line = in.readLine()) == null || line.length() == -1 || (line = line.trim()).length() == 0) break;
                Query query = parser.parse(line);
                System.out.println("Searching for: " + query.toString(field));
                if (repeat > 0) {
                    Date start = new Date();
                    int i = 0;
                    while (i < repeat) {
                        this.searcher.search(query, null, 100);
                        ++i;
                    }
                    Date end = new Date();
                    System.out.println("Time: " + (end.getTime() - start.getTime()) + "ms");
                }
                if (paging) {
                    LocalizerApp.doPagingSearch(in, this.searcher, query, hitsPerPage, raw, queries == null);
                    continue;
                }
                this.doStreamingSearch(this.searcher, query);
            }
            this.reader.close();
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            FileDocument fileDoc = new FileDocument();
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    protected int getTotalHits(Query query, int hitsPerPage) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)(5 * hitsPerPage), (boolean)false);
        this.searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        int numTotalHits = collector.getTotalHits();
        return numTotalHits;
    }

    public static void doPagingSearch(BufferedReader in, Searcher searcher, Query query, int hitsPerPage, boolean raw, boolean interactive) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)(5 * hitsPerPage), (boolean)false);
        searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        int numTotalHits = collector.getTotalHits();
        System.out.println(String.valueOf(numTotalHits) + " total matching documents");
        int start = 0;
        int end = Math.min(numTotalHits, hitsPerPage);
        while (true) {
            if (end > hits.length) {
                System.out.println("Only results 1 - " + hits.length + " of " + numTotalHits + " total matching documents collected.");
                System.out.println("Collect more (y/n) ?");
                String line = in.readLine();
                if (line.length() == 0 || line.charAt(0) == 'n') break;
                collector = TopScoreDocCollector.create((int)numTotalHits, (boolean)false);
                searcher.search(query, (Collector)collector);
                hits = collector.topDocs().scoreDocs;
            }
            end = Math.min(hits.length, start + hitsPerPage);
            int i = start;
            while (i < end) {
                if (raw) {
                    System.out.println("doc=" + hits[i].doc + " score=" + hits[i].score);
                } else {
                    Document doc = searcher.doc(hits[i].doc);
                    String path = doc.get("path");
                    if (path != null) {
                        System.out.println(String.valueOf(i + 1) + ". " + path);
                        String title = doc.get("title");
                        if (title != null) {
                            System.out.println("   Title: " + doc.get("title"));
                        }
                    } else {
                        System.out.println(String.valueOf(i + 1) + ". " + "No path for this document");
                    }
                }
                ++i;
            }
            if (!interactive) break;
            if (numTotalHits < end) continue;
            boolean quit = false;
            while (true) {
                System.out.print("Press ");
                if (start - hitsPerPage >= 0) {
                    System.out.print("(p)revious page, ");
                }
                if (start + hitsPerPage < numTotalHits) {
                    System.out.print("(n)ext page, ");
                }
                System.out.println("(q)uit or enter number to jump to a page.");
                String line = in.readLine();
                if (line.length() == 0 || line.charAt(0) == 'q') {
                    quit = true;
                    break;
                }
                if (line.charAt(0) == 'p') {
                    start = Math.max(0, start - hitsPerPage);
                    break;
                }
                if (line.charAt(0) == 'n') {
                    if (start + hitsPerPage >= numTotalHits) break;
                    start += hitsPerPage;
                    break;
                }
                int page = Integer.parseInt(line);
                if ((page - 1) * hitsPerPage < numTotalHits) {
                    start = (page - 1) * hitsPerPage;
                    break;
                }
                System.out.println("No such page");
            }
            if (quit) break;
            end = Math.min(numTotalHits, start + hitsPerPage);
        }
    }

    public void doStreamingSearch(Searcher searcher, Query query) throws IOException {
        Collector streamingHitCollector = new Collector(){
            private Scorer scorer;
            private int docBase;

            public void collect(int doc) throws IOException {
                System.out.println("doc=" + doc + this.docBase + " score=" + this.scorer.score());
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.docBase = docBase;
            }

            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
            }
        };
        searcher.search(query, streamingHitCollector);
    }

    void indexDocs(IndexWriter writer, File file) throws IOException {
        block3: {
            String fileName;
            block4: {
                fileName = file.getName();
                System.out.println("Parsing " + fileName);
                if (!file.canRead()) break block3;
                if (!file.isDirectory()) break block4;
                String[] files = file.list();
                if (files == null) break block3;
                int i = 0;
                while (i < files.length) {
                    this.indexDocs(writer, new File(file, files[i]));
                    ++i;
                }
                break block3;
            }
            if (!fileName.endsWith(".java") && !fileName.endsWith(".xml")) break block3;
            System.out.println("adding " + file);
            try {
                writer.addDocument(this.fileDoc.loadDocument(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        boolean doResCheck = false;
        if (doResCheck) {
            LocalizerApp fd = new LocalizerApp();
            fd.processProperties();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceBundle.getBundle("resources", Locale.getDefault());
                }
                catch (MissingResourceException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(LocalizerApp.class, ex);
                    Locale.setDefault(Locale.ENGLISH);
                    UIRegistry.setResourceLocale(Locale.ENGLISH);
                }
                LocalizerApp fd = new LocalizerApp();
                fd.indexSourceFiles();
            }
        });
    }

    public class FileDocument {
        public Document loadDocument(File f) throws FileNotFoundException {
            Document doc = new Document();
            doc.add((Fieldable)new Field("path", f.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("contents", (Reader)new FileReader(f)));
            return doc;
        }

        private FileDocument() {
        }
    }

    public class MacOSAppHandler
    extends Application {
        protected WeakReference<LocalizerApp> app;

        public MacOSAppHandler(LocalizerApp app) {
            this.app = new WeakReference<LocalizerApp>(app);
            this.addApplicationListener(new AppHandler());
            this.setEnabledPreferencesMenu(false);
        }

        class AppHandler
        extends ApplicationAdapter {
            AppHandler() {
            }

            public void handleAbout(ApplicationEvent event) {
                ((LocalizerApp)MacOSAppHandler.this.app.get()).doAbout();
                event.setHandled(true);
            }

            public void handleAppPrefsMgr(ApplicationEvent event) {
                event.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent event) {
                event.setHandled(true);
            }

            public void handleQuit(ApplicationEvent event) {
                event.setHandled(false);
            }
        }
    }
}

