/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFormatterListEdtDlg;
import edu.ku.brc.af.ui.weblink.WebLinkConfigDlg;
import edu.ku.brc.af.ui.weblink.WebLinkDef;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFaceListener;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableJListItem;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizerBasePanel;
import edu.ku.brc.specify.tools.schemalocale.PickListEditorDlg;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerPanel;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FieldItemPanel
extends LocalizerBasePanel
implements LocalizableIOIFaceListener {
    private static final Logger log = Logger.getLogger(FieldItemPanel.class);
    protected final String SL_NONE = UIRegistry.getResourceString("NONE");
    protected final String SL_FORMAT = UIRegistry.getResourceString("SL_FORMAT");
    protected final String SL_WEBLINK = UIRegistry.getResourceString("SL_WEBLINK");
    protected final String SL_PICKLIST = UIRegistry.getResourceString("SL_PICKLIST");
    protected final String ELIPSES = "...";
    protected LocalizableIOIFace localizableIO = null;
    protected WebLinkMgr webLinkMgrCache;
    protected SchemaLocalizerPanel schemaPanel;
    protected LocalizableJListItem currJListItem = null;
    protected LocalizableContainerIFace currContainer = null;
    protected boolean includeHiddenUI;
    protected boolean isDBSchema;
    protected boolean includeFormatAndAutoNumUI;
    protected DBTableInfo tableInfo = null;
    protected DBFieldInfo fieldInfo = null;
    protected DBRelationshipInfo relInfo = null;
    protected JList fieldsList;
    protected JTextArea fieldDescText = UIHelper.createTextArea(5, 40);
    protected JTextField fieldNameText = UIHelper.createTextField();
    protected JLabel fieldDescLbl;
    protected JLabel fieldNameLbl;
    protected JLabel fieldTypeLbl;
    protected JLabel fieldLengthLbl;
    protected JLabel fieldTypeTxt;
    protected JLabel fieldLengthTxt;
    protected JCheckBox fieldReqChk;
    protected boolean mustBeRequired;
    protected JLabel formatLbl = null;
    protected JComboBox formatSwitcherCombo = null;
    protected JPanel formatterPanel;
    protected CardLayout fmtCardLayout;
    protected JComboBox formatCombo;
    protected JButton formatMoreBtn;
    protected Hashtable<String, UIFieldFormatterIFace> formatHash = new Hashtable();
    protected JComboBox webLinkCombo;
    protected JButton webLinkMoreBtn;
    protected WebLinkDef webLinkDefNone = new WebLinkDef(UIRegistry.getResourceString("NONE"), null);
    protected JLabel pickListLbl;
    protected JComboBox pickListCBX;
    protected PickList pickListNone = new PickList(UIRegistry.getResourceString("NONE"));
    protected JButton pickListMoreBtn;
    protected JLabel autoNumLbl;
    protected JComboBox autoNumberCombo;
    protected DefaultListModel fieldsModel = new DefaultListModel();
    protected JButton nxtBtn;
    protected JButton nxtEmptyBtn;
    protected JCheckBox fieldHideChk = UIHelper.createCheckBox(UIRegistry.getResourceString("SL_FIELD_HIDE_CHK"));
    protected LocalizableItemIFace prevField = null;
    protected JStatusBar statusBar = null;
    protected JButton fldSpellChkBtn = null;
    protected PropertyChangeListener pcl = null;
    protected List<PickList> pickLists = new Vector<PickList>();
    protected DisciplineType disciplineType = null;
    protected String disciplineName = null;
    protected Byte schemaType;

    public FieldItemPanel(SchemaLocalizerPanel schemaPanel, WebLinkMgr webLinkMgrCache, boolean includeHiddenUI, boolean includeFormatAndAutoNumUI, boolean isDBSchema, PropertyChangeListener pcl) {
        this(schemaPanel, webLinkMgrCache, includeHiddenUI, includeFormatAndAutoNumUI, isDBSchema, pcl, SpLocaleContainer.CORE_SCHEMA);
    }

    public FieldItemPanel(SchemaLocalizerPanel schemaPanel, WebLinkMgr webLinkMgrCache, boolean includeHiddenUI, boolean includeFormatAndAutoNumUI, boolean isDBSchema, PropertyChangeListener pcl, Byte schemaType) {
        this.schemaPanel = schemaPanel;
        this.webLinkMgrCache = webLinkMgrCache;
        this.includeHiddenUI = includeHiddenUI;
        this.includeFormatAndAutoNumUI = includeFormatAndAutoNumUI;
        this.isDBSchema = isDBSchema;
        this.pcl = pcl;
        this.schemaType = schemaType;
        this.init();
        this.buildUI();
    }

    public void buildUI() {
        PanelBuilder inner;
        this.setIgnoreChanges(true);
        this.fieldsList = UIHelper.createList(this.fieldsModel);
        this.fieldsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FieldItemPanel.this.getAllDataFromUI();
                    FieldItemPanel.this.fieldSelected();
                }
            }
        });
        this.fieldsList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
            }
        });
        this.fieldDescText.addKeyListener(new LengthWatcher(255));
        this.fieldNameText.addKeyListener(new LengthWatcher(64));
        CellConstraints cc = new CellConstraints();
        int y = 1;
        JScrollPane fldsp = UIHelper.createScrollPane(this.fieldsList);
        PanelBuilder pb = new PanelBuilder(new FormLayout("max(200px;p),4px,p,2px,p,10px,p,2px,p,f:p:g", String.valueOf(this.includeHiddenUI ? "p,2px," : "") + (this.isDBSchema ? "p,2px,p,2px," : "") + (this.includeFormatAndAutoNumUI ? "p,2px,p,2px," : "") + "p,2px,p,2px,p,2px,p,2px,p,2px,p,2px,f:p:g"), (JPanel)this);
        pb.add((Component)fldsp, cc.xywh(1, y, 1, 7 + (this.isDBSchema ? 4 : 0)));
        this.fieldNameLbl = UIHelper.createI18NFormLabel("SL_LABEL", 4);
        pb.add((Component)this.fieldNameLbl, cc.xy(3, y));
        pb.add((Component)this.fieldNameText, cc.xywh(5, y, 6, 1));
        y += 2;
        if (this.includeHiddenUI) {
            pb.add((Component)this.fieldHideChk, cc.xy(5, y));
            y += 2;
        }
        this.fieldDescLbl = UIHelper.createI18NFormLabel("SL_DESC", 4);
        pb.add((Component)this.fieldDescLbl, cc.xy(3, y));
        JScrollPane sp = new JScrollPane(this.fieldDescText, 20, 30);
        pb.add((Component)sp, cc.xywh(5, y, 6, 1));
        y += 2;
        this.fieldDescText.setLineWrap(true);
        this.fieldDescText.setWrapStyleWord(true);
        if (this.isDBSchema) {
            this.fieldTypeTxt = UIHelper.createLabel("");
            this.fieldLengthTxt = UIHelper.createLabel("");
            this.fieldTypeLbl = UIHelper.createI18NFormLabel("SL_TYPE", 4);
            pb.add((Component)this.fieldTypeLbl, cc.xy(3, y));
            pb.add((Component)this.fieldTypeTxt, cc.xy(5, y));
            this.fieldReqChk = UIHelper.createCheckBox(UIRegistry.getResourceString("SL_REQ"));
            pb.add((Component)this.fieldReqChk, cc.xy(9, y));
            this.fieldLengthLbl = UIHelper.createI18NFormLabel("SL_LENGTH", 4);
            pb.add((Component)this.fieldLengthLbl, cc.xy(3, y += 2));
            pb.add((Component)this.fieldLengthTxt, cc.xy(5, y));
            y += 2;
            this.fieldTypeTxt.setBackground(Color.WHITE);
            this.fieldLengthTxt.setBackground(Color.WHITE);
            this.fieldTypeTxt.setOpaque(true);
            this.fieldLengthTxt.setOpaque(true);
        }
        if (this.includeFormatAndAutoNumUI) {
            inner = new PanelBuilder(new FormLayout("p,2px,p", "p"));
            this.formatSwitcherCombo = UIHelper.createComboBox();
            this.fmtCardLayout = new CardLayout();
            this.formatterPanel = new JPanel(this.fmtCardLayout);
            this.formatLbl = UIHelper.createI18NFormLabel("SL_FMTTYPE", 4);
            pb.add((Component)this.formatLbl, cc.xy(3, y));
            inner.add((Component)this.formatSwitcherCombo, cc.xy(1, 1));
            inner.add((Component)this.formatterPanel, cc.xy(3, 1));
            pb.add((Component)inner.getPanel(), cc.xywh(5, y, 6, 1));
            y += 2;
            ActionListener switchAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String item = (String)FieldItemPanel.this.formatSwitcherCombo.getSelectedItem();
                    if (item != null) {
                        FieldItemPanel.this.fmtCardLayout.show(FieldItemPanel.this.formatterPanel, item);
                        FieldItemPanel.this.webLinkCombo.setEnabled(item.equals(FieldItemPanel.this.SL_WEBLINK));
                        if (FieldItemPanel.this.formatSwitcherCombo.getSelectedIndex() == 0) {
                            if (FieldItemPanel.this.webLinkCombo.getModel().getSize() > 0) {
                                FieldItemPanel.this.webLinkCombo.setSelectedIndex(0);
                            }
                            if (FieldItemPanel.this.formatCombo.getModel().getSize() > 0) {
                                FieldItemPanel.this.formatCombo.setSelectedIndex(0);
                            }
                            if (FieldItemPanel.this.pickListCBX.getModel().getSize() > 0) {
                                FieldItemPanel.this.pickListCBX.setSelectedIndex(0);
                            }
                        }
                    }
                }
            };
            this.formatSwitcherCombo.addActionListener(switchAL);
            this.formatterPanel.add(this.SL_NONE, new JPanel());
            inner = new PanelBuilder(new FormLayout("max(p;150px),2px,min", "p"));
            this.formatCombo = UIHelper.createComboBox(new DefaultComboBoxModel());
            this.formatMoreBtn = UIHelper.createButton("...");
            inner.add((Component)this.formatCombo, cc.xy(1, 1));
            inner.add((Component)this.formatMoreBtn, cc.xy(3, 1));
            this.formatMoreBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIFormatterListEdtDlg dlg = new UIFormatterListEdtDlg((Frame)UIRegistry.getTopWindow(), FieldItemPanel.this.fieldInfo, true, FieldItemPanel.this.schemaPanel.getUiFieldFormatterMgrCache());
                    dlg.setVisible(true);
                    if (!dlg.isCancelled() && dlg.hasChanged()) {
                        FieldItemPanel.this.formHasChanged();
                        FieldItemPanel.this.setSelectedFieldFormatter(dlg.getSelectedFormat());
                    }
                }
            });
            this.formatterPanel.add(this.SL_FORMAT, inner.getPanel());
            ActionListener changed = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FieldItemPanel.this.formHasChanged();
                    boolean hasFormat = FieldItemPanel.this.formatCombo.getSelectedIndex() > 0;
                    FieldItemPanel.this.webLinkCombo.setEnabled(!hasFormat);
                    if (hasFormat) {
                        FieldItemPanel.this.webLinkCombo.setSelectedIndex(FieldItemPanel.this.webLinkCombo.getModel().getSize() > 0 ? 0 : -1);
                        FieldItemPanel.this.pickListCBX.setSelectedIndex(FieldItemPanel.this.pickListCBX.getModel().getSize() > 0 ? 0 : -1);
                    }
                }
            };
            this.formatCombo.addActionListener(changed);
            this.webLinkMoreBtn = UIHelper.createButton("...");
            this.webLinkMoreBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebLinkDef selectedWL = (WebLinkDef)FieldItemPanel.this.webLinkCombo.getSelectedItem();
                    WebLinkConfigDlg dlg = FieldItemPanel.this.webLinkMgrCache.editWebLinks(FieldItemPanel.this.tableInfo, false);
                    if (dlg.getBtnPressed() == 1) {
                        FieldItemPanel.this.fillWebLinkBox();
                        FieldItemPanel.this.formHasChanged();
                        if (selectedWL != null && !selectedWL.getName().equals(FieldItemPanel.this.SL_WEBLINK)) {
                            dlg.setWebLink(selectedWL.getName());
                        }
                        if (dlg.getBtnPressed() == 1) {
                            FieldItemPanel.this.setSelectedWebLink(dlg.getSelectedItem());
                        }
                    }
                }
            });
            inner = new PanelBuilder(new FormLayout("max(p;150px),2px,min", "p"));
            this.webLinkCombo = UIHelper.createComboBox();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.webLinkCombo.getModel();
            model.addElement(this.webLinkDefNone);
            this.webLinkCombo.setSelectedIndex(0);
            inner.add((Component)this.webLinkCombo, cc.xy(1, 1));
            inner.add((Component)this.webLinkMoreBtn, cc.xy(3, 1));
            ActionListener wlchanged = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FieldItemPanel.this.formHasChanged();
                    boolean hasWL = FieldItemPanel.this.webLinkCombo.getSelectedIndex() > 0;
                    FieldItemPanel.this.webLinkCombo.setEnabled(hasWL);
                    if (hasWL) {
                        FieldItemPanel.this.formatCombo.setSelectedIndex(FieldItemPanel.this.formatCombo.getModel().getSize() > 0 ? 0 : -1);
                        FieldItemPanel.this.pickListCBX.setSelectedIndex(FieldItemPanel.this.pickListCBX.getModel().getSize() > 0 ? 0 : -1);
                    }
                }
            };
            this.webLinkCombo.addActionListener(wlchanged);
            this.formatterPanel.add(this.SL_WEBLINK, inner.getPanel());
        }
        this.pickListCBX = UIHelper.createComboBox(new DefaultComboBoxModel());
        this.pickListCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldItemPanel.this.formHasChanged();
                if (FieldItemPanel.this.formatCombo != null && FieldItemPanel.this.pickListCBX.getSelectedIndex() > 0) {
                    FieldItemPanel.this.formatCombo.setSelectedIndex(FieldItemPanel.this.formatCombo.getModel().getSize() > 0 ? 0 : -1);
                    FieldItemPanel.this.webLinkCombo.setSelectedIndex(FieldItemPanel.this.webLinkCombo.getModel().getSize() > 0 ? 0 : -1);
                }
            }
        });
        this.pickListMoreBtn = UIHelper.createButton("...");
        this.pickListMoreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalizableItemIFace currentField = FieldItemPanel.this.prevField;
                FieldItemPanel.this.prevField = FieldItemPanel.this.getSelectedFieldItem();
                PickList selectedItem = (PickList)FieldItemPanel.this.pickListCBX.getSelectedItem();
                PickListEditorDlg dlg = new PickListEditorDlg(FieldItemPanel.this.localizableIO.hasUpdatablePickLists() ? null : FieldItemPanel.this.localizableIO, true, true);
                dlg.setTableInfo(FieldItemPanel.this.tableInfo);
                dlg.setFieldInfo(FieldItemPanel.this.fieldInfo);
                dlg.createUI();
                dlg.setSize(400, 500);
                dlg.setVisible(true);
                if (!dlg.isCancelled() && dlg.hasChanged()) {
                    FieldItemPanel.this.hasChanged = true;
                    Vector<PickList> list = dlg.getNewPickLists();
                    DefaultComboBoxModel plCbxModel = (DefaultComboBoxModel)FieldItemPanel.this.pickListCBX.getModel();
                    int i = 0;
                    while (i < plCbxModel.getSize()) {
                        list.add((PickList)plCbxModel.getElementAt(i));
                        ++i;
                    }
                    Collections.sort(list);
                    plCbxModel.removeAllElements();
                    plCbxModel.addElement(FieldItemPanel.this.pickListNone);
                    int inx = -1;
                    int i2 = 0;
                    for (PickList pl : list) {
                        plCbxModel.addElement(pl);
                        if (inx == -1 && selectedItem != null && (selectedItem.getId() != null && pl.getId() != null && selectedItem.getId().equals(pl.getId()) || selectedItem.getName() != null && pl.getName() != null && selectedItem.getName().equals(pl.getName()))) {
                            inx = i2;
                        }
                        ++i2;
                    }
                    FieldItemPanel.this.pickListCBX.setSelectedIndex(inx + 1);
                }
                FieldItemPanel.this.prevField = currentField;
            }
        });
        if (this.includeFormatAndAutoNumUI) {
            inner = new PanelBuilder(new FormLayout("max(p;150px),2px,min", "p"));
            inner.add((Component)this.pickListCBX, cc.xy(1, 1));
            inner.add((Component)this.pickListMoreBtn, cc.xy(3, 1));
            this.formatterPanel.add(this.SL_PICKLIST, inner.getPanel());
        } else {
            this.pickListLbl = UIHelper.createI18NFormLabel(this.SL_PICKLIST, 4);
            pb.add((Component)this.pickListLbl, cc.xy(3, y));
            pb.add((Component)this.pickListCBX, cc.xy(5, y));
            pb.add((Component)this.pickListMoreBtn, cc.xy(7, y));
            y += 2;
        }
        this.nxtBtn = UIHelper.createI18NButton("SL_NEXT");
        this.nxtEmptyBtn = UIHelper.createI18NButton("SL_NEXT_EMPTY");
        this.fldSpellChkBtn = UIHelper.createI18NButton("SL_SPELL_CHECK");
        this.nxtBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldItemPanel.this.next();
            }
        });
        this.nxtEmptyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldItemPanel.this.nextEmpty();
            }
        });
        this.fldSpellChkBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FieldItemPanel.this.checker != null) {
                    FieldItemPanel.this.checker.spellCheck((JTextComponent)FieldItemPanel.this.fieldDescText);
                    FieldItemPanel.this.checker.spellCheck((JTextComponent)FieldItemPanel.this.fieldNameText);
                }
            }
        });
        this.fieldHideChk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FieldItemPanel.this.formHasChanged();
            }
        });
        this.fieldReqChk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FieldItemPanel.this.formHasChanged();
            }
        });
        DocumentAdaptor dl = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                FieldItemPanel.this.formHasChanged();
            }
        };
        this.fieldNameText.getDocument().addDocumentListener(dl);
        this.fieldDescText.getDocument().addDocumentListener(dl);
        SchemaI18NService.getInstance().checkCurrentLocaleMenu();
        this.enableUIControls(false);
        this.setIgnoreChanges(false);
    }

    protected void formHasChanged() {
        if (!this.isIgnoreChanges()) {
            this.setHasChanged(true);
            this.schemaPanel.setHasChanged(true);
            this.schemaPanel.setTableInfoChanged(true);
        }
    }

    protected void fillFormatSwticherCBX(DBTableChildIFace item) {
        this.formatSwitcherCombo.removeAllItems();
        this.formatSwitcherCombo.addItem(this.SL_NONE);
        if (item instanceof DBRelationshipInfo) {
            if (((DBRelationshipInfo)item).getType() == DBRelationshipInfo.RelationshipType.ManyToOne) {
                this.formatSwitcherCombo.addItem(this.SL_PICKLIST);
            }
        } else {
            DBFieldInfo fi = (DBFieldInfo)item;
            if (fi != null) {
                if (fi.getDataClass() == String.class) {
                    String typeStr;
                    String ts = fi.getType();
                    String string = typeStr = ts.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)fi.getType(), (String)".") : ts;
                    if (StringUtils.isNotEmpty((String)typeStr)) {
                        this.formatSwitcherCombo.addItem(this.SL_FORMAT);
                        this.formatSwitcherCombo.addItem(this.SL_WEBLINK);
                        this.formatSwitcherCombo.addItem(this.SL_PICKLIST);
                    }
                } else if (fi.getDataClass() == Byte.class || fi.getDataClass() == Short.class || fi.getDataClass() == Integer.class) {
                    this.formatSwitcherCombo.addItem(this.SL_PICKLIST);
                }
            }
        }
        this.formatSwitcherCombo.setEnabled(this.formatSwitcherCombo.getModel().getSize() > 1 && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
    }

    protected void setSelectedFieldFormatter(UIFieldFormatterIFace formatter) {
        LocalizableItemIFace fld = this.getSelectedFieldItem();
        String oldFormat = fld.getFormat();
        String newFormat = formatter != null ? formatter.getName() : "";
        fld.setFormat(newFormat);
        fld.setIsUIFormatter(true);
        this.fillWithFieldFormatter(formatter);
        this.setHasChanged(newFormat.equals(oldFormat));
    }

    protected void setSelectedWebLink(WebLinkDef webLinkDef) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.webLinkCombo.getModel();
        model.removeAllElements();
        model.addElement(this.webLinkDefNone);
        int fndInx = 0;
        int index = 0;
        for (WebLinkDef wld : this.webLinkMgrCache.getWebLinkDefs(null)) {
            model.addElement(wld);
            if (webLinkDef == wld) {
                this.setHasChanged(true);
                this.webLinkCombo.setSelectedIndex(index);
                fndInx = index;
                break;
            }
            ++index;
        }
        if (fndInx > 0) {
            this.webLinkCombo.setSelectedItem(webLinkDef);
            this.setHasChanged(true);
        }
        this.webLinkCombo.setEnabled(this.webLinkCombo.getModel().getSize() > 1);
    }

    public void setDisciplineType(DisciplineType disciplineType) {
        this.disciplineType = disciplineType;
    }

    protected void fillWebLinkBox() {
        if (this.webLinkCombo != null) {
            String webLinkName;
            DefaultComboBoxModel wlModel = (DefaultComboBoxModel)this.webLinkCombo.getModel();
            wlModel.removeAllElements();
            wlModel.addElement(this.webLinkDefNone);
            for (WebLinkDef wld : this.webLinkMgrCache.getWebLinkDefs(null)) {
                wlModel.addElement(wld);
            }
            this.webLinkMoreBtn.setEnabled(true);
            int selInx = this.webLinkCombo.getModel().getSize() > 0 ? 0 : -1;
            LocalizableItemIFace fld = this.getSelectedFieldItem();
            if (fld != null && StringUtils.isNotEmpty((String)(webLinkName = fld.getWebLinkName()))) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.webLinkCombo.getModel();
                int i = 0;
                while (i < model.getSize()) {
                    WebLinkDef wld = (WebLinkDef)model.getElementAt(i);
                    if (wld.getName().equals(webLinkName)) {
                        selInx = i;
                        break;
                    }
                    ++i;
                }
            }
            this.webLinkCombo.setSelectedIndex(selInx);
        }
    }

    protected void fillFormatBox(UIFieldFormatterIFace fmtr) {
        if (this.formatCombo != null) {
            ((DefaultComboBoxModel)this.formatCombo.getModel()).removeAllElements();
            this.formatCombo.setEnabled(false);
            this.formatMoreBtn.setEnabled(false);
            this.webLinkCombo.setEnabled(false);
            if (this.fieldInfo != null && this.currContainer instanceof SpLocaleContainer) {
                SpLocaleContainer localeContainer = (SpLocaleContainer)this.currContainer;
                if (this.fieldInfo.getDataClass() == Date.class || this.fieldInfo.getDataClass() == Calendar.class) {
                    this.fillWithDate(localeContainer);
                } else {
                    this.fillWithFieldFormatter(fmtr);
                }
            }
        }
    }

    protected void fillWithDate(SpLocaleContainer localeContainer) {
        this.formatHash.clear();
        DefaultComboBoxModel cbxModel = (DefaultComboBoxModel)this.formatCombo.getModel();
        cbxModel.removeAllElements();
        DBFieldInfo precision = this.tableInfo.getFieldByName(String.valueOf(this.fieldInfo.getName()) + "Precision");
        if (precision != null) {
            cbxModel.addElement(UIRegistry.getResourceString("SL_PARTIAL_DATE"));
        } else {
            cbxModel.addElement(UIRegistry.getResourceString("SL_DATE"));
        }
        this.formatCombo.setSelectedIndex(0);
        this.formatCombo.setEnabled(false);
        this.formatMoreBtn.setEnabled(false);
    }

    protected UIFieldFormatterIFace fillWithFieldFormatter(UIFieldFormatterIFace formatter) {
        Collection collection;
        this.formatHash.clear();
        DefaultComboBoxModel cbxModel = (DefaultComboBoxModel)this.formatCombo.getModel();
        cbxModel.removeAllElements();
        cbxModel.addElement(this.SL_NONE);
        if (this.fieldInfo.getDataClass() == String.class || UIHelper.isClassNumeric(this.fieldInfo.getDataClass(), true)) {
            this.formatCombo.setEnabled(true);
            this.formatMoreBtn.setEnabled(true);
        }
        int selectedInx = 0;
        UIFieldFormatterIFace selectedFmt = null;
        List<UIFieldFormatterIFace> fList = this.schemaPanel.getUiFieldFormatterMgrCache().getFormatterList(this.tableInfo.getClassObj(), this.fieldInfo.getName());
        Collections.sort(fList, new Comparator<UIFieldFormatterIFace>(){

            @Override
            public int compare(UIFieldFormatterIFace o1, UIFieldFormatterIFace o2) {
                return o1.toPattern().compareTo(o2.toPattern());
            }
        });
        if (fList != null && fList.size() > 0) {
            for (UIFieldFormatterIFace fmt : fList) {
                log.debug((Object)("[" + (formatter != null ? formatter.getName() : "null") + "][" + fmt.getTitle() + "]"));
                cbxModel.addElement(fmt);
                if (formatter == null || !formatter.getName().equals(fmt.getName())) continue;
                selectedInx = cbxModel.getSize() - 1;
                selectedFmt = fmt;
            }
        }
        boolean enableFormatter = true;
        if (this.tableInfo.getTableId() == CollectionObject.getClassTableId() && this.fieldInfo.getName().equals("catalogNumber") && (collection = AppContextMgr.getInstance().getClassObject(Collection.class)) != null && collection.getNumberingSchemes().size() > 0) {
            enableFormatter = AppPreferences.getLocalPrefs().getBoolean("EDIT_CATNUM", false);
        }
        boolean hasFormat = selectedInx > 0;
        this.webLinkCombo.setEnabled(hasFormat);
        this.formatCombo.setSelectedIndex(selectedInx);
        this.formatSwitcherCombo.setEnabled(enableFormatter && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.formatCombo.setEnabled(enableFormatter && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.formatMoreBtn.setEnabled(enableFormatter && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        return selectedFmt;
    }

    private void setAsDefFormatter() {
        Object item = this.formatCombo.getSelectedItem();
        UIFieldFormatterIFace selected = null;
        if (item instanceof UIFieldFormatterIFace) {
            selected = (UIFieldFormatterIFace)item;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.formatCombo.getModel();
        int i = 1;
        while (i < model.getSize()) {
            UIFieldFormatterIFace uif;
            uif.setDefault((uif = (UIFieldFormatterIFace)model.getElementAt(i)) == selected);
            ++i;
        }
        if (this.fieldInfo != null) {
            this.fieldInfo.setFormatter(selected);
        }
    }

    public void setContainer(LocalizableContainerIFace container, LocalizableJListItem jListContainerItem) {
        this.currContainer = container;
        this.currJListItem = jListContainerItem;
        String cName = null;
        if (this.currContainer != null && (cName = this.currContainer.getName()).equals("taxononly")) {
            cName = "taxon";
        }
        this.tableInfo = this.currContainer == null ? null : DBTableIdMgr.getInstance().getInfoByTableName(cName);
        this.fillFieldList();
    }

    public JList getFieldsList() {
        return this.fieldsList;
    }

    public void setIncludeHiddenUI(boolean includeHiddenUI) {
        this.includeHiddenUI = includeHiddenUI;
    }

    public LocalizableIOIFace getLocalizableIO() {
        return this.localizableIO;
    }

    public void setLocalizableIO(LocalizableIOIFace localizableIO) {
        this.localizableIO = localizableIO;
        this.pickListMoreBtn.setEnabled(localizableIO.hasUpdatablePickLists());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fieldsList.setEnabled(enabled);
    }

    public int getSelectedIndex() {
        return this.fieldsList.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.fieldsList.setSelectedIndex(index);
    }

    protected void enableUIControls(boolean enable) {
        this.fieldDescText.setEnabled(enable);
        this.fieldNameText.setEnabled(enable);
        this.fieldNameLbl.setEnabled(enable);
        this.fieldDescLbl.setEnabled(enable);
        this.fieldHideChk.setEnabled(enable);
        this.fieldTypeLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.fieldTypeTxt.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.fieldReqChk.setEnabled(!this.mustBeRequired && enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.fieldLengthLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.fieldLengthTxt.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        this.formatSwitcherCombo.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        if (this.pickListLbl != null) {
            this.pickListLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        }
        this.pickListCBX.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        if (this.formatLbl != null) {
            this.formatLbl.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
            this.formatCombo.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
            this.formatMoreBtn.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
            this.webLinkCombo.setEnabled(enable && this.schemaType != SpLocaleContainer.WORKBENCH_SCHEMA);
        }
        if (!enable) {
            this.fldSpellChkBtn.setEnabled(false);
            this.nxtBtn.setEnabled(false);
            this.nxtEmptyBtn.setEnabled(false);
        } else {
            this.updateBtns();
            this.checkForMoreEmpties();
            this.enableSpellCheck();
        }
    }

    public void setStatusBar(JStatusBar statusBar) {
        this.statusBar = statusBar;
    }

    protected void updateBtns() {
        int inx = this.fieldsList.getSelectedIndex();
        boolean enabled = inx != -1 && inx < this.fieldsModel.size() - 1;
        this.nxtBtn.setEnabled(enabled);
        this.checkForMoreEmpties();
    }

    protected void checkForMoreEmpties() {
        int inx = this.getNextEmptyIndex(this.fieldsList.getSelectedIndex());
        this.nxtEmptyBtn.setEnabled(inx != -1);
    }

    protected int getNextEmptyIndex(int inx) {
        if (inx > -1 && inx < this.fieldsModel.size()) {
            int i = inx;
            while (i < this.fieldsModel.size()) {
                LocalizableStrIFace desc;
                LocalizableItemIFace f = this.getFieldItem(i);
                if (f != null && ((desc = FieldItemPanel.getDescForCurrLocale(f)) == null || StringUtils.isEmpty((String)desc.getText()))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean getAllDataFromUI() {
        return this.getItemDataFromUI();
    }

    protected void getFormatterFromUI(LocalizableItemIFace field) {
        this.setAsDefFormatter();
        Object item = this.formatCombo.getSelectedItem();
        if (item != null) {
            boolean isNone = item instanceof String;
            if (!isNone) {
                UIFieldFormatterIFace frmt = (UIFieldFormatterIFace)item;
                field.setFormat(frmt.getName());
                field.setIsUIFormatter(true);
            } else {
                field.setIsUIFormatter(false);
                field.setFormat(null);
            }
        } else {
            log.error((Object)"We should never get here!");
        }
    }

    protected boolean getItemDataFromUI() {
        boolean changed = this.hasChanged;
        if (this.prevField != null && changed) {
            String prevPickListName = this.prevField.getPickListName();
            this.prevField.setPickListName(null);
            this.prevField.setWebLinkName(null);
            this.prevField.setFormat(null);
            this.prevField.setIsUIFormatter(false);
            this.prevField.setIsRequired(this.fieldReqChk.isSelected());
            this.prevField.setIsHidden(this.fieldHideChk.isSelected());
            boolean nameChanged = FieldItemPanel.setNameDescStrForCurrLocale(this.prevField, this.fieldNameText.getText());
            boolean descChanged = FieldItemPanel.setDescStrForCurrLocale(this.prevField, this.fieldDescText.getText());
            if (nameChanged || descChanged) {
                this.formHasChanged();
            }
            if (this.pickListCBX.getSelectedIndex() > 0) {
                PickList pl = (PickList)this.pickListCBX.getSelectedItem();
                this.prevField.setPickListName(pl != null ? pl.getName() : null);
                if (this.isDBSchema && pl != null && pl.getName() != null && (prevPickListName == null || pl.getName().equals(prevPickListName))) {
                    UIRegistry.showLocalizedMsg("SL_WARN_PL_CREATION");
                }
            }
            if (this.formatCombo != null) {
                this.getFormatterFromUI(this.prevField);
            }
            if (this.webLinkCombo != null && this.webLinkCombo.getSelectedIndex() > 0) {
                WebLinkDef wld = (WebLinkDef)this.webLinkCombo.getSelectedItem();
                this.prevField.setWebLinkName(wld.getName());
            }
            this.prevField = null;
        }
        this.hasChanged = false;
        return changed;
    }

    protected void next() {
        int inx;
        if (this.getItemDataFromUI()) {
            this.formHasChanged();
        }
        if ((inx = this.fieldsList.getSelectedIndex()) < this.fieldsModel.size() - 1) {
            ++inx;
        }
        this.fieldsList.setSelectedIndex(inx);
        this.updateBtns();
    }

    protected void nextEmpty() {
        int inx;
        if (this.getItemDataFromUI()) {
            this.formHasChanged();
        }
        if ((inx = this.getNextEmptyIndex(this.fieldsList.getSelectedIndex() + 1)) > -1) {
            this.fieldsList.setSelectedIndex(inx);
            this.fieldsList.ensureIndexIsVisible(inx);
        }
        this.updateBtns();
    }

    protected void fillFieldList() {
        this.fieldsModel.clear();
        if (this.currJListItem != null) {
            this.localizableIO.getContainer(this.currJListItem, this);
        }
        this.updateBtns();
    }

    protected LocalizableItemIFace getFieldItem(int index) {
        if (this.currContainer != null) {
            LocalizableJListItem jlistFieldItem = (LocalizableJListItem)this.fieldsModel.get(index);
            if (jlistFieldItem != null) {
                return this.localizableIO.getItem(this.currContainer, jlistFieldItem);
            }
            log.error((Object)"fieldsList item was null");
        } else {
            log.error((Object)"currContainer was null");
        }
        return null;
    }

    protected LocalizableItemIFace getSelectedFieldItem() {
        if (this.fieldsList.getSelectedIndex() > -1) {
            if (this.currContainer != null) {
                LocalizableJListItem jlistFieldItem = (LocalizableJListItem)this.fieldsList.getSelectedValue();
                if (jlistFieldItem != null) {
                    return this.localizableIO.getItem(this.currContainer, jlistFieldItem);
                }
                log.error((Object)"fieldsList item was null");
            } else {
                log.error((Object)"currContainer was null");
            }
        }
        return null;
    }

    protected void fieldSelected() {
        LocalizableItemIFace fld;
        boolean ignoreChanges = this.isIgnoreChanges();
        this.setIgnoreChanges(true);
        if (this.statusBar != null) {
            this.statusBar.setText("");
        }
        if ((fld = this.getSelectedFieldItem()) != null && this.tableInfo != null) {
            String dspName;
            this.fieldInfo = fld != null ? this.tableInfo.getFieldByName(fld.getName()) : null;
            this.relInfo = this.fieldInfo == null ? this.tableInfo.getRelationshipByName(fld.getName()) : null;
            this.fillFormatSwticherCBX(this.tableInfo.getItemByName(fld.getName()));
            if (this.pcl != null) {
                this.pcl.propertyChange(new PropertyChangeEvent(this.fieldsList, "index", null, fld));
            }
            this.fieldDescText.setText(FieldItemPanel.getDescStrForCurrLocale(fld));
            this.fieldNameText.setText(FieldItemPanel.getNameDescStrForCurrLocale(fld));
            this.fieldHideChk.setSelected(fld.getIsHidden());
            String string = dspName = this.disciplineType != null ? this.disciplineType.getName() : null;
            if (AppContextMgr.getInstance().hasContext() && AppContextMgr.getInstance().getClassObject(Discipline.class) != null) {
                dspName = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
            }
            this.loadPickLists(dspName, fld);
            if (this.isDBSchema) {
                this.mustBeRequired = true;
                this.fieldReqChk.setSelected(false);
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoByTableName(this.currContainer.getName());
                if (ti != null) {
                    DBFieldInfo fi = ti.getFieldByName(fld.getName());
                    if (fi != null) {
                        String typeStr;
                        String ts = fi.getType();
                        String string2 = typeStr = ts.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)fi.getType(), (String)".") : ts;
                        if (typeStr.equals("Calendar")) {
                            typeStr = "Date";
                        }
                        this.fieldTypeTxt.setText(typeStr);
                        String lenStr = fi.getLength() != -1 ? Integer.toString(fi.getLength()) : " ";
                        this.fieldLengthTxt.setText(lenStr);
                        this.fieldTypeLbl.setEnabled(true);
                        this.fieldTypeTxt.setEnabled(true);
                        this.fieldLengthLbl.setEnabled(StringUtils.isNotEmpty((String)lenStr));
                        this.fieldLengthTxt.setEnabled(StringUtils.isNotEmpty((String)lenStr));
                        this.mustBeRequired = fi.isRequiredInSchema();
                        this.fieldReqChk.setSelected(this.mustBeRequired || fld.getIsRequired() != false);
                    } else {
                        DBRelationshipInfo ri = ti.getRelationshipByName(fld.getName());
                        if (ri != null) {
                            String title = ri.getType().toString();
                            if (ri.getType() == DBRelationshipInfo.RelationshipType.OneToMany) {
                                title = DBRelationshipInfo.RelationshipType.OneToMany.toString();
                            } else if (ri.getType() == DBRelationshipInfo.RelationshipType.ManyToOne) {
                                title = DBRelationshipInfo.RelationshipType.ManyToOne.toString();
                            }
                            this.fieldTypeTxt.setText(String.valueOf(title) + " " + UIRegistry.getResourceString("SL_TO") + " " + FieldItemPanel.getNameDescStrForCurrLocale(this.currContainer));
                            this.fieldTypeLbl.setEnabled(true);
                            this.fieldLengthTxt.setText(" ");
                            this.fieldLengthLbl.setEnabled(false);
                            this.fieldLengthTxt.setEnabled(false);
                            this.fieldReqChk.setSelected(false);
                        }
                    }
                }
            }
            if (this.doAutoSpellCheck) {
                this.checker.spellCheck((JTextComponent)this.fieldDescText);
                this.checker.spellCheck((JTextComponent)this.fieldNameText);
            }
            this.enableUIControls(true);
        } else {
            this.enableUIControls(false);
            this.fieldDescText.setText("");
            this.fieldNameText.setText("");
            this.fieldHideChk.setSelected(false);
            this.fieldTypeTxt.setText("");
            this.fieldLengthTxt.setText("");
        }
        this.fillFormatBox(this.fieldInfo != null ? this.fieldInfo.getFormatter() : null);
        this.fillWebLinkBox();
        String label = this.SL_NONE;
        if (this.pickListCBX.getSelectedIndex() > 0) {
            label = this.SL_PICKLIST;
        }
        if (this.formatCombo.getSelectedIndex() > 0) {
            label = this.SL_FORMAT;
        }
        if (this.webLinkCombo.getSelectedIndex() > 0) {
            label = this.SL_WEBLINK;
        }
        this.formatSwitcherCombo.setSelectedItem(label);
        boolean ok = fld != null;
        this.fieldDescText.setEnabled(ok);
        this.fieldNameText.setEnabled(ok);
        this.fieldNameLbl.setEnabled(ok);
        this.fieldDescLbl.setEnabled(ok);
        this.setIgnoreChanges(ignoreChanges);
        this.prevField = fld;
        this.updateBtns();
        this.hasChanged = false;
    }

    protected void loadPickLists(String dspName, LocalizableItemIFace fld) {
        if (this.disciplineName == null || !dspName.equals(this.disciplineName)) {
            this.disciplineName = dspName;
            this.pickLists.clear();
            List<PickList> plList = this.localizableIO.getPickLists(null);
            if (plList != null) {
                this.pickLists.addAll(plList);
            }
            if (this.disciplineName != null && (plList = this.localizableIO.getPickLists(this.disciplineName)) != null) {
                this.pickLists.addAll(plList);
            }
            Collections.sort(this.pickLists);
        }
        if (this.pickLists != null) {
            DBRelationshipInfo.RelationshipType relType = this.relInfo != null ? this.relInfo.getType() : null;
            Class<?> typeCls = this.fieldInfo != null ? this.fieldInfo.getDataClass() : null;
            boolean isTypeOK = typeCls != null && (typeCls == String.class || UIHelper.isClassNumeric(typeCls, true));
            int selectedIndex = 0;
            DefaultComboBoxModel plCbxModel = (DefaultComboBoxModel)this.pickListCBX.getModel();
            if (isTypeOK) {
                plCbxModel.removeAllElements();
                plCbxModel.addElement(this.pickListNone);
                int inx = 1;
                for (PickList pl : this.pickLists) {
                    if (pl.getType() != 0 && pl.getType() != 2) continue;
                    plCbxModel.addElement(pl);
                    String plName = fld.getPickListName();
                    if (selectedIndex == 0 && StringUtils.isNotEmpty((String)plName) && plName.equals(pl.getName())) {
                        selectedIndex = inx;
                    }
                    ++inx;
                }
            } else if (relType != null && relType == DBRelationshipInfo.RelationshipType.ManyToOne) {
                plCbxModel.removeAllElements();
                plCbxModel.addElement(this.pickListNone);
                int inx = 1;
                for (PickList pl : this.pickLists) {
                    if (pl.getType() != 1) continue;
                    DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoByTableName(pl.getTableName());
                    if (this.relInfo.getDataClass() != tblInfo.getClassObj()) continue;
                    plCbxModel.addElement(pl);
                    String plName = fld.getPickListName();
                    if (StringUtils.isNotEmpty((String)plName) && plName.equals(pl.getName())) {
                        selectedIndex = inx;
                    }
                    ++inx;
                }
            }
            this.pickListCBX.setEnabled(isTypeOK || relType != null);
            this.pickListCBX.setSelectedIndex(this.pickListCBX.getModel().getSize() > 0 ? selectedIndex : -1);
        } else {
            this.pickListCBX.setEnabled(false);
        }
    }

    @Override
    protected void enableSpellCheck() {
        boolean ok = SchemaI18NService.getCurrentLocale().getLanguage().equals("en");
        LocalizableItemIFace fld = this.getSelectedFieldItem();
        this.fldSpellChkBtn.setEnabled(fld != null && ok && this.checker != null && this.spellCheckLoaded);
    }

    @Override
    public void localeChanged(Locale newLocale) {
    }

    @Override
    public void containterRetrieved(LocalizableContainerIFace container) {
        if (container != null) {
            for (LocalizableJListItem fItem : this.localizableIO.getDisplayItems(this.currJListItem)) {
                this.fieldsModel.addElement(fItem);
            }
            this.fieldsList.setSelectedIndex(0);
        }
    }

    public void realizeComplete(LocalizableItemIFace liif) {
    }

    class LengthWatcher
    extends KeyAdapter {
        protected int maxLength;

        public LengthWatcher(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            super.keyReleased(e);
            final JTextComponent tc = (JTextComponent)e.getSource();
            String text = tc.getText();
            if (text.length() > this.maxLength) {
                if (FieldItemPanel.this.statusBar != null) {
                    FieldItemPanel.this.statusBar.setErrorMessage(String.valueOf(UIRegistry.getResourceString("SL_MAX_LENGTH_ERROR")) + ": " + this.maxLength);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tc.setText(tc.getText().substring(0, LengthWatcher.this.maxLength));
                    }
                });
            }
        }
    }
}

