/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.init.BldrPickList;
import edu.ku.brc.specify.config.init.BldrPickListItem;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import edu.ku.brc.specify.datamodel.SpLocaleItemStr;
import edu.ku.brc.specify.tools.schemalocale.DisciplineBasedContainer;
import edu.ku.brc.specify.tools.schemalocale.FieldItemPanel;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableIOIFaceListener;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableJListItem;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerPanel;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DisciplineBasedPanel
extends JPanel
implements LocalizableIOIFace,
PropertyChangeListener {
    protected JComboBox disciplineCBX = UIHelper.createComboBox();
    protected JButton addBtn;
    protected JButton delBtn;
    protected final SchemaLocalizerPanel schemaPanel;
    protected FieldItemPanel fieldPanel;
    protected Vector<SpLocaleContainerItem> items = new Vector();
    protected Vector<LocalizableJListItem> listItems = new Vector();
    protected DisciplineBasedContainer currentBaselineContainer = null;
    protected LocalizableJListItem jlistContainer = null;
    protected SpLocaleContainerItem currentBaselineItem = null;
    protected SpLocaleContainerItem currentItem = null;
    protected DisciplineType disciplineType = null;
    protected WebLinkMgr webLinkMgrCache = null;

    public DisciplineBasedPanel(SchemaLocalizerPanel schemaPanel, WebLinkMgr webLinkMgrCache) {
        this.schemaPanel = schemaPanel;
        this.webLinkMgrCache = webLinkMgrCache;
        for (DisciplineType disp : DisciplineType.getDisciplineList()) {
            if (disp.getType() != 0) continue;
            this.disciplineCBX.addItem(disp);
        }
        this.disciplineCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisciplineBasedPanel.this.getDataFromUI();
                DisciplineBasedPanel.this.disciplineType = (DisciplineType)DisciplineBasedPanel.this.disciplineCBX.getSelectedItem();
                DisciplineBasedPanel.this.fillWithDisciplineItems();
                if (DisciplineBasedPanel.this.fieldPanel != null) {
                    DisciplineBasedPanel.this.fieldPanel.setDisciplineType(DisciplineBasedPanel.this.disciplineType);
                    DisciplineBasedPanel.this.fieldPanel.setContainer(DisciplineBasedPanel.this.currentBaselineContainer, DisciplineBasedPanel.this.jlistContainer);
                }
                DisciplineBasedPanel.this.updateBtnUI();
            }
        });
        this.disciplineCBX.setSelectedIndex(0);
        this.createUI();
    }

    public void getDataFromUI() {
        if (this.fieldPanel != null) {
            this.fieldPanel.getAllDataFromUI();
        }
        if (this.currentBaselineContainer != null) {
            Set<SpLocaleContainerItem> cItems = this.currentBaselineContainer.getDisciplineItems(this.disciplineType.getName());
            cItems.clear();
            cItems.addAll(this.items);
        }
    }

    protected void createUI() {
        CellConstraints cc = new CellConstraints();
        this.addBtn = UIHelper.createIconBtn("DownArrow", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisciplineBasedPanel.this.addItem();
            }
        });
        this.delBtn = UIHelper.createIconBtn("UpArrow", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisciplineBasedPanel.this.delItem();
            }
        });
        this.fieldPanel = new FieldItemPanel(this.schemaPanel, this.webLinkMgrCache, true, true, true, null);
        this.fieldPanel.setLocalizableIO(this);
        this.fieldPanel.setStatusBar(this.schemaPanel.getStatusBar());
        PanelBuilder arrowPanel = new PanelBuilder(new FormLayout("f:p:g, p, 2px, p, f:p:g", "p"));
        arrowPanel.add((Component)this.addBtn, cc.xy(2, 1));
        arrowPanel.add((Component)this.delBtn, cc.xy(4, 1));
        PanelBuilder pb = new PanelBuilder(new FormLayout("p, 2px, f:p:g", "p,2px,p,2px,p,2px,p"), (JPanel)this);
        pb.add((Component)arrowPanel.getPanel(), cc.xy(1, 1));
        pb.addSeparator("Disciplines", cc.xywh(1, 3, 3, 1));
        pb.add((Component)this.disciplineCBX, cc.xy(1, 5));
        pb.add((Component)this.fieldPanel, cc.xywh(1, 7, 3, 1));
    }

    public void set(DisciplineBasedContainer container, LocalizableJListItem jListContainerItem) {
        if (this.currentBaselineContainer != null) {
            this.getDataFromUI();
        }
        this.currentBaselineContainer = container;
        this.currentBaselineItem = null;
        this.jlistContainer = jListContainerItem;
        this.fillWithDisciplineItems();
        this.fieldPanel.setDisciplineType(this.disciplineType);
        this.fieldPanel.setContainer(container, jListContainerItem);
        this.updateBtnUI();
    }

    public void setItem(SpLocaleContainerItem currBaselineItem) {
        this.currentBaselineItem = currBaselineItem;
        this.updateBtnUI();
    }

    protected void fillWithDisciplineItems() {
        this.items.clear();
        this.listItems.clear();
        if (this.currentBaselineContainer != null && this.currentBaselineContainer.hasDiscipline(this.disciplineType.getName())) {
            this.items.addAll(this.currentBaselineContainer.getDisciplineItems(this.disciplineType.getName()));
            Collections.sort(this.items);
            for (SpLocaleContainerItem item : this.items) {
                this.listItems.add(new LocalizableJListItem(item.getName(), item.getId(), null));
            }
        }
    }

    protected void updateBtnUI() {
        if (this.addBtn != null) {
            boolean inListAlready = false;
            if (this.currentBaselineItem != null) {
                for (SpLocaleContainerItem item : this.items) {
                    if (!item.getName().equals(this.currentBaselineItem.getName())) continue;
                    inListAlready = true;
                    break;
                }
            }
            this.addBtn.setEnabled(this.currentBaselineItem != null && !inListAlready);
            this.delBtn.setEnabled(this.currentItem != null);
        }
    }

    protected void copyItems(Set<SpLocaleItemStr> fromItems, Set<SpLocaleItemStr> toItems) {
        for (SpLocaleItemStr str : fromItems) {
            SpLocaleItemStr newStr = new SpLocaleItemStr();
            newStr.initialize();
            newStr.setCountry(str.getCountry());
            newStr.setLanguage(str.getLanguage());
            newStr.setVariant(str.getVariant());
            newStr.setText(str.getText());
            toItems.add(newStr);
        }
    }

    protected void addItem() {
        SpLocaleContainerItem item = new SpLocaleContainerItem();
        item.initialize();
        item.setName(this.currentBaselineItem.getName());
        item.setType(this.currentBaselineItem.getType());
        this.copyItems(this.currentBaselineItem.getNames(), item.getNames());
        this.copyItems(this.currentBaselineItem.getDescs(), item.getDescs());
        this.items.add(item);
        Collections.sort(this.items);
        this.listItems.insertElementAt(new LocalizableJListItem(item.getName(), item.getId(), null), this.items.indexOf(item));
        this.fieldPanel.setDisciplineType(this.disciplineType);
        this.fieldPanel.setContainer(this.currentBaselineContainer, this.jlistContainer);
    }

    protected void delItem() {
    }

    @Override
    public void copyLocale(LocalizableIOIFaceListener lcl, Locale src, Locale dst, PropertyChangeListener pcl) {
    }

    @Override
    public boolean createResourceFiles() {
        return false;
    }

    @Override
    public boolean didModelChangeDuringLoad() {
        return false;
    }

    @Override
    public boolean exportToDirectory(File expportFile) {
        return false;
    }

    @Override
    public LocalizableContainerIFace getContainer(LocalizableJListItem item, LocalizableIOIFaceListener l) {
        if (l != null) {
            l.containterRetrieved(this.currentBaselineContainer);
        }
        return this.currentBaselineContainer;
    }

    @Override
    public Vector<LocalizableJListItem> getContainerDisplayItems() {
        return null;
    }

    @Override
    public Vector<LocalizableJListItem> getDisplayItems(LocalizableJListItem container) {
        return this.listItems;
    }

    @Override
    public LocalizableItemIFace getItem(LocalizableContainerIFace container, LocalizableJListItem item) {
        return this.items.get(this.listItems.indexOf(item));
    }

    @Override
    public Vector<Locale> getLocalesInUse() {
        return null;
    }

    @Override
    public boolean isLocaleInUse(Locale locale) {
        return false;
    }

    @Override
    public boolean load(boolean useCurrentLocaleOnly) {
        return false;
    }

    @Override
    public void containerChanged(LocalizableContainerIFace container) {
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public boolean hasUpdatablePickLists() {
        return false;
    }

    @Override
    public boolean shouldIncludeAppTables() {
        return true;
    }

    private void getPickLists(List<PickList> pickLists, String disciplineName) {
        List<BldrPickList> bdlrPickLists = DataBuilder.getBldrPickLists(disciplineName != null ? disciplineName : "common");
        for (BldrPickList pl : bdlrPickLists) {
            PickList pickList = DataBuilder.createPickList(pl.getName(), pl.getType(), pl.getTableName(), pl.getFieldName(), pl.getFormatter(), pl.getReadOnly(), pl.getSizeLimit(), pl.getIsSystem(), pl.getSortType(), null);
            for (BldrPickListItem item : pl.getItems()) {
                pickList.addItem(item.getTitle(), item.getValue());
            }
            pickLists.add(pickList);
        }
    }

    @Override
    public List<PickList> getPickLists(String disciplineName) {
        Vector<PickList> pickLists = new Vector<PickList>();
        this.getPickLists(pickLists, null);
        this.getPickLists(pickLists, disciplineName);
        return pickLists;
    }

    @Override
    public boolean exportSingleLanguageToDirectory(File expportFile, Locale locale) {
        throw new RuntimeException("Not Impl");
    }

    @Override
    public boolean hasChanged() {
        throw new RuntimeException("Not Impl");
    }
}

