/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.schemalocale;

import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpLocaleContainerItem;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DisciplineBasedContainer
extends SpLocaleContainer
implements Cloneable {
    private static final Logger log = Logger.getLogger(DisciplineBasedContainer.class);
    protected Hashtable<String, Set<SpLocaleContainerItem>> disciplineHashItems = null;

    public boolean hasDisciplineItems() {
        return this.disciplineHashItems != null;
    }

    public boolean hasDiscipline(String dispName) {
        return this.disciplineHashItems != null && this.disciplineHashItems.get(dispName) != null;
    }

    public Set<SpLocaleContainerItem> getDisciplineItems(String disciplineArg) {
        if (this.disciplineHashItems == null) {
            this.disciplineHashItems = new Hashtable();
        }
        if (this.disciplineHashItems.get(disciplineArg) == null) {
            HashSet<SpLocaleContainerItem> dispHash = new HashSet<SpLocaleContainerItem>();
            this.disciplineHashItems.put(disciplineArg, dispHash);
            return dispHash;
        }
        return this.disciplineHashItems.get(disciplineArg);
    }

    public void add(String disciplineArg, SpLocaleContainerItem item) {
        Set<SpLocaleContainerItem> dispSet;
        if (this.disciplineHashItems == null) {
            this.disciplineHashItems = new Hashtable();
            dispSet = new HashSet<SpLocaleContainerItem>();
            this.disciplineHashItems.put(disciplineArg, dispSet);
        } else {
            dispSet = this.disciplineHashItems.get(disciplineArg);
            if (dispSet == null) {
                dispSet = new HashSet<SpLocaleContainerItem>();
                this.disciplineHashItems.put(disciplineArg, dispSet);
            }
        }
        dispSet.add(item);
    }

    public void remove(String disciplineArg) {
        if (this.disciplineHashItems != null) {
            Set<SpLocaleContainerItem> dispSet = this.disciplineHashItems.get(disciplineArg);
            if (dispSet != null) {
                dispSet.remove(disciplineArg);
            } else {
                log.error((Object)("dispSet can't be null for disciplineType[" + disciplineArg + "]"));
            }
        } else {
            log.error((Object)"disciplineHashItems can't be null!");
        }
    }

    public void merge(String disciplineArg) {
        Set<SpLocaleContainerItem> dispSet = this.disciplineHashItems.get(disciplineArg);
        for (SpLocaleContainerItem item : new Vector(this.items)) {
            for (SpLocaleContainerItem dispItem : dispSet) {
                if (!item.getName().equalsIgnoreCase(dispItem.getName())) continue;
                this.items.remove(item);
                this.items.add(dispItem);
            }
        }
    }

    @Override
    public Object clone() {
        DisciplineBasedContainer dbc = new DisciplineBasedContainer();
        dbc.initialize();
        dbc.schemaType = this.schemaType;
        dbc.discipline = this.discipline;
        dbc.name = this.name;
        dbc.type = this.type;
        return dbc;
    }
}

