/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.ireportspecify;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.subpane.JRConnectionFieldDef;
import edu.ku.brc.specify.tasks.subpane.SpJRIReportConnection;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReportRepeatPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(ReportRepeatPanel.class);
    protected final Vector<JRConnectionFieldDef> validFields;
    protected JTextField constantTxt;
    protected JComboBox fldCombo;
    protected JComboBox typeCombo;
    protected JButton cancelBtn;
    private static final int CONST = 1;
    private static final int DEFAULT = 0;
    private static final int FIELD = 2;

    public ReportRepeatPanel(SpJRIReportConnection connection, JButton cancelBtn) {
        this.validFields = this.bldValidFields(connection);
        this.cancelBtn = cancelBtn;
    }

    protected Vector<JRConnectionFieldDef> bldValidFields(SpJRIReportConnection connection) {
        Vector<JRConnectionFieldDef> result = new Vector<JRConnectionFieldDef>();
        int f = 0;
        while (f < connection.getFields()) {
            JRConnectionFieldDef fld = connection.getField(f);
            if (Number.class.isAssignableFrom(fld.getFldClass())) {
                result.add(fld);
            }
            ++f;
        }
        return result;
    }

    protected String[] getTypeChoices() {
        if (this.validFields.size() > 0) {
            String[] result = new String[]{UIRegistry.getResourceString("REP_DEFAULT_REPEAT"), UIRegistry.getResourceString("REP_CONST_REPEAT"), UIRegistry.getResourceString("REP_FLD_REPEAT")};
            return result;
        }
        String[] result = new String[]{UIRegistry.getResourceString("REP_DEFAULT_REPEAT"), UIRegistry.getResourceString("REP_CONST_REPEAT")};
        return result;
    }

    protected void createUI(Object reps) {
        String repFldName = null;
        Integer constRep = null;
        if (reps != null) {
            if (reps instanceof Integer) {
                constRep = (Integer)reps;
            } else if (reps instanceof String) {
                repFldName = (String)reps;
            } else {
                log.error((Object)("invalid repeats parameter: " + reps));
            }
        }
        PanelBuilder builder = new PanelBuilder(new FormLayout("left:p, fill:p:grow", "c:p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        Object[] chcs = this.getTypeChoices();
        this.typeCombo = UIHelper.createComboBox(chcs);
        this.typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportRepeatPanel.this.constantTxt.setVisible(ReportRepeatPanel.this.typeCombo.getSelectedIndex() == 1);
                ReportRepeatPanel.this.fldCombo.setVisible(ReportRepeatPanel.this.typeCombo.getSelectedIndex() == 2);
            }
        });
        builder.add((Component)this.typeCombo, cc.xy(1, 1));
        this.constantTxt = UIHelper.createTextField("2");
        this.constantTxt.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && e.getOppositeComponent() != ReportRepeatPanel.this.typeCombo && e.getOppositeComponent() != ReportRepeatPanel.this.cancelBtn) {
                    boolean OK = true;
                    try {
                        Integer entry = Integer.valueOf(ReportRepeatPanel.this.constantTxt.getText().trim());
                        OK = entry > 1;
                    }
                    catch (NumberFormatException ex) {
                        UIRegistry.showLocalizedMsg("REP_INVALID_COUNT_TITLE", "REP_INVALID_REPEAT_COUNT_MSG", new Object[0]);
                        OK = false;
                    }
                    if (!OK) {
                        ReportRepeatPanel.this.constantTxt.grabFocus();
                    }
                }
            }
        });
        builder.add((Component)this.constantTxt, cc.xy(2, 1));
        this.fldCombo = UIHelper.createComboBox(this.validFields);
        builder.add((Component)this.fldCombo, cc.xy(2, 1));
        this.typeCombo.setSelectedIndex(0);
        if (repFldName != null) {
            int f = 0;
            while (f < this.validFields.size()) {
                if (this.validFields.get(f).getFldName().equals(repFldName)) {
                    this.fldCombo.setSelectedIndex(f);
                    this.typeCombo.setSelectedIndex(2);
                    break;
                }
                ++f;
            }
        } else if (constRep != null) {
            this.constantTxt.setText(String.valueOf(constRep));
            this.typeCombo.setSelectedIndex(1);
        }
    }

    public Object getRepeats() {
        if (this.typeCombo.getSelectedIndex() == 0 || this.typeCombo.getSelectedIndex() == -1) {
            return null;
        }
        if (this.typeCombo.getSelectedIndex() == 1) {
            return Integer.valueOf(this.constantTxt.getText().trim());
        }
        if (this.typeCombo.getSelectedIndex() == 2) {
            return ((JRConnectionFieldDef)this.fldCombo.getSelectedItem()).getFldName();
        }
        log.error((Object)("Unrecognized repeat type: " + this.typeCombo.getSelectedItem()));
        return null;
    }

    public boolean validInputs() {
        if (this.typeCombo.getSelectedIndex() == 1) {
            try {
                Integer.valueOf(this.constantTxt.getText().trim());
                return true;
            }
            catch (NumberFormatException nfe) {
                UIRegistry.showLocalizedMsg("REP_INVALID_COUNT_TITLE", "REP_INVALID_REPEAT_COUNT_MSG", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        ReportRepeatPanel rpp = new ReportRepeatPanel(null, null);
        rpp.createUI(6);
        CustomDialog cd = new CustomDialog(null, "Blah", true, rpp);
        UIHelper.centerAndShow(cd);
        System.exit(0);
    }
}

