/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.ireportspecify;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.tasks.DataEntryTask;
import edu.ku.brc.specify.tasks.DataEntryView;
import edu.ku.brc.specify.tasks.InteractionEntry;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tools.ireportspecify.ReportRepeatPanel;
import edu.ku.brc.specify.tools.ireportspecify.ReportSpecify;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RepResourcePropsPanel
extends JPanel {
    protected final String reportName;
    protected final String reportType;
    protected final boolean showTableIds;
    protected JTextField nameTxt;
    protected JTextField titleTxt;
    protected JTextField levelTxt;
    protected JTextField subReportsTxt;
    protected JComboBox typeCombo;
    protected JComboBox resDirCombo;
    protected JComboBox tblCombo;
    protected ReportRepeatPanel repeatPanel;
    protected JButton canceller = null;

    public RepResourcePropsPanel(String reportName, String reportType, boolean showTableIds, ReportSpecify rep) {
        this.reportName = reportName;
        this.reportType = reportType;
        this.showTableIds = showTableIds;
        this.createUI(rep);
    }

    protected void createUI(ReportSpecify rep) {
        String rowDefStr = UIHelper.createDuplicateJGoodiesDef("p", "2px", this.showTableIds ? 7 : 6);
        PanelBuilder builder = new PanelBuilder(new FormLayout("p, 2px, fill:p:grow", rowDefStr), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        int y = 1;
        builder.add((Component)UIHelper.createI18NFormLabel("REP_NAME_LBL"), cc.xy(1, y));
        this.nameTxt = UIHelper.createTextField(this.reportName != null ? this.reportName : "untitled");
        builder.add((Component)this.nameTxt, cc.xy(3, y));
        JLabel titleLbl = UIHelper.createI18NFormLabel("REP_TITLE_DESC_LBL");
        builder.add((Component)titleLbl, cc.xy(1, y += 2));
        this.titleTxt = UIHelper.createTextField("none");
        builder.add((Component)this.titleTxt, cc.xy(3, y));
        titleLbl.setVisible(false);
        this.titleTxt.setVisible(false);
        this.levelTxt = UIHelper.createTextField("0");
        this.levelTxt.setEnabled(false);
        builder.add((Component)UIHelper.createI18NFormLabel("REP_REPTYPE_LBL"), cc.xy(1, y += 2));
        this.typeCombo = UIHelper.createComboBox();
        this.typeCombo.addItem(UIRegistry.getResourceString("REP_REPORT"));
        this.typeCombo.addItem(UIRegistry.getResourceString("REP_LABEL"));
        this.typeCombo.addItem(UIRegistry.getResourceString("REP_INVOICE"));
        if (this.reportType != null && this.reportType.equals("Label")) {
            this.typeCombo.setSelectedIndex(1);
        } else if (this.reportType != null && this.reportType.equals("Invoice")) {
            this.typeCombo.setSelectedIndex(2);
        } else if (this.reportType != null && this.reportType.equals("Subreport")) {
            this.typeCombo.setSelectedIndex(2);
        }
        builder.add((Component)this.typeCombo, cc.xy(3, y));
        builder.add((Component)UIHelper.createI18NFormLabel("REP_RESDIR_LBL"), cc.xy(1, y += 2));
        this.resDirCombo = UIHelper.createComboBox();
        this.fillResDirCombo();
        if (rep != null && rep.getAppResource() != null) {
            SpAppResource repRes = (SpAppResource)rep.getAppResource();
            if (repRes.getSpAppResourceDir().getIsPersonal().booleanValue()) {
                this.resDirCombo.setSelectedIndex(1);
            } else {
                this.resDirCombo.setSelectedIndex(0);
            }
        }
        builder.add((Component)this.resDirCombo, cc.xy(3, y));
        y += 2;
        builder.setDefaultDialogBorder();
        if (rep == null) {
            builder.add((Component)UIHelper.createI18NFormLabel("REP_SUBREPS_LBL"), cc.xy(1, y));
            this.subReportsTxt = UIHelper.createTextField(null);
            builder.add((Component)this.subReportsTxt, cc.xy(3, y));
            y += 2;
        }
        if (this.showTableIds) {
            builder.add((Component)UIHelper.createI18NFormLabel("REP_TBL_LBL"), cc.xy(1, y));
            this.tblCombo = UIHelper.createComboBox();
            this.fillTblCombo();
            this.tblCombo.setSelectedIndex(0);
            builder.add((Component)this.tblCombo, cc.xy(3, y));
            y += 2;
        }
        if (rep != null) {
            builder.add((Component)UIHelper.createI18NFormLabel("REP_REPEAT_LBL"), cc.xy(1, y));
            this.repeatPanel = new ReportRepeatPanel(rep.getConnection(), this.canceller);
            this.repeatPanel.createUI(rep.getSpReport() == null ? null : rep.getSpReport().getRepeats());
            builder.add((Component)this.repeatPanel, cc.xy(3, y));
            y += 2;
        } else {
            this.repeatPanel = null;
        }
    }

    public int getTableId() {
        if (!this.showTableIds) {
            return -1;
        }
        return ((DBTableInfo)this.tblCombo.getSelectedItem()).getTableId();
    }

    protected void fillResDirCombo() {
        this.resDirCombo.addItem(new ResDirItem(UIRegistry.getResourceString("SpecifyAppContextMgr.Discipline"), "Discipline"));
        this.resDirCombo.addItem(new ResDirItem(UIRegistry.getResourceString("SpecifyAppContextMgr.Personal"), "Personal"));
    }

    protected void fillTblCombo() {
        DBTableInfo info;
        InteractionsTask interactionsTask;
        DBTableInfo info2;
        Vector<DBTableInfo> tbls = new Vector<DBTableInfo>();
        DataEntryTask dataEntryTask = (DataEntryTask)TaskMgr.getTask("Data_Entry");
        if (dataEntryTask != null) {
            for (DataEntryView dv : dataEntryTask.getStdViews()) {
                if (!dv.isVisible()) continue;
                tbls.add(dv.getTableInfo());
            }
        }
        if (TaskMgr.getTask("TaxonTree") != null && !tbls.contains(info2 = DBTableIdMgr.getInstance().getInfoByTableName("taxon"))) {
            tbls.add(info2);
        }
        if (TaskMgr.getTask("GeographyTree") != null && !tbls.contains(info2 = DBTableIdMgr.getInstance().getInfoByTableName("geography"))) {
            tbls.add(info2);
        }
        if (TaskMgr.getTask("LithoStratTree") != null && !tbls.contains(info2 = DBTableIdMgr.getInstance().getInfoByTableName("lithostrat"))) {
            tbls.add(info2);
        }
        if (TaskMgr.getTask("GeoTimePeriodTree") != null && !tbls.contains(info2 = DBTableIdMgr.getInstance().getInfoByTableName("geologictimeperiod"))) {
            tbls.add(info2);
        }
        if (TaskMgr.getTask("StorageTree") != null && !tbls.contains(info2 = DBTableIdMgr.getInstance().getInfoByTableName("storage"))) {
            tbls.add(info2);
        }
        if ((interactionsTask = (InteractionsTask)TaskMgr.getTask("Interactions")) != null) {
            for (InteractionEntry ie : interactionsTask.getEntries()) {
                if (!ie.isOnLeft() || !ie.isVisible() || tbls.contains(info = DBTableIdMgr.getInstance().getInfoByTableName(ie.getTableName()))) continue;
                tbls.add(info);
            }
        }
        if (dataEntryTask != null) {
            for (DataEntryView dv : dataEntryTask.getMiscViews()) {
                if (!dv.isVisible() || tbls.contains(info = dv.getTableInfo())) continue;
                tbls.add(info);
            }
        }
        if (interactionsTask != null) {
            for (InteractionEntry ie : interactionsTask.getEntries()) {
                if (ie.isOnLeft() || !ie.isVisible() || tbls.contains(info = DBTableIdMgr.getInstance().getInfoByTableName(ie.getTableName()))) continue;
                tbls.add(info);
            }
        }
        for (DBTableInfo tbl : tbls) {
            this.tblCombo.addItem(tbl);
        }
    }

    public JTextField getNameTxt() {
        return this.nameTxt;
    }

    public JTextField getTitleTxt() {
        return this.titleTxt;
    }

    public JTextField getLevelTxt() {
        return this.levelTxt;
    }

    public JComboBox getTypeCombo() {
        return this.typeCombo;
    }

    public JComboBox getResDirCombo() {
        return this.resDirCombo;
    }

    public static void main(String[] args) {
        CustomDialog tcd = new CustomDialog(null, "Testing", false, new RepResourcePropsPanel(null, null, true, null));
        UIHelper.centerAndShow(tcd);
    }

    public void setCanceller(JButton canceller) {
        this.canceller = canceller;
    }

    public Object getRepeats() {
        if (this.repeatPanel != null) {
            return this.repeatPanel.getRepeats();
        }
        return null;
    }

    public JTextField getSubReportsTxt() {
        return this.subReportsTxt;
    }

    public boolean validInputs() {
        if (this.repeatPanel != null) {
            return this.repeatPanel.validInputs();
        }
        return true;
    }

    public class ResDirItem
    extends Pair<String, String> {
        public ResDirItem(String title, String name) {
            super(title, name);
        }

        public String getTitle() {
            return (String)this.getFirst();
        }

        public String getName() {
            return (String)this.getSecond();
        }

        @Override
        public String toString() {
            return (String)this.getFirst();
        }
    }
}

