/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.ireportspecify;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizardFrame;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpAppResource;
import edu.ku.brc.specify.datamodel.SpAppResourceData;
import edu.ku.brc.specify.datamodel.SpAppResourceDir;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpReport;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.dbsupport.PostDeleteEventListener;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.dbsupport.PostUpdateEventListener;
import edu.ku.brc.specify.tasks.ReportsBaseTask;
import edu.ku.brc.specify.tasks.subpane.JRConnectionFieldDef;
import edu.ku.brc.specify.tasks.subpane.SpJRIReportConnection;
import edu.ku.brc.specify.tasks.subpane.qb.QBJRIReportConnection;
import edu.ku.brc.specify.tasks.subpane.wb.WBJRIReportConnection;
import edu.ku.brc.specify.tools.ireportspecify.AppResAndProps;
import edu.ku.brc.specify.tools.ireportspecify.IReportLauncher;
import edu.ku.brc.specify.tools.ireportspecify.RepResourcePropsPanel;
import edu.ku.brc.specify.tools.ireportspecify.ReportSpecify;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportReader;
import it.businesslogic.ireport.ReportWriter;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportPropertiesFrame;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.UnresolvableObjectException;

public class MainFrameSpecify
extends MainFrame {
    private static final Logger log = Logger.getLogger(MainFrameSpecify.class);
    protected static final String REP_CHOOSE_REPORT = "REP_CHOOSE_REPORT";
    protected boolean refreshingConnections = false;
    protected static Integer overwrittenReportId = null;
    protected JMenuItem homePageItem = null;

    public MainFrameSpecify(Map<?, ?> args, boolean noExit, boolean embedded) {
        super(args);
        this.setNoExit(noExit);
        this.setEmbeddedIreport(embedded);
        this.fixUpHelpLinks();
    }

    public void fixUpHelpLinks() {
        int helpMenuIdx = 9;
        int homePageItemIdx = 0;
        int helpItemIdx = 1;
        String jasperHomePage = "http://jasperforge.org/";
        JMenuBar mb = this.getJMenuBar();
        JMenu hm = mb.getMenu(helpMenuIdx);
        this.homePageItem = hm.getItem(homePageItemIdx);
        ActionListener[] als = this.homePageItem.getActionListeners();
        int l = 0;
        while (l < als.length) {
            this.homePageItem.removeActionListener(als[l]);
            ++l;
        }
        this.homePageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainFrameSpecify.this.openUrl("http://jasperforge.org/");
            }
        });
        JMenuItem helpPageItem = hm.getItem(helpItemIdx);
        als = helpPageItem.getActionListeners();
        int l2 = 0;
        while (l2 < als.length) {
            helpPageItem.removeActionListener(als[l2]);
            ++l2;
        }
        HelpMgr.registerComponent((AbstractButton)helpPageItem, "iReport");
        this.setIconImage(IconManager.getIcon("SPIReports", IconManager.IconSize.NonStd).getImage());
    }

    public void applyI18n() {
        super.applyI18n();
        if (this.homePageItem != null) {
            this.homePageItem.setText(UIRegistry.getResourceString("MainFrameSpecify.JASPERHOMEPAGE"));
        }
    }

    public void refreshSpJRConnections() {
        this.refreshingConnections = true;
        try {
            this.getConnections().clear();
            this.addSpQBConns();
            this.addSpWBConns();
        }
        finally {
            this.refreshingConnections = false;
        }
    }

    protected void addSpQBConns() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                String sqlStr = "from SpQuery where specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId();
                List<?> qs = session.createQuery(sqlStr, false).list();
                Collections.sort(qs, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                SpQuery prevQ = null;
                for (Object q : qs) {
                    SpQuery spq = (SpQuery)q;
                    if (prevQ == null || !prevQ.getId().equals(spq.getId())) {
                        this.addSpQBConn((SpQuery)q);
                    }
                    prevQ = spq;
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        finally {
            session.close();
        }
    }

    protected List<String> getQueryNames() {
        LinkedList<String> result = new LinkedList<String>();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpQuery> qs = session.getDataList(SpQuery.class);
            for (SpQuery q : qs) {
                result.add(q.getName());
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
    }

    protected void addSpQBConn(SpQuery q) {
        if (!AppContextMgr.isSecurityOn() || DBTableIdMgr.getInstance().getInfoById(q.getContextTableId().shortValue()).getPermissions().canView()) {
            QBJRIReportConnection newq = new QBJRIReportConnection(q);
            newq.loadProperties(null);
            this.getConnections().add(newq);
        }
    }

    protected void addSpWBConn(Workbench wb) {
        if (!AppContextMgr.isSecurityOn() || DBTableIdMgr.getInstance().getInfoById(Workbench.getClassTableId()).getPermissions().canView()) {
            WBJRIReportConnection newWb = new WBJRIReportConnection(wb);
            newWb.loadProperties(null);
            this.getConnections().add(newWb);
        }
    }

    protected void addSpWBConns() {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                String sqlStr = "From Workbench where specifyUserId = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId();
                List<?> wbs = session.createQuery(sqlStr, false).list();
                Collections.sort(wbs, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                for (Object wb : wbs) {
                    this.addSpWBConn((Workbench)wb);
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        finally {
            session.close();
        }
    }

    public static Map<String, Object> getDefaultArgs() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    public void saveAll(JInternalFrame[] frames) {
        int f = 0;
        while (f < frames.length) {
            JReportFrame jrf;
            if (frames[f] instanceof JReportFrame && (jrf = (JReportFrame)frames[f]).getReport() instanceof ReportSpecify && jrf.getReport().isModified()) {
                this.save(jrf);
            }
            ++f;
        }
    }

    public static boolean importJasperReport(File jasperFile, boolean confirmOverwrite, String newResName) {
        ByteArrayOutputStream xml = null;
        try {
            xml = new ByteArrayOutputStream();
            xml.write(FileUtils.readFileToByteArray((File)jasperFile));
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
            UIRegistry.getStatusBar().setErrorMessage(e.getLocalizedMessage(), e);
            return false;
        }
        String resName = newResName != null ? newResName : FilenameUtils.getBaseName((String)jasperFile.getName());
        AppResAndProps resApp = MainFrameSpecify.getAppRes(resName, null, confirmOverwrite);
        if (resApp != null) {
            String metaData = resApp.getAppRes().getMetaData();
            String newMetaData = "isimport=1";
            try {
                Element element = XMLHelper.readFileToDOM4J(jasperFile);
                List parameters = element.selectNodes("/jasperReport/parameter");
                boolean isDropSite = false;
                for (Object p : parameters) {
                    Element param = (Element)p;
                    if (!param.attributeValue("name").equals("itemnum")) continue;
                    isDropSite = true;
                    break;
                }
                newMetaData = isDropSite ? String.valueOf(newMetaData) + ";hasrsdropparam=1" : String.valueOf(newMetaData) + ";hasrsdropparam=0";
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                UIRegistry.getStatusBar().setErrorMessage(e.getLocalizedMessage(), e);
                return false;
            }
            metaData = StringUtils.isEmpty((String)metaData) ? newMetaData : String.valueOf(metaData) + ";" + newMetaData;
            resApp.getAppRes().setMetaData(metaData);
            return MainFrameSpecify.saveXML(xml, resApp, null, false);
        }
        return false;
    }

    protected static boolean saveXML(ByteArrayOutputStream xml, AppResAndProps apr, ReportSpecify rep, boolean saveAs) {
        boolean newRep;
        AppResourceIFace appRes = apr.getAppRes();
        boolean bl = newRep = ((SpAppResource)appRes).getId() == null;
        if (!newRep) {
            AppResourceIFace freshAppRes = AppContextMgr.getInstance().getResource(appRes.getName());
            if (freshAppRes != null) {
                freshAppRes.setName(appRes.getName());
                freshAppRes.setDescription(appRes.getDescription());
                freshAppRes.setLevel(appRes.getLevel());
                freshAppRes.setMimeType(appRes.getMimeType());
                freshAppRes.setMetaData(appRes.getMetaData());
                ((SpAppResource)freshAppRes).setSpAppResourceDir(((SpAppResource)appRes).getSpAppResourceDir());
                appRes = freshAppRes;
            } else {
                SpAppResource spAppRes = (SpAppResource)appRes;
                spAppRes.setSpAppResourceId(null);
                spAppRes.setVersion(0);
                spAppRes.setTimestampCreated(new Timestamp(System.currentTimeMillis()));
                SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                SpAppResourceDir dir = spMgr.getSpAppResourceDirByName(spMgr.getDirName(spAppRes.getSpAppResourceDir()));
                spAppRes.setSpAppResourceDir(dir);
                spAppRes.setSpAppResourceDatas(new HashSet<SpAppResourceData>());
                spAppRes.setSpReports(new HashSet<SpReport>());
                if (rep != null) {
                    rep.setSpReport(null);
                }
                newRep = true;
            }
        }
        boolean result = false;
        boolean savedAppRes = false;
        String xmlString = xml.toString();
        if (rep != null) {
            xmlString = MainFrameSpecify.modifyXMLForSaving(xmlString, rep);
        }
        appRes.setDataAsString(xmlString);
        try {
            savedAppRes = AppContextMgr.getInstance().saveResource(appRes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
            return false;
        }
        if (!savedAppRes) {
            return false;
        }
        if (rep == null) {
            return true;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        boolean transOpen = false;
        boolean createReport = true;
        try {
            try {
                SpReport spRep;
                if (rep.getSpReport() != null && !saveAs) {
                    try {
                        session.refresh(rep.getSpReport());
                        createReport = false;
                        result = true;
                    }
                    catch (UnresolvableObjectException e) {
                        log.debug((Object)("Report has been deleted in Specify? (" + (Object)((Object)e) + ")"));
                    }
                }
                if (createReport) {
                    spRep = new SpReport();
                    spRep.initialize();
                } else {
                    spRep = rep.getSpReport();
                }
                spRep.setName(appRes.getName());
                SpAppResource freshRes = session.get(SpAppResource.class, ((SpAppResource)appRes).getId());
                rep.setAppResource(freshRes);
                spRep.setAppResource(freshRes);
                spRep.setRepeats(apr.getRepeats());
                DataModelObjBase obj = rep.getConnection().getSpObject();
                DataModelObjBase freshObject = (DataModelObjBase)session.get(obj.getClass(), obj.getId());
                if (freshObject != null) {
                    spRep.setReportObject(freshObject);
                    spRep.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
                    session.beginTransaction();
                    transOpen = true;
                    session.saveOrUpdate(spRep.getReportObject());
                    session.save(spRep);
                    session.commit();
                    transOpen = false;
                    session.refresh(spRep);
                    rep.setSpReport(spRep);
                    result = true;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
                if (transOpen) {
                    session.rollback();
                }
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (!newRep) {
                session.evict(appRes);
            }
            if (newRep && !result) {
                SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
                SpAppResource spRes = (SpAppResource)appRes;
                spMgr.removeAppResourceSp(spRes.getSpAppResourceDir(), spRes);
            }
            session.close();
        }
        return result;
    }

    public void save(JReportFrame jrf) {
        this.doSave(jrf, false);
    }

    protected void doSave(JReportFrame jrf, boolean saveAs) {
        PermissionSettings permissions;
        ((SpecifyAppContextMgr)AppContextMgr.getInstance()).setContext(((SpecifyAppContextMgr)AppContextMgr.getInstance()).getDatabaseName(), ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getUserName(), true, true, false);
        if (AppContextMgr.isSecurityOn() && !(permissions = SecurityMgr.getInstance().getPermission("Task.Reports")).canModify()) {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("IReportLauncher.PERMISSION_TO_MODIFY_DENIED"), UIRegistry.getResourceString("IReportLauncher.PERMISSION_DENIED_TITLE"), 0);
            return;
        }
        overwrittenReportId = null;
        AppResAndProps apr = this.getAppResAndPropsForFrame(jrf, saveAs);
        if (overwrittenReportId != null) {
            this.removeFrameForDeletedReport(overwrittenReportId);
            overwrittenReportId = null;
        }
        if (apr != null) {
            ReportSpecify rep = (ReportSpecify)jrf.getReport();
            ByteArrayOutputStream xmlOut = new ByteArrayOutputStream();
            try {
                this.modifyFieldsForSaving(rep);
                ReportWriter rw = new ReportWriter((Report)rep);
                rw.writeToOutputStream((OutputStream)xmlOut);
            }
            finally {
                this.modifyFieldsForEditing(rep);
            }
            boolean success = MainFrameSpecify.saveXML(xmlOut, apr, rep, saveAs);
            if (success) {
                jrf.setIsDocDirty(false);
                jrf.getReport().setReportChanges(0);
            } else {
                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_UNABLE_TO_SAVE_IREPORT"), UIRegistry.getResourceString("Error"), 0);
            }
        }
    }

    private AppResAndProps getAppResAndPropsForFrame(JReportFrame jrf, boolean saveAs) {
        PermissionSettings permissions;
        SpReport spRep = ((ReportSpecify)jrf.getReport()).getSpReport();
        SpAppResource appRes = null;
        if (!saveAs) {
            SpAppResource spAppResource = appRes = spRep == null ? MainFrameSpecify.getRepResource(jrf.getReport().getName()) : spRep.getAppResource();
        }
        if (appRes != null && spRep != null) {
            appRes.setTimestampModified(new Timestamp(System.currentTimeMillis()));
            return MainFrameSpecify.getProps(jrf.getReport().getName(), -1, (ReportSpecify)jrf.getReport(), appRes);
        }
        if (AppContextMgr.isSecurityOn() && !(permissions = SecurityMgr.getInstance().getPermission("Task.Reports")).canAdd()) {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("IReportLauncher.PERMISSION_TO_ADD_DENIED"), UIRegistry.getResourceString("IReportLauncher.PERMISSION_DENIED_TITLE"), 0);
            return null;
        }
        AppResAndProps result = MainFrameSpecify.createAppResAndProps(jrf.getReport().getName(), -1, (ReportSpecify)jrf.getReport());
        if (result != null) {
            jrf.getReport().setName(result.getAppRes().getName());
        }
        return result;
    }

    private static AppResAndProps getAppRes(String appResName, Integer tableid, boolean confirmOverwrite) {
        AppResourceIFace resApp = AppContextMgr.getInstance().getResource(appResName);
        if (resApp != null) {
            if (!confirmOverwrite) {
                return new AppResAndProps(resApp, null);
            }
            int option = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("REP_CONFIRM_IMP_OVERWRITE"), resApp.getName()), UIRegistry.getResourceString("REP_CONFIRM_IMP_OVERWRITE_TITLE"), 0, 3, null, null, 1);
            if (option == 0) {
                return new AppResAndProps(resApp, null);
            }
            return null;
        }
        return MainFrameSpecify.createAppResAndProps(appResName, tableid, null);
    }

    protected static SpAppResource getRepResource(String repResName) {
        List<AppResourceIFace> reps = AppContextMgr.getInstance().getResourceByMimeType("jrxml/label");
        reps.addAll(AppContextMgr.getInstance().getResourceByMimeType("jrxml/report"));
        for (AppResourceIFace rep : reps) {
            if (!rep.getName().equals(repResName)) continue;
            return (SpAppResource)rep;
        }
        return null;
    }

    protected static SpAppResourceDir getDirForResource(String dirName) {
        SpecifyAppContextMgr spMgr = (SpecifyAppContextMgr)AppContextMgr.getInstance();
        if (dirName.equals("Personal")) {
            for (SpAppResourceDir dir : spMgr.getSpAppResourceList()) {
                if (!dir.getIsPersonal().booleanValue()) continue;
                return dir;
            }
        }
        return spMgr.getSpAppResourceDirByName(dirName);
    }

    protected static AppResAndProps getProps(String repResName, Integer tableId, ReportSpecify spReport, AppResourceIFace appRes) {
        String repType;
        if (appRes == null) {
            repType = "Report";
        } else {
            String mime = appRes.getMimeType();
            String reportType = appRes.getMetaDataMap().getProperty("reporttype", null);
            repType = mime.equals("jrxml/label") ? "Label" : (mime.equals("jrxml/subreport") ? "Subreport" : (reportType != null && reportType.equalsIgnoreCase("invoice") ? "Invoice" : "Report"));
        }
        RepResourcePropsPanel propPanel = new RepResourcePropsPanel(repResName, repType, tableId == null, spReport);
        boolean goodProps = false;
        boolean overwrite = false;
        SpAppResource match = null;
        CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_PROPS_DLG_TITLE"), true, propPanel);
        propPanel.setCanceller(cd.getCancelBtn());
        while (!goodProps) {
            UIHelper.centerAndShow(cd);
            if (cd.isCancelled()) {
                return null;
            }
            String repName = propPanel.getNameTxt().getText().trim();
            boolean isNameOK = repName.matches("[a-zA-Z0-9\\-. '`_]*");
            if (StringUtils.isEmpty((String)repName)) {
                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("REP_NAME_MUST_NOT_BE_BLANK"), propPanel.getNameTxt().getText()));
                continue;
            }
            if (!isNameOK) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("INVALID_CHARS_NAME"));
                continue;
            }
            match = MainFrameSpecify.getRepResource(propPanel.getNameTxt().getText());
            if (match != null) {
                if (appRes == null || !((SpAppResource)appRes).getId().equals(match.getId())) {
                    int chc = JOptionPane.showConfirmDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("REP_NAME_ALREADY_EXISTS_OVERWRITE_CONFIRM"), propPanel.getNameTxt().getText()));
                    if (chc == 0) {
                        goodProps = true;
                        overwrite = true;
                    } else if (chc != 1) {
                        return null;
                    }
                } else {
                    goodProps = true;
                }
            } else {
                goodProps = true;
            }
            boolean bl = goodProps = goodProps && propPanel.validInputs();
        }
        if (goodProps) {
            SpAppResourceDir dir;
            String dirName;
            if (match != null && overwrite) {
                Integer matchId = null;
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    SpReport matchRep = session.getData(SpReport.class, "appResource", match, DataProviderSessionIFace.CompareType.Equals);
                    if (matchRep == null) {
                        JOptionPane.showMessageDialog(null, String.format(UIRegistry.getResourceString("REP_UNABLE_TO_OVERWRITE"), match.getName()), UIRegistry.getResourceString("Error"), 0);
                        return null;
                    }
                    matchId = matchRep.getId();
                }
                finally {
                    session.close();
                    session = null;
                }
                ReportsBaseTask.deleteReportAndResource(matchId, match);
                overwrittenReportId = matchId;
            }
            AppResourceIFace modifiedRes = null;
            if (appRes == null) {
                dirName = ((RepResourcePropsPanel.ResDirItem)propPanel.getResDirCombo().getSelectedItem()).getName();
                dir = MainFrameSpecify.getDirForResource(dirName);
                modifiedRes = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).createAppResourceForDir(dir);
            } else {
                modifiedRes = appRes;
                dirName = ((RepResourcePropsPanel.ResDirItem)propPanel.getResDirCombo().getSelectedItem()).getName();
                dir = MainFrameSpecify.getDirForResource(dirName);
                ((SpAppResource)modifiedRes).setSpAppResourceDir(dir);
            }
            modifiedRes.setName(propPanel.getNameTxt().getText().trim());
            modifiedRes.setDescription(propPanel.getNameTxt().getText().trim());
            modifiedRes.setLevel(Short.valueOf(propPanel.getLevelTxt().getText()));
            propPanel.getResDirCombo().getSelectedItem();
            String metaDataStr = "tableid=" + propPanel.getTableId() + ";";
            metaDataStr = propPanel.getTypeCombo().getSelectedIndex() == 2 ? String.valueOf(metaDataStr) + "reporttype=Invoice;" : String.valueOf(metaDataStr) + "reporttype=Report;";
            if (propPanel.getSubReportsTxt() != null && propPanel.getSubReportsTxt().getText() != null) {
                metaDataStr = String.valueOf(metaDataStr) + "subreports=" + propPanel.getSubReportsTxt().getText() + ";";
            }
            if (propPanel.getTypeCombo().getSelectedIndex() == 3) {
                modifiedRes.setMimeType("jrxml/subreport");
            } else if (propPanel.getTypeCombo().getSelectedIndex() == 1) {
                modifiedRes.setMimeType("jrxml/label");
            } else {
                modifiedRes.setMimeType("jrxml/report");
            }
            if (StringUtils.isNotEmpty((String)modifiedRes.getMetaData())) {
                log.info((Object)("overwriting existing AppResource metadata (" + modifiedRes.getMetaData() + ") with (" + metaDataStr + ")"));
            }
            modifiedRes.setMetaData(metaDataStr);
            AppResAndProps result = new AppResAndProps(modifiedRes, propPanel.getRepeats());
            return result;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void removeFrameForDeletedReport(Integer reportId) {
        if (reportId != null) {
            void var5_5;
            JInternalFrame[] frames = this.getJMDIDesktopPane().getAllFrames();
            Vector<JReportFrame> toRemove = new Vector<JReportFrame>();
            boolean bl = false;
            while (var5_5 < frames.length) {
                JReportFrame jrf;
                if (frames[var5_5] instanceof JReportFrame && (jrf = (JReportFrame)frames[var5_5]).getReport() instanceof ReportSpecify && ((ReportSpecify)jrf.getReport()).getSpReport() != null && reportId.equals(((ReportSpecify)jrf.getReport()).getSpReport().getId())) {
                    toRemove.add(jrf);
                }
                ++var5_5;
            }
            for (Component component : toRemove) {
                this.getJMDIDesktopPane().remove(component);
            }
        }
    }

    protected static AppResAndProps createAppResAndProps(String repResName, Integer tableid, ReportSpecify rep) {
        return MainFrameSpecify.getProps(repResName, tableid, rep, null);
    }

    public void saveAs(JReportFrame jrf) {
        this.doSave(jrf, true);
        this.setActiveReportForm(jrf);
    }

    protected boolean repResIsEditableByUser(AppResourceIFace repRes) {
        if (!(repRes instanceof SpAppResource)) {
            return false;
        }
        String sql1 = "select count(spq.SpQueryID) from spquery spq inner join spreport spr  on spr.SpQueryID = spq.SpQueryID inner join spappresource spa on spa.SpAppResourceID = spr.AppResourceID where spq.SpecifyUserID = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " and spa.SpAppResourceID = " + ((SpAppResource)repRes).getId();
        String sql2 = "select count(spw.WorkbenchTemplateID) from workbenchtemplate spw inner join spreport spr  on spr.WorkbenchTemplateID = spw.WorkbenchTemplateID inner join spappresource spa on spa.SpAppResourceID = spr.AppResourceID where spw.SpecifyUserID = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getSpecifyUserId() + " and spa.SpAppResourceID = " + ((SpAppResource)repRes).getId();
        try {
            return BasicSQLUtils.getCount(sql1) != 0 || BasicSQLUtils.getCount(sql2) != 0;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
            log.error((Object)ex);
            return false;
        }
    }

    public JReportFrame[] open() {
        JReportFrame[] result = null;
        Vector<AppResourceIFace> list = new Vector<AppResourceIFace>();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            String[] mimes = new String[]{"jrxml/label", "jrxml/report"};
            int m = 0;
            while (m < mimes.length) {
                for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType(mimes[m])) {
                    if (!(ap instanceof SpAppResource) || ((SpAppResource)ap).getSpAppResourceId() == null) continue;
                    session.attach(ap);
                    if (session.getData(SpReport.class, "appResource", ap, DataProviderSessionIFace.CompareType.Equals) != null) {
                        Properties params = ap.getMetaDataMap();
                        String tableid = params.getProperty("tableid");
                        String rptType = params.getProperty("reporttype");
                        if (StringUtils.isNotEmpty((String)tableid) && StringUtils.isNotEmpty((String)rptType) && (rptType.equals("Report") || rptType.equals("Invoice")) && this.repResIsEditableByUser(ap)) {
                            list.add(ap);
                        }
                    }
                    session.evict(ap);
                }
                ++m;
            }
        }
        finally {
            session.close();
        }
        Collections.sort(list, new Comparator<AppResourceIFace>(){

            @Override
            public int compare(AppResourceIFace o1, AppResourceIFace o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        if (list.size() > 0) {
            ChooseFromListDlg dlg = new ChooseFromListDlg(null, UIRegistry.getResourceString(REP_CHOOSE_REPORT), list);
            dlg.setVisible(true);
            AppResourceIFace appRes = (AppResourceIFace)dlg.getSelectedObject();
            if (appRes != null) {
                result = new JReportFrame[]{this.openReportFromResource(appRes)};
            }
        } else {
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_NO_REPORTS_TO_EDIT"), "", 1);
        }
        return result;
    }

    private JReportFrame findReportFrameByResource(AppResourceIFace rep) {
        if (rep != null) {
            JInternalFrame[] frames = this.getJMDIDesktopPane().getAllFrames();
            int i = 0;
            while (i < frames.length) {
                JReportFrame jrf;
                if (frames[i] instanceof JReportFrame && (jrf = (JReportFrame)frames[i]).getReport() instanceof ReportSpecify && ((ReportSpecify)jrf.getReport()).resourceMatch(rep)) {
                    return jrf;
                }
                ++i;
            }
        }
        return null;
    }

    protected String modifyXMLForEditing(String xml, SpReport spRep) {
        SpJRIReportConnection c;
        String result = new String(xml);
        if (spRep != null && (c = this.getConnectionByObject(spRep.getReportObject())) != null) {
            int f = 0;
            while (f < c.getFields()) {
                JRConnectionFieldDef fld = c.getField(f);
                result = result.replace("$F{" + fld.getFldName() + "}", "$F{" + fld.getFldTitle() + "}");
                ++f;
            }
        }
        return result;
    }

    protected static String modifyXMLForSaving(String xml, ReportSpecify rep) {
        String result = new String(xml);
        SpJRIReportConnection c = rep.getConnection();
        if (c != null) {
            int f = 0;
            while (f < c.getFields()) {
                JRConnectionFieldDef fld = c.getField(f);
                result = result.replace("$F{" + fld.getFldTitle() + "}", "$F{" + fld.getFldName() + "}");
                ++f;
            }
        }
        return result;
    }

    protected void modifyFieldsForEditing(ReportSpecify report) {
        for (Object jrfObj : report.getFields()) {
            JRField jrf = (JRField)jrfObj;
            JRConnectionFieldDef qbjrf = report.getConnection().getFieldByName(jrf.getName());
            if (qbjrf == null) continue;
            jrf.setName(qbjrf.getFldTitle());
        }
    }

    protected void modifyFieldsForSaving(ReportSpecify report) {
        for (Object jrfObj : report.getFields()) {
            JRField jrf = (JRField)jrfObj;
            JRConnectionFieldDef qbjrf = report.getConnection().getFieldByTitle(jrf.getName());
            if (qbjrf == null) continue;
            jrf.setName(qbjrf.getFldName());
        }
    }

    public JReportFrame openReportFromResource(AppResourceIFace rep) {
        JReportFrame reportFrame = this.findReportFrameByResource(rep);
        if (reportFrame == null) {
            try {
                ReportSpecify report = this.makeReport(rep);
                report.setConnection(this.getConnectionByObject(report.getSpReport().getReportObject()));
                this.modifyFieldsForEditing(report);
                this.updateReportFields(report);
                report.setUsingMultiLineExpressions(false);
                reportFrame = this.openNewReportWindow(report);
                report.addReportDocumentStatusChangedListener((ReportDocumentStatusChangedListener)this);
                this.setActiveReportForm(reportFrame);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                e.printStackTrace();
                this.logOnConsole(String.valueOf(e.getMessage()) + "\n");
            }
        } else {
            try {
                this.setActiveReportForm(reportFrame);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
                ex.printStackTrace();
            }
        }
        return reportFrame;
    }

    protected SpJRIReportConnection getConnectionByObject(DataModelObjBase object) {
        int c = 0;
        while (c < this.getConnections().size()) {
            SpJRIReportConnection conn = (SpJRIReportConnection)((Object)this.getConnections().get(c));
            if (conn.getName().equals(object.getIdentityTitle())) {
                return conn;
            }
            ++c;
        }
        return null;
    }

    public static ReportSpecify loadReport(AppResourceIFace rep) {
        ReportSpecify report = null;
        SpReport spRep = null;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            spRep = session.getData(SpReport.class, "appResource", rep, DataProviderSessionIFace.CompareType.Equals);
            report = spRep != null ? new ReportSpecify(spRep) : new ReportSpecify(rep);
        }
        finally {
            session.close();
        }
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(rep.getDataAsString().getBytes());
        while (report.getStyles().size() > 0) {
            report.removeStyle((Style)report.getStyles().get(0));
        }
        ReportReader rr = new ReportReader((Report)report);
        try {
            rr.readFromStream((InputStream)xmlStream);
            return report;
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
            return null;
        }
    }

    public ReportSpecify makeReport(AppResourceIFace rep) {
        ReportSpecify report = null;
        SpReport spRep = null;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            spRep = session.getData(SpReport.class, "appResource", rep, DataProviderSessionIFace.CompareType.Equals);
            report = spRep != null ? new ReportSpecify(spRep) : new ReportSpecify(rep);
        }
        finally {
            session.close();
        }
        InputStream xmlStream = this.getXML(rep, spRep != null ? spRep : null);
        while (report.getStyles().size() > 0) {
            report.removeStyle((Style)report.getStyles().get(0));
        }
        ReportReader rr = new ReportReader((Report)report);
        try {
            rr.readFromStream(xmlStream);
            return report;
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
            return null;
        }
    }

    private ReportSpecify makeNewReport(SpJRIReportConnection connection) {
        ReportSpecify report = new ReportSpecify();
        report.setConnection(connection);
        int f = 0;
        while (f < connection.getFields()) {
            JRConnectionFieldDef fDef = connection.getField(f);
            report.addField(new JRField(fDef.getFldTitle(), fDef.getFldClass().getName()));
            ++f;
        }
        return report;
    }

    protected void updateReportFields(ReportSpecify report) {
        SpJRIReportConnection c = report.getConnection();
        if (c != null) {
            int f = report.getFields().size() - 1;
            while (f >= 0) {
                JRField jrf = (JRField)report.getFields().get(f);
                if (c.getFieldByTitle(jrf.getName()) == null) {
                    report.getFields().remove(f);
                }
                --f;
            }
            f = 0;
            while (f < c.getFields()) {
                boolean isNew = true;
                for (Object jrfObj : report.getFields()) {
                    JRField jrf = (JRField)jrfObj;
                    if (!jrf.getName().equals(c.getField(f).getFldTitle())) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    report.addField(new JRField(c.getField(f).getFldTitle(), c.getField(f).getFldClass().getName()));
                }
                ++f;
            }
        } else {
            log.info((Object)("Skipping fields update for '" + report.getName() + "' because connection is null."));
        }
    }

    private InputStream getXML(AppResourceIFace rep, SpReport spRep) {
        String xml = this.modifyXMLForEditing(rep.getDataAsString(), spRep);
        return new ByteArrayInputStream(xml.getBytes());
    }

    public Report newWizard() {
        PermissionSettings permissions;
        if (AppContextMgr.isSecurityOn() && !(permissions = SecurityMgr.getInstance().getPermission("Task.Reports")).canAdd()) {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("IReportLauncher.PERMISSION_TO_ADD_DENIED"), UIRegistry.getResourceString("IReportLauncher.PERMISSION_DENIED_TITLE"), 0);
            return null;
        }
        Vector<SpJRIReportConnection> spConns = new Vector<SpJRIReportConnection>();
        Vector cons = this.getConnections();
        for (Object conn : cons) {
            if (!(conn instanceof SpJRIReportConnection)) continue;
            spConns.add((SpJRIReportConnection)((Object)conn));
        }
        if (spConns.size() == 0) {
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("REP_NO_QUERIES_FOR_DATA_SOURCES"), "", 1);
            return null;
        }
        ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)((Object)this), UIRegistry.getResourceString("REP_CHOOSE_SP_QUERY"), spConns);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return null;
        }
        ReportSpecify result = this.makeNewReport((SpJRIReportConnection)((Object)dlg.getSelectedObject()));
        dlg.dispose();
        if (result != null) {
            if (this.getReportProperties(result)) {
                this.openNewReportWindow(result);
                return result;
            }
            return null;
        }
        return result;
    }

    public String getFirstNameFree() {
        String base = UIRegistry.getResourceString("REP_NewReportName");
        int count = 0;
        JInternalFrame[] frames = this.getJMDIDesktopPane().getAllFrames();
        int f = 0;
        while (f < frames.length) {
            if (frames[f] instanceof JReportFrame) {
                JReportFrame jrf = (JReportFrame)frames[f];
                String repName = jrf.getReport().getName();
                if (repName.equals(base)) {
                    if (count == 0) {
                        ++count;
                    }
                } else if (repName.startsWith(base)) {
                    String end = repName.substring(base.length());
                    try {
                        int endInt = Integer.valueOf(StringUtils.strip((String)end));
                        if (endInt > count) {
                            count = endInt;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++f;
        }
        return String.valueOf(base) + (count > 0 ? " " + ++count : "");
    }

    protected boolean getReportProperties(Report report) {
        ReportPropertiesFrame rpf = new ReportPropertiesFrame((Frame)((Object)this), true);
        rpf.setModal(true);
        String name = this.getFirstNameFree();
        rpf.setReportName(name);
        rpf.setVisible(true);
        if (rpf.getDialogResult() == 0) {
            report.setUsingMultiLineExpressions(false);
            report.setWidth(rpf.getReportWidth());
            report.setHeight(rpf.getReportHeight());
            report.setOrientation(rpf.getOrientation());
            report.setName(rpf.getReportName());
            report.setTopMargin(rpf.getTopMargin());
            report.setLeftMargin(rpf.getLeftMargin());
            report.setRightMargin(rpf.getRightMargin());
            report.setBottomMargin(rpf.getBottomMargin());
            report.setColumnCount(rpf.getColumns());
            report.setColumnWidth(rpf.getColumnsWidth());
            report.setColumnSpacing(rpf.getColumnsSpacing());
            report.setIsSummaryNewPage(rpf.isSummaryOnNewPage());
            report.setIsTitleNewPage(rpf.isTitleOnNewPage());
            report.setWhenNoDataType(rpf.getWhenNoDataType());
            report.setScriptletClass(rpf.getScriptletClass());
            report.setEncoding(rpf.getXmlEncoding());
            report.setPrintOrder(rpf.getPrintOrder());
            report.setReportFormat(rpf.getReportFormat());
            report.setFloatColumnFooter(rpf.isFloatColumnFooter());
            report.setResourceBundleBaseName(rpf.getResourceBundleBaseName());
            report.setWhenResourceMissingType(rpf.getWhenResourceMissingType());
            report.setIgnorePagination(rpf.isIgnorePagination());
            report.setFormatFactoryClass(rpf.getFormatFactoryClass());
            report.setLanguage(rpf.getLanguage());
            return true;
        }
        return false;
    }

    public Vector getConnections() {
        if (!this.refreshingConnections) {
            this.refreshSpJRConnections();
        }
        return super.getConnections();
    }

    protected static void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", null);
            String variant = AppPreferences.getLocalPrefs().get("locale.var", null);
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }

    public static void main(String[] args) {
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        UIRegistry.setAppName("Specify");
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        AppBase.processArgs(args);
        AppBase.setupTeeForStdErrStdOut(true, false);
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFaceGlobal", "edu.ku.brc.specify.config.AppPrefsGlobalDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
        final AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        MainFrameSpecify.adjustLocaleFromPrefs();
        final String iRepPrefDir = localPrefs.getDirPath();
        int mark = iRepPrefDir.lastIndexOf(UIRegistry.getAppName(), iRepPrefDir.length());
        final String SpPrefDir = String.valueOf(iRepPrefDir.substring(0, mark)) + "Specify";
        HibernateUtil.setListener("post-commit-update", new PostUpdateEventListener());
        HibernateUtil.setListener("post-commit-insert", new PostInsertEventListener());
        HibernateUtil.setListener("post-commit-delete", new PostDeleteEventListener());
        ImageIcon helpIcon = IconManager.getIcon(IconManager.makeIconName("AppIcon"), IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                if (UIHelper.isLinux()) {
                    Specify.checkForSpecifyAppsRunning();
                }
                if (UIRegistry.isEmbedded().booleanValue()) {
                    SpecifyDBSetupWizardFrame.checkForMySQLProcesses();
                }
                DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider = new DatabaseLoginPanel.MasterPasswordProviderIFace(){

                    @Override
                    public boolean hasMasterUserAndPwdInfo(String username, String password, String dbName) {
                        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                            UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                            boolean result = false;
                            try {
                                try {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                    result = UserAndMasterPasswordMgr.getInstance().hasMasterUsernameAndPassword();
                                }
                                finally {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                }
                            }
                            catch (Exception e) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                                result = false;
                            }
                            return result;
                        }
                        return false;
                    }

                    @Override
                    public Pair<String, String> getUserNamePassword(String username, String password, String dbName) {
                        UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                        Pair<String, String> result = null;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = null;
                        }
                        return result;
                    }

                    @Override
                    public boolean editMasterInfo(String username, String dbName, boolean askFroCredentials) {
                        boolean result = false;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().editMasterInfo(username, dbName, askFroCredentials);
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = false;
                        }
                        return result;
                    }
                };
                if (UIRegistry.isMobile()) {
                    DBConnection.setShutdownUI(new DBConnection.ShutdownUIIFace(){
                        CustomDialog processDlg;

                        @Override
                        public void displayInitialDlg() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    UIRegistry.showLocalizedMsg(1, "MOBILE_INFO", "MOBILE_INTRO", new Object[0]);
                                }
                            });
                        }

                        @Override
                        public void displayFinalShutdownDlg() {
                            this.processDlg.setVisible(false);
                            UIRegistry.showLocalizedMsg(1, "MOBILE_INFO", "MOBILE_FINI", new Object[0]);
                        }

                        @Override
                        public void displayShutdownMsgDlg() {
                            JPanel panel = new JPanel(new BorderLayout());
                            panel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
                            panel.add((Component)new JLabel(IconManager.getIcon(Specify.getLargeIconName()), 0), "West");
                            panel.add((Component)UIHelper.createI18NLabel("MOBILE_SHUTTING_DOWN", 0), "Center");
                            this.processDlg = new CustomDialog(null, "Shutdown", false, 0, (Component)panel);
                            this.processDlg.setAlwaysOnTop(true);
                            UIHelper.centerAndShow(this.processDlg);
                        }
                    });
                }
                String nameAndTitle = "Specify iReport";
                UIRegistry.setRelease(true);
                UIHelper.doLogin(usrPwdProvider, true, false, false, new IReportLauncher(), IconManager.makeIconName("SPIReports"), nameAndTitle, nameAndTitle, IconManager.makeIconName("SpecifyWhite32"), "iReport");
                localPrefs.load();
            }
        });
    }
}

