/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.ireportspecify;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.ireportspecify.MainFrameSpecify;
import edu.ku.brc.ui.UIRegistry;
import it.businesslogic.ireport.gui.MainFrame;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IReportLauncher
implements DatabaseLoginListener {
    protected static MainFrameSpecify iReportMainFrame = null;

    @Override
    public void cancelled() {
        System.exit(0);
    }

    @Override
    public void loggedIn(Window window, String databaseName, String userName) {
        AppPreferences.shutdownRemotePrefs();
        if (window != null) {
            window.setVisible(false);
        }
        AppContextMgr.CONTEXT_STATUS status = AppContextMgr.getInstance().setContext(databaseName, userName, true, true, true);
        SpecifyAppPrefs.initialPrefs();
        if (status == AppContextMgr.CONTEXT_STATUS.OK) {
            if (AppContextMgr.getInstance().getClassObject(Discipline.class) == null) {
                return;
            }
            int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
            SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineeId, DBTableIdMgr.getInstance(), Locale.getDefault());
        } else if (status == AppContextMgr.CONTEXT_STATUS.Error) {
            if (AppContextMgr.getInstance().getClassObject(Collection.class) == null) {
                JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH"), UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH_TITLE"), 0);
            }
            System.exit(0);
        }
        boolean canOpen = true;
        if (AppContextMgr.isSecurityOn()) {
            PermissionSettings permissions = SecurityMgr.getInstance().getPermission("Task.Reports");
            canOpen = permissions.canView();
        }
        if (canOpen) {
            this.openIReportEditor();
        } else {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("IReportLauncher.PERMISSION_DENIED"), UIRegistry.getResourceString("IReportLauncher.PERMISSION_DENIED_TITLE"), 0);
            System.exit(0);
        }
    }

    protected void openIReportEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (iReportMainFrame == null) {
                        MainFrame.reportClassLoader.rescanLibDirectory();
                        Thread.currentThread().setContextClassLoader((ClassLoader)MainFrame.reportClassLoader);
                        iReportMainFrame = new MainFrameSpecify(MainFrameSpecify.getDefaultArgs(), false, false);
                    }
                    iReportMainFrame.refreshSpJRConnections();
                    iReportMainFrame.setVisible(true);
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(IReportLauncher.class, e);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

