/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.export;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.tools.export.ExportPanel;
import edu.ku.brc.specify.tools.ireportspecify.IReportLauncher;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SchemaExportLauncher
implements DatabaseLoginListener {
    @Override
    public void cancelled() {
        System.exit(0);
    }

    @Override
    public void loggedIn(Window window, String databaseName, String userName) {
        AppPreferences.shutdownRemotePrefs();
        if (window != null) {
            window.setVisible(false);
        }
        AppContextMgr.CONTEXT_STATUS status = AppContextMgr.getInstance().setContext(databaseName, userName, true, true, true);
        SpecifyAppPrefs.initialPrefs();
        if (status == AppContextMgr.CONTEXT_STATUS.OK) {
            if (AppContextMgr.getInstance().getClassObject(Discipline.class) == null) {
                return;
            }
            int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
            SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineeId, DBTableIdMgr.getInstance(), Locale.getDefault());
        } else if (status == AppContextMgr.CONTEXT_STATUS.Error) {
            if (AppContextMgr.getInstance().getClassObject(Collection.class) == null) {
                JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH"), UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH_TITLE"), 0);
            }
            System.exit(0);
        }
        boolean canOpen = true;
        if (AppContextMgr.isSecurityOn()) {
            PermissionSettings permissions = SecurityMgr.getInstance().getPermission("Task.ExportMappingTask");
            canOpen = permissions.canView();
        }
        if (canOpen) {
            this.openSchemaExporter();
        } else {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("SchemaExportLauncher.PERMISSION_DENIED"), UIRegistry.getResourceString("SchemaExportLauncher.PERMISSION_DENIED_TITLE"), 0);
            System.exit(0);
        }
    }

    protected void openSchemaExporter() {
        try {
            List<SpExportSchemaMapping> maps;
            block12: {
                TaskMgr.register(new QueryTask(), false);
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                maps = null;
                try {
                    try {
                        maps = session.getDataList(SpExportSchemaMapping.class);
                        Discipline disc = AppContextMgr.getInstance().getClassObject(Discipline.class);
                        int m = maps.size() - 1;
                        while (m >= 0) {
                            SpExportSchemaMapping map = maps.get(m);
                            if (!map.getSpExportSchema().getDiscipline().getId().equals(disc.getId())) {
                                maps.remove(m);
                            } else {
                                map.forceLoad();
                                map.getMappings().iterator().next().getQueryField().getQuery().forceLoad();
                                map.getSpExportSchema().forceLoad();
                            }
                            --m;
                        }
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
                        ex.printStackTrace();
                        System.exit(1);
                        session.close();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    throw throwable;
                }
                session.close();
            }
            if (maps != null) {
                if (maps.size() == 0) {
                    JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("SchemaExportLauncher.NoExportSchemaFound"), UIRegistry.getResourceString("SchemaExportLauncher.NoExportSchemaFoundTitle"), 0);
                    System.exit(0);
                }
                final ExportPanel ep = new ExportPanel(maps);
                final JFrame frame = new JFrame();
                frame.addWindowListener(new WindowListener(){

                    @Override
                    public void windowActivated(WindowEvent arg0) {
                    }

                    @Override
                    public void windowClosed(WindowEvent arg0) {
                        System.exit(0);
                    }

                    @Override
                    public void windowClosing(WindowEvent arg0) {
                        if (ep.close()) {
                            frame.setVisible(false);
                            System.exit(0);
                        }
                    }

                    @Override
                    public void windowDeactivated(WindowEvent arg0) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowIconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowOpened(WindowEvent arg0) {
                    }
                });
                frame.setDefaultCloseOperation(0);
                frame.setTitle(UIRegistry.getResourceString("SchemaExportLauncher.DlgTitle"));
                frame.setContentPane(ep);
                frame.pack();
                frame.setIconImage(IconManager.getImage(IconManager.makeIconName("SpecifyWhite32")).getImage());
                UIHelper.centerAndShow(frame);
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(IReportLauncher.class, e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

