/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.export;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.helpers.XMLHelper;
import org.dom4j.Element;

public class MappedFieldInfo {
    protected final String stringId;
    protected final String fieldName;
    protected final String tableIds;
    protected final boolean isRel;
    protected final boolean isActive;

    public MappedFieldInfo(String stringId, String fieldName, String tableIds, boolean isRel, boolean isActive) {
        this.stringId = stringId;
        this.fieldName = fieldName;
        this.tableIds = tableIds;
        this.isRel = isRel;
        this.isActive = isActive;
    }

    public MappedFieldInfo(String stringId, String fieldName, String tableIds, boolean isRel) {
        this(stringId, fieldName, tableIds, isRel, true);
    }

    public MappedFieldInfo(Element def) {
        this(XMLHelper.getAttr(def, "specify_field", null), XMLHelper.getAttr(def, "fieldname", null), XMLHelper.getAttr(def, "table_path", null), XMLHelper.getAttr(def, "is_relationship", false), XMLHelper.getAttr(def, "active", true));
    }

    public String getStringId() {
        return this.stringId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTableIds() {
        return this.tableIds;
    }

    public boolean isRel() {
        return this.isRel;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String toXML() {
        return "specify_field=\"" + this.stringId + "\" fieldname=\"" + this.fieldName + "\" table_path=\"" + this.tableIds + "\" is_relationship=\"" + (this.isRel ? "true" : "false") + "\" active=\"" + (this.isActive ? "true" : "false") + "\"";
    }

    public Class<?> getDataType() {
        if (this.isRel) {
            return String.class;
        }
        Integer tblId = Integer.valueOf(this.tableIds.substring(this.tableIds.lastIndexOf(",") + 1));
        DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoById(tblId);
        DBFieldInfo fld = tbl.getFieldByName(this.fieldName);
        return fld.getDataClass();
    }

    public int getContextTableId() {
        return Integer.parseInt(this.tableIds.substring(this.tableIds.indexOf(",")));
    }

    public String toString() {
        return "(" + this.stringId + ", " + this.fieldName + ", " + this.tableIds + ", " + this.isRel + ", " + this.isActive + ")";
    }
}

