/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.export;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSource;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceListenerIFace;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;

public class ExportToMySQLDB {
    protected static String getFieldTypeDef(ERTICaptionInfo column) {
        Class<?> dataType;
        DBFieldInfo fld = column.getFieldInfo();
        Class<Object> clazz = column.getColClass() != null ? column.getColClass() : (dataType = fld != null ? fld.getDataClass() : null);
        if (dataType == null && fld == null) {
            return "varchar(256)";
        }
        if (dataType.equals(String.class)) {
            String length = "256";
            if (fld != null && fld.getLength() != -1 && fld.getLength() <= 256) {
                length = String.valueOf(fld.getLength());
            }
            return "varchar(" + length + ")";
        }
        if (dataType.equals(Integer.class) || dataType.equals(Byte.class) || dataType.equals(Short.class) || dataType.equals(Long.class)) {
            return "int";
        }
        if (dataType.equals(Calendar.class)) {
            return "date";
        }
        if (dataType.equals(BigDecimal.class)) {
            return "decimal(13,10)";
        }
        if (dataType.equals(Boolean.class)) {
            return "bit(1)";
        }
        if (dataType.equals(Double.class) || dataType.equals(Float.class)) {
            return "double";
        }
        if (dataType.equals(Timestamp.class)) {
            return "datetime";
        }
        return null;
    }

    protected static String getFieldName(ERTICaptionInfo column) {
        return column.getColLabel();
    }

    public static String fixNameForMySQL(String name) {
        return name.trim().replaceAll(" ", "_").replaceAll("\\.", "_");
    }

    public static String fixTblNameForMySQL(String name) {
        return ExportToMySQLDB.fixNameForMySQL(name).toLowerCase();
    }

    protected static String getFieldDef(ERTICaptionInfo column) {
        return "`" + ExportToMySQLDB.getFieldName(column) + "` " + ExportToMySQLDB.getFieldTypeDef(column);
    }

    protected static String getIdFieldName(String tblName) {
        return String.valueOf(tblName) + "Id";
    }

    protected static void dropTable(Connection toConnection, String tblName) throws Exception {
        Statement stmt = toConnection.createStatement();
        try {
            stmt.execute("drop table " + tblName);
        }
        finally {
            stmt.close();
        }
    }

    public static void createTable(Connection toConnection, List<ERTICaptionInfoQB> columns, String tblName, boolean idColumn) throws Exception {
        Statement stmt = toConnection.createStatement();
        StringBuilder sql = new StringBuilder();
        try {
            sql.append("create table " + tblName + "(");
            if (idColumn) {
                sql.append(String.valueOf(ExportToMySQLDB.getIdFieldName(tblName)) + " int");
            }
            boolean commafy = idColumn;
            for (ERTICaptionInfo eRTICaptionInfo : columns) {
                if (commafy) {
                    sql.append(", ");
                }
                commafy = true;
                sql.append(ExportToMySQLDB.getFieldDef(eRTICaptionInfo));
            }
            sql.append(")");
            sql.append(" CHARSET=utf8");
            stmt.execute(sql.toString());
            String string = "ALTER TABLE " + tblName + " CHANGE COLUMN " + ExportToMySQLDB.getIdFieldName(tblName) + " " + ExportToMySQLDB.getIdFieldName(tblName) + " INT(11) NOT NULL, " + "ADD PRIMARY KEY (" + ExportToMySQLDB.getIdFieldName(tblName) + ")";
            stmt.execute(string);
        }
        finally {
            stmt.close();
        }
    }

    public static boolean tableExists(Connection connection, String tblName) throws Exception {
        Statement stmt = connection.createStatement();
        try {
            stmt.execute("select * from " + tblName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
        finally {
            stmt.close();
        }
    }

    public static long exportToTable(Connection toConnection, List<ERTICaptionInfoQB> columns, QBDataSource rows, String originalTblName, List<QBDataSourceListenerIFace> listeners, boolean idColumnPresent, boolean overwrite, boolean update, int baseTableId, boolean firstPass) throws Exception {
        boolean newTable = false;
        String tblName = ExportToMySQLDB.fixTblNameForMySQL(originalTblName);
        if (firstPass && (overwrite || !ExportToMySQLDB.tableExists(toConnection, tblName))) {
            if (ExportToMySQLDB.tableExists(toConnection, tblName)) {
                ExportToMySQLDB.dropTable(toConnection, tblName);
            }
            ExportToMySQLDB.createTable(toConnection, columns, tblName, idColumnPresent);
            newTable = true;
        }
        if (firstPass && update) {
            DBTableInfo tbl = DBTableIdMgr.getInstance().getInfoById(baseTableId);
            ExportToMySQLDB.deleteDeletedRecs(toConnection, tblName, String.valueOf(tblName) + "Id", tbl.getName(), tbl.getIdColumnName(), AppContextMgr.getInstance().getClassObject(Collection.class).getId());
        }
        if (rows.hasResultSize()) {
            for (QBDataSourceListenerIFace listener : listeners) {
                listener.loaded();
                listener.rowCount(rows.size());
            }
        }
        Statement stmt = toConnection.createStatement();
        try {
            for (QBDataSourceListenerIFace listener : listeners) {
                listener.filling();
            }
            int rowNum = 0;
            while (rows.getNext()) {
                for (QBDataSourceListenerIFace listener : listeners) {
                    listener.currentRow(rowNum++);
                }
                if (update && !newTable) {
                    stmt.execute("delete from " + tblName + " where " + ExportToMySQLDB.getIdFieldName(tblName) + " = " + rows.getFieldValue(0));
                }
                stmt.execute(ExportToMySQLDB.getInsertSql(rows, tblName));
            }
            long l = rowNum;
            return l;
        }
        finally {
            stmt.close();
        }
    }

    public static long exportToTable(List<ERTICaptionInfoQB> columns, QBDataSource rows, String tblName, List<QBDataSourceListenerIFace> listeners, boolean idColumnPresent, boolean overwrite, boolean update, int baseTableId, boolean firstPass) throws Exception {
        return ExportToMySQLDB.exportToTable(DBConnection.getInstance().createConnection(), columns, rows, tblName, listeners, idColumnPresent, overwrite, update, baseTableId, firstPass);
    }

    protected static void deleteDeletedRecs(Connection connection, String tblName, String keyFld, String spTblName, String spKeyFld, int collMemId) throws Exception {
        String sql = "delete from " + tblName + " where " + keyFld + " not in(select " + spKeyFld + " from " + spTblName;
        if (collMemId != -1) {
            sql = String.valueOf(sql) + " where CollectionMemberId = " + collMemId;
        }
        sql = String.valueOf(sql) + ")";
        Statement statement = connection.createStatement();
        statement.execute(sql);
        statement.close();
    }

    protected static String getInsertSql(QBDataSource row, String tblName) {
        StringBuilder result = new StringBuilder();
        result.append("insert into " + tblName + " values(");
        int r = 0;
        while (r < row.getFieldCount()) {
            String val;
            Object valObj;
            if (r > 0) {
                result.append(", ");
            }
            if ((valObj = row.getFieldValue(r)) == null) {
                val = "null";
            } else {
                Object fldVal = row.getFieldValue(r);
                if (fldVal instanceof String) {
                    String fldStr = (String)fldVal;
                    fldVal = fldStr.substring(0, Math.min(fldStr.length(), 256));
                }
                if (StringUtils.isBlank((String)(val = BasicSQLUtils.getStrValue(fldVal)))) {
                    val = "null";
                }
            }
            result.append(val);
            ++r;
        }
        result.append(")");
        return result.toString();
    }

    public static String getSelectForIPTDBSrc(String tblName) {
        String string;
        Connection c;
        block10: {
            c = null;
            Statement s = null;
            try {
                c = DBConnection.getInstance().createConnection();
                s = c.createStatement();
                ResultSet rs = s.executeQuery("select * from " + tblName + " limit 1");
                String result = "select ";
                int col = 1;
                while (col <= rs.getMetaData().getColumnCount()) {
                    if (col > 1) {
                        result = String.valueOf(result) + ", ";
                    }
                    result = String.valueOf(result) + tblName.toLowerCase() + "." + rs.getMetaData().getColumnName(col) + " as \"" + rs.getMetaData().getColumnName(col) + "\"";
                    ++col;
                }
                string = String.valueOf(result) + " from " + tblName.toLowerCase();
                if (s == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    if (c != null) {
                        c.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    UIRegistry.displayErrorDlg(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getLocalizedMessage());
                    return null;
                }
            }
            s.close();
        }
        if (c != null) {
            c.close();
        }
        return string;
    }

    protected static boolean exportRowsToTabDelimitedText(File file, List<String> headers, String tableName) {
        Connection conn = DBConnection.getInstance().createConnection();
        Statement stmt = null;
        FileWriter fw = new FileWriter(file);
        try {
            stmt = conn.createStatement();
            ResultSet rows = stmt.executeQuery("select * from " + tableName);
            String headerLine = "";
            if (headers != null) {
                for (String header : headers) {
                    if (headerLine.length() > 0) {
                        headerLine = String.valueOf(headerLine) + "\t";
                    }
                    headerLine = String.valueOf(headerLine) + header;
                }
            } else {
                int c = 1;
                while (c <= rows.getMetaData().getColumnCount()) {
                    if (headerLine.length() > 0) {
                        headerLine = String.valueOf(headerLine) + "\t";
                    }
                    headerLine = String.valueOf(headerLine) + rows.getMetaData().getColumnName(c);
                    ++c;
                }
            }
            if (headerLine.length() > 0) {
                fw.write(String.valueOf(headerLine) + "\n");
            }
            int lines = 1;
            while (rows.next()) {
                String line = ExportToMySQLDB.getTabDelimLine(rows);
                fw.write(String.valueOf(line) + "\n");
                if (lines++ != 10000) continue;
                fw.flush();
                lines = 0;
            }
            fw.flush();
        }
        catch (Throwable throwable) {
            try {
                fw.close();
                if (stmt != null) {
                    stmt.close();
                }
                conn.close();
                throw throwable;
            }
            catch (Exception ex) {
                UIRegistry.displayErrorDlg(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getLocalizedMessage());
                return false;
            }
        }
        fw.close();
        if (stmt != null) {
            stmt.close();
        }
        conn.close();
        return true;
    }

    protected static String getTabDelimLine(ResultSet rows) throws SQLException {
        StringBuilder result = new StringBuilder();
        int c = 1;
        while (c <= rows.getMetaData().getColumnCount()) {
            String val;
            if (c > 1) {
                result.append("\t");
            }
            if ((val = rows.getString(c)) != null) {
                int type = rows.getMetaData().getColumnType(c);
                if (type == -16 || type == -1 || type == 12 || type == 1 || type == -15) {
                    val = val.replace("\t", " ");
                    val = val.replace("\n", " ");
                    val = val.replace("\r", " ");
                }
                result.append(val);
            }
            ++c;
        }
        return result.toString();
    }

    protected static SwingWorker<Object, Object> exportRowsToTabDelimitedText(final File file, final List<String> headers, final String tableName, final List<QBDataSourceListenerIFace> listeners) {
        SwingWorker<Object, Object> result = new SwingWorker<Object, Object>(){
            boolean success = false;
            long rowCount = -1L;

            @Override
            protected Object doInBackground() throws Exception {
                Connection conn = DBConnection.getInstance().createConnection();
                Statement stmt = null;
                FileWriter fw = new FileWriter(file);
                try {
                    for (QBDataSourceListenerIFace listener : listeners) {
                        listener.loading();
                    }
                    stmt = conn.createStatement();
                    ResultSet rows = stmt.executeQuery("select * from " + tableName);
                    this.rowCount = BasicSQLUtils.getCount(conn, "select count(*) from " + tableName).intValue();
                    for (QBDataSourceListenerIFace listener : listeners) {
                        listener.loaded();
                        listener.rowCount(this.rowCount);
                    }
                    String headerLine = "";
                    if (headers != null) {
                        for (String header : headers) {
                            if (headerLine.length() > 0) {
                                headerLine = String.valueOf(headerLine) + "\t";
                            }
                            headerLine = String.valueOf(headerLine) + header;
                        }
                    } else {
                        int c = 1;
                        while (c <= rows.getMetaData().getColumnCount()) {
                            if (headerLine.length() > 0) {
                                headerLine = String.valueOf(headerLine) + "\t";
                            }
                            headerLine = String.valueOf(headerLine) + rows.getMetaData().getColumnName(c);
                            ++c;
                        }
                    }
                    if (headerLine.length() > 0) {
                        fw.write(String.valueOf(headerLine) + "\n");
                    }
                    long lines = 0L;
                    while (rows.next()) {
                        fw.write(String.valueOf(ExportToMySQLDB.getTabDelimLine(rows)) + "\n");
                        if (lines++ % 1000L != 0L) continue;
                        fw.flush();
                        for (QBDataSourceListenerIFace listener : listeners) {
                            listener.loaded();
                            listener.currentRow(lines);
                        }
                    }
                    fw.flush();
                    this.success = true;
                }
                catch (Throwable throwable) {
                    try {
                        fw.close();
                        if (stmt != null) {
                            stmt.close();
                        }
                        conn.close();
                        throw throwable;
                    }
                    catch (Exception ex) {
                        UIRegistry.displayErrorDlg(String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getLocalizedMessage());
                        this.success = false;
                        return null;
                    }
                }
                fw.close();
                if (stmt != null) {
                    stmt.close();
                }
                conn.close();
                return null;
            }

            @Override
            protected void done() {
                super.done();
                for (QBDataSourceListenerIFace listener : listeners) {
                    listener.done(this.success ? this.rowCount : -1L);
                }
            }
        };
        return result;
    }
}

