/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.export;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.SpExportSchemaItemMapping;
import edu.ku.brc.specify.datamodel.SpExportSchemaMapping;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.dbsupport.PostDeleteEventListener;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.dbsupport.PostUpdateEventListener;
import edu.ku.brc.specify.tasks.ExportMappingTask;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.qb.ERTICaptionInfoQB;
import edu.ku.brc.specify.tasks.subpane.qb.HQLSpecs;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSource;
import edu.ku.brc.specify.tasks.subpane.qb.QBDataSourceListenerIFace;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanel;
import edu.ku.brc.specify.tasks.subpane.qb.QueryParameterPanel;
import edu.ku.brc.specify.tasks.subpane.qb.TableQRI;
import edu.ku.brc.specify.tasks.subpane.qb.TableTree;
import edu.ku.brc.specify.tools.export.ExportToMySQLDB;
import edu.ku.brc.specify.tools.export.SchemaExportLauncher;
import edu.ku.brc.specify.tools.ireportspecify.MainFrameSpecify;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExportPanel
extends JPanel
implements QBDataSourceListenerIFace {
    protected static final Logger log = Logger.getLogger(ExportPanel.class);
    protected static final String EXPORT_TEXT_PATH = "ExportPanel.TabDelimExportPath";
    protected static final long maxExportRowCount = 250000L;
    protected JTable mapsDisplay;
    protected DefaultTableModel mapsModel;
    protected JButton exportToDbTblBtn;
    protected JButton exportToTabDelimBtn;
    protected JButton showIPTSQLBtn;
    protected JButton helpBtn;
    protected JLabel status;
    protected JProgressBar prog;
    protected JPanel progPane;
    protected String itUserName = null;
    protected String itPw = null;
    protected long rowCount = 0L;
    protected long rowsExported = 0L;
    protected long cacheRowCount = 0L;
    protected int mapUpdating = -1;
    protected int stupid = -1;
    protected SwingWorker<Object, Object> updater = null;
    protected SwingWorker<Object, Object> dumper = null;
    protected final List<SpExportSchemaMapping> maps;

    public ExportPanel(List<SpExportSchemaMapping> maps) {
        this.maps = maps;
        this.createUI();
        this.startStatusCalcs();
    }

    protected void startStatusCalcs() {
        int row = 0;
        for (SpExportSchemaMapping map : this.maps) {
            if (this.rebuildForRow(row++)) continue;
            this.getMappingStatus(map);
        }
    }

    public static String getCacheTableName(String mappingName) {
        return ExportToMySQLDB.fixTblNameForMySQL(mappingName);
    }

    public void createUI() {
        this.buildTableModel();
        this.mapsDisplay = new JTable(this.mapsModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.mapsDisplay.setPreferredScrollableViewportSize(this.mapsDisplay.getPreferredSize());
        this.mapsDisplay.getSelectionModel().setSelectionMode(0);
        this.mapsDisplay.getSelectionModel().setSelectionInterval(0, 0);
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.mapsDisplay);
        PanelBuilder tblpb = new PanelBuilder(new FormLayout("2dlu, f:p:g, 2dlu", "5dlu, f:p:g, 5dlu"));
        CellConstraints cc = new CellConstraints();
        tblpb.add((Component)sp, cc.xy(2, 2));
        this.add((Component)tblpb.getPanel(), "Center");
        this.exportToDbTblBtn = UIHelper.createButton(UIRegistry.getResourceString("ExportPanel.ExportToDBTbl"));
        this.exportToDbTblBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = ExportPanel.this.mapsDisplay.getSelectedRow();
                if (row != -1) {
                    ExportPanel.this.mapUpdating = row;
                    ExportPanel.this.stupid = 1;
                    SpExportSchemaMapping map = ExportPanel.this.maps.get(row);
                    boolean reBuildIt = false;
                    if (ExportPanel.this.isUpToDateForRow(row) && !(reBuildIt = UIRegistry.displayConfirmLocalized("ExportPanel.ConfirmForceRebuildTitle", "ExportPanel.ConfirmForceRebuildMsg", "ExportPanel.RebuildBtn", "Cancel", 3))) {
                        return;
                    }
                    if (ExportPanel.this.checkLock(map)) {
                        ExportPanel.this.updater = ExportPanel.this.exportToTable(map, ExportPanel.this.rebuildForRow(row) || reBuildIt);
                        if (ExportPanel.this.updater != null) {
                            ExportPanel.this.updater.execute();
                            ExportPanel.this.exportToDbTblBtn.setEnabled(false);
                            ExportPanel.this.exportToTabDelimBtn.setEnabled(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((CardLayout)(this).ExportPanel.this.progPane.getLayout()).last((this).ExportPanel.this.progPane);
                                }
                            });
                        }
                    }
                } else {
                    UIRegistry.showLocalizedMsg("ExportPanel.PleaseMakeASelection");
                }
            }
        });
        this.exportToTabDelimBtn = UIHelper.createButton(UIRegistry.getResourceString("ExportPanel.ExportTabDelimTxt"));
        this.exportToTabDelimBtn.setToolTipText(UIRegistry.getResourceString("ExportPanel.ExportTabDelimTxtHint"));
        this.exportToTabDelimBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = ExportPanel.this.mapsDisplay.getSelectedRow();
                if (row != -1) {
                    if (!ExportPanel.this.isBuiltForRow(row)) {
                        UIRegistry.displayInfoMsgDlgLocalized("ExportPanel.CacheNotCreated", new Object[0]);
                        return;
                    }
                    AppPreferences localPrefs = AppPreferences.getLocalPrefs();
                    String defPath = localPrefs.get(ExportPanel.EXPORT_TEXT_PATH, null);
                    JFileChooser save = defPath == null ? new JFileChooser() : new JFileChooser(new File(defPath));
                    int result = save.showSaveDialog(null);
                    if (result != 0) {
                        return;
                    }
                    localPrefs.put(ExportPanel.EXPORT_TEXT_PATH, save.getCurrentDirectory().getPath());
                    ExportPanel.this.mapUpdating = row;
                    ExportPanel.this.stupid = 0;
                    SpExportSchemaMapping map = ExportPanel.this.maps.get(row);
                    SpQuery q = map.getMappings().iterator().next().getQueryField().getQuery();
                    Vector<QBDataSourceListenerIFace> ls = new Vector<QBDataSourceListenerIFace>();
                    ls.add(ExportPanel.this);
                    File file = save.getSelectedFile();
                    ExportPanel.this.exportToDbTblBtn.setEnabled(false);
                    ExportPanel.this.exportToTabDelimBtn.setEnabled(false);
                    ExportPanel.this.dumper = ExportToMySQLDB.exportRowsToTabDelimitedText(file, null, ExportPanel.getCacheTableName(q.getName()), ls);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((CardLayout)(this).ExportPanel.this.progPane.getLayout()).last((this).ExportPanel.this.progPane);
                        }
                    });
                    ExportPanel.this.dumper.execute();
                } else {
                    UIRegistry.showLocalizedMsg("ExportPanel.PleaseMakeASelection");
                }
            }
        });
        this.showIPTSQLBtn = UIHelper.createButton(UIRegistry.getResourceString("ExportPanel.ShowSQLBtn"));
        this.showIPTSQLBtn.setToolTipText(UIRegistry.getResourceString("ExportPanel.ShowSQLBtnTT"));
        this.showIPTSQLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = ExportPanel.this.mapsDisplay.getSelectedRow();
                if (row != -1) {
                    if (!ExportPanel.this.isBuiltForRow(row)) {
                        UIRegistry.displayInfoMsgDlgLocalized("ExportPanel.NoSQLForRebuild", new Object[0]);
                    } else {
                        SpExportSchemaMapping map = ExportPanel.this.maps.get(row);
                        String iptSQL = ExportToMySQLDB.getSelectForIPTDBSrc(ExportPanel.getCacheTableName(map.getMappingName()));
                        JTextArea ta = new JTextArea(iptSQL);
                        ta.setLineWrap(true);
                        ta.setColumns(60);
                        ta.setRows(10);
                        ta.selectAll();
                        JScrollPane scrp = new JScrollPane(ta);
                        CustomDialog cd = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("ExportPanel.SQLTitle"), true, scrp);
                        UIHelper.centerAndShow(cd);
                    }
                } else {
                    UIRegistry.showLocalizedMsg("ExportPanel.PleaseMakeASelection");
                }
            }
        });
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, "schema_tool");
        PanelBuilder pbb = new PanelBuilder(new FormLayout("2dlu, f:p:g, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu", "p, p, 7dlu"));
        this.status = new JLabel(UIRegistry.getResourceString("ExportPanel.InitialStatus"));
        this.status.setFont(this.status.getFont().deriveFont(2));
        Dimension pref = this.status.getPreferredSize();
        pref.setSize(Math.max(300.0, pref.getWidth()), pref.getHeight());
        this.status.setPreferredSize(pref);
        pbb.add((Component)this.status, cc.xy(2, 1));
        pbb.add((Component)this.showIPTSQLBtn, cc.xy(3, 1));
        pbb.add((Component)this.exportToTabDelimBtn, cc.xy(7, 1));
        pbb.add((Component)this.exportToDbTblBtn, cc.xy(5, 1));
        pbb.add((Component)this.helpBtn, cc.xy(9, 1));
        this.progPane = new JPanel(new CardLayout());
        this.progPane.add((Component)new JPanel(), "blank");
        this.prog = new JProgressBar();
        this.progPane.add((Component)this.prog, "prog");
        pbb.add((Component)this.progPane, cc.xyw(2, 2, 6));
        this.add((Component)pbb.getPanel(), "South");
        HelpMgr.setAppDefHelpId("schema_tool");
    }

    protected boolean checkLock(SpExportSchemaMapping map) {
        boolean result = ExportMappingTask.checkMappingLock(map);
        return result;
    }

    protected void unlock(int mapUpdatingArg) {
        if (this.mapUpdating != -1) {
            ExportMappingTask.unlockMapping(this.maps.get(mapUpdatingArg));
        }
    }

    protected boolean rebuildForRow(int row) {
        return this.mapsModel.getValueAt(row, 2).toString().equals(UIRegistry.getResourceString("ExportPanel.MappingCacheNeedsBuilding"));
    }

    protected boolean isBuiltForRow(int row) {
        return !this.mapsModel.getValueAt(row, 1).toString().equals(UIRegistry.getResourceString("ExportPanel.Never"));
    }

    protected boolean isUpToDateForRow(int row) {
        return this.mapsModel.getValueAt(row, 2).toString().equals(UIRegistry.getResourceString("ExportPanel.Uptodate"));
    }

    protected String getInitialMapStatusText(SpExportSchemaMapping map) {
        if (this.needsToBeRebuilt(map)) {
            return UIRegistry.getResourceString("ExportPanel.MappingCacheNeedsBuilding");
        }
        return UIRegistry.getResourceString("ExportPanel.CalculatingStatus");
    }

    protected void displayStatusForMap(SpExportSchemaMapping map, MappingUpdateStatus stats) {
        String statsText = stats == null ? UIRegistry.getResourceString("ExportPanel.NeedsUpdating") : (stats.getTotalRecsChanged() == 0L ? UIRegistry.getResourceString("ExportPanel.Uptodate") : String.format(UIRegistry.getResourceString("ExportPanel.OutOfDateRecs"), stats.getTotalRecsChanged()));
        int row = 0;
        while (this.maps.get(row) != map) {
            ++row;
        }
        this.mapsModel.setValueAt(statsText, row, 2);
    }

    protected void buildTableModel() {
        Vector data = new Vector();
        for (SpExportSchemaMapping map : this.maps) {
            Vector<String> row = new Vector<String>(3);
            row.add(map.getMappingName());
            row.add(map.getTimestampExported() != null ? map.getTimestampExported().toString() : UIRegistry.getResourceString("ExportPanel.Never"));
            row.add(this.getInitialMapStatusText(map));
            data.add(row);
        }
        Vector<String> headers = new Vector<String>();
        headers.add(UIRegistry.getResourceString("ExportPanel.MappingTitle"));
        headers.add(UIRegistry.getResourceString("ExportPanel.MappingExportTimeTitle"));
        headers.add(UIRegistry.getResourceString("ExportPanel.Status"));
        this.mapsModel = new DefaultTableModel(data, headers);
    }

    public boolean close() {
        if (this.updater != null || this.dumper != null) {
            boolean result = UIRegistry.displayConfirmLocalized("ExportPanel.CancelExportTitle", "ExportPanel.CancelConfirmMsg", "YES", "NO", 3);
            if (result) {
                if (this.updater != null && !this.updater.isCancelled() && !this.updater.isDone()) {
                    this.updater.cancel(true);
                } else if (this.dumper != null && !this.dumper.isCancelled() && !this.dumper.isDone()) {
                    this.dumper.cancel(true);
                }
            }
            return result;
        }
        return true;
    }

    protected int getNumberColumnsInCache(SpExportSchemaMapping map) {
        int n;
        Connection conn = DBConnection.getInstance().createConnection();
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("select * from " + ExportPanel.getCacheTableName(map.getMappingName()) + " limit 1");
            int result = rs.getMetaData().getColumnCount();
            rs.close();
            n = result;
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                conn.close();
                throw throwable;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ExportPanel.class, ex);
                throw new RuntimeException(ex);
            }
        }
        stmt.close();
        conn.close();
        return n;
    }

    protected boolean needsToBeRebuilt(SpExportSchemaMapping map) {
        if (map.getTimestampExported() != null) {
            if (this.getNumberColumnsInCache(map) - 1 != map.getMappings().size()) {
                return true;
            }
            for (SpExportSchemaItemMapping im : map.getMappings()) {
                if (im.getTimestampCreated().compareTo(map.getTimestampExported()) > 0) {
                    return true;
                }
                if (im.getTimestampModified() == null || im.getTimestampModified().compareTo(map.getTimestampExported()) <= 0) continue;
                return true;
            }
            SpQuery q = map.getMappings().iterator().next().getQueryField().getQuery();
            if (q.getTimestampCreated().compareTo(map.getTimestampExported()) > 0) {
                return true;
            }
            if (q.getTimestampModified() != null && q.getTimestampModified().compareTo(map.getTimestampExported()) > 0) {
                return true;
            }
            for (SpQueryField qf : q.getFields()) {
                if (qf.getTimestampCreated().compareTo(map.getTimestampExported()) > 0) {
                    return true;
                }
                if (qf.getTimestampModified() == null || qf.getTimestampModified().compareTo(map.getTimestampExported()) <= 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected List<Specs> getSpecs(SpExportSchemaMapping theMapping, boolean includeRecordIds, boolean getColInfo, boolean rebuildExistingTbl) {
        UsageTracker.incrUsageCount("SchemaExport.ExportToTable");
        QueryTask qt = (QueryTask)ContextMgr.getTaskByClass(QueryTask.class);
        if (qt == null) {
            log.error((Object)"Cound not find the Query task when exporting mapping");
            throw new RuntimeException("Cound not find the Query task when exporting mapping");
        }
        Pair<TableTree, Hashtable<String, TableTree>> trees = qt.getTableTrees();
        TableTree tblTree = trees.getFirst();
        Hashtable<String, TableTree> ttHash = trees.getSecond();
        TableQRI rootQRI = null;
        Vector<ExportPanel> dataSrcListeners = new Vector<ExportPanel>();
        dataSrcListeners.add(this);
        SpQuery exportQuery = theMapping.getMappings().iterator().next().getQueryField().getQuery();
        short cId = exportQuery.getContextTableId();
        for (TableTree tt : ttHash.values()) {
            if (cId != tt.getTableInfo().getTableId()) continue;
            rootQRI = tt.getTableQRI();
            break;
        }
        QueryParameterPanel qpp = new QueryParameterPanel();
        qpp.setQuery(exportQuery, tblTree, ttHash, false);
        Vector<QueryFieldPanel> qfps = QueryBldrPane.getQueryFieldPanelsForMapping(qpp, exportQuery.getFields(), tblTree, ttHash, null, theMapping, null, null);
        HQLSpecs sql = null;
        String uniquenessHQL = null;
        HQLSpecs uniquenessSql = null;
        try {
            sql = QueryBldrPane.buildHQL(rootQRI, !includeRecordIds, qfps, tblTree, null, exportQuery.getSearchSynonymy() == null ? false : exportQuery.getSearchSynonymy(), true, rebuildExistingTbl ? null : theMapping.getTimestampExported());
            if (theMapping.getTimestampExported() != null && !rebuildExistingTbl) {
                uniquenessSql = QueryBldrPane.buildHQL(rootQRI, !includeRecordIds, qfps, tblTree, null, exportQuery.getSearchSynonymy() == null ? false : exportQuery.getSearchSynonymy(), true, null);
                uniquenessHQL = uniquenessSql.getHql();
            } else {
                uniquenessHQL = sql.getHql();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ex.printStackTrace();
            ExceptionTracker.getInstance().capture(QueryBldrPane.class, ex);
            UIRegistry.getStatusBar().setErrorMessage(ex.getLocalizedMessage(), ex);
            return null;
        }
        List<ERTICaptionInfoQB> cols = getColInfo ? QueryBldrPane.getColumnInfo(qfps, false, rootQRI.getTableInfo(), true) : null;
        ArrayList<Specs> result = new ArrayList<Specs>();
        result.add(new Specs(sql, cols, uniquenessHQL, uniquenessSql));
        return result;
    }

    protected SwingWorker<Object, Object> exportToTable(final SpExportSchemaMapping theMapping, final boolean rebuildExistingTbl) {
        UsageTracker.incrUsageCount("SchemaExport.ExportToTable");
        final SpQuery exportQuery = theMapping.getMappings().iterator().next().getQueryField().getQuery();
        final Vector<ExportPanel> dataSrcListeners = new Vector<ExportPanel>();
        dataSrcListeners.add(this);
        Pair<String, String> it = null;
        if (rebuildExistingTbl && (it = DatabaseLoginPanel.getITUsernamePwd()) == null) {
            return null;
        }
        boolean includeRecordIds = true;
        List<Specs> specs = this.getSpecs(theMapping, true, true, rebuildExistingTbl);
        if (specs == null) {
            return null;
        }
        final List<ERTICaptionInfoQB> cols = specs.get(0).getCols();
        final HQLSpecs hql = specs.get(0).getSpecs();
        final String uniquenessHql = specs.get(0).getUniquenessHQL();
        final HQLSpecs uniquenessSpecs = specs.get(0).getUniquenessSpecs();
        final DBConnection itDbConn = !rebuildExistingTbl ? null : this.getItDBConnection(it);
        final Connection conn = !rebuildExistingTbl ? DBConnection.getInstance().getConnection() : itDbConn.getConnection();
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
            private Exception killer = null;
            private boolean success = false;

            @Override
            protected Object doInBackground() throws Exception {
                Pair<Boolean, Long> ucheck;
                block11: {
                    ucheck = QueryBldrPane.checkUniqueRecIds(uniquenessHql, uniquenessSpecs.getArgs());
                    if (ucheck.getFirst().booleanValue()) break block11;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("ExportPanel.DUPLICATE_KEYS_EXPORT"));
                        }
                    });
                    return null;
                }
                try {
                    ExportPanel.this.cacheRowCount = ucheck.getSecond() - ExportPanel.this.rowsExported;
                    boolean rebuild = rebuildExistingTbl;
                    boolean firstPass = true;
                    Connection loopConn = conn;
                    while (ExportPanel.this.rowsExported < ExportPanel.this.cacheRowCount) {
                        QBDataSource src = new QBDataSource(hql.getHql(), hql.getArgs(), hql.getSortElements(), cols, true);
                        for (QBDataSourceListenerIFace l : dataSrcListeners) {
                            src.addListener(l);
                        }
                        src.setFirstResult(ExportPanel.this.rowsExported);
                        src.setMaxResults(250000L);
                        src.startDataAcquisition();
                        ExportPanel.this.loading();
                        ExportPanel.this.rowsExported = ExportPanel.this.rowsExported + ExportToMySQLDB.exportToTable(loopConn, cols, src, exportQuery.getName(), dataSrcListeners, true, rebuild, !rebuildExistingTbl, 1, firstPass);
                        rebuild = false;
                        firstPass = false;
                    }
                    boolean transOpen = false;
                    DataProviderSessionIFace theSession = DataProviderFactory.getInstance().createSession();
                    try {
                        try {
                            SpExportSchemaMapping mergedMap = theSession.merge(theMapping);
                            mergedMap.setTimestampExported(new Timestamp(System.currentTimeMillis()));
                            theSession.beginTransaction();
                            transOpen = true;
                            theSession.saveOrUpdate(mergedMap);
                            theSession.commit();
                            transOpen = false;
                        }
                        catch (Exception ex) {
                            if (transOpen) {
                                theSession.rollback();
                            }
                            throw ex;
                        }
                    }
                    finally {
                        theSession.close();
                    }
                    this.success = true;
                }
                catch (Exception ex) {
                    this.killer = ex;
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.success) {
                    for (QBDataSourceListenerIFace listener : dataSrcListeners) {
                        listener.done(ExportPanel.this.rowsExported);
                    }
                } else {
                    String msg = UIRegistry.getResourceString("ExportPanel.UpdateFailMsg");
                    if (this.killer != null) {
                        this.killer.printStackTrace();
                        msg = String.valueOf(msg) + " Error: " + this.killer.getClass().getSimpleName();
                        if (StringUtils.isNotBlank((String)this.killer.getLocalizedMessage())) {
                            msg = String.valueOf(msg) + " (" + this.killer.getLocalizedMessage() + ")";
                        }
                    } else {
                        msg = String.valueOf(msg) + ".";
                    }
                    UIRegistry.displayErrorDlg(msg);
                    for (QBDataSourceListenerIFace l : dataSrcListeners) {
                        l.done(-1L);
                    }
                }
                if (itDbConn != null) {
                    itDbConn.close();
                }
            }
        };
        return worker;
    }

    protected DBConnection getItDBConnection(Pair<String, String> it) {
        DBConnection dbc = DBConnection.getInstance();
        return DBConnection.createInstance(dbc.getDriver(), dbc.getDialect(), dbc.getDatabaseName(), dbc.getConnectionStr(), it.getFirst(), it.getSecond());
    }

    @Override
    public void currentRow(final long currentRow) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportPanel.this.prog.setValue((int)currentRow);
            }
        });
    }

    @Override
    public void done(long rows) {
        if (rows != -1L && this.rowsExported + rows < this.cacheRowCount) {
            this.prog.setValue(0);
            return;
        }
        this.unlock(this.mapUpdating);
        if (rows == -1L || this.stupid == 0 && this.mapUpdating != -1) {
            final long frows = rows;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ExportPanel.this.updater != null) {
                        if (frows != -1L) {
                            UIRegistry.displayInfoMsgDlgLocalized("ExportPanel.UpdateSuccess", new Object[0]);
                            ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.CacheUpdated"));
                        } else {
                            UIRegistry.displayInfoMsgDlgLocalized("ExportPanel.UpdateFailMsg", new Object[0]);
                            ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.UpdateFail"));
                        }
                    } else if (frows != -1L) {
                        ExportPanel.this.status.setText(String.format(UIRegistry.getResourceString("ExportPanel.ExportDone"), ExportPanel.this.rowCount));
                    } else {
                        UIRegistry.displayInfoMsgDlgLocalized("ExportPanel.ExportFailMsg", new Object[0]);
                        ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.ExportFail"));
                    }
                    if (ExportPanel.this.updater != null && frows != -1L) {
                        ExportPanel.this.refreshUpdatedMapDisplay(ExportPanel.this.mapUpdating);
                    }
                    ((CardLayout)ExportPanel.this.progPane.getLayout()).first(ExportPanel.this.progPane);
                    ExportPanel.this.prog.setValue(0);
                    ExportPanel.this.exportToDbTblBtn.setEnabled(true);
                    ExportPanel.this.exportToTabDelimBtn.setEnabled(true);
                    ExportPanel.this.mapUpdating = -1;
                    ExportPanel.this.updater = null;
                    ExportPanel.this.dumper = null;
                }
            });
        }
        --this.stupid;
    }

    protected void refreshUpdatedMapDisplay(int mapToRefresh) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            SpExportSchemaMapping newMap = session.get(SpExportSchemaMapping.class, this.maps.get(mapToRefresh).getId());
            newMap.forceLoad();
            newMap.getMappings().iterator().next().getQueryField().getQuery().forceLoad();
            newMap.getSpExportSchema().forceLoad();
            this.maps.set(mapToRefresh, newMap);
        }
        finally {
            session.close();
        }
        this.mapsModel.setValueAt(this.maps.get(mapToRefresh).getTimestampExported().toString(), mapToRefresh, 1);
        this.mapsModel.setValueAt(UIRegistry.getResourceString("ExportPanel.Uptodate"), mapToRefresh, 2);
    }

    @Override
    public void filling() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ExportPanel.this.rowCount > 0L && ExportPanel.this.prog.isIndeterminate()) {
                    ExportPanel.this.prog.setIndeterminate(false);
                    ExportPanel.this.prog.setValue(0);
                }
                if (ExportPanel.this.rowCount < ExportPanel.this.cacheRowCount) {
                    ExportPanel.this.status.setText(String.format(UIRegistry.getResourceString("ExportPanel.UpdatingCacheChunk"), ExportPanel.this.rowsExported + 1L, ExportPanel.this.rowsExported + ExportPanel.this.rowCount, ExportPanel.this.cacheRowCount));
                } else {
                    ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.UpdatingCache"));
                }
            }
        });
    }

    @Override
    public void loaded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportPanel.this.prog.setIndeterminate(false);
                ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.DataRetrieved"));
            }
        });
    }

    @Override
    public void loading() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportPanel.this.prog.setIndeterminate(true);
                ExportPanel.this.status.setText(UIRegistry.getResourceString("ExportPanel.RetrievingData"));
            }
        });
    }

    @Override
    public void rowCount(final long rowCountArg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rowCountArg > 0L) {
                    ExportPanel.this.prog.setIndeterminate(false);
                    ExportPanel.this.prog.setMinimum(0);
                    ExportPanel.this.prog.setMaximum((int)rowCountArg - 1);
                }
                ExportPanel.this.rowCount = rowCountArg;
            }
        });
    }

    protected void getMappingStatus(final SpExportSchemaMapping map) {
        SwingWorker<MappingUpdateStatus, Object> worker = new SwingWorker<MappingUpdateStatus, Object>(){

            @Override
            protected MappingUpdateStatus doInBackground() throws Exception {
                MappingUpdateStatus mappingUpdateStatus;
                Connection conn = DBConnection.getInstance().createConnection();
                Statement stmt = conn.createStatement();
                try {
                    MappingUpdateStatus result = null;
                    String tbl = ExportPanel.getCacheTableName(map.getMappingName());
                    String keyFld = String.valueOf(tbl) + "Id";
                    SpQuery q = map.getMappings().iterator().next().getQueryField().getQuery();
                    DBTableInfo rootTbl = DBTableIdMgr.getInstance().getInfoById(q.getContextTableId().shortValue());
                    String spTbl = rootTbl.getName();
                    String spKeyFld = rootTbl.getIdColumnName();
                    String sql = "select count(*) from " + tbl + " where " + keyFld + " not in(select " + spKeyFld + " from " + spTbl;
                    if (rootTbl.getFieldByName("collectionMemberId") != null) {
                        sql = String.valueOf(sql) + " where CollectionMemberId = " + AppContextMgr.getInstance().getClassObject(Collection.class).getId();
                    }
                    sql = String.valueOf(sql) + ")";
                    int deletedRecs = BasicSQLUtils.getCountAsInt(conn, sql);
                    int otherRecs = 0;
                    HQLSpecs hql = ExportPanel.this.getSpecs(map, true, false, false).get(0).getSpecs();
                    DataProviderSessionIFace theSession = DataProviderFactory.getInstance().createSession();
                    try {
                        DataProviderSessionIFace.QueryIFace query = theSession.createQuery(hql.getHql(), false);
                        if (hql.getArgs() != null) {
                            for (Pair<String, Object> param : hql.getArgs()) {
                                query.setParameter(param.getFirst(), param.getSecond());
                            }
                        }
                        otherRecs = query.list().size();
                    }
                    finally {
                        theSession.close();
                    }
                    mappingUpdateStatus = result = new MappingUpdateStatus(deletedRecs, 0L, 0L, deletedRecs + otherRecs);
                }
                catch (Throwable throwable) {
                    try {
                        stmt.close();
                        conn.close();
                        throw throwable;
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ExportPanel.class, ex);
                        throw new RuntimeException(ex);
                    }
                }
                stmt.close();
                conn.close();
                return mappingUpdateStatus;
            }

            @Override
            protected void done() {
                super.done();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExportPanel.this.displayStatusForMap(map, (MappingUpdateStatus)this.get());
                        }
                        catch (Exception ex) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(ExportPanel.class, ex);
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        UIRegistry.setAppName("Specify");
        AppBase.processArgs(args);
        AppBase.setupTeeForStdErrStdOut(true, false);
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFaceGlobal", "edu.ku.brc.specify.config.AppPrefsGlobalDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
        final AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        ExportPanel.adjustLocaleFromPrefs();
        final String iRepPrefDir = localPrefs.getDirPath();
        int mark = iRepPrefDir.lastIndexOf(UIRegistry.getAppName(), iRepPrefDir.length());
        final String SpPrefDir = String.valueOf(iRepPrefDir.substring(0, mark)) + "Specify";
        HibernateUtil.setListener("post-commit-update", new PostUpdateEventListener());
        HibernateUtil.setListener("post-commit-insert", new PostInsertEventListener());
        HibernateUtil.setListener("post-commit-delete", new PostDeleteEventListener());
        ImageIcon helpIcon = IconManager.getIcon(Specify.getIconName(), IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ExportPanel.class, e);
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider = new DatabaseLoginPanel.MasterPasswordProviderIFace(){

                    @Override
                    public boolean hasMasterUserAndPwdInfo(String username, String password, String dbName) {
                        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                            UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                            boolean result = false;
                            try {
                                try {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                    result = UserAndMasterPasswordMgr.getInstance().hasMasterUsernameAndPassword();
                                }
                                finally {
                                    AppPreferences.getLocalPrefs().flush();
                                    AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                    AppPreferences.getLocalPrefs().setProperties(null);
                                }
                            }
                            catch (Exception e) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                                result = false;
                            }
                            return result;
                        }
                        return false;
                    }

                    @Override
                    public Pair<String, String> getUserNamePassword(String username, String password, String dbName) {
                        UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                        Pair<String, String> result = null;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = null;
                        }
                        return result;
                    }

                    @Override
                    public boolean editMasterInfo(String username, String dbName, boolean askFroCredentials) {
                        boolean result = false;
                        try {
                            try {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(SpPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                                result = UserAndMasterPasswordMgr.getInstance().editMasterInfo(username, dbName, askFroCredentials);
                            }
                            finally {
                                AppPreferences.getLocalPrefs().flush();
                                AppPreferences.getLocalPrefs().setDirPath(iRepPrefDir);
                                AppPreferences.getLocalPrefs().setProperties(null);
                            }
                        }
                        catch (Exception e) {
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, e);
                            result = false;
                        }
                        return result;
                    }
                };
                String nameAndTitle = UIRegistry.getResourceString("SchemaExportLauncher.DlgTitle");
                UIRegistry.setRelease(true);
                UIHelper.doLogin(usrPwdProvider, true, false, false, new SchemaExportLauncher(), Specify.getLargeIconName(), nameAndTitle, nameAndTitle, "SpecifyWhite32", "login");
                localPrefs.load();
            }
        });
    }

    protected static void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", null);
            String variant = AppPreferences.getLocalPrefs().get("locale.var", null);
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(MainFrameSpecify.class, ex);
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }

    public class MappingUpdateStatus {
        protected final long recsToDelete;
        protected final long recsUpdated;
        protected final long recsAdded;
        protected final long totalRecsChanged;

        public MappingUpdateStatus(long recsToDelete, long recsUpdated, long recsAdded, long totalRecsChanged) {
            this.recsToDelete = recsToDelete;
            this.recsUpdated = recsUpdated;
            this.recsAdded = recsAdded;
            this.totalRecsChanged = totalRecsChanged;
        }

        public long getRecsToDelete() {
            return this.recsToDelete;
        }

        public long getRecsUpdated() {
            return this.recsUpdated;
        }

        public long getRecsAdded() {
            return this.recsAdded;
        }

        public long getTotalRecsChanged() {
            return this.totalRecsChanged;
        }
    }

    private class Specs {
        protected final HQLSpecs specs;
        protected final List<ERTICaptionInfoQB> cols;
        protected final String uniquenessHQL;
        protected final HQLSpecs uniquenessSpecs;

        public Specs(HQLSpecs specs, List<ERTICaptionInfoQB> cols, String uniquenessHQL, HQLSpecs uniquenessSpecs) {
            this.specs = specs;
            this.cols = cols;
            this.uniquenessHQL = uniquenessHQL;
            this.uniquenessSpecs = uniquenessSpecs;
        }

        public HQLSpecs getSpecs() {
            return this.specs;
        }

        public List<ERTICaptionInfoQB> getCols() {
            return this.cols;
        }

        public String getUniquenessHQL() {
            return this.uniquenessHQL;
        }

        public HQLSpecs getUniquenessSpecs() {
            return this.uniquenessSpecs == null ? this.specs : this.uniquenessSpecs;
        }
    }
}

