/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.datamodelgenerator;

import edu.ku.brc.specify.tools.datamodelgenerator.Display;
import edu.ku.brc.specify.tools.datamodelgenerator.Field;
import edu.ku.brc.specify.tools.datamodelgenerator.FieldAlias;
import edu.ku.brc.specify.tools.datamodelgenerator.Id;
import edu.ku.brc.specify.tools.datamodelgenerator.Relationship;
import edu.ku.brc.specify.tools.datamodelgenerator.TableIndex;
import edu.ku.brc.specify.tools.schemalocale.LocalizedStrIFace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Table
implements Comparable<Table> {
    private String name;
    private String table;
    private String lazy;
    private String tableId;
    private boolean searchable;
    private String businessRule;
    private String abbrv;
    private List<Field> fields = new ArrayList<Field>();
    private List<Id> ids = new ArrayList<Id>();
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private Display display;
    private List<FieldAlias> fieldAliases = new ArrayList<FieldAlias>();
    private LocalizedStrIFace desc;
    private LocalizedStrIFace nameDesc;
    private Vector<TableIndex> indexes = new Vector();
    private HashMap<String, Boolean> likeManyToOneHash = null;

    public Table(String name, String table, String lazy, String tableId, Display display, List<FieldAlias> fieldAliases, boolean searchable, String businessRule, String abbrv) {
        this.name = name;
        this.table = table;
        this.lazy = lazy;
        this.tableId = tableId;
        this.display = display;
        this.fieldAliases = fieldAliases;
        this.searchable = searchable;
        this.businessRule = businessRule;
        this.abbrv = abbrv;
    }

    public String getLazy() {
        return this.lazy;
    }

    public void setLazy(String lazy) {
        this.lazy = lazy;
    }

    public String getName() {
        return this.name;
    }

    public String getTableId() {
        return this.tableId;
    }

    protected String createShortName(String nameArg) {
        int inx = nameArg.lastIndexOf(46);
        if (inx != -1) {
            return nameArg.substring(inx + 1, nameArg.length());
        }
        return nameArg;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void addField(Field aField) {
        this.fields.add(aField);
    }

    public void addRelationship(Relationship rel) {
        this.relationships.add(rel);
    }

    public void addId(Id anId) {
        this.ids.add(anId);
    }

    public Collection<Field> getFields() {
        Collections.sort(this.fields);
        return this.fields;
    }

    public Collection<Id> getIds() {
        return this.ids;
    }

    public Collection<Relationship> getRelationships() {
        Collections.sort(this.relationships);
        return this.relationships;
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean getSearchable() {
        return this.searchable;
    }

    public String getBusinessRule() {
        return this.businessRule;
    }

    public Vector<TableIndex> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Vector<TableIndex> indexes) {
        this.indexes = indexes;
    }

    public LocalizedStrIFace getDesc() {
        return this.desc;
    }

    public void setDesc(LocalizedStrIFace desc) {
        this.desc = desc;
    }

    public void updateIndexFields() {
        Collections.sort(this.fields);
        for (TableIndex ti : this.indexes) {
            String[] stringArray = ti.getColumnNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                for (Field f : this.fields) {
                    if (!f.getColumn().equals(columnName)) continue;
                    f.setIndexName(ti.getIndexName());
                    break;
                }
                ++n2;
            }
        }
    }

    public String getAbbrv() {
        return this.abbrv;
    }

    public void setAbbrv(String abbrv) {
        this.abbrv = abbrv;
    }

    public void setNameDesc(LocalizedStrIFace nameDesc) {
        this.nameDesc = nameDesc;
    }

    public LocalizedStrIFace getNameDesc() {
        return this.nameDesc;
    }

    public List<FieldAlias> getFieldAliases() {
        return this.fieldAliases;
    }

    public void setFieldAliases(List<FieldAlias> fieldAliases) {
        this.fieldAliases = fieldAliases;
    }

    public boolean getIsLikeManyToOne(String relName) {
        if (this.likeManyToOneHash != null) {
            Boolean isLike = this.likeManyToOneHash.get(relName);
            return isLike != null ? isLike : false;
        }
        return false;
    }

    public void setLikeManyToOneHash(HashMap<String, Boolean> likeManyToOneHash) {
        this.likeManyToOneHash = likeManyToOneHash;
    }

    @Override
    public int compareTo(Table obj) {
        if (obj == null) {
            return 0;
        }
        return this.name.compareTo(obj.name);
    }
}

