/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.datamodelgenerator;

import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.tools.datamodelgenerator.Desc;
import edu.ku.brc.specify.tools.datamodelgenerator.Display;
import edu.ku.brc.specify.tools.datamodelgenerator.Field;
import edu.ku.brc.specify.tools.datamodelgenerator.FieldAlias;
import edu.ku.brc.specify.tools.datamodelgenerator.Id;
import edu.ku.brc.specify.tools.datamodelgenerator.Name;
import edu.ku.brc.specify.tools.datamodelgenerator.Relationship;
import edu.ku.brc.specify.tools.datamodelgenerator.Table;
import edu.ku.brc.specify.tools.datamodelgenerator.TableIndex;
import edu.ku.brc.specify.tools.datamodelgenerator.TableMetaData;
import edu.ku.brc.specify.tools.schemalocale.LocalizableContainerIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableItemIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizableStrIFace;
import edu.ku.brc.specify.tools.schemalocale.LocalizerBasePanel;
import edu.ku.brc.specify.tools.schemalocale.SchemaLocalizerXMLHelper;
import edu.ku.brc.util.DatamodelHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

public class DatamodelGenerator {
    private static final Logger log = Logger.getLogger(DatamodelGenerator.class);
    protected static final boolean DEBUG = false;
    protected Hashtable<String, TableMetaData> tblMetaDataHash = new Hashtable();
    protected File srcCodeDir = null;
    protected String packageName = null;
    protected int missing = 0;
    protected SchemaLocalizerXMLHelper schemaLocalizer = null;
    protected Hashtable<String, String> abbrvHash = new Hashtable();
    protected boolean includeDesc = false;
    protected boolean doRelsToZeroToOne = true;
    protected boolean doPT = true;
    protected boolean showDescErrors = false;
    protected boolean showDebug = false;

    public DatamodelGenerator(boolean includeDesc) {
        this.includeDesc = includeDesc;
        this.readDescriptions();
    }

    protected void readDescriptions() {
        if (this.includeDesc) {
            if (this.doPT) {
                SchemaI18NService.setCurrentLocale(new Locale("pt", "", ""));
            }
            this.schemaLocalizer = new SchemaLocalizerXMLHelper(SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance());
            this.includeDesc = this.schemaLocalizer.load(true);
        }
    }

    protected Desc getTableDesc(String tableName) {
        LocalizableContainerIFace container = this.schemaLocalizer.getContainer(tableName);
        if (container != null) {
            LocalizableStrIFace d = LocalizerBasePanel.getDescForCurrLocale(container);
            if (d != null) {
                Desc desc = new Desc(d.getText(), d.getCountry(), d.getLanguage(), d.getVariant());
                return desc;
            }
            if (this.showDescErrors) {
                log.error((Object)("No Desc for Table[" + tableName + "]"));
            }
        } else {
            log.error((Object)("No Table[" + tableName + "]"));
        }
        return null;
    }

    protected Name getTableNameDesc(String tableName) {
        LocalizableContainerIFace container = this.schemaLocalizer.getContainer(tableName);
        if (container != null) {
            LocalizableStrIFace dn = LocalizerBasePanel.getNameDescForCurrLocale(container);
            if (dn != null) {
                Name nm = new Name(dn.getText(), dn.getCountry(), dn.getLanguage(), dn.getVariant());
                return nm;
            }
            log.error((Object)("No NameDesc for [" + tableName + "]"));
        } else {
            log.error((Object)("No Table[" + tableName + "]"));
        }
        return null;
    }

    protected Desc getFieldDesc(String tableName, String fieldName) {
        LocalizableContainerIFace container = this.schemaLocalizer.getContainer(tableName);
        if (container != null) {
            LocalizableItemIFace item = container.getItemByName(fieldName);
            if (item != null) {
                LocalizableStrIFace d = LocalizerBasePanel.getDescForCurrLocale(item);
                if (d != null) {
                    Desc desc = new Desc(d.getText(), d.getCountry(), d.getLanguage(), d.getVariant());
                    return desc;
                }
                if (this.showDescErrors) {
                    log.error((Object)("No Desc for [" + tableName + "] Field[" + fieldName + "]"));
                }
            } else {
                log.error((Object)("No Field [" + tableName + "] Field[" + fieldName + "]"));
            }
        } else {
            log.error((Object)("No Table[" + tableName + "] Field[" + fieldName + "]"));
        }
        return null;
    }

    protected Name getFieldNameDesc(String tableName, String fieldName) {
        LocalizableContainerIFace container = this.schemaLocalizer.getContainer(tableName);
        if (container != null) {
            LocalizableItemIFace item = container.getItemByName(fieldName);
            if (item != null) {
                LocalizableStrIFace dn = LocalizerBasePanel.getNameDescForCurrLocale(item);
                if (dn != null) {
                    Name nm = new Name(dn.getText(), dn.getCountry(), dn.getLanguage(), dn.getVariant());
                    return nm;
                }
                log.error((Object)("No Name for [" + tableName + "] Field[" + fieldName + "]"));
            } else {
                log.error((Object)("No Field [" + tableName + "] Field[" + fieldName + "]"));
            }
        } else {
            log.error((Object)("No Table[" + tableName + "] Field[" + fieldName + "]"));
        }
        return null;
    }

    private Display createDisplay(Element element) {
        Element fdElement;
        if (element != null && (fdElement = (Element)element.selectSingleNode("display")) != null) {
            return new Display(fdElement.attributeValue("view"), fdElement.attributeValue("dataobjformatter"), fdElement.attributeValue("uiformatter"), fdElement.attributeValue("searchdlg"), fdElement.attributeValue("newobjdlg"));
        }
        return null;
    }

    private Vector<FieldAlias> createFieldAliases(Element element) {
        if (element != null) {
            Vector<FieldAlias> aliases = new Vector<FieldAlias>();
            List items = element.selectNodes("fieldaliases/field");
            if (items.size() > 0) {
                for (Element faItem : items) {
                    FieldAlias fa = new FieldAlias(XMLHelper.getAttr(faItem, "vname", null), XMLHelper.getAttr(faItem, "aname", null));
                    aliases.add(fa);
                }
                return aliases;
            }
        }
        return null;
    }

    private Table createTable(String className, String tableName) {
        log.info((Object)("Processing: " + className));
        TableMetaData tableMetaData = this.tblMetaDataHash.get(className);
        if (tableMetaData == null) {
            log.error((Object)("Could not retrieve TableMetaData from tblMetaDataHashtable for table: " + className));
            throw new RuntimeException("Could not retrieve TableMetaData from tblMetaDataHashtable for table: " + className + " check to see if table is listed in the file: " + DatamodelHelper.getTableIdFilePath());
        }
        Table tbl = new Table(className, tableName, null, tableMetaData.getId(), tableMetaData.getDisplay(), tableMetaData.getFieldAliase(), tableMetaData.isSearchable(), tableMetaData.getBusinessRule(), tableMetaData.getAbbrv());
        tbl.setLikeManyToOneHash(tableMetaData.getLikeManyToOneHash());
        return tbl;
    }

    protected String getReturnType(Method method) {
        ParameterizedType type;
        Type[] typeArray;
        Class<?> classObj = method.getReturnType();
        if (classObj == Set.class && (typeArray = (type = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 0) {
            Type t = typeArray[0];
            String cls = t.toString();
            return cls.substring(6, cls.length());
        }
        return classObj.getName();
    }

    protected String getNameFromMethod(Method method) {
        String name = method.getName();
        name = String.valueOf(name.substring(3, 4).toLowerCase()) + name.substring(4, name.length());
        return name;
    }

    public Relationship createRelationship(Method method, String type, JoinColumn joinCol, String otherSideName, boolean isRequired) {
        Relationship rel = new Relationship(type, this.getReturnType(method), joinCol != null ? joinCol.name() : "", this.getNameFromMethod(method));
        rel.setOtherSideName(otherSideName);
        rel.setRequired(isRequired);
        return rel;
    }

    public Id createId(Method method, Column col) {
        return new Id(this.getNameFromMethod(method), this.getReturnType(method), col.name(), "");
    }

    public Field createField(Method method, Column col, boolean isLob) {
        String len;
        String retType;
        if (isLob) {
            retType = "text";
            len = retType.equals("java.lang.String") ? Integer.toString(col.length()) : (col.length() != 255 ? Integer.toString(col.length()) : "");
        } else {
            String string = retType = isLob ? "text" : this.getReturnType(method);
            if (retType.equals("int")) {
                retType = "java.lang.Integer";
            }
            len = retType.equals("java.lang.String") ? Integer.toString(col.length()) : (col.length() != 255 ? Integer.toString(col.length()) : "");
        }
        Field field = new Field(this.getNameFromMethod(method), retType, col.name(), len);
        field.setRequired(!col.nullable());
        field.setUpdatable(col.updatable());
        field.setUnique(col.unique());
        return field;
    }

    public Class<?> getSetsClassType(Class<?> cls, String methodName) {
        File f;
        block5: {
            f = new File(this.srcCodeDir.getAbsoluteFile() + File.separator + cls.getSimpleName() + ".java");
            if (f.exists()) break block5;
            log.error((Object)("Can't locate source file[" + f.getAbsolutePath() + "]"));
            return null;
        }
        try {
            List lines = FileUtils.readLines((File)f);
            for (String line : lines) {
                int sInx = line.indexOf("Set<");
                if (sInx <= -1 || line.indexOf(methodName) <= -1) continue;
                int eInx = line.indexOf(">", sInx);
                String className = line.substring(sInx + 4, eInx);
                return Class.forName(String.valueOf(this.packageName) + "." + className);
            }
        }
        catch (ClassNotFoundException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
        }
        return null;
    }

    protected String getRightSideForOneToMany(Class<?> leftSide, Class<?> rightSide, String mappedByName) {
        if (StringUtils.isEmpty((String)mappedByName)) {
            throw new RuntimeException("Couldn't find otherside method name missing for [" + rightSide.getSimpleName() + "]  mappedByName[" + mappedByName + "]");
        }
        Method[] methodArray = rightSide.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Class<?> retType;
                Method method;
                block7: {
                    method = methodArray[n2];
                    String methodName = method.getName();
                    if (!methodName.startsWith("get") || !method.isAnnotationPresent(ManyToOne.class)) break block6;
                    retType = method.getReturnType();
                    boolean isSet = Collection.class.isAssignableFrom(retType);
                    if (!isSet) break block7;
                    Class<?> rt = this.getSetsClassType(rightSide, methodName);
                    if (rt == null) break block6;
                    retType = rt;
                }
                if (leftSide == retType) {
                    return this.getFieldNameFromMethod(method);
                }
            }
            ++n2;
        }
        return null;
    }

    protected String getRightSideForManyToOne(Class<?> leftSide, Class<?> rightSide, String leftSideVarName) {
        Method[] methodArray = rightSide.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                OneToMany oneToMany;
                String othersideName;
                Class<?> retType;
                Method method;
                block6: {
                    method = methodArray[n2];
                    String methodName = method.getName();
                    if (!methodName.startsWith("get") || !method.isAnnotationPresent(OneToMany.class)) break block5;
                    retType = method.getReturnType();
                    boolean isSet = Collection.class.isAssignableFrom(retType);
                    if (!isSet) break block6;
                    Class<?> rt = this.getSetsClassType(rightSide, methodName);
                    if (rt == null) break block5;
                    retType = rt;
                }
                if (leftSide == retType && StringUtils.isNotEmpty((String)(othersideName = (oneToMany = method.getAnnotation(OneToMany.class)).mappedBy())) && othersideName.equals(leftSideVarName)) {
                    return this.getFieldNameFromMethod(method);
                }
            }
            ++n2;
        }
        return null;
    }

    protected String getRightSideForManyToMany(Class<?> leftSide, Class<?> rightSide, String leftSideVarName) {
        Method[] methodArray = rightSide.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                ManyToMany manyToMany;
                String othersideName;
                Class<?> retType;
                Method method;
                block6: {
                    method = methodArray[n2];
                    String methodName = method.getName();
                    if (!methodName.startsWith("get") || !method.isAnnotationPresent(ManyToMany.class)) break block5;
                    retType = method.getReturnType();
                    boolean isSet = Collection.class.isAssignableFrom(retType);
                    if (!isSet) break block6;
                    Class<?> rt = this.getSetsClassType(rightSide, methodName);
                    if (rt == null) break block5;
                    retType = rt;
                }
                if (leftSide == retType && StringUtils.isNotEmpty((String)(othersideName = (manyToMany = method.getAnnotation(ManyToMany.class)).mappedBy())) && leftSideVarName.equals(othersideName)) {
                    return this.getFieldNameFromMethod(method);
                }
            }
            ++n2;
        }
        return null;
    }

    protected String getRightSideForOneToOne(Class<?> leftSide, Class<?> rightSide, String leftSideVarName, String mappedName, boolean isMappedBy) {
        Method[] methodArray = rightSide.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Method method;
                block8: {
                    method = methodArray[n2];
                    String methodName = method.getName();
                    if (!methodName.startsWith("get") || !method.isAnnotationPresent(OneToOne.class)) break block7;
                    Class<?> retType = method.getReturnType();
                    boolean isSet = Collection.class.isAssignableFrom(retType);
                    if (!isSet) break block8;
                    Class<?> rt = this.getSetsClassType(rightSide, methodName);
                    if (rt == null) break block7;
                    retType = rt;
                }
                String othersideName = "";
                if (isMappedBy) {
                    othersideName = this.getFieldNameFromMethod(method);
                } else {
                    OneToOne oneToOne = method.getAnnotation(OneToOne.class);
                    othersideName = oneToOne.mappedBy();
                }
                if (StringUtils.isNotEmpty((String)othersideName) && leftSideVarName.equals(othersideName)) {
                    return this.getFieldNameFromMethod(method);
                }
            }
            ++n2;
        }
        return null;
    }

    protected String getFieldNameFromMethod(Method method) {
        String methodName = method.getName().substring(3);
        return String.valueOf(methodName.substring(0, 1).toLowerCase()) + methodName.substring(1, methodName.length());
    }

    protected void processClass(String className, List<Table> tableList) {
        try {
            Class<?> classObj = Class.forName(String.valueOf(this.packageName) + "." + className);
            Table table = null;
            String tableName = null;
            if (classObj.isAnnotationPresent(javax.persistence.Table.class)) {
                Vector<TableIndex> indexes = new Vector<TableIndex>();
                javax.persistence.Table tableAnno = classObj.getAnnotation(javax.persistence.Table.class);
                tableName = tableAnno.name();
                org.hibernate.annotations.Table hiberTableAnno = classObj.getAnnotation(org.hibernate.annotations.Table.class);
                if (hiberTableAnno != null) {
                    Index[] indexArray = hiberTableAnno.indexes();
                    int n = indexArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Index index = indexArray[n2];
                        indexes.add(new TableIndex(index.name(), index.columnNames()));
                        ++n2;
                    }
                }
                table = this.createTable(String.valueOf(this.packageName) + "." + className, tableName);
                if (this.includeDesc) {
                    table.setDesc(this.getTableDesc(tableName));
                    table.setNameDesc(this.getTableNameDesc(tableName));
                }
                table.setIndexes(indexes);
                tableList.add(table);
            }
            if (table != null) {
                boolean isLob = false;
                Method[] methodArray = classObj.getMethods();
                int n = methodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Method method = methodArray[n3];
                    String methodName = method.getName();
                    if (methodName.startsWith("get")) {
                        Class typeClass;
                        Type type = method.getGenericReturnType();
                        if (type instanceof Class) {
                            typeClass = (Class)type;
                        } else if (type instanceof ParameterizedType) {
                            typeClass = null;
                            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                            int n4 = typeArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                Type t = typeArray[n5];
                                if (t instanceof Class) {
                                    typeClass = (Class)t;
                                }
                                ++n5;
                            }
                        } else {
                            if (!method.getName().equals("getDataObj") && !method.getName().equals("getTreeRootNode")) {
                                log.warn((Object)("Not handled: " + type));
                            }
                            typeClass = null;
                        }
                        if (typeClass != null && typeClass != AttributeIFace.class && typeClass != PickListItemIFace.class && typeClass != RecordSetItemIFace.class) {
                            CascadeType[] cascadeTypeArray;
                            String thisSideName = this.getFieldNameFromMethod(method);
                            if (method.isAnnotationPresent(Lob.class)) {
                                isLob = true;
                            }
                            if (method.isAnnotationPresent(Column.class)) {
                                if (method.isAnnotationPresent(javax.persistence.Id.class)) {
                                    table.addId(this.createId(method, method.getAnnotation(Column.class)));
                                } else {
                                    Field field = this.createField(method, method.getAnnotation(Column.class), isLob);
                                    if (this.includeDesc) {
                                        field.setDesc(this.getFieldDesc(tableName, field.getName()));
                                        field.setNameDesc(this.getFieldNameDesc(tableName, field.getName()));
                                    }
                                    if (typeClass == Calendar.class) {
                                        String mName = String.valueOf(method.getName()) + "Precision";
                                        Method[] methodArray2 = classObj.getMethods();
                                        int n6 = methodArray2.length;
                                        int n7 = 0;
                                        while (n7 < n6) {
                                            Method mthd = methodArray2[n7];
                                            if (mthd.getName().equals(mName)) {
                                                field.setPartialDate(true);
                                                field.setDatePrecisionName(String.valueOf(field.getName()) + "Precision");
                                                break;
                                            }
                                            ++n7;
                                        }
                                    }
                                    table.addField(field);
                                }
                            } else if (method.isAnnotationPresent(ManyToOne.class)) {
                                JoinColumn join;
                                ManyToOne oneToMany = method.getAnnotation(ManyToOne.class);
                                boolean isSave = false;
                                CascadeType[] cascadeTypeArray2 = oneToMany.cascade();
                                int n8 = cascadeTypeArray2.length;
                                int n9 = 0;
                                while (n9 < n8) {
                                    CascadeType ct = cascadeTypeArray2[n9];
                                    if (ct == CascadeType.ALL || ct == CascadeType.PERSIST) {
                                        isSave = true;
                                    }
                                    ++n9;
                                }
                                isSave = !isSave ? this.isOKToSave(method) : isSave;
                                String otherSideName = this.getRightSideForManyToOne(classObj, typeClass, thisSideName);
                                JoinColumn joinColumn = join = method.isAnnotationPresent(JoinColumn.class) ? method.getAnnotation(JoinColumn.class) : null;
                                if (join != null) {
                                    Relationship rel = this.createRelationship(method, "many-to-one", join, otherSideName, join != null ? !join.nullable() : false);
                                    table.addRelationship(rel);
                                    rel.setSave(isSave);
                                    if (this.includeDesc) {
                                        rel.setDesc(this.getFieldDesc(tableName, rel.getRelationshipName()));
                                        rel.setNameDesc(this.getFieldNameDesc(tableName, rel.getRelationshipName()));
                                    }
                                } else {
                                    log.error((Object)"No Join!");
                                }
                            } else if (method.isAnnotationPresent(ManyToMany.class)) {
                                JoinTable joinTable;
                                JoinColumn join;
                                ManyToMany manyToMany = method.getAnnotation(ManyToMany.class);
                                String othersideName = manyToMany.mappedBy();
                                if (StringUtils.isEmpty((String)othersideName)) {
                                    othersideName = this.getRightSideForManyToMany(classObj, typeClass, this.getFieldNameFromMethod(method));
                                }
                                boolean isSave = false;
                                cascadeTypeArray = manyToMany.cascade();
                                int n10 = cascadeTypeArray.length;
                                int rel = 0;
                                while (rel < n10) {
                                    CascadeType ct = cascadeTypeArray[rel];
                                    if (ct == CascadeType.ALL || ct == CascadeType.PERSIST) {
                                        isSave = true;
                                    }
                                    ++rel;
                                }
                                isSave = !isSave ? this.isOKToSave(method) : isSave;
                                JoinColumn joinColumn = join = method.isAnnotationPresent(JoinColumn.class) ? method.getAnnotation(JoinColumn.class) : null;
                                Relationship rel2 = this.createRelationship(method, "many-to-many", join, othersideName, join != null ? !join.nullable() : false);
                                rel2.setLikeManyToOne(table.getIsLikeManyToOne(rel2.getRelationshipName()));
                                rel2.setSave(isSave);
                                table.addRelationship(rel2);
                                if (this.includeDesc) {
                                    rel2.setDesc(this.getFieldDesc(tableName, rel2.getRelationshipName()));
                                    rel2.setNameDesc(this.getFieldNameDesc(tableName, rel2.getRelationshipName()));
                                }
                                if ((joinTable = method.getAnnotation(JoinTable.class)) != null) {
                                    rel2.setJoinTableName(joinTable.name());
                                }
                            } else if (method.isAnnotationPresent(OneToMany.class)) {
                                JoinColumn join;
                                OneToMany oneToMany = method.getAnnotation(OneToMany.class);
                                String othersideName = oneToMany.mappedBy();
                                if (StringUtils.isEmpty((String)othersideName)) {
                                    othersideName = this.getRightSideForOneToMany(classObj, typeClass, oneToMany.mappedBy());
                                }
                                boolean isSave = false;
                                cascadeTypeArray = oneToMany.cascade();
                                int joinTable = cascadeTypeArray.length;
                                int rel2 = 0;
                                while (rel2 < joinTable) {
                                    CascadeType ct = cascadeTypeArray[rel2];
                                    if (ct == CascadeType.ALL || ct == CascadeType.PERSIST) {
                                        isSave = true;
                                    }
                                    ++rel2;
                                }
                                isSave = !isSave ? this.isOKToSave(method) : isSave;
                                JoinColumn joinColumn = join = method.isAnnotationPresent(JoinColumn.class) ? method.getAnnotation(JoinColumn.class) : null;
                                Relationship rel3 = this.createRelationship(method, "one-to-many", join, othersideName, join != null ? !join.nullable() : false);
                                rel3.setLikeManyToOne(table.getIsLikeManyToOne(rel3.getRelationshipName()));
                                rel3.setSave(isSave);
                                table.addRelationship(rel3);
                                if (this.includeDesc) {
                                    rel3.setDesc(this.getFieldDesc(tableName, rel3.getRelationshipName()));
                                    rel3.setNameDesc(this.getFieldNameDesc(tableName, rel3.getRelationshipName()));
                                }
                            } else if (method.isAnnotationPresent(OneToOne.class)) {
                                JoinColumn join;
                                OneToOne oneToOne = method.getAnnotation(OneToOne.class);
                                String leftSideVarName = this.getFieldNameFromMethod(method);
                                boolean isMappedBy = true;
                                String othersideName = oneToOne.mappedBy();
                                if (StringUtils.isEmpty((String)othersideName)) {
                                    isMappedBy = false;
                                    othersideName = this.getRightSideForOneToOne(classObj, typeClass, leftSideVarName, othersideName, isMappedBy);
                                }
                                boolean isSave = false;
                                CascadeType[] cascadeTypeArray3 = oneToOne.cascade();
                                int n11 = cascadeTypeArray3.length;
                                int n12 = 0;
                                while (n12 < n11) {
                                    CascadeType ct = cascadeTypeArray3[n12];
                                    if (ct == CascadeType.ALL || ct == CascadeType.PERSIST) {
                                        isSave = true;
                                    }
                                    ++n12;
                                }
                                isSave = !isSave ? this.isOKToSave(method) : isSave;
                                JoinColumn joinColumn = join = method.isAnnotationPresent(JoinColumn.class) ? method.getAnnotation(JoinColumn.class) : null;
                                Relationship rel = this.createRelationship(method, "one-to-one", join, othersideName, join != null ? !join.nullable() : false);
                                rel.setSave(isSave);
                                table.addRelationship(rel);
                                if (this.includeDesc) {
                                    rel.setDesc(this.getFieldDesc(tableName, rel.getRelationshipName()));
                                    rel.setNameDesc(this.getFieldNameDesc(tableName, rel.getRelationshipName()));
                                }
                            }
                            isLob = false;
                        }
                    }
                    ++n3;
                }
                table.updateIndexFields();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean isOKToSave(Method method) {
        Cascade hibCascade = method.getAnnotation(Cascade.class);
        if (hibCascade != null) {
            org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibCascade.value();
            int n = cascadeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.hibernate.annotations.CascadeType ct = cascadeTypeArray[n2];
                if (ct == org.hibernate.annotations.CascadeType.ALL || ct == org.hibernate.annotations.CascadeType.PERSIST || ct == org.hibernate.annotations.CascadeType.SAVE_UPDATE) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void addCascadeRule(Class<?> cls, Method method, String rule) {
        String import1 = "import org.hibernate.annotations.Cascade;";
        try {
            File f = new File(this.srcCodeDir.getAbsoluteFile() + File.separator + cls.getSimpleName() + ".java");
            if (!f.exists()) {
                log.error((Object)("Can't locate source file[" + f.getAbsolutePath() + "]"));
                return;
            }
            List strLines = FileUtils.readLines((File)f);
            Vector<String> lines = new Vector<String>();
            boolean fnd = false;
            boolean passedImport = false;
            String methodName = String.valueOf(method.getName()) + "(";
            for (String line : strLines) {
                if (!passedImport && line.indexOf("import") > -1) {
                    passedImport = true;
                }
                if (!fnd && line.indexOf(import1) > -1) {
                    fnd = true;
                }
                if (line.indexOf(methodName) > -1 && line.indexOf("public") > -1) {
                    lines.add(rule);
                }
                lines.add(line);
            }
            FileUtils.writeLines((File)f, lines);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
        }
    }

    protected void processCascadeAddCascade(String className, List<Table> tableList) {
        try {
            Class<?> classObj = Class.forName(String.valueOf(this.packageName) + "." + className);
            Table table = null;
            String tableName = null;
            if (classObj.isAnnotationPresent(javax.persistence.Table.class)) {
                Vector<TableIndex> indexes = new Vector<TableIndex>();
                javax.persistence.Table tableAnno = classObj.getAnnotation(javax.persistence.Table.class);
                tableName = tableAnno.name();
                org.hibernate.annotations.Table hiberTableAnno = classObj.getAnnotation(org.hibernate.annotations.Table.class);
                if (hiberTableAnno != null) {
                    Index[] indexArray = hiberTableAnno.indexes();
                    int n = indexArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Index index = indexArray[n2];
                        indexes.add(new TableIndex(index.name(), index.columnNames()));
                        ++n2;
                    }
                }
                table = this.createTable(String.valueOf(this.packageName) + "." + className, tableName);
                table.setIndexes(indexes);
                tableList.add(table);
            }
            if (table != null) {
                Method[] methodArray = classObj.getMethods();
                int n = methodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Method method = methodArray[n3];
                    String methodName = method.getName();
                    if (methodName.startsWith("get") && !method.isAnnotationPresent(Transient.class)) {
                        if (method.isAnnotationPresent(ManyToOne.class)) {
                            if (!method.isAnnotationPresent(Cascade.class)) {
                                System.out.println("Missing Cascade[" + method.getName() + "]");
                                ++this.missing;
                            }
                        } else if (method.isAnnotationPresent(ManyToMany.class)) {
                            if (!method.isAnnotationPresent(Cascade.class)) {
                                System.out.println("Missing Cascade[" + method.getName() + "]");
                                ++this.missing;
                            }
                        } else if (method.isAnnotationPresent(OneToMany.class)) {
                            if (!method.isAnnotationPresent(Cascade.class)) {
                                System.out.println("Missing Cascade[" + method.getName() + "]");
                                ++this.missing;
                                this.addCascadeRule(classObj, method, "    @org.hibernate.annotations.Cascade( { org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN })");
                            }
                        } else if (method.isAnnotationPresent(OneToOne.class) && !method.isAnnotationPresent(Cascade.class)) {
                            ++this.missing;
                        }
                    }
                    ++n3;
                }
                table.updateIndexFields();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
        }
    }

    protected void removeCascadeRule(Class<?> cls, Method method) {
        try {
            File f = new File(this.srcCodeDir.getAbsoluteFile() + File.separator + cls.getSimpleName() + ".java");
            if (!f.exists()) {
                log.error((Object)("Can't locate source file[" + f.getAbsolutePath() + "]"));
                return;
            }
            List strLines = FileUtils.readLines((File)f);
            Vector<String> lines = new Vector<String>();
            String methodName = String.valueOf(method.getName()) + "(";
            int inx = 0;
            for (String line : strLines) {
                if (line.indexOf(methodName) > -1 && line.indexOf("public") > -1) {
                    int i = inx;
                    int stop = i - 10;
                    System.out.println("[" + (String)strLines.get(i) + "]");
                    while (!StringUtils.contains((String)((String)strLines.get(i)), (String)"@Cascade") && i > stop) {
                        System.out.println("[" + (String)strLines.get(--i) + "]");
                    }
                    if (i < stop || StringUtils.contains((String)((String)strLines.get(i)), (String)"@Cascade")) {
                        lines.remove(i);
                    }
                }
                lines.add(line);
                ++inx;
            }
            FileUtils.writeLines((File)f, lines);
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
        }
    }

    protected void processCascade(String className, List<Table> tableList) {
        try {
            Class<?> classObj = Class.forName(String.valueOf(this.packageName) + "." + className);
            if (classObj.isAnnotationPresent(javax.persistence.Table.class)) {
                Method[] methodArray = classObj.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    String methodName = method.getName();
                    if (methodName.startsWith("get") && !method.isAnnotationPresent(Transient.class) && method.isAnnotationPresent(ManyToOne.class) && method.isAnnotationPresent(Cascade.class)) {
                        System.out.println("Missing Cascade[" + method.getName() + "]");
                        ++this.missing;
                        this.removeCascadeRule(classObj, method);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
        }
    }

    public List<Table> generateDatamodelTree(List<Table> tableList, String dataModelPath) {
        try {
            log.debug((Object)("Preparing to read in DataModel Classes files from  path: " + dataModelPath));
            this.srcCodeDir = new File(dataModelPath);
            String path = this.srcCodeDir.getAbsolutePath();
            log.info((Object)path);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.toString().indexOf(".java") != -1;
                }
            };
            String PACKAGE = "package ";
            String CLASS = "public class ";
            File[] files = this.srcCodeDir.listFiles(fileFilter);
            int count = 0;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (this.showDebug) {
                    log.debug((Object)("Reading    " + file.getAbsolutePath()));
                }
                List lines = FileUtils.readLines((File)file);
                ++count;
                if (this.showDebug) {
                    log.debug((Object)("Processing " + count + " of " + files.length + "  " + file.getAbsolutePath()));
                }
                String className = null;
                for (Object lineObj : lines) {
                    String line = ((String)lineObj).trim();
                    if (line.startsWith(PACKAGE)) {
                        this.packageName = line.substring(PACKAGE.length(), line.length() - 1);
                    }
                    if (!StringUtils.contains((String)line, (String)CLASS)) continue;
                    String str = line.substring(CLASS.length());
                    while (str.charAt(0) == ' ') {
                        str = str.substring(1);
                    }
                    int eInx = str.indexOf(32);
                    if (eInx == -1) {
                        className = str;
                        break;
                    }
                    className = str.substring(0, eInx);
                    break;
                }
                if (className != null) {
                    if (!StringUtils.contains(className, (String)"SpUI")) {
                        this.processClass(className, tableList);
                    }
                } else {
                    String fileName = file.getName();
                    if (!(StringUtils.contains((String)fileName, (String)"DataModelObjBase") || StringUtils.contains((String)fileName, (String)"CollectionMember") || StringUtils.contains((String)fileName, (String)"DisciplineMember") || StringUtils.contains((String)fileName, (String)"UserGroupScope") || StringUtils.contains((String)fileName, (String)"Treeable") || StringUtils.contains((String)fileName, (String)"SpLocaleBase") || StringUtils.contains((String)fileName.toLowerCase(), (String)"iface") || StringUtils.contains((String)fileName, (String)"BaseTreeDef") || StringUtils.contains((String)fileName, (String)"TreeDefItemStandardEntry"))) {
                        throw new RuntimeException("Couldn't locate class name for " + file.getAbsolutePath());
                    }
                }
                ++n2;
            }
            System.out.println(this.missing);
            return tableList;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
            log.fatal((Object)ex);
            return null;
        }
    }

    public String getColumnName(Element element) {
        String columnName = null;
        Iterator i2 = element.elementIterator("column");
        while (i2.hasNext()) {
            Element element1 = (Element)i2.next();
            columnName = element1.attributeValue("name");
        }
        return columnName;
    }

    protected void setRelToZeroToOne(Collection<Relationship> rels, String name) {
        for (Relationship rel : rels) {
            if (!rel.getRelationshipName().equalsIgnoreCase(name)) continue;
            rel.setType("zero-to-one");
        }
    }

    protected void adjustRelsForZeroToOne(Table tbl) {
        String shortTableName = StringUtils.substringAfterLast((String)tbl.getName(), (String)".");
        if (shortTableName.equals("Locality")) {
            this.setRelToZeroToOne(tbl.getRelationships(), "localityDetails");
            this.setRelToZeroToOne(tbl.getRelationships(), "geoCoordDetails");
        }
    }

    public boolean writeTree(List<Table> classesList) {
        block5: {
            if (this.doRelsToZeroToOne) {
                for (Table tbl : classesList) {
                    this.adjustRelsForZeroToOne(tbl);
                }
            }
            try {
                if (classesList != null) break block5;
                log.error((Object)"Datamodel information is null - datamodel file will not be written!!");
                return false;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
                log.error((Object)"error writing writeTree", (Throwable)ex);
                return false;
            }
        }
        log.info((Object)("writing data model tree to file: " + DatamodelHelper.getDatamodelFilePath()));
        File file = DatamodelHelper.getDatamodelFilePath();
        FileWriter fw = new FileWriter(file);
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fw.write("<!-- \n");
        fw.write("    Do Not Edit this file!\n");
        fw.write("    Run DatamodelGenerator \n");
        Date date = new Date();
        fw.write("    Generated: " + date.toString() + "\n");
        fw.write("-->\n");
        BeanWriter beanWriter = new BeanWriter((Writer)fw);
        XMLIntrospector introspector = beanWriter.getXMLIntrospector();
        introspector.getConfiguration().setWrapCollectionsInElement(false);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.setWriteEmptyElements(false);
        beanWriter.enablePrettyPrint();
        beanWriter.write("database", classesList);
        fw.close();
        return true;
    }

    private boolean readTableMetadataFromFile(String tableIdListingFilePath) {
        Hashtable<String, Boolean> abbrvHashLocal = new Hashtable<String, Boolean>();
        log.info((Object)("Preparing to read in Table and TableID listing from file: " + tableIdListingFilePath));
        try {
            File tableIdFile = new File(tableIdListingFilePath);
            FileInputStream fileInputStream = new FileInputStream(tableIdFile);
            SAXReader reader = new SAXReader();
            reader.setValidation(false);
            Document doc = reader.read((InputStream)fileInputStream);
            Element root = doc.getRootElement();
            Element dbNode = (Element)root.selectSingleNode("database");
            if (dbNode != null) {
                Iterator i = dbNode.elementIterator("table");
                while (i.hasNext()) {
                    Element element = (Element)i.next();
                    String tablename = element.attributeValue("name");
                    String defaultView = element.attributeValue("view");
                    String id = element.attributeValue("id");
                    String abbrv = XMLHelper.getAttr(element, "abbrev", null);
                    boolean isSearchable = XMLHelper.getAttr(element, "searchable", false);
                    if (StringUtils.isNotEmpty((String)abbrv)) {
                        if (abbrvHashLocal.get(abbrv) != null) {
                            throw new RuntimeException("`abbrev` [" + abbrv + "]  or table[" + tablename + "] ids already in use.");
                        }
                    } else {
                        throw new RuntimeException("`abbrev` is missing or empty for table[" + tablename + "]");
                    }
                    abbrvHashLocal.put(abbrv, true);
                    String busRule = "";
                    Element brElement = (Element)element.selectSingleNode("businessrule");
                    if (brElement != null) {
                        busRule = brElement.getTextTrim();
                    }
                    TableMetaData tblMetaData = new TableMetaData(id, defaultView, this.createDisplay(element), this.createFieldAliases(element), isSearchable, busRule, abbrv);
                    this.tblMetaDataHash.put(tablename, tblMetaData);
                    Iterator ir = element.elementIterator("relationship");
                    while (ir.hasNext()) {
                        Element relElement = (Element)ir.next();
                        String relName = relElement.attributeValue("relationshipname");
                        boolean isLike = XMLHelper.getAttr(relElement, "likemanytoone", false);
                        tblMetaData.setIsLikeManyToOne(relName, isLike);
                    }
                }
            } else {
                log.debug((Object)("Ill-formatted file for reading in Table and TableID listing.  Filename:" + tableIdFile.getAbsolutePath()));
            }
            fileInputStream.close();
            return true;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatamodelGenerator.class, ex);
            ex.printStackTrace();
            log.fatal((Object)ex);
            return false;
        }
    }

    public void process(String outputFileName) {
        if (StringUtils.isNotEmpty((String)outputFileName)) {
            DatamodelHelper.setOutputFileName(outputFileName);
        }
        System.out.println("Starting...");
        List<Table> tableList = new ArrayList<Table>(150);
        String tableIdListingFilePath = DatamodelHelper.getTableIdFilePath();
        if (this.readTableMetadataFromFile(tableIdListingFilePath)) {
            String dmSrc = DatamodelHelper.getDataModelSrcDirPath();
            tableList = this.generateDatamodelTree(tableList, dmSrc);
            Collections.sort(tableList);
            boolean didWrite = this.writeTree(tableList);
            if (!didWrite) {
                log.error((Object)"Failed to write out datamodel document");
            }
        } else {
            log.error((Object)"Could not find table/ID listing file for input ");
        }
        log.info((Object)"Done.");
        System.out.println("Done.");
    }

    public static void main(String[] args) {
        DatamodelGenerator datamodelWriter = new DatamodelGenerator(false);
        datamodelWriter.process(null);
    }

    static enum RelType {
        OneToMany,
        OneToOne,
        ManyToOne,
        ManyToMany,
        ZeroOrOne;

    }
}

