/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.datamodelgenerator;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DataModelToCSV {
    protected PrintWriter pw = null;
    protected char sep = (char)9;

    protected String getLast(String str) {
        if (str.indexOf(46) > -1) {
            return StringUtils.substringAfterLast((String)str, (String)".");
        }
        return str;
    }

    protected String fixText(String text) {
        return StringUtils.replace((String)text, (String)"&apos;", (String)"'");
    }

    protected void processId(Element id) {
        Element nameElement = (Element)id.selectSingleNode("nameDesc");
        String name = nameElement != null ? nameElement.getText() : XMLHelper.getAttr(id, "column", null);
        System.out.println(name);
        Element descElement = (Element)id.selectSingleNode("desc");
        String desc = descElement != null ? this.fixText(descElement.getText()) : "";
        this.pw.print(name);
        this.pw.print(this.sep);
        this.pw.print(desc);
        this.pw.print(this.sep);
        this.pw.print(this.getLast(XMLHelper.getAttr(id, "type", "")));
        this.pw.print(this.sep);
        this.pw.print(XMLHelper.getAttr(id, "column", ""));
        this.pw.println();
    }

    protected void processField(Element field) {
        Element nameElement = (Element)field.selectSingleNode("nameDesc");
        String name = nameElement != null ? nameElement.getText() : XMLHelper.getAttr(field, "column", null);
        System.out.println(name);
        Element descElement = (Element)field.selectSingleNode("desc");
        String desc = descElement != null ? this.fixText(descElement.getText()) : "";
        this.pw.print(name);
        this.pw.print(this.sep);
        this.pw.print(desc);
        this.pw.print(this.sep);
        this.pw.print(this.getLast(XMLHelper.getAttr(field, "type", null)));
        this.pw.print(this.sep);
        this.pw.print(this.getLast(XMLHelper.getAttr(field, "column", null)));
        this.pw.println();
    }

    protected void processRelationship(Element rel) {
        Element nameElement = (Element)rel.selectSingleNode("nameDesc");
        String name = nameElement != null ? nameElement.getText() : this.getLast(XMLHelper.getAttr(rel, "classname", null));
        System.out.println(name);
        Element descElement = (Element)rel.selectSingleNode("desc");
        String desc = descElement != null ? this.fixText(descElement.getText()) : "";
        String type = XMLHelper.getAttr(rel, "type", null);
        this.pw.print(name);
        this.pw.print(this.sep);
        this.pw.print(desc);
        this.pw.print(this.sep);
        this.pw.print(type);
        this.pw.print(this.sep);
        this.pw.print(XMLHelper.getAttr(rel, "relationshipname", null));
        this.pw.println();
    }

    protected void processTables(Element table) {
        this.pw.println("" + this.sep + this.sep + this.sep + this.sep);
        this.pw.println("TABLE" + this.sep + this.sep + this.sep);
        Element nameElement = (Element)table.selectSingleNode("nameDesc");
        String name = nameElement != null ? nameElement.getText() : StringUtils.substringAfterLast((String)XMLHelper.getAttr(table, "classname", null), (String)".");
        System.out.println(name);
        Element descElement = (Element)table.selectSingleNode("desc");
        String desc = descElement != null ? this.fixText(descElement.getText()) : "";
        this.pw.print(name);
        this.pw.print(this.sep);
        this.pw.print(desc);
        this.pw.print(this.sep);
        this.pw.print(this.sep);
        this.pw.println();
        this.pw.println("FIELDS" + this.sep + this.sep + this.sep);
        this.processId((Element)table.selectSingleNode("id"));
        Iterator iter = table.selectNodes("field").iterator();
        while (iter.hasNext()) {
            this.processField((Element)iter.next());
        }
        this.pw.println("RELATIONSHIPS" + this.sep + this.sep + this.sep);
        iter = table.selectNodes("relationship").iterator();
        while (iter.hasNext()) {
            this.processRelationship((Element)iter.next());
        }
    }

    public void process() {
        try {
            this.pw = new PrintWriter(XMLHelper.getConfigDir("specify_datamodel.csv"));
            this.pw.println("Name" + this.sep + "Description" + this.sep + "Column" + this.sep + "Type");
            Element root = XMLHelper.readFileToDOM4J(XMLHelper.getConfigDir("specify_datamodel.xml"));
            Iterator iter = root.selectNodes("/database/table").iterator();
            while (iter.hasNext()) {
                this.processTables((Element)iter.next());
            }
            this.pw.close();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataModelToCSV.class, ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DataModelToCSV toCSV = new DataModelToCSV();
        toCSV.process();
        System.out.println("Done.");
    }
}

