/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools.datamodelgenerator;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class DataDict {
    protected Vector<TableDef> tables = new Vector();
    protected Vector<TableDef> sp5Tables = new Vector();

    protected void print(Element node, int level) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < level) {
            sb.append("  ");
            ++i;
        }
        for (Object k : node.elements()) {
            System.out.println(String.valueOf(sb.toString()) + ((Element)k).getName());
            this.print((Element)k, level + 1);
        }
    }

    protected String getText(String text) {
        String desc = StringUtils.replace((String)StringUtils.remove((String)text, (char)'\n'), (String)"     ", (String)" ");
        desc = StringUtils.replace((String)desc, (String)"  ", (String)" ");
        desc = StringUtils.replace((String)desc, (String)"  ", (String)" ");
        desc = StringEscapeUtils.escapeXml((String)desc);
        desc = StringUtils.replace((String)desc, (String)"&amp;apos;", (String)"'");
        desc = StringUtils.replace((String)desc, (String)"&#160;", (String)" ");
        if (StringUtils.isNotBlank((String)(desc = StringUtils.replace((String)desc, (String)"&#160;", (String)" ")))) {
            return desc;
        }
        return "";
    }

    protected String getName(Element e) {
        Element node = (Element)e.selectSingleNode("a/strong/u");
        if (node == null) {
            node = (Element)e.selectSingleNode("a/strong");
        }
        return this.getText(node.getText());
    }

    protected String getCol1(Element e) {
        Element node = (Element)e.selectSingleNode("strong");
        if (node == null) {
            node = e;
        }
        System.out.println("1 " + e.getName() + " [" + node.getText() + "]");
        return this.getText(node.getText());
    }

    protected String getCol2(Element e, boolean isRel) {
        if (isRel) {
            StringBuilder sb = new StringBuilder();
            for (Element link : e.selectNodes("a")) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(this.getText(link.getText()));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(e.getText());
        Element node = (Element)e.selectSingleNode("em");
        if (node != null) {
            sb.append(" ");
            sb.append(node.getText());
        }
        System.out.println(String.valueOf(e.getName()) + " [" + sb.toString() + "]");
        return this.getText(sb.toString());
    }

    public void processSpecify5Schema() {
        File file = new File("src/edu/ku/brc/specify/tools/datamodelgenerator/Specify5Tables.txt");
        try {
            TableDef tableDef = null;
            Vector<FieldDef> fields = null;
            boolean processingTable = false;
            for (String line : FileUtils.readLines((File)file)) {
                String[] tokens;
                if (processingTable) {
                    if (line.startsWith(") ON [")) {
                        processingTable = false;
                        continue;
                    }
                    tokens = StringUtils.split((String)line, (String)"[]");
                    String notNull = tokens[4];
                    FieldDef fieldDef = new FieldDef(tokens[1], tokens[3], "", notNull != null && notNull.indexOf("NOT NULL") > -1 ? "true" : "false", "");
                    fields.add(fieldDef);
                    tokens = StringUtils.split((String)line, (String)"()");
                    if (tokens.length <= 1) continue;
                    fieldDef.setLength(tokens[1]);
                    continue;
                }
                if (!line.startsWith("CREATE TABLE")) continue;
                tokens = StringUtils.split((String)line, (String)"[]");
                tableDef = new TableDef(tokens[3], "");
                this.sp5Tables.add(tableDef);
                fields = tableDef.getFields();
                processingTable = true;
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataDict.class, ex);
            System.err.println(file.getAbsolutePath());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataDict.class, ex);
            ex.printStackTrace();
        }
    }

    public void processTable(Element table) {
        String desc = StringUtils.replace((String)StringUtils.remove((String)table.selectSingleNode("caption/strong").getText(), (char)'\n'), (String)"     ", (String)" ");
        desc = StringUtils.replace((String)desc, (String)"  ", (String)" ");
        desc = StringUtils.replace((String)desc, (String)"  ", (String)" ");
        String[] parts = StringUtils.split((String)desc, (String)"'");
        TableDef tableDef = new TableDef(desc, parts[1]);
        Vector<FieldDef> fields = tableDef.getFields();
        Vector<IndexDef> indexes = tableDef.getIndexes();
        Vector<RelationshipDef> relationships = tableDef.getRelationships();
        this.tables.add(tableDef);
        for (Element tr : table.selectNodes("tr")) {
            List tds = tr.selectNodes("td");
            if (tds.size() == 5) {
                String type = this.getText(((Element)tds.get(1)).getText());
                String[] tokens = StringUtils.split((String)type, (String)"()");
                FieldDef fd = new FieldDef(this.getName((Element)tds.get(0)), type, this.getText(((Element)tds.get(2)).getText()), this.getText(((Element)tds.get(3)).getText()), this.getText(((Element)tds.get(4)).getText()));
                if (tokens.length > 1) {
                    fd.setLength(tokens[1]);
                }
                fields.add(fd);
                continue;
            }
            if (tds.size() != 2) continue;
            String col1 = this.getCol1((Element)tds.get(0));
            int inx = col1.indexOf(58);
            if (inx > -1) {
                col1 = col1.substring(0, inx);
            }
            if (!StringUtils.isNotBlank((String)col1)) continue;
            if (inx == -1) {
                relationships.add(new RelationshipDef(col1, this.getCol2((Element)tds.get(1), true)));
                continue;
            }
            indexes.add(new IndexDef(col1, this.getCol2((Element)tds.get(1), false)));
        }
    }

    public void writeSp5Tables() {
        this.writeTables("datadictSp5.xml", this.sp5Tables);
    }

    public void writeTables() {
        this.writeTables("datadict.xml", this.tables);
    }

    public boolean writeTables(String outFileName, Vector<TableDef> tbls) {
        block3: {
            try {
                if (this.tables != null) break block3;
                System.err.println("Datamodel information is null - datamodel file will not be written!!");
                return false;
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataDict.class, ex);
                ex.printStackTrace();
                return false;
            }
        }
        System.err.println("writing data model tree to file: " + outFileName);
        File file = new File(outFileName);
        FileWriter fw = new FileWriter(file);
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fw.write("<!-- \n");
        fw.write("    Do Not Edit this file!\n");
        fw.write("    Run DatamodelGenerator \n");
        Date date = new Date();
        fw.write("    Generated: " + date.toString() + "\n");
        fw.write("-->\n");
        BeanWriter beanWriter = new BeanWriter((Writer)fw);
        XMLIntrospector introspector = beanWriter.getXMLIntrospector();
        introspector.getConfiguration().setWrapCollectionsInElement(false);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.setWriteEmptyElements(false);
        beanWriter.enablePrettyPrint();
        beanWriter.write("database", tbls);
        fw.close();
        return true;
    }

    protected void compareFields(TableDef tableDef, DBTableInfo tableInfo, Vector<String> okTables) {
        Hashtable<String, DBFieldInfo> fieldHash = new Hashtable<String, DBFieldInfo>();
        for (DBFieldInfo fi : tableInfo.getFields()) {
            fieldHash.put(fi.getName().toLowerCase(), fi);
        }
        boolean hasMissing = false;
        block1: for (FieldDef fieldDef : tableDef.getFields()) {
            if (fieldDef.getName().endsWith("ID")) continue;
            String fieldName = fieldDef.getName().toLowerCase();
            int i = 0;
            while (i < 2) {
                DBFieldInfo fieldInfo = (DBFieldInfo)fieldHash.get(fieldName);
                if (fieldInfo != null) {
                    int fdLen;
                    int n = fdLen = StringUtils.isNotEmpty((String)fieldDef.getLength()) && fieldDef.getLength().indexOf(44) == -1 ? Integer.parseInt(fieldDef.getLength()) : -1;
                    if (fdLen == -1 || fdLen == fieldInfo.getLength() || fdLen <= fieldInfo.getLength()) continue block1;
                    if (!hasMissing) {
                        System.err.println("\nComparing " + tableDef.getName());
                    }
                    System.err.println("  " + fieldDef.getName() + " Length: " + fdLen + " != " + fieldInfo.getLength());
                    continue block1;
                }
                if (i == 1) {
                    if (!hasMissing) {
                        System.err.println("\nComparing " + tableDef.getName());
                    }
                    System.err.println("  " + fieldDef.getName() + " is missing.");
                    hasMissing = true;
                }
                fieldName = "is" + fieldName;
                ++i;
            }
        }
        if (!hasMissing) {
            okTables.add(tableDef.getName());
        }
    }

    protected void compareSchemas() {
        String[] skipTables = new String[]{"AgentAddress", "BiologicalObjectAttributes", "BiologicalObjectRelation", "BiologicalObjectRelationType", "BorrowAgents", "BorrowShipments", "CatalogSeriesDefinition", "Collection", "CollectionObjectType", "CollectionTaxonomyTypes", "DATAVIEWS", "GeologicTimeBoundary", "Habitat", "Image", "ImageAgents", "ImageCollectionObjects", "ImageLocalities", "Observation", "Preparation", "REPORTS", "RaveProject", "Sound", "SoundEventStorage", "TaxonName", "TaxonomicUnitType", "TaxonomyType", "WebAdmin"};
        String[] nameMapArray = new String[]{"AccessionAgents", "AccessionAgent", "AccessionAuthorizations", "AccessionAuthorization", "Authors", "Author", "BorrowAgents", "BorrowAgent", "Collectors", "Collector", "CollectionObjectCatalog", "CollectionObject", "CollectionObject", "CollectionObject", "DeaccessionAgents", "DeaccessionAgent", "GroupPersons", "GroupPerson", "LoanAgents", "LoanAgent", "TaxonName", "Taxon"};
        Hashtable<String, String> nameMap = new Hashtable<String, String>();
        int i = 0;
        while (i < nameMapArray.length) {
            nameMap.put(nameMapArray[i], nameMapArray[i + 1]);
            ++i;
            ++i;
        }
        Hashtable<String, String> tablesToSkip = new Hashtable<String, String>();
        int i2 = 0;
        while (i2 < skipTables.length) {
            tablesToSkip.put(skipTables[i2], skipTables[i2]);
            ++i2;
        }
        Vector<String> okTables = new Vector<String>();
        DBTableIdMgr mgr = DBTableIdMgr.getInstance();
        for (TableDef tableDef : this.sp5Tables) {
            DBTableInfo tableInfo;
            if (tableDef.getName().startsWith("USYS") || tablesToSkip.get(tableDef.getName()) != null) continue;
            String tblName = (String)nameMap.get(tableDef.getName());
            if (tblName == null) {
                tblName = tableDef.getName();
            }
            if ((tableInfo = mgr.getInfoByTableName(tblName.toLowerCase())) != null) {
                this.compareFields(tableDef, tableInfo, okTables);
                continue;
            }
            System.err.println("Missing table [" + tableDef.getName() + "]");
        }
        System.out.println("\nTables passed:");
        for (String name : okTables) {
            System.out.println(name);
        }
        System.out.println("\nTables Skipped:");
        String[] stringArray = skipTables;
        int n = skipTables.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            name = stringArray[n2];
            System.out.println(name);
            ++n2;
        }
    }

    public static void main(String[] args) {
        try {
            Iterator iterator;
            DataDict dd = new DataDict();
            dd.processSpecify5Schema();
            dd.compareSchemas();
            Vector<String> names = new Vector<String>();
            Element doc = XMLHelper.readFileToDOM4J(new File("src/edu/ku/brc/specify/tools/datamodelgenerator/datadict.xml"));
            Element div = (Element)doc.selectSingleNode("//div[@class='plain']");
            if (div != null) {
                iterator = div.selectNodes("p/a").iterator();
                while (iterator.hasNext()) {
                    Object linkObj = iterator.next();
                    String href = XMLHelper.getAttr((Element)linkObj, "href", null);
                    if (!StringUtils.isNotEmpty((String)href)) continue;
                    names.add(href);
                }
            }
            if ((iterator = div.selectNodes("table").iterator()).hasNext()) {
                Element table = (Element)iterator.next();
                dd.processTable(table);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DataDict.class, ex);
            ex.printStackTrace();
        }
    }

    class FieldDef {
        protected String name;
        protected String type;
        protected String desc;
        protected String required;
        protected String index;
        protected String length;

        public FieldDef(String name, String type, String desc, String required, String index) {
            this.name = name;
            this.type = type;
            this.desc = desc;
            this.required = required;
            this.index = index;
            this.length = "";
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getIndex() {
            return this.index;
        }

        public String getLength() {
            return this.length;
        }

        public void setLength(String length) {
            this.length = length;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRequired() {
            return this.required;
        }

        public void setRequired(String required) {
            this.required = required;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    class IndexDef {
        protected String name;
        protected String properties;

        public IndexDef(String name, String properties) {
            this.name = name;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }
    }

    class RelationshipDef
    extends IndexDef {
        public RelationshipDef(String name, String properties) {
            super(name, properties);
        }
    }

    class TableDef {
        protected String name;
        protected String desc;
        protected Vector<FieldDef> fields = new Vector();
        protected Vector<IndexDef> indexes = new Vector();
        protected Vector<RelationshipDef> relationships = new Vector();

        public TableDef(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Vector<FieldDef> getFields() {
            return this.fields;
        }

        public Vector<IndexDef> getIndexes() {
            return this.indexes;
        }

        public Vector<RelationshipDef> getRelationships() {
            return this.relationships;
        }
    }
}

