/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import com.google.api.translate.Language;
import com.google.api.translate.Translate;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.SearchBox;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.ResultSetControllerListener;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.tools.LocalizerSearchHelper;
import edu.ku.brc.specify.tools.StrLocaleEntry;
import edu.ku.brc.specify.tools.StrLocaleFile;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class StrLocalizerApp
extends JPanel
implements FrameworkAppIFace,
WindowListener {
    private static final Logger log = Logger.getLogger(StrLocalizerApp.class);
    protected JFrame frame = null;
    protected GhostGlassPane glassPane;
    protected File rootDir = null;
    protected File baseDir = null;
    protected String srcLangCode = "en";
    protected String currentPath = null;
    protected LanguageEntry destLanguage = null;
    protected Locale englishLocale = Locale.US;
    protected StrLocaleFile srcFile;
    protected StrLocaleFile destFile;
    protected Vector<StrLocaleFile> srcFiles = new Vector();
    protected Vector<StrLocaleFile> destFiles = new Vector();
    protected Vector<LanguageEntry> languages = new Vector();
    protected JList termList;
    protected JList newTermList;
    protected JTextArea srcLbl;
    protected JLabel destLbl;
    protected JTextField textField;
    protected JButton prevBtn;
    protected JButton nxtBtn;
    protected JButton transBtn;
    protected JLabel fileLbl;
    protected JPanel mainPane;
    protected JStatusBar statusBar;
    protected SearchBox searchBox;
    protected JAutoCompTextField searchText;
    protected JButton searchBtn;
    protected JTable searchResultsTbl;
    protected SearchResultsModel model;
    protected Vector<StrLocaleEntry> results = new Vector();
    protected LocalizerSearchHelper searchable = null;
    protected HashSet<String> fndKeyHash = new HashSet();
    protected JMenuItem startTransMenuItem;
    protected JMenuItem stopTransMenuItem;
    protected ResultSetController rsController;
    protected ResultSetControllerListener rscListener = null;
    protected int oldInx = -1;
    protected boolean hasChanged = false;
    protected Vector<String> newKeyList = new Vector();
    protected AtomicBoolean contTrans = new AtomicBoolean(true);

    public StrLocalizerApp() {
        new MacOSAppHandler(this);
        this.loadLanguages();
    }

    public String[] getFileNames() {
        String[] fileNames = new String[]{"backuprestore_en", "common_en", "expresssearch_en", "global_views_en", "masterusrpwd_en", "preferences_en", "resources_en", "specify", "specify_plugins_en", "specifydbsetupwiz_en", "stats_en", "system_setup_en", "views_en"};
        return fileNames;
    }

    private boolean copyPropFiles(File dir, Locale locale, boolean doAddOrigExt) {
        String[] fileNames = this.getFileNames();
        String ext = ".properties";
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String nm = stringArray[n2];
            try {
                String name = StringUtils.replace((String)nm, (String)"_en", (String)("_" + this.getFullLang(locale)));
                String outName = String.valueOf(dir.getAbsolutePath()) + File.separator + name + ext + (doAddOrigExt ? ".orig" : "");
                PrintWriter pw = new PrintWriter(outName);
                InputStream inputStream = Specify.class.getResourceAsStream("/" + nm + ext);
                try {
                    inputStream.available();
                }
                catch (Exception ex) {
                    inputStream = new FileInputStream(new File("src/" + nm + ext));
                }
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                byte[] buf = new byte[4096];
                int len = bis.read(buf);
                while (len > 0) {
                    pw.write(new String(buf, 0, len));
                    len = bis.read(buf);
                }
                pw.close();
                bis.close();
                inputStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private File doCopyLocale(Locale locale, boolean doAddOrigExt) {
        String path;
        File tmpBaseDir = null;
        if (locale != null && ((tmpBaseDir = new File(path = String.valueOf(this.rootDir.getAbsolutePath()) + File.separator + this.getFullLang(locale))).exists() || tmpBaseDir.mkdir()) && !this.copyPropFiles(tmpBaseDir, locale, doAddOrigExt)) {
            UIRegistry.showError("There was an error creating the locale[" + locale.getDisplayCountry() + "]");
            System.exit(0);
        }
        return tmpBaseDir;
    }

    private void doCreateNewLocale(boolean doFromStartup) {
        Locale locale = this.doChooseLangLocale(true);
        if (locale != null) {
            this.doCopyLocale(this.englishLocale, false);
            this.doCopyLocale(locale, true);
            this.baseDir = this.doCopyLocale(locale, false);
        } else if (doFromStartup) {
            UIRegistry.showError("StrLocalizer will exit now.");
            System.exit(0);
        }
    }

    public void startUp() {
        String fullLanguage;
        this.rootDir = new File(String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "I18N");
        if (!this.rootDir.exists()) {
            if (this.rootDir.mkdir()) {
                this.doCreateNewLocale(true);
            } else {
                UIRegistry.showError("Error creating directory[" + this.rootDir.getAbsolutePath() + "]");
                System.exit(0);
            }
        }
        int cnt = 0;
        String[] stringArray = this.rootDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nm = stringArray[n2];
            if (!nm.startsWith(".")) {
                ++cnt;
            }
            ++n2;
        }
        if (cnt < 2) {
            this.doCreateNewLocale(true);
        }
        if ((fullLanguage = this.doChooseExistingLocalization()) != null) {
            this.init(fullLanguage);
            UIRegistry.register("mainpane", this.mainPane);
            this.glassPane = GhostGlassPane.getInstance();
            this.frame.setGlassPane(this.glassPane);
            this.frame.setLocationRelativeTo(null);
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            UIRegistry.register("glasspane", this.glassPane);
        } else {
            UIRegistry.showError("StrLocalizer will exit.");
            System.exit(0);
        }
    }

    protected void init(String langStr) {
        this.setupSrcFiles(String.valueOf(this.rootDir.getAbsolutePath()) + File.separator + "en");
        this.destLanguage = this.getLanguageByCode(langStr);
        if (this.destLanguage == null) {
            UIRegistry.showError("No Destination Language found.\nStrLocalizer will exit.");
            System.exit(0);
        }
        final String newLang = this.destLanguage.getEnglishName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StrLocalizerApp.this.destLbl.setText(String.valueOf(newLang) + ":");
            }
        });
        this.setupDestFiles(this.destLanguage.getCode(), null);
        this.srcFile = this.getResourcesFile();
        this.createUI();
        this.newSrcFile(this.getResourcesFile());
    }

    protected StrLocaleFile getResourcesFile() {
        String path = String.valueOf(this.getPath()) + File.separator + "resources_" + (this.destLanguage == null ? "en" : this.destLanguage.getCode()) + ".properties";
        StrLocaleFile file = this.getLocaleFileByPath(this.srcFiles, path);
        if (file == null) {
            file = this.srcFiles.get(0);
        }
        return file;
    }

    protected String getPath() {
        if (this.currentPath == null) {
            return this.getDefaultPath();
        }
        return String.valueOf(this.currentPath) + File.separator;
    }

    protected String getDefaultPath() {
        String prefName = "StrLoc.BASEDIR";
        if (this.baseDir == null) {
            String lang = AppPreferences.getLocalPrefs().get(prefName, null);
            if (StringUtils.isEmpty((String)lang)) {
                lang = this.doChooseExistingLocalization();
                this.baseDir = new File(String.valueOf(this.rootDir.getAbsolutePath()) + File.separator + lang);
                try {
                    AppPreferences.getLocalPrefs().flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                return this.baseDir.getAbsolutePath();
            }
            this.baseDir = new File(String.valueOf(this.rootDir.getAbsolutePath()) + File.separator + lang);
        }
        return this.baseDir.getAbsolutePath();
    }

    private String doChooseExistingLocalization() {
        ArrayList<String> dirNames = new ArrayList<String>();
        String[] stringArray = this.rootDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nm = stringArray[n2];
            if (!nm.startsWith(".") && !nm.equals("en")) {
                dirNames.add(nm);
            }
            ++n2;
        }
        String fullLanguage = null;
        if (dirNames.size() > 1) {
            Collections.sort(dirNames);
            ToggleButtonChooserDlg chooser = new ToggleButtonChooserDlg(null, "CHOOSE_LOCALE", dirNames, ToggleButtonChooserPanel.Type.RadioButton);
            chooser.setUseScrollPane(true);
            chooser.setVisible(true);
            if (!chooser.isCancelled()) {
                fullLanguage = (String)chooser.getSelectedObject();
            }
        } else if (dirNames.size() == 1) {
            fullLanguage = (String)dirNames.get(0);
        }
        return fullLanguage;
    }

    protected void setupSrcFiles(String dirName) {
        String postFix = "_" + (this.destLanguage == null ? "en" : this.destLanguage.getCode()) + ".properties";
        boolean doRewrite = false;
        File verFile = new File(String.valueOf(dirName) + File.separator + "version");
        if (verFile.exists()) {
            try {
                String appVersion = UIRegistry.getAppVersion();
                String version = FileUtils.readFileToString((File)verFile);
                doRewrite = !version.equals(appVersion) && appVersion.compareTo(version) > 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            doRewrite = true;
        }
        if (doRewrite) {
            try {
                FileUtils.writeStringToFile((File)verFile, (String)UIRegistry.getAppVersion());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.doCopyLocale(this.englishLocale, false);
        }
        this.srcFiles.clear();
        this.destFiles.clear();
        File dir = new File(dirName);
        String[] exts = new String[]{"properties"};
        Collection files = FileUtils.listFiles((File)dir, (String[])exts, (boolean)false);
        for (Object fobj : files) {
            File f = (File)fobj;
            if (!f.getName().endsWith(postFix)) continue;
            this.srcFiles.add(new StrLocaleFile(String.valueOf(dirName) + File.separator + f.getName(), null, false));
        }
        Collections.sort(this.srcFiles, new Comparator<StrLocaleFile>(){

            @Override
            public int compare(StrLocaleFile arg0, StrLocaleFile arg1) {
                return arg0.getPath().compareTo(arg1.getPath());
            }
        });
    }

    protected void setupDestFiles(String langCode, String destPath) {
        this.destFiles.clear();
        for (StrLocaleFile f : this.srcFiles) {
            String newPath;
            if (destPath != null) {
                File duh = new File(f.getPath());
                String newName = duh.getName().replace("_" + this.srcLangCode + ".", "_" + langCode + ".");
                newPath = String.valueOf(destPath) + File.separator + newName;
            } else {
                String path = f.getPath();
                newPath = path.replace("_" + this.srcLangCode + ".", "_" + langCode + ".");
                newPath = newPath.replace(String.valueOf(File.separator) + this.srcLangCode + File.separator, String.valueOf(File.separator) + langCode + File.separator);
            }
            this.destFiles.add(new StrLocaleFile(newPath, f.getPath(), true));
        }
    }

    protected void loadLanguages() {
        this.languages.clear();
        boolean doXML = false;
        if (doXML) {
            Element root = XMLHelper.readDOMFromConfigDir("languagecodes.xml");
            for (Object langObj : root.selectNodes("languagecode")) {
                Element lang = (Element)langObj;
                this.languages.add(new LanguageEntry(lang.attributeValue("englishname"), lang.attributeValue("code")));
            }
        } else {
            Locale[] localeArray = Locale.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale l = localeArray[n2];
                System.out.println(l.getDisplayName());
                this.languages.add(new LanguageEntry(l.getDisplayName(), this.getFullLang(l)));
                ++n2;
            }
        }
        Collections.sort(this.languages);
    }

    private void createUI() {
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.tools.StrLocPickListFactory");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "p,4px,f:p:g,4px,p"), (JPanel)this);
        pb.addSeparator("Localize", cc.xyw(1, 1, 3));
        this.termList = new JList(new ItemModel(this.srcFile));
        this.newTermList = new JList<String>(this.newKeyList);
        this.srcLbl = UIHelper.createTextArea(3, 40);
        this.srcLbl.setBorder(new LineBorder(this.srcLbl.getForeground()));
        this.textField = UIHelper.createTextField(40);
        this.textField.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                StrLocalizerApp.this.hasChanged = true;
            }
        });
        this.statusBar = new JStatusBar();
        this.statusBar.setSectionText(1, "     ");
        UIRegistry.setStatusBar(this.statusBar);
        this.srcLbl.setEditable(false);
        this.rsController = new ResultSetController(null, false, false, false, "", 1, true);
        this.transBtn = UIHelper.createButton(UIRegistry.getResourceString("StrLocalizerApp.Translate"));
        PanelBuilder pbr = new PanelBuilder(new FormLayout("r:p,2px,f:p:g", "p, 4px, c:p,4px,p,4px,p,4px,p,4px,p,10px,p,2px,f:p:g"));
        pbr.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("StrLocalizerApp.FileLbl")), cc.xy(1, 1));
        this.fileLbl = UIHelper.createLabel("   ");
        pbr.add((Component)this.fileLbl, cc.xy(3, 1));
        pbr.add((Component)UIHelper.createLabel("English:"), cc.xy(1, 3));
        pbr.add((Component)this.srcLbl, cc.xy(3, 3));
        this.destLbl = UIHelper.createFormLabel(this.destLanguage.getEnglishName());
        pbr.add((Component)this.destLbl, cc.xy(1, 5));
        pbr.add((Component)this.textField, cc.xy(3, 5));
        pbr.add((Component)this.rsController.getPanel(), cc.xyw(1, 7, 3));
        pbr.add((Component)this.transBtn, cc.xy(1, 9));
        pbr.addSeparator("Searching", cc.xyw(1, 11, 3));
        this.searchBtn = UIHelper.createButton(UIRegistry.getResourceString("SEARCH"));
        this.searchBtn.setToolTipText(UIRegistry.getResourceString("ExpressSearchTT"));
        this.searchText = new JAutoCompTextField(15, PickListDBAdapterFactory.getInstance().create("ExpressSearch", true));
        this.searchText.setAskBeforeSave(false);
        this.searchBox = new SearchBox(this.searchText, null, true);
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StrLocalizerApp.this.fndKeyHash.clear();
                    StrLocalizerApp.this.results.clear();
                    String txt = StrLocalizerApp.this.searchText.getText();
                    if (!txt.isEmpty()) {
                        StrLocalizerApp.this.doSearch(txt, "key");
                        StrLocalizerApp.this.doSearch(txt, "src");
                        StrLocalizerApp.this.doSearch(txt, "dst");
                    }
                    StrLocalizerApp.this.model.fireChanges();
                }
            }
        });
        pbr.add((Component)this.searchBox, cc.xyw(1, 13, 3));
        this.model = new SearchResultsModel();
        this.searchResultsTbl = new JTable(this.model);
        pbr.add((Component)UIHelper.createScrollPane(this.searchResultsTbl), cc.xyw(1, 15, 3));
        this.searchResultsTbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StrLocaleEntry entry;
                if (StrLocalizerApp.this.results != null && StrLocalizerApp.this.results.size() > 0 && StrLocalizerApp.this.searchResultsTbl.getSelectedRow() > -1 && (entry = StrLocalizerApp.this.results.get(StrLocalizerApp.this.searchResultsTbl.getSelectedRow())) != null) {
                    int listIndex = StrLocalizerApp.this.srcFile.getInxForKey(entry.getKey());
                    StrLocalizerApp.this.termList.setSelectedIndex(listIndex);
                    StrLocalizerApp.this.termList.ensureIndexIsVisible(listIndex);
                }
            }
        });
        PanelBuilder pbl = new PanelBuilder(new FormLayout("f:p:g", "f:p:g,10px,p,4px,f:p:g"));
        JScrollPane sp = UIHelper.createScrollPane(this.termList);
        JScrollPane nsp = UIHelper.createScrollPane(this.newTermList);
        pbl.add((Component)sp, cc.xy(1, 1));
        pbl.addSeparator("New Items", cc.xy(1, 3));
        pbl.add((Component)nsp, cc.xy(1, 5));
        pb.add((Component)pbl.getPanel(), cc.xy(1, 3));
        pb.add((Component)pbr.getPanel(), cc.xy(3, 3));
        pb.add((Component)this.statusBar, cc.xyw(1, 5, 3));
        ResultSetController.setBackStopRS(this.rsController);
        pb.setDefaultDialogBorder();
        this.mainPane = pb.getPanel();
        this.termList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StrLocalizerApp.this.listSelected();
            }
        });
        this.newTermList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StrLocalizerApp.this.newListSelected();
            }
        });
        this.transBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txt = StrLocalizerApp.this.srcLbl.getText();
                String newText = StrLocalizerApp.this.translate(txt);
                if (StringUtils.isNotEmpty((String)newText)) {
                    newText = newText.replace("&#039;", "'");
                    StrLocalizerApp.this.textField.setText(newText);
                    StrLocaleEntry entry = StrLocalizerApp.this.srcFile.getKey(StrLocalizerApp.this.termList.getSelectedIndex());
                    entry.setDstStr(StrLocalizerApp.this.textField.getText());
                }
            }
        });
        this.rscListener = new ResultSetControllerListener(){

            @Override
            public void newRecordAdded() {
            }

            @Override
            public void indexChanged(int newIndex) {
                StrLocalizerApp.this.termList.setSelectedIndex(newIndex);
            }

            @Override
            public boolean indexAboutToChange(int oldIndex, int newIndex) {
                return true;
            }
        };
        this.rsController.addListener(this.rscListener);
        this.frame.pack();
    }

    private void doSearch(String searchText, String fileName) {
        int[] indexes = this.searchable.doPropsSearch(searchText, fileName);
        if (indexes != null) {
            int i = 0;
            while (i < indexes.length) {
                StrLocaleEntry entry = this.srcFile.getItems().get(indexes[i]);
                if (!this.fndKeyHash.contains(entry.getKey())) {
                    this.results.add(entry);
                    this.fndKeyHash.add(entry.getKey());
                }
                ++i;
            }
        }
    }

    private void listSelected() {
        int inx;
        if (this.oldInx > -1 && this.hasChanged) {
            StrLocaleEntry entry = this.srcFile.getKey(this.oldInx);
            entry.setDstStr(this.textField.getText());
        }
        if ((inx = this.termList.getSelectedIndex()) > -1) {
            this.transBtn.setEnabled(true);
            StrLocaleEntry srcEntry = this.srcFile.getKey(inx);
            this.srcLbl.setText(srcEntry.getSrcStr());
            String str = srcEntry.getDstStr();
            this.textField.setText(str != null ? str : srcEntry.getSrcStr());
            this.rsController.removeListener(this.rscListener);
            this.rsController.setIndex(inx);
            this.rsController.addListener(this.rscListener);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StrLocalizerApp.this.textField.requestFocus();
                    StrLocalizerApp.this.textField.selectAll();
                }
            });
        } else {
            this.srcLbl.setText("");
            this.textField.setText("");
            this.transBtn.setEnabled(false);
        }
        this.oldInx = inx;
        this.hasChanged = false;
    }

    private void newListSelected() {
        Integer inx;
        String key = (String)this.newTermList.getSelectedValue();
        if (key != null && (inx = this.srcFile.getInxForKey(key)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StrLocalizerApp.this.termList.setSelectedIndex(inx);
                    StrLocalizerApp.this.termList.ensureIndexIsVisible(inx);
                }
            });
        }
    }

    private void mergeToSrc(StrLocaleFile src, StrLocaleFile dst) {
        Hashtable<String, StrLocaleEntry> dstHash = dst.getItemHash();
        int cnt = 0;
        for (StrLocaleEntry srcEntry : src.getItems()) {
            if (!srcEntry.isValue()) continue;
            StrLocaleEntry dstEntry = dstHash.get(srcEntry.getKey());
            if (dstEntry != null) {
                if (dst.isSrcSameAsDest(srcEntry.getKey(), srcEntry.getSrcStr())) {
                    if (StringUtils.isEmpty((String)dstEntry.getSrcStr()) || dstEntry.getSrcStr().equals(srcEntry.getSrcStr())) {
                        this.newKeyList.add(srcEntry.getKey());
                    }
                } else {
                    this.newKeyList.add(dstEntry.getKey());
                }
                srcEntry.setDstStr(dstEntry.getSrcStr());
                srcEntry.setStatus(dstEntry.getStatus());
            } else {
                srcEntry.setDstStr(srcEntry.getSrcStr());
                dstEntry = new StrLocaleEntry(srcEntry.getKey(), srcEntry.getSrcStr(), null, StrLocaleEntry.STATUS.IsNew);
                dstHash.put(srcEntry.getKey(), dstEntry);
                this.newKeyList.add(srcEntry.getKey());
            }
            ++cnt;
        }
        this.srcFile.clearEditFlags();
        this.statusBar.setText(String.format("%d new items.", this.newKeyList.size()));
    }

    private void mergeToDst(StrLocaleFile src, StrLocaleFile dst) {
        Hashtable<String, StrLocaleEntry> dstHash = dst.getItemHash();
        Vector<StrLocaleEntry> srcItems = src.getItems();
        Vector<StrLocaleEntry> dstItems = dst.getItems();
        dstItems.clear();
        for (StrLocaleEntry srcEntry : srcItems) {
            String key = srcEntry.getKey();
            if (key == null || key.equals("#")) {
                dstItems.add(srcEntry);
                continue;
            }
            StrLocaleEntry dstEntry = dstHash.get(key);
            if (dstEntry != null) {
                dstEntry.setDstStr(srcEntry.getDstStr());
                dstItems.add(dstEntry);
                continue;
            }
            dstItems.add(srcEntry);
        }
    }

    private Language getLangFromCode(String code) {
        if (code.equals("se")) {
            return Language.SWEDISH;
        }
        if (code.equals("es")) {
            return Language.SPANISH;
        }
        if (code.equals("pt")) {
            return Language.PORTUGUESE;
        }
        return Language.ENGLISH;
    }

    protected String translate(String inputText) {
        if (inputText.isEmpty()) {
            return "";
        }
        Translate.setHttpReferrer((String)"http://www.specifysoftware.org");
        try {
            String text = inputText;
            boolean hasSpecialChars = false;
            while (StringUtils.contains((String)text, (String)"%d") || StringUtils.contains((String)text, (String)"%s") || StringUtils.contains((String)text, (String)"\\n")) {
                text = StringUtils.replace((String)text, (String)"%d", (String)"99");
                text = StringUtils.replace((String)text, (String)"%s", (String)"88");
                text = StringUtils.replace((String)text, (String)"\\n", (String)" 77 ");
                hasSpecialChars = true;
            }
            Language lang = this.getLangFromCode(this.destLanguage.getCode());
            String newText = Translate.execute((String)text, (Language)Language.ENGLISH, (Language)lang);
            if (hasSpecialChars) {
                while (StringUtils.contains((String)newText, (String)"77") || StringUtils.contains((String)newText, (String)"88") || StringUtils.contains((String)newText, (String)"99")) {
                    newText = StringUtils.replace((String)newText, (String)"99", (String)"%d");
                    newText = StringUtils.replace((String)newText, (String)"88", (String)"%s");
                    newText = StringUtils.replace((String)newText, (String)" 77 ", (String)" \\n ");
                    newText = StringUtils.replace((String)newText, (String)"77 ", (String)"\\n ");
                    newText = StringUtils.replace((String)newText, (String)" 77", (String)" \\n");
                }
            }
            return newText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void translateNewItems() {
        String STATUSBAR_NAME = "STATUS";
        final JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setProgressRange("STATUS", 0, 100);
        this.startTransMenuItem.setEnabled(false);
        this.stopTransMenuItem.setEnabled(true);
        final double total = this.newKeyList.size();
        SwingWorker<Integer, Integer> translator = new SwingWorker<Integer, Integer>(){

            @Override
            protected Integer doInBackground() throws Exception {
                int count = 0;
                for (String key : StrLocalizerApp.this.newKeyList) {
                    StrLocaleEntry entry = StrLocalizerApp.this.srcFile.getItemHash().get(key);
                    String transText = StrLocalizerApp.this.translate(entry.getSrcStr());
                    if (transText != null) {
                        entry.setDstStr(transText);
                    }
                    try {
                        Thread.sleep(100 + (int)(Math.random() * 100.0));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.setProgress((int)((double)count / total * 100.0));
                    System.out.println(String.valueOf(entry.getSrcStr()) + "  " + count);
                    ++count;
                    if (StrLocalizerApp.this.contTrans.get()) continue;
                    return null;
                }
                return null;
            }

            @Override
            protected void done() {
                statusBar.setText("");
                statusBar.setProgressDone("STATUS");
                UIRegistry.showLocalizedMsg("Done Localizing");
                StrLocalizerApp.this.startTransMenuItem.setEnabled(true);
                StrLocalizerApp.this.stopTransMenuItem.setEnabled(false);
            }
        };
        statusBar.setIndeterminate("STATUS", true);
        translator.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    statusBar.setText(String.valueOf(String.format("%d / 100 ", (Integer)evt.getNewValue())) + "%");
                }
            }
        });
        translator.execute();
    }

    @Override
    public void doAbout() {
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        if (doAppExit) {
            this.checkForChanges();
            System.exit(0);
            return true;
        }
        return false;
    }

    @Override
    public void doPreferences() {
    }

    private void doSave() {
        this.termList.clearSelection();
        this.mergeToDst(this.srcFile, this.destFile);
        this.destFile.save();
        this.destFile.clearEditFlags();
        this.srcFile.clearEditFlags();
    }

    public void addMenuBar(JFrame frame) {
        this.frame = frame;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(UIRegistry.getResourceString("FILE"));
        JMenuItem chooseFileItem = new JMenuItem(UIRegistry.getResourceString("StrLocalizerApp.ChooseFileMenu"));
        fileMenu.add(chooseFileItem);
        chooseFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrLocalizerApp.this.doChooseFile();
            }
        });
        JMenuItem saveItem = new JMenuItem(UIRegistry.getResourceString("SAVE"));
        fileMenu.add(saveItem);
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrLocalizerApp.this.doSave();
            }
        });
        fileMenu.addSeparator();
        JMenuItem chooseDirMenu = new JMenuItem(UIRegistry.getResourceString("StrLocalizerApp.CreateNewLocaleMenu"));
        fileMenu.add(chooseDirMenu);
        chooseDirMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrLocalizerApp.this.doCreateNewLocale(false);
            }
        });
        JMenuItem newLocaleItem = new JMenuItem(UIRegistry.getResourceString("StrLocalizerApp.ChooseLocaleMenu"));
        fileMenu.add(newLocaleItem);
        newLocaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fullLanguage = StrLocalizerApp.this.doChooseExistingLocalization();
                if (fullLanguage != null) {
                    StrLocalizerApp.this.init(fullLanguage);
                }
            }
        });
        if (!UIHelper.isMacOS()) {
            fileMenu.addSeparator();
            JMenuItem exitMenu = new JMenuItem(UIRegistry.getResourceString("EXIT"));
            exitMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StrLocalizerApp.this.doExit(StrLocalizerApp.this.checkForChanges());
                }
            });
            fileMenu.add(exitMenu);
        }
        menuBar.add(fileMenu);
        JMenu transMenu = new JMenu(UIRegistry.getResourceString("StrLocalizerApp.Translate"));
        menuBar.add(transMenu);
        this.startTransMenuItem = new JMenuItem(UIRegistry.getResourceString("StrLocalizerApp.Start"));
        transMenu.add(this.startTransMenuItem);
        this.startTransMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrLocalizerApp.this.translateNewItems();
            }
        });
        this.stopTransMenuItem = new JMenuItem(UIRegistry.getResourceString("Stop"));
        transMenu.add(this.stopTransMenuItem);
        this.stopTransMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrLocalizerApp.this.contTrans.set(false);
            }
        });
        this.stopTransMenuItem.setEnabled(false);
        frame.setJMenuBar(menuBar);
        UIRegistry.setTopWindow(frame);
        UIRegistry.register("frame", frame);
    }

    protected void doNewLocale() {
        if (!this.checkForChanges()) {
            return;
        }
        ChooseFromListDlg<LanguageEntry> ldlg = new ChooseFromListDlg<LanguageEntry>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("StrLocalizerApp.ChooseLanguageDlgTitle"), this.languages);
        UIHelper.centerAndShow(ldlg);
        if (ldlg.isCancelled() || ldlg.getSelectedObject() == null) {
            return;
        }
        JFileChooser fdlg = new JFileChooser();
        fdlg.setFileSelectionMode(1);
        int fdlgResult = fdlg.showOpenDialog(null);
        if (fdlgResult != 0) {
            return;
        }
        File destDir = fdlg.getSelectedFile();
        this.destLanguage = ldlg.getSelectedObject();
        final String newLang = this.destLanguage.getEnglishName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StrLocalizerApp.this.destLbl.setText(String.valueOf(newLang) + ":");
            }
        });
        this.setupSrcFiles(this.getDefaultPath());
        this.setupDestFiles(ldlg.getSelectedObject().getCode(), destDir.getPath());
        for (StrLocaleFile file : this.destFiles) {
            file.save();
        }
        this.currentPath = destDir.getPath();
        this.newSrcFile(this.getResourcesFile());
    }

    protected int getLocaleFileInxBySrcPath(Vector<StrLocaleFile> files, String srcPath) {
        int result = 0;
        for (StrLocaleFile file : files) {
            if (file.getSrcPath().equals(srcPath)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    protected StrLocaleFile getLocaleFileByPath(List<StrLocaleFile> files, String path) {
        for (StrLocaleFile file : files) {
            if (!file.getPath().equals(path)) continue;
            return file;
        }
        return null;
    }

    protected boolean checkForChanges() {
        int s = this.termList.getSelectedIndex();
        if (s != -1) {
            StrLocaleEntry entry = this.srcFile.getKey(s);
            entry.setDstStr(this.textField.getText());
        }
        if (this.srcFile.isEdited()) {
            int response = JOptionPane.showOptionDialog((Frame)UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("StrLocalizerApp.SaveChangesMsg"), this.destFile.getPath()), UIRegistry.getResourceString("StrLocalizerApp.SaveChangesTitle"), 1, 3, null, null, 0);
            if (response == 2) {
                return false;
            }
            if (response == 0) {
                this.doSave();
                return true;
            }
        }
        return true;
    }

    protected void doChooseFile() {
        if (!this.checkForChanges()) {
            return;
        }
        ChooseFromListDlg<StrLocaleFile> ldlg = new ChooseFromListDlg<StrLocaleFile>((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("StrLocalizerApp.ChooseFileDlgTitle"), this.srcFiles);
        UIHelper.centerAndShow(ldlg);
        if (ldlg.isCancelled() || ldlg.getSelectedObject() == null) {
            return;
        }
        this.newSrcFile(ldlg.getSelectedObject());
    }

    protected void newSrcFile(StrLocaleFile newSrc) {
        this.termList.clearSelection();
        this.newTermList.clearSelection();
        this.srcFile = newSrc;
        int destInx = this.getLocaleFileInxBySrcPath(this.destFiles, this.srcFile.getPath());
        StrLocaleFile oldDest = this.destFiles.get(destInx);
        this.destFile = new StrLocaleFile(oldDest.getPath(), oldDest.getSrcPath(), true);
        this.destFiles.set(destInx, this.destFile);
        this.newKeyList.clear();
        this.mergeToSrc(this.srcFile, this.destFile);
        ItemModel termsModel = new ItemModel(this.srcFile);
        this.termList.setModel(termsModel);
        DefaultListModel<String> itemModel = new DefaultListModel<String>();
        itemModel.clear();
        for (String str : this.newKeyList) {
            itemModel.addElement(str);
        }
        this.newTermList.setModel(itemModel);
        this.rsController.setLength(this.srcFile.getNumberOfKeys());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StrLocalizerApp.this.fileLbl.setText(StrLocalizerApp.this.destFile.getPath());
            }
        });
        this.searchable = new LocalizerSearchHelper(this.baseDir, "props-index");
        this.searchable.indexProps(this.srcFile.getItems());
    }

    private String getFullLang(Locale locale) {
        return String.valueOf(locale.getLanguage()) + (StringUtils.isNotEmpty((String)locale.getVariant()) ? "_" + locale.getVariant() : "");
    }

    private Locale doChooseLangLocale(boolean hideExisting) {
        int n;
        HashSet<String> existingLocs = new HashSet<String>();
        if (hideExisting) {
            String[] stringArray = this.rootDir.list();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nm = stringArray[n2];
                if (!nm.startsWith(".")) {
                    existingLocs.add(nm);
                }
                ++n2;
            }
        }
        Vector<Locale> locales = new Vector<Locale>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n3 = localeArray.length;
        n = 0;
        while (n < n3) {
            Locale l = localeArray[n];
            if (!hideExisting || !existingLocs.contains(this.getFullLang(l))) {
                locales.add(l);
            }
            ++n;
        }
        Collections.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        Vector<String> localeNames = new Vector<String>();
        for (Locale l : locales) {
            localeNames.add(l.getDisplayName());
        }
        ToggleButtonChooserDlg chooser = new ToggleButtonChooserDlg(null, "CHOOSE_LOCALE", localeNames, ToggleButtonChooserPanel.Type.RadioButton);
        chooser.setUseScrollPane(true);
        chooser.setVisible(true);
        if (!chooser.isCancelled()) {
            return (Locale)locales.get(chooser.getSelectedIndex());
        }
        return null;
    }

    protected NameValuePair[] createPostParameters(String inputStr, String src) {
        Vector<NameValuePair> postParams = new Vector<NameValuePair>();
        try {
            postParams.add(new NameValuePair("doit", "done"));
            postParams.add(new NameValuePair("ei", "UTF-8"));
            postParams.add(new NameValuePair("lp", src));
            postParams.add(new NameValuePair("fr", "bf-home"));
            postParams.add(new NameValuePair("intl", "1"));
            postParams.add(new NameValuePair("tt", "urltext"));
            postParams.add(new NameValuePair("trtext", inputStr));
            NameValuePair[] paramArray = new NameValuePair[postParams.size()];
            int i = 0;
            while (i < paramArray.length) {
                paramArray[i] = (NameValuePair)postParams.get(i);
                ++i;
            }
            return paramArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.doExit(this.checkForChanges());
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public static void main(String[] args) {
        String appdatadir;
        UIRegistry.setAppName("Specify");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] pairs = s.split("=");
            if (pairs.length == 2) {
                if (pairs[0].startsWith("-D")) {
                    System.setProperty(pairs[0].substring(2, pairs[0].length()), pairs[1]);
                }
            } else {
                String symbol = pairs[0].substring(2, pairs[0].length());
                System.setProperty(symbol, symbol);
            }
            ++n2;
        }
        String appDir = System.getProperty("appdir");
        if (StringUtils.isNotEmpty((String)appDir)) {
            UIRegistry.setDefaultWorkingPath(appDir);
        }
        if (StringUtils.isNotEmpty((String)(appdatadir = System.getProperty("appdatadir")))) {
            UIRegistry.setBaseAppDataDir(appdatadir);
        }
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons.xml"));
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
        try {
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        boolean doIt = false;
        if (doIt) {
            Charset utf8charset = Charset.forName("UTF-8");
            Charset iso88591charset = Charset.forName("ISO-8859-1");
            ByteBuffer inputBuffer = ByteBuffer.wrap(new byte[]{-61, -94});
            CharBuffer data = utf8charset.decode(inputBuffer);
            ByteBuffer outputBuffer = iso88591charset.encode(data);
            byte[] outputData = outputBuffer.array();
            System.out.println(new String(outputData));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIHelper.OSTYPE osType = UIHelper.getOSType();
                    if (osType == UIHelper.OSTYPE.Windows) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                    } else if (osType == UIHelper.OSTYPE.Linux) {
                        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                JFrame frame = new JFrame(UIRegistry.getResourceString("StrLocalizerApp.AppTitle"));
                frame.setDefaultCloseOperation(0);
                final StrLocalizerApp sl = new StrLocalizerApp();
                sl.addMenuBar(frame);
                frame.setContentPane(sl);
                frame.setSize(768, 1024);
                frame.addWindowListener(sl);
                IconManager.setApplicationClass(Specify.class);
                frame.setIconImage(IconManager.getImage(IconManager.makeIconName("SpecifyWhite32")).getImage());
                UIHelper.centerAndShow(frame);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        sl.startUp();
                    }
                });
            }
        });
    }

    protected LanguageEntry getLanguageByCode(String code) {
        for (LanguageEntry l : this.languages) {
            System.out.println(String.valueOf(l.getCode()) + "=" + code);
            if (!l.getCode().equals(code)) continue;
            return l;
        }
        return null;
    }

    class ItemModel
    extends AbstractListModel {
        protected StrLocaleFile file;

        public ItemModel(StrLocaleFile file) {
            this.file = file;
        }

        @Override
        public Object getElementAt(int index) {
            return this.file.getKey(index).getKey();
        }

        @Override
        public int getSize() {
            return this.file.getNumberOfKeys();
        }
    }

    private class LanguageEntry
    implements Comparable<LanguageEntry> {
        private String englishName;
        private String code;

        public LanguageEntry(String englishName, String code) {
            this.englishName = englishName;
            this.code = code;
        }

        public String getEnglishName() {
            return this.englishName;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.englishName) + " (" + this.code + ")";
        }

        @Override
        public int compareTo(LanguageEntry arg0) {
            return this.englishName.compareTo(arg0.englishName);
        }
    }

    class SearchResultsModel
    extends AbstractTableModel {
        protected String[] headers = new String[]{"Key", "Text"};

        SearchResultsModel() {
        }

        public void fireChanges() {
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers != null ? this.headers[column] : "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.headers != null ? this.headers.length : 0;
        }

        @Override
        public int getRowCount() {
            return StrLocalizerApp.this.results.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StrLocaleEntry entry = StrLocalizerApp.this.results.get(rowIndex);
            return columnIndex == 0 ? entry.getKey() : entry.getSrcStr();
        }
    }
}

