/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import edu.ku.brc.specify.tools.StrLocaleEntry;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StrLocaleFile {
    private static final Logger log = Logger.getLogger(StrLocaleFile.class);
    protected String dstPath;
    protected String srcPath;
    protected Vector<StrLocaleEntry> items = new Vector();
    protected Hashtable<String, StrLocaleEntry> itemHash = new Hashtable();
    protected Hashtable<String, String> chkHash = new Hashtable();
    protected boolean isDestination;
    protected Hashtable<String, Integer> keyToInxMap = new Hashtable();
    protected Vector<StrLocaleEntry> keys = new Vector();

    public StrLocaleFile(String dstPath, String srcPath, boolean isDestination) {
        this.dstPath = dstPath;
        this.srcPath = srcPath;
        this.isDestination = isDestination;
        this.load();
    }

    public int getNumberOfKeys() {
        return this.keys.size();
    }

    public Integer getInxForKey(String key) {
        return this.keyToInxMap.get(key);
    }

    private void load() {
        char[] dstBytes = new char[2048];
        try {
            this.itemHash.clear();
            File file = new File(this.dstPath);
            if (file.exists()) {
                int duplicateCnt = 0;
                int index = 0;
                int count = 0;
                List lines = FileUtils.readLines((File)file);
                for (String line : lines) {
                    if (line.trim().startsWith("#")) {
                        this.items.add(new StrLocaleEntry("#", line, null, StrLocaleEntry.STATUS.IsComment));
                    } else if (line.indexOf(61) > -1) {
                        int spec;
                        int fInx;
                        int inx = line.indexOf(61);
                        String key = line.substring(0, inx);
                        String value = line.substring(inx + 1, line.length());
                        boolean debug = false;
                        if (debug && (fInx = value.indexOf(spec = 65533)) > -1) {
                            int jj = 0;
                            byte[] bytes = value.getBytes();
                            int ii = 0;
                            while (ii < bytes.length) {
                                int b1 = bytes[ii];
                                short s1 = (short)(b1 < 0 ? 256 + b1 : b1);
                                if (s1 > 127 && s1 != 195) {
                                    s1 = (short)(s1 + 64);
                                }
                                if (s1 == 195) {
                                    if ((s1 = (short)((b1 = bytes[++ii]) < 0 ? 256 + b1 : b1)) > 127 && s1 != 195) {
                                        s1 = (short)(s1 + 64);
                                    }
                                    dstBytes[jj++] = (char)s1;
                                } else {
                                    dstBytes[jj++] = (char)bytes[ii];
                                }
                                ++ii;
                            }
                            System.out.print(String.valueOf(value) + '=');
                            value = new String(dstBytes, 0, jj);
                            System.out.println(value);
                        }
                        if (this.itemHash.get(key) != null) {
                            log.error((Object)("Key '" + key + "' on Line " + count + " is a duplicate."));
                            ++duplicateCnt;
                        } else {
                            StrLocaleEntry entry = new StrLocaleEntry(key, value, null, StringUtils.isEmpty((String)value) ? StrLocaleEntry.STATUS.IsNew : StrLocaleEntry.STATUS.IsOK);
                            this.items.add(entry);
                            this.itemHash.put(key, entry);
                            this.keyToInxMap.put(key, this.keys.size());
                            this.keys.add(entry);
                        }
                        ++index;
                    } else {
                        this.items.add(new StrLocaleEntry(null, null, null, StrLocaleEntry.STATUS.IsBlank));
                    }
                    ++count;
                }
                log.error((Object)(String.valueOf(duplicateCnt) + " duplicate keys: " + this.dstPath));
            }
            if (this.isDestination) {
                this.loadCheckFile();
            }
            this.clearEditFlags();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadCheckFile() {
        try {
            this.chkHash.clear();
            File file = new File(String.valueOf(this.dstPath) + ".orig");
            if (file.exists()) {
                List lines = FileUtils.readLines((File)file);
                for (String line : lines) {
                    if (line.trim().startsWith("#") || line.indexOf(61) <= -1) continue;
                    int inx = line.indexOf(61);
                    String key = line.substring(0, inx);
                    String value = line.substring(inx + 1, line.length());
                    this.chkHash.put(key, value);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isSrcSameAsDest(String key, String srcValue) {
        String origValue = this.chkHash.get(key);
        if (origValue != null) {
            return origValue.equals(srcValue);
        }
        return false;
    }

    public boolean save() {
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(this.dstPath);
            dos = new DataOutputStream(fos);
            for (StrLocaleEntry entry : this.items) {
                String str = "";
                if (entry.getKey() != null) {
                    str = entry.getKey().equals("#") ? entry.getSrcStr() : String.valueOf(entry.getKey()) + "=" + (entry.getDstStr() == null ? "" : entry.getDstStr());
                }
                str = String.valueOf(str) + '\n';
                dos.writeBytes(str);
            }
            dos.flush();
            dos.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("e: " + e);
            return false;
        }
    }

    public void clearEditFlags() {
        for (StrLocaleEntry entry : this.items) {
            entry.setEdited(false);
        }
    }

    public boolean isEdited() {
        for (StrLocaleEntry entry : this.items) {
            if (!entry.isEdited()) continue;
            return true;
        }
        return false;
    }

    public StrLocaleEntry getKey(int index) {
        return this.keys.get(index);
    }

    public Hashtable<String, StrLocaleEntry> getItemHash() {
        return this.itemHash;
    }

    public Vector<StrLocaleEntry> getItems() {
        return this.items;
    }

    public Hashtable<String, String> getChkHash() {
        return this.chkHash;
    }

    public String getPath() {
        return this.dstPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public String toString() {
        return FilenameUtils.getName((String)this.getPath());
    }
}

