/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SpecifySchemaGenerator {
    protected static final Logger log = Logger.getLogger(SpecifySchemaGenerator.class);

    public static void generateSchema(DatabaseDriverInfo dbdriverInfo, String hostname, String databaseName, String userName, String password) throws SQLException {
        SpecifySchemaGenerator.generateSchema(dbdriverInfo, hostname, databaseName, userName, password, false);
    }

    public static boolean updateSchema(DatabaseDriverInfo dbdriverInfo, String hostname, String databaseName, String userName, String password) throws SQLException {
        return SpecifySchemaGenerator.generateSchema(dbdriverInfo, hostname, databaseName, userName, password, true);
    }

    public static boolean generateSchema(DatabaseDriverInfo dbdriverInfo, String hostname, String databaseName, String userName, String password, boolean doUpdate) throws SQLException {
        log.debug((Object)("generateSchema hostname:" + hostname));
        log.debug((Object)("generateSchema databaseName:" + databaseName));
        String connectionStr = dbdriverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostname, databaseName, false, true, userName, password, dbdriverInfo.getName());
        log.debug((Object)("generateSchema connectionStr: " + connectionStr));
        DBConnection dbConn = null;
        try {
            dbConn = DBConnection.createInstance(dbdriverInfo.getDriverClassName(), dbdriverInfo.getDialectClassName(), databaseName, connectionStr, userName, password);
            if (dbConn != null && dbConn.getConnection() != null) {
                if (!doUpdate) {
                    SpecifySchemaGenerator.dropAndCreateDB(dbConn, databaseName);
                }
                connectionStr = dbdriverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostname, databaseName, userName, password, dbdriverInfo.getName());
                SpecifySchemaGenerator.doGenSchema(dbdriverInfo, connectionStr, userName, password, doUpdate);
                String connStr = connectionStr;
                DBConnection dbConnForDatabase = DBConnection.createInstance(dbdriverInfo.getDriverClassName(), dbdriverInfo.getDialectClassName(), databaseName, connStr, userName, password);
                if (!doUpdate) {
                    SpecifySchemaGenerator.fixFloatFields(dbConnForDatabase);
                    BasicSQLUtils.setDBConnection(dbConnForDatabase.getConnection());
                    SpecifySchemaUpdateService.createSGRTables(dbConnForDatabase.getConnection(), databaseName);
                    BasicSQLUtils.setDBConnection(null);
                }
                dbConnForDatabase.close();
            } else {
                UIRegistry.showLocalizedError("SpecifySchemaGenerator.IT_UP_ERROR");
                CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit", null));
                return false;
            }
            return true;
        }
        finally {
            if (dbConn != null) {
                dbConn.close();
            }
        }
    }

    protected static void dropAndCreateDB(DBConnection dbConnection, String dbName) throws SQLException {
        SpecifySchemaGenerator.dropDB(dbConnection, dbName);
        SpecifySchemaGenerator.createDB(dbConnection, dbName);
    }

    protected static void dropDB(DBConnection dbConnection, String dbName) throws SQLException {
        Connection connection = dbConnection.createConnection();
        if (connection != null) {
            Statement stmt = connection.createStatement();
            try {
                log.info((Object)("Dropping database " + dbName));
                stmt.execute("drop database " + dbName);
                log.info((Object)("Dropped database " + dbName));
                stmt.close();
            }
            catch (SQLException ex) {
                log.error((Object)("SQLException could not drop database [" + dbName + "]:" + "\n" + ex.toString()));
                ex.toString();
            }
            stmt.close();
            connection.close();
        } else {
            log.error((Object)dbConnection.getErrorMsg());
        }
    }

    protected static void fixFloatFields(DBConnection dbConnection) throws SQLException {
        Connection connection = dbConnection.createConnection();
        if (connection != null) {
            Statement stmt = connection.createStatement();
            try {
                for (DBTableInfo tableInfo : DBTableIdMgr.getInstance().getTables()) {
                    for (DBFieldInfo fldInfo : tableInfo.getFields()) {
                        if (fldInfo.getDataClass() != Float.class) continue;
                        String sql = "ALTER TABLE " + tableInfo.getName() + " MODIFY " + fldInfo.getColumn() + " FLOAT(20,10)";
                        stmt.executeUpdate(sql);
                        stmt.clearBatch();
                        log.info((Object)sql);
                    }
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            stmt.close();
            connection.close();
        } else {
            log.error((Object)dbConnection.getErrorMsg());
        }
    }

    protected static void createDB(DBConnection dbConnection, String dbName) throws SQLException {
        Connection connection = dbConnection.createConnection();
        if (connection != null) {
            Statement stmt = connection.createStatement();
            log.info((Object)("Creating database " + dbName));
            stmt.execute("create database " + dbName + " default charset utf8;");
            log.info((Object)("Created database " + dbName));
            stmt.close();
            connection.close();
        } else {
            log.error((Object)dbConnection.getErrorMsg());
        }
    }

    protected static Properties getHibernateProperties(DatabaseDriverInfo driverInfo, String connectionStr, String user, String passwd, boolean doUpdate) {
        Properties props = new Properties();
        props.setProperty("hibernate.connection.driver_class", driverInfo.getDriverClassName());
        props.setProperty("hibernate.dialect", driverInfo.getDialectClassName());
        props.setProperty("hibernate.connection.url", connectionStr);
        props.setProperty("hibernate.connection.username", user);
        props.setProperty("hibernate.connection.password", passwd);
        props.setProperty("hibernate.max_fetch_depth", "3");
        props.setProperty("hibernate.connection.pool_size", "5");
        props.setProperty("hibernate.format_sql", "true");
        if (doUpdate) {
            props.setProperty("hibernate.hbm2ddl.auto=update", "true");
        }
        log.debug((Object)("Hibernate Propereties: " + props.toString()));
        return props;
    }

    protected static void doGenSchema(DatabaseDriverInfo driverInfo, String connectionStr, String user, String passwd, boolean doUpdate) {
        AnnotationConfiguration hibCfg = new AnnotationConfiguration();
        hibCfg.setProperties(SpecifySchemaGenerator.getHibernateProperties(driverInfo, connectionStr, user, passwd, doUpdate));
        hibCfg.configure();
        if (doUpdate) {
            SchemaUpdate schemaUpdater = new SchemaUpdate((Configuration)hibCfg);
            log.info((Object)"Updating schema");
            boolean doScript = false;
            log.info((Object)"Updating the DB schema");
            schemaUpdater.execute(doScript, true);
            log.info((Object)"DB schema Updating completed");
            List exceptions = schemaUpdater.getExceptions();
            for (Object o : exceptions) {
                Exception e = (Exception)o;
                log.error((Object)e.getMessage());
            }
        } else {
            SchemaExport schemaExporter = new SchemaExport((Configuration)hibCfg);
            schemaExporter.setDelimiter(";");
            log.info((Object)"Generating schema");
            boolean printToScreen = false;
            boolean exportToDb = true;
            boolean justDrop = false;
            boolean justCreate = true;
            log.info((Object)"Creating the DB schema");
            schemaExporter.execute(printToScreen, exportToDb, justDrop, justCreate);
            log.info((Object)"DB schema creation completed");
            List exceptions = schemaExporter.getExceptions();
            for (Object o : exceptions) {
                Exception e = (Exception)o;
                log.error((Object)e.getMessage());
            }
        }
    }

    public static void main(String[] args) throws SQLException {
        DatabaseDriverInfo dbdriverInfo = DatabaseDriverInfo.getDriver("SQLServer");
        SpecifySchemaGenerator.generateSchema(dbdriverInfo, "localhost", "Fish_sp6", "sa", "Re4a22jiu");
    }
}

