/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.dom4j.Element;
import org.dom4j.Node;

public class ReadMeBuilder {
    protected Vector<BugInfo> list = new Vector();

    public void process() {
        String path;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0 && (path = chooser.getSelectedFile().getAbsolutePath()) != null) {
            try {
                Element root = XMLHelper.readFileToDOM4J(new File(path));
                if (root != null) {
                    for (Object bugObj : root.selectNodes("bug")) {
                        Element node = (Element)bugObj;
                        String bugId = ((Node)node.selectObject("bug_id")).getText();
                        this.list.add(new BugInfo(((Node)node.selectObject("short_desc")).getText(), ((Node)node.selectObject("delta_ts")).getText(), bugId));
                        System.out.println(bugId);
                    }
                }
                Collections.sort(this.list);
                PrintWriter pw = new PrintWriter(new File("readme.html"));
                pw.append("</body>\n</html>\n");
                pw.append("<html>\n");
                pw.append("<head>\n");
                pw.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                pw.append("<title>Release Notes</title>\n");
                pw.append("</head>\n");
                pw.append("<body>\n");
                pw.append("<h3>Release Notes<br />\n");
                pw.append("  Specify 6.0.xx<br />\n");
                pw.append("  08 July 2009<br />\n");
                pw.append("  Specify Software Project</h3>\n");
                pw.append("<ol>\n");
                for (BugInfo bi : this.list) {
                    pw.append("<li>");
                    pw.append(bi.getText());
                    pw.append("&nbsp;&nbsp;");
                    pw.append(bi.getDate());
                    pw.append("&nbsp;&nbsp;(");
                    pw.append(bi.getNum());
                    pw.append(").</li>\n");
                }
                pw.append("</ol>\n");
                int i = 0;
                while (i < 4) {
                    pw.append("<BR>\n");
                    ++i;
                }
                pw.append("</body>\n</html>\n");
                pw.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            UIRegistry.showLocalizedMsg("Done.");
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReadMeBuilder rmb = new ReadMeBuilder();
                rmb.process();
            }
        });
    }

    class BugInfo
    implements Comparable<BugInfo> {
        protected String text;
        protected String date;
        protected String num;

        public BugInfo(String text, String date, String num) {
            this.text = text;
            this.date = date;
            this.num = num;
        }

        public String getText() {
            return this.text;
        }

        public String getDate() {
            return this.date;
        }

        public String getNum() {
            return this.num;
        }

        @Override
        public int compareTo(BugInfo o) {
            int rv = this.num.compareTo(o.num);
            if (rv == 0) {
                rv = this.date.compareTo(o.date);
            }
            return rv;
        }
    }
}

