/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.tools.StrLocaleEntry;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class LocalizerSearchHelper {
    private static final Logger log = Logger.getLogger(LocalizerSearchHelper.class);
    protected File srcCodeFilesDir = null;
    protected File baseDir;
    protected FileDocument fileDoc = new FileDocument();
    protected File FILE_INDEX_DIR;
    protected IndexReader reader;
    protected Searcher searcher;
    protected Analyzer analyzer;
    protected Directory memIndexer = null;

    public LocalizerSearchHelper(File baseDir, String indexDirName) {
        this.baseDir = baseDir;
        this.FILE_INDEX_DIR = new File(this.baseDir + File.separator + indexDirName);
    }

    public void setSrcCodeFilesDir(File srcCodeFilesDir) {
        this.srcCodeFilesDir = srcCodeFilesDir;
    }

    public void initLucene(boolean doDeleteIndex) {
        try {
            this.reader = IndexReader.open((Directory)FSDirectory.open((File)this.FILE_INDEX_DIR), (boolean)true);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.searcher = new IndexSearcher(this.reader);
        this.analyzer = new StandardAnalyzer(Version.LUCENE_30);
    }

    /*
     * WARNING - void declaration
     */
    public Vector<Pair<String, String>> findOldL10NKeys(String[] fileNames) {
        this.initLucene(true);
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (this.srcCodeFilesDir != null) {
            chooser.setSelectedFile(new File(FilenameUtils.getName((String)this.srcCodeFilesDir.getAbsolutePath())));
            chooser.setSelectedFile(new File(this.srcCodeFilesDir.getParent()));
        }
        if (chooser.showOpenDialog(UIRegistry.getMostRecentWindow()) != 0) {
            return null;
        }
        this.srcCodeFilesDir = new File(chooser.getSelectedFile().getAbsolutePath());
        this.indexSourceFiles();
        Vector<Pair<String, String>> fullNotFoundList = new Vector<Pair<String, String>>();
        try {
            ConversionLogger convLogger = new ConversionLogger();
            convLogger.initialize("resources", "Resources");
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                Vector<Pair<String, void>> notFoundList = new Vector<Pair<String, void>>();
                Vector<String> terms = new Vector<String>();
                String propFileName = String.valueOf(this.baseDir.getAbsolutePath()) + "/" + fileName;
                File resFile = new File(String.valueOf(propFileName) + ".properties");
                if (resFile.exists()) {
                    List lines = FileUtils.readLines((File)resFile);
                    for (String line : lines) {
                        String[] toks;
                        int inx;
                        if (line.startsWith("#") || (inx = line.indexOf("=")) <= -1 || (toks = StringUtils.split((String)line, (String)"=")).length <= 1) continue;
                        terms.add(toks[0]);
                    }
                } else {
                    System.err.println("Doesn't exist: " + resFile.getAbsolutePath());
                }
                String field = "contents";
                QueryParser parser = new QueryParser(Version.LUCENE_30, field, this.analyzer);
                for (String term : terms) {
                    try {
                        void var17_24;
                        int lastInx;
                        String string;
                        int n3;
                        if (term.equals("AND") || term.equals("OR")) continue;
                        Query query = parser.parse(term);
                        Object var17_21 = null;
                        int hits = this.getTotalHits(query, 10);
                        if (hits == 0 && (n3 = term.indexOf(46)) > -1 && (hits = this.getTotalHits(parser.parse(string = term.substring(n3 + 1)), 10)) == 0 && (lastInx = term.lastIndexOf(46)) > -1 && lastInx != n3) {
                            String string2 = term.substring(lastInx + 1);
                            hits = this.getTotalHits(parser.parse(string2), 10);
                        }
                        if (hits != 0 || term.endsWith("_desc")) continue;
                        notFoundList.add(new Pair<String, void>(term, var17_24));
                        log.debug((Object)("'" + term + "' was not found " + (var17_24 != null ? "SubTerm[" + (String)var17_24 + "]" : "")));
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
                String fullName = String.valueOf(propFileName) + ".html";
                TableWriter tblWriter = convLogger.getWriter(FilenameUtils.getName((String)fullName), propFileName);
                tblWriter.startTable();
                tblWriter.logHdr("Id", "Full Key", "Sub Key");
                int cnt = 1;
                for (Pair pair : notFoundList) {
                    tblWriter.log(Integer.toString(cnt++), (String)pair.first, pair.second != null ? (String)pair.second : "&nbsp;");
                }
                tblWriter.endTable();
                fullNotFoundList.addAll(notFoundList);
                if (notFoundList.size() > 0 && resFile.exists()) {
                    List list = FileUtils.readLines((File)resFile);
                    Vector linesCache = new Vector();
                    block8: for (Pair pair : notFoundList) {
                        linesCache.clear();
                        linesCache.addAll(list);
                        int lineInx = 0;
                        for (String line : linesCache) {
                            String[] toks;
                            int inx;
                            if (!line.startsWith("#") && (inx = line.indexOf("=")) > -1 && (toks = StringUtils.split((String)line, (String)"=")).length > 1 && toks[0].equals(pair.first)) {
                                list.remove(lineInx);
                                continue block8;
                            }
                            ++lineInx;
                        }
                    }
                    FileUtils.writeLines((File)resFile, linesCache);
                }
                ++n2;
            }
            convLogger.closeAll();
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(LocalizerSearchHelper.class, ex);
            ex.printStackTrace();
        }
        return fullNotFoundList;
    }

    protected void indexSourceFiles() {
        if (this.FILE_INDEX_DIR.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.FILE_INDEX_DIR);
            }
            catch (IOException e) {
                e.printStackTrace();
                UIRegistry.displayErrorDlg("Cannot save index to '" + this.FILE_INDEX_DIR + "' directory, please delete it first");
                System.exit(1);
            }
        }
        this.FILE_INDEX_DIR.mkdirs();
        if (this.srcCodeFilesDir == null || !this.srcCodeFilesDir.exists()) {
            UIRegistry.displayErrorDlg("Cannot save index to '" + this.srcCodeFilesDir + "' directory, please delete it first");
            System.exit(1);
        }
        Date start = new Date();
        try {
            IndexWriter writer = new IndexWriter((Directory)FSDirectory.open((File)this.FILE_INDEX_DIR), (Analyzer)new StandardAnalyzer(Version.LUCENE_30), true, IndexWriter.MaxFieldLength.LIMITED);
            log.debug((Object)("Indexing to directory '" + this.FILE_INDEX_DIR + "'..."));
            this.indexDocs(writer, this.srcCodeFilesDir);
            log.debug((Object)"Optimizing...");
            writer.optimize();
            writer.close();
            Date end = new Date();
            log.debug((Object)(String.valueOf(end.getTime() - start.getTime()) + " total milliseconds"));
        }
        catch (IOException e) {
            log.debug((Object)(" caught a " + e.getClass() + "\n with message: " + e.getMessage()));
        }
    }

    public void indexProps(Vector<StrLocaleEntry> entries) {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_30);
        }
        this.memIndexer = new RAMDirectory();
        try {
            IndexWriter w = new IndexWriter(this.memIndexer, this.analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
            int i = 0;
            for (StrLocaleEntry entry : entries) {
                if (entry.isValue()) {
                    Document doc = new Document();
                    doc.add((Fieldable)new Field("key", entry.getKey(), Field.Store.NO, Field.Index.ANALYZED));
                    doc.add((Fieldable)new Field("src", entry.getSrcStr(), Field.Store.NO, Field.Index.ANALYZED));
                    doc.add((Fieldable)new Field("dst", entry.getDstStr() != null ? entry.getDstStr() : "", Field.Store.NO, Field.Index.ANALYZED));
                    doc.add((Fieldable)new Field("index", Integer.toString(i), Field.Store.YES, Field.Index.NOT_ANALYZED));
                    w.addDocument(doc);
                }
                ++i;
            }
            w.close();
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (LockObtainFailedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int[] doPropsSearch(String searchText, String fieldName) {
        try {
            QueryParser parser = new QueryParser(Version.LUCENE_30, fieldName, this.analyzer);
            Query query = parser.parse(searchText.toLowerCase());
            IndexSearcher memSearcher = new IndexSearcher(this.memIndexer, true);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)50000, (boolean)true);
            memSearcher.search(query, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            int[] inxs = new int[hits.length];
            int i = 0;
            ScoreDoc[] scoreDocArray = hits;
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                Document d = memSearcher.doc(doc.doc);
                inxs[i++] = Integer.parseInt(d.get("index"));
                ++n2;
            }
            return inxs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void doInteractiveSearch(String searchText) {
        try {
            String field = "contents";
            int repeat = 0;
            QueryParser parser = new QueryParser(Version.LUCENE_30, field, this.analyzer);
            if (StringUtils.isEmpty((String)searchText)) {
                return;
            }
            Query query = parser.parse(searchText);
            log.debug((Object)("Searching for: " + query.toString(field)));
            if (repeat > 0) {
                Date start = new Date();
                int i = 0;
                while (i < repeat) {
                    this.searcher.search(query, null, 100);
                    ++i;
                }
                Date end = new Date();
                log.debug((Object)("Time: " + (end.getTime() - start.getTime()) + "ms"));
            }
            this.doStreamingSearch(this.searcher, query);
            this.reader.close();
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    protected int getTotalHits(Query query, int hitsPerPage) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)(5 * hitsPerPage), (boolean)false);
        this.searcher.search(query, (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        int numTotalHits = collector.getTotalHits();
        return numTotalHits;
    }

    public void doStreamingSearch(Searcher searcher, Query query) throws IOException {
        Collector streamingHitCollector = new Collector(){
            private Scorer scorer;
            private int docBase;

            public void collect(int doc) throws IOException {
                log.debug((Object)("doc=" + doc + this.docBase + " score=" + this.scorer.score()));
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.docBase = docBase;
            }

            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
            }
        };
        searcher.search(query, streamingHitCollector);
    }

    void indexDocs(IndexWriter writer, File file) throws IOException {
        block3: {
            String fileName;
            block4: {
                fileName = file.getName();
                log.debug((Object)("Parsing " + fileName));
                if (!file.canRead()) break block3;
                if (!file.isDirectory()) break block4;
                String[] files = file.list();
                if (files == null) break block3;
                int i = 0;
                while (i < files.length) {
                    this.indexDocs(writer, new File(file, files[i]));
                    ++i;
                }
                break block3;
            }
            if (!fileName.endsWith(".java") && !fileName.endsWith(".xml")) break block3;
            log.debug((Object)("adding " + file));
            try {
                writer.addDocument(this.fileDoc.loadDocument(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public class FileDocument {
        public Document loadDocument(File f) throws FileNotFoundException {
            Document doc = new Document();
            doc.add((Fieldable)new Field("path", f.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("contents", (Reader)new FileReader(f)));
            return doc;
        }

        private FileDocument() {
        }
    }
}

