/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.forms.DataGetterForHashMap;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.ViewSetMgr;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.persist.AltViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewDefIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.HTTPGetter;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.helpers.ZipFileHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.utilapps.ERDVisualizer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class FormDisplayer {
    protected PrintWriter pw = null;
    protected File file = null;
    protected String contentTag = "<!-- Content -->";
    protected int MARGIN = 10;
    protected int HGAP = 60;
    protected int VGAP = 30;
    protected String mapTemplate = "";
    protected File baseDir;
    protected File outputDir;
    protected boolean doPNG = true;
    protected boolean doAll = true;
    protected List<Pair<String, File>> entries = new Vector<Pair<String, File>>();
    protected List<ViewIFace> viewList;
    protected AtomicBoolean okToProc = new AtomicBoolean(true);
    protected int viewInx = 0;
    protected JFrame frame = null;
    protected CustomDialog cancelDlg;

    public FormDisplayer() {
        UIHelper.adjustUIDefaults();
        UIRegistry.setBaseFont(UIHelper.createLabel("").getFont());
        Specify.setUpSystemProperties();
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        UIFieldFormatterMgr.setDoingLocal(true);
        DataObjFieldFormatMgr.setDoingLocal(true);
        TypeSearchForQueryFactory.setDoingLocal(true);
    }

    protected void createHTMLFile(String fileName, String title) {
        try {
            this.file = new File(fileName);
            this.pw = new PrintWriter(this.file);
            this.pw.print("<html><head><title>" + title + "</title></head><body>");
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, ex);
            ex.printStackTrace();
        }
    }

    public void generateFormImages() {
        int userChoice;
        if (this.setup()) {
            this.createFormImagesIndexFile();
        }
        boolean bl = this.doAll = (userChoice = JOptionPane.showConfirmDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("FormDisplayer.CHOOSE_VIEWLIST"), UIRegistry.getResourceString("FormDisplayer.CHOOSE_VIEWLIST_TITLE"), 0)) == 0;
        if (this.setup()) {
            SpecifyAppContextMgr appContext = (SpecifyAppContextMgr)AppContextMgr.getInstance();
            this.viewList = this.doAll ? appContext.getEntirelyAllViews() : appContext.getAllViews();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormDisplayer.this.showView();
                }
            });
        }
        JButton stopBtn = UIHelper.createButton("Stop Generating Images");
        PanelBuilder pb = new PanelBuilder(new FormLayout("p", "p"));
        pb.add((Component)stopBtn, new CellConstraints().xy(1, 1));
        pb.setDefaultDialogBorder();
        this.cancelDlg = new CustomDialog(null, "Stop Image Generation", false, 1, (Component)pb.getPanel());
        this.cancelDlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        this.cancelDlg.setAlwaysOnTop(true);
        this.cancelDlg.setVisible(true);
        Rectangle screenRect = this.cancelDlg.getGraphicsConfiguration().getBounds();
        int y = screenRect.height - this.cancelDlg.getSize().height * 2;
        this.cancelDlg.setLocation(screenRect.x, y);
        stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = (this).FormDisplayer.this.okToProc;
                        synchronized (atomicBoolean) {
                            (this).FormDisplayer.this.okToProc.set(false);
                            (this).FormDisplayer.this.viewInx = (this).FormDisplayer.this.viewList.size();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showView() {
        boolean done = false;
        AtomicBoolean atomicBoolean = this.okToProc;
        synchronized (atomicBoolean) {
            if (this.okToProc.get()) {
                if (this.frame != null) {
                    this.generateViewImage(this.viewList.get(this.viewInx));
                    this.frame.dispose();
                }
                ++this.viewInx;
                ViewIFace view = this.viewList.get(this.viewInx);
                System.out.println(view.getName());
                if (!view.getViewSetName().equals("Editor")) {
                    Object data = null;
                    try {
                        Class<?> dataCls;
                        ViewDefIFace viewDef = view.getAltViews().get(0).getViewDef();
                        if (!(viewDef.getDataGettable() instanceof DataGetterForHashMap) && (dataCls = Class.forName(viewDef.getClassName())) != null) {
                            System.err.println(dataCls);
                            data = dataCls.newInstance();
                            if (data instanceof FormDataObjIFace) {
                                ((FormDataObjIFace)data).initialize();
                            }
                        }
                    }
                    catch (Exception viewDef) {
                        // empty catch block
                    }
                    if (data instanceof Discipline) {
                        ((Discipline)data).setType("fish");
                    }
                    FormPane formPane = new FormPane(view.getName(), null, null, view.getName(), "edit", data, 12, true);
                    this.frame = new JFrame();
                    this.frame.setFocusable(false);
                    this.frame.setContentPane(formPane);
                    this.frame.setSize(1024, 768);
                    this.frame.setVisible(true);
                    this.frame.setLocation(0, 0);
                    Dimension size = this.frame.getContentPane().getPreferredSize();
                    size.height += 40;
                    size.width += 30;
                    this.frame.setSize(size);
                    String str = String.format("%d of %d", this.viewInx + 1, this.viewList.size());
                    System.out.println(str);
                    UIRegistry.getStatusBar().setText(str);
                } else if (this.frame != null) {
                    this.frame.setVisible(false);
                    this.frame.dispose();
                    this.frame = null;
                }
                if (this.viewInx < this.viewList.size() - 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception ex) {
                                UsageTracker.incrHandledUsageCount();
                                ExceptionTracker.getInstance().capture(FormDisplayer.class, ex);
                            }
                            FormDisplayer.this.showView();
                        }
                    });
                } else {
                    done = true;
                }
            } else {
                done = true;
            }
        }
        if (done) {
            if (this.cancelDlg != null) {
                this.cancelDlg.setVisible(false);
            }
            if (this.frame != null) {
                this.frame.setVisible(false);
                this.frame.dispose();
            }
            this.createIndexFile();
            UIRegistry.getStatusBar().setText("Done");
        }
    }

    protected void writeImageFile(String title, String fileName, String prevName, String nxtName) {
        String fName = String.valueOf(this.outputDir.getAbsolutePath()) + File.separator + FilenameUtils.getBaseName((String)fileName) + ".html";
        try {
            File html = new File(fName);
            BufferedWriter output = new BufferedWriter(new FileWriter(html));
            int inx = this.mapTemplate.indexOf(this.contentTag);
            String subContent = this.mapTemplate.substring(0, inx);
            output.write(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)title));
            output.write("<br>");
            if (prevName != null) {
                output.write("<a href=\"" + prevName + "\">Previous</a>");
            } else {
                output.write(UIRegistry.getResourceString("FormDisplayer.PREV"));
            }
            output.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            if (nxtName != null) {
                output.write("<a href=\"" + nxtName + "\">Next</a>");
            } else {
                output.write(UIRegistry.getResourceString("FormDisplayer.NEXT"));
            }
            output.write("<center><br><img src=\"" + fileName + "\"><br><br>" + title);
            output.write("</center>");
            output.write(this.mapTemplate.substring(inx + this.contentTag.length() + 1, this.mapTemplate.length()));
            output.close();
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, e);
            e.printStackTrace();
        }
    }

    protected void createIndexFile() {
        String fName = String.valueOf(this.outputDir.getAbsolutePath()) + File.separator + "index.html";
        try {
            File html = new File(fName);
            BufferedWriter output = new BufferedWriter(new FileWriter(html));
            int inx = this.mapTemplate.indexOf(this.contentTag);
            String subContent = this.mapTemplate.substring(0, inx);
            output.write(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)UIRegistry.getResourceString("FormDisplayer.FORM_INDEX")));
            output.write("<UL>");
            Collections.sort(this.entries, new Comparator<Pair<String, File>>(){

                @Override
                public int compare(Pair<String, File> o1, Pair<String, File> o2) {
                    return ((String)o1.first).compareTo((String)o2.first);
                }
            });
            int cnt = 0;
            for (Pair<String, File> p : this.entries) {
                output.write("<LI><a href=\"" + FilenameUtils.getBaseName((String)((File)p.second).getName()) + ".html\">" + (String)p.first + "</a></LI>");
                String prvName = cnt == 0 ? null : String.valueOf(FilenameUtils.getBaseName((String)((File)this.entries.get((int)(cnt - 1)).second).getName())) + ".html";
                String nxtName = cnt == this.entries.size() - 1 ? null : String.valueOf(FilenameUtils.getBaseName((String)((File)this.entries.get((int)(cnt + 1)).second).getName())) + ".html";
                this.writeImageFile((String)p.first, ((File)p.second).getName(), prvName, nxtName);
                ++cnt;
            }
            output.write("</UL>");
            output.write(this.mapTemplate.substring(inx + this.contentTag.length() + 1, this.mapTemplate.length()));
            output.close();
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, e);
            e.printStackTrace();
        }
        this.createFormImagesIndexFile();
        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("FormDisplayer.OUTPUT"), this.outputDir.getAbsoluteFile()));
    }

    protected void createFormImagesIndexFile() {
        String fName = String.valueOf(this.baseDir.getAbsolutePath()) + File.separator + "index.html";
        try {
            File html = new File(fName);
            BufferedWriter output = new BufferedWriter(new FileWriter(html));
            int inx = this.mapTemplate.indexOf(this.contentTag);
            String subContent = this.mapTemplate.substring(0, inx);
            output.write(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)UIRegistry.getResourceString("FormDisplayer.FORM_INDEX")));
            output.write("<UL>\n");
            Vector<File> files = new Vector<File>();
            File[] fileArray = this.baseDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String nm = f.getName();
                if (nm.endsWith("_all") || nm.endsWith("_user")) {
                    files.add(f);
                }
                ++n2;
            }
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            String currDiscipline = "";
            for (File f : files) {
                String[] segments = StringUtils.split((String)f.getName(), (String)"_");
                if (segments == null || segments.length != 3) continue;
                DisciplineType dt = DisciplineType.getDisciplineHash().get(segments[0]);
                if (!dt.getName().equals(currDiscipline)) {
                    if (currDiscipline.length() > 0) {
                        output.write("</UL>\n");
                    }
                    output.write("<LI>" + dt.getTitle() + "</LI>\n");
                    output.write("<UL>\n");
                    currDiscipline = dt.getName();
                }
                String title = String.format("%s %s", segments[1], segments[2].equals("all") ? "All" : "User");
                output.write("<LI><a href=\"" + f.getName() + File.separator + "index.html\">" + title + "</a></LI>\n");
            }
            output.write("</UL>\n");
            output.write("</UL>\n");
            output.write(this.mapTemplate.substring(inx + this.contentTag.length() + 1, this.mapTemplate.length()));
            output.close();
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, e);
            e.printStackTrace();
        }
    }

    private File checkForTemplateFiles(String dstDirPath) {
        String templatePath = String.valueOf(dstDirPath) + File.separator + "schema_template.html";
        File templateFile = new File(templatePath);
        if (templateFile.exists()) {
            return templateFile;
        }
        System.out.println(templatePath);
        try {
            File dstDirFile = new File(dstDirPath);
            if (!dstDirFile.exists() && !dstDirFile.mkdirs()) {
                JOptionPane.showMessageDialog(null, "Error creating the site directory.");
            }
            String zipFilePath = String.valueOf(dstDirPath) + File.separator + "site.zip";
            System.out.println("[" + zipFilePath + "]");
            String url = "http://files.specifysoftware.org/site.zip";
            HTTPGetter getter = new HTTPGetter();
            InputStream ins = getter.beginHTTPRequest(url);
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(zipFilePath));
            byte[] bytes = new byte[4096];
            int totalBytes = 0;
            int numBytes = 0;
            do {
                if ((numBytes = ins.read(bytes)) <= 0) continue;
                dos.write(bytes, 0, numBytes);
                totalBytes += numBytes;
                System.out.println(numBytes);
            } while (numBytes > 0);
            dos.flush();
            dos.close();
            System.out.println(totalBytes);
            File zipFile = new File(zipFilePath);
            System.out.println("zipFile: " + zipFile + " exists: " + zipFile.exists());
            List<File> unzippedFiles = ZipFileHelper.getInstance().unzipToFiles(zipFile);
            for (File unzippedFile : unzippedFiles) {
                FileUtils.copyFileToDirectory((File)unzippedFile, (File)dstDirFile);
            }
            if (templateFile.exists()) {
                return templateFile;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "You are missing the template that is needed to run this tool.");
        }
        return null;
    }

    protected boolean setup() {
        String pathStr = AppContextMgr.getInstance().getClassObject(Discipline.class) != null ? AppContextMgr.getInstance().getClassObject(Discipline.class).getType() : "";
        pathStr = String.valueOf(pathStr) + "_" + UIHelper.getOSType().toString() + "_" + (this.doAll ? "all" : "user");
        this.baseDir = new File(String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "FormImages");
        this.outputDir = new File(this.baseDir.getAbsoluteFile() + File.separator + pathStr);
        if (!this.baseDir.exists() && !this.baseDir.mkdir()) {
            UIRegistry.showError(String.format(UIRegistry.getResourceString("FormDisplayer.OUTPUT_ERROR"), this.baseDir.getAbsoluteFile()));
        }
        if (!this.outputDir.exists()) {
            if (!this.outputDir.mkdir()) {
                UIRegistry.showError(String.format(UIRegistry.getResourceString("FormDisplayer.OUTPUT_ERROR"), this.outputDir.getAbsoluteFile()));
            }
        } else {
            try {
                FileUtils.cleanDirectory((File)this.outputDir);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(FormDisplayer.class, ex);
                ex.printStackTrace();
            }
        }
        String dstDirPath = String.valueOf(UIRegistry.getDefaultUserHomeDir()) + File.separator + "Specify/site";
        try {
            File tmplateFile = this.checkForTemplateFiles(dstDirPath);
            this.mapTemplate = FileUtils.readFileToString((File)tmplateFile);
            this.mapTemplate = StringUtils.replace((String)this.mapTemplate, (String)"Database Schema", (String)UIRegistry.getResourceString("FormDisplayer.FORMS"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "You are missing the template that is needed to run this tool.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.mapTemplate)) {
            System.err.println("The template file is empty!");
        }
        try {
            File srcDir = new File(dstDirPath);
            File[] fileArray = srcDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.getName().startsWith(".")) {
                    File dst = new File(String.valueOf(this.outputDir.getAbsolutePath()) + File.separator + f.getName());
                    if (!FilenameUtils.getExtension((String)f.getName()).toLowerCase().equals("html")) {
                        FileUtils.copyFile((File)f, (File)dst);
                    }
                    dst = new File(String.valueOf(this.baseDir.getAbsolutePath()) + File.separator + f.getName());
                    if (!FilenameUtils.getExtension((String)f.getName()).toLowerCase().equals("html")) {
                        FileUtils.copyFile((File)f, (File)dst);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, ex);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected void generateViewImage(ViewIFace view) {
        Rectangle rect = this.frame.getContentPane().getBounds();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        BufferedImage bufImage = new BufferedImage(rect.width, rect.height, this.doPNG ? 2 : 1);
        Graphics2D g2 = bufImage.createGraphics();
        if (!this.doPNG) {
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, rect.width, rect.height);
        }
        g2.setRenderingHints(ERDVisualizer.createTextRenderingHints());
        this.frame.getContentPane().paint(g2);
        g2.dispose();
        String baseFileName = this.outputDir.getAbsoluteFile() + "/" + view.getName() + "_" + this.viewInx;
        File imgFile = new File(String.valueOf(baseFileName) + (this.doPNG ? ".png" : ".jpg"));
        System.out.println(imgFile.getAbsolutePath());
        try {
            ImageIO.write((RenderedImage)bufImage, "PNG", imgFile);
            this.entries.add(new Pair<String, File>(view.getName(), imgFile));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(FormDisplayer.class, ex);
            ex.printStackTrace();
        }
    }

    protected void processDir(String viewSetMgrName, File dir) {
        ViewSetMgr viewSetMgr = new ViewSetMgr(viewSetMgrName, dir);
        this.pw.println("<br><h2>" + viewSetMgrName + "</h2>");
        if (viewSetMgr.getViewSets().size() > 0) {
            for (ViewSetIFace vs : viewSetMgr.getViewSets()) {
                if (vs.getName().equals("Editor")) continue;
                System.out.println(vs.getName());
                if (vs.getViews().keySet().size() > 0) {
                    this.pw.println("<h3>" + vs.getName() + "</h3>");
                    this.pw.println("<table border=\"1\" width=\"50%\">");
                    this.pw.println("<tr><th>View Name</th><th>Is Internal</th><th>Types</th></tr>");
                    Vector<String> vNames = new Vector<String>(vs.getViews().keySet());
                    Collections.sort(vNames);
                    for (String vName : vNames) {
                        ViewIFace view = vs.getViews().get(vName);
                        this.pw.println("<tr><td>" + view.getName() + "</td>");
                        StringBuilder sb = new StringBuilder();
                        for (AltViewIFace av : view.getAltViews()) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            if (av.getViewDef() == null) continue;
                            sb.append(String.valueOf(av.getViewDef().getType().toString()) + " (" + av.getMode().toString().toLowerCase() + ")");
                        }
                        this.pw.println("<td><center>" + view.isInternal() + "</center></td>");
                        this.pw.println("<td>" + sb.toString() + "</td></tr>");
                    }
                    this.pw.println("</table><br>");
                    continue;
                }
                this.pw.println("<i>" + UIRegistry.getResourceString("FormDisplayer.NO_VIEWS_DEFINED") + "</i><br>");
            }
        } else {
            this.pw.println("<i>No viewset_registry.xml</i><br>");
        }
        if (dir != null && dir.isDirectory()) {
            System.out.println(dir.getAbsolutePath());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && !file.getName().startsWith(".")) {
                    this.processDir(String.valueOf(viewSetMgrName) + "/" + file.getName(), file);
                }
                ++n2;
            }
        }
    }

    public void createViewListing(String path, boolean doShowInBrowser) {
        String fullPath = String.valueOf(path != null ? String.valueOf(path) + File.separator : "") + "views.html";
        this.createHTMLFile(fullPath, UIRegistry.getResourceString("FormDisplayer.VIEWS"));
        this.processDir("Common", XMLHelper.getConfigDir("common"));
        this.processDir("Backstop", XMLHelper.getConfigDir("backstop"));
        File[] fileArray = new File(XMLHelper.getConfigDirPath(".")).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && !file.getName().equals("common") && !file.getName().equals("backstop") && !file.getName().startsWith(".")) {
                this.processDir(file.getName(), XMLHelper.getConfigDir(file.getName()));
            }
            ++n2;
        }
        this.pw.println("</body><html>");
        this.pw.flush();
        this.pw.close();
        try {
            if (doShowInBrowser) {
                AttachmentUtils.openURI(this.file.toURI());
            } else {
                JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("FormDisplayer.OUTPUT"), this.file.getCanonicalFile()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FormDisplayer fd = new FormDisplayer();
        fd.createViewListing(null, true);
    }
}

