/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tools;

import edu.ku.brc.helpers.XMLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class AppendHelp {
    private Hashtable<String, String> targetToUrlHash = new Hashtable();
    private Hashtable<String, String> urlToTargetHash = new Hashtable();
    private Hashtable<String, String> targetToAnchor = new Hashtable();

    public Element readFileToDOM4J(File file) throws IOException, DocumentException {
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.setValidation(false);
            saxReader.setStripWhitespaceText(true);
            saxReader.setIgnoreComments(true);
            EntityResolver entityResolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource("");
                }
            };
            saxReader.setEntityResolver(entityResolver);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Document document = saxReader.read((InputStream)new FileInputStream(file));
        return document.getRootElement();
    }

    private String getXMLStr(File file, String element) throws IOException {
        String text = FileUtils.readFileToString((File)file);
        int inx = text.indexOf(element);
        System.out.println(text.substring(inx));
        return text.substring(inx);
    }

    void getMapEntries(File directory) {
        try {
            File mapFile = new File("help/SpecifyHelp.jhm");
            Element root = XMLHelper.readStrToDOM4J(this.getXMLStr(mapFile, "<map"));
            if (root == null) {
                return;
            }
            List sections = root.selectNodes("/map/mapID");
            for (Element section : sections) {
                String target = XMLHelper.getAttr(section, "target", null);
                String url = XMLHelper.getAttr(section, "url", null);
                if (!StringUtils.isNotEmpty((String)target) || !StringUtils.isNotEmpty((String)url) || url.startsWith("http")) continue;
                this.targetToUrlHash.put(target, url);
                this.urlToTargetHash.put(url, target);
                String[] toks = StringUtils.split((String)url, (String)"#");
                if (toks.length <= 1) continue;
                this.targetToAnchor.put(target, toks[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void buildList(Element parent, Vector<TOCItem> list, StringBuilder sb) {
        List sections = parent.selectNodes("tocitem");
        if (sections.size() > 0) {
            sb.append("<UL>\n");
            for (Element section : sections) {
                String target = XMLHelper.getAttr(section, "target", null);
                String text = XMLHelper.getAttr(section, "text", null);
                if (StringUtils.isNotEmpty((String)target) && StringUtils.isNotEmpty((String)text)) {
                    String anchor = this.targetToAnchor.get(target);
                    list.add(new TOCItem(target, text));
                    sb.append("<LI>");
                    sb.append("<a href=\"#");
                    sb.append(anchor != null ? anchor : target);
                    sb.append("\">");
                    sb.append(text);
                    sb.append("</a>");
                    sb.append("</LI>\n");
                }
                this.buildList(section, list, sb);
            }
            sb.append("</UL>\n");
        }
    }

    private List<TOCItem> getTOCList(File directory, StringBuilder sb) {
        Element root;
        Vector<TOCItem> list;
        block3: {
            list = new Vector<TOCItem>();
            File tocFile = new File("help/SpecifyHelpTOC.xml");
            root = XMLHelper.readStrToDOM4J(this.getXMLStr(tocFile, "<toc"));
            if (root != null) break block3;
            return null;
        }
        try {
            Element parent = (Element)root.selectSingleNode("/toc");
            this.buildList(parent, list, sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static String getContents(File file, String target, String anchor) throws IOException {
        if (file.length() < 500L) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String contents = FileUtils.readFileToString((File)file);
        String lower = contents.toLowerCase();
        int sInx = lower.indexOf("<title>");
        int eInx = lower.indexOf("</title>");
        sInx = lower.indexOf("<body");
        sInx = lower.indexOf(62, sInx);
        eInx = lower.indexOf("</body>");
        if (eInx == -1) {
            eInx = lower.indexOf("</html>");
        }
        if (sInx == -1 || eInx == -1) {
            System.out.println(String.valueOf(file.getAbsolutePath()) + "  " + sInx + "  " + eInx);
            return "";
        }
        String body = contents.substring(sInx + 1, eInx - 1);
        body = StringUtils.replace((String)body, (String)"src=\"../images", (String)"src=\"help/SpecifyHelp/images");
        body = StringUtils.replace((String)body, (String)"src=\"../../images", (String)"src=\"help/images");
        body = StringUtils.replace((String)body, (String)"background=\"../../images", (String)"background=\"help/images");
        if (contents.indexOf("topbar.png") == -1) {
            sb.append("<HR>");
        }
        sb.append("<a name=\"");
        sb.append(anchor != null ? anchor : target);
        sb.append("\">");
        sb.append(body);
        return sb.toString();
    }

    public AppendHelp() {
        StringBuilder sb = new StringBuilder();
        String path = "help/SpecifyHelp";
        File spHelpDir = new File(path);
        this.getMapEntries(spHelpDir);
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
        sb.append("<head>\n");
        sb.append("<style>body { font-family: sans-serif; }</style>\n");
        sb.append("<link href=\"../../main.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\"></link>\n");
        sb.append("<title>Specify Help</title>\n");
        sb.append("</head>\n");
        sb.append("<body bgcolor=\"#ffffff\">\n");
        sb.append("<H1>");
        sb.append("Specify Help");
        sb.append("</H1>\n");
        try {
            List<TOCItem> tocList = this.getTOCList(spHelpDir, sb);
            Vector<String> fileNameList = new Vector<String>();
            Hashtable<String, Boolean> fileNameHash = new Hashtable<String, Boolean>();
            for (TOCItem item : tocList) {
                String fName = this.targetToUrlHash.get(item.getTarget());
                if (fName == null) continue;
                if (fName.indexOf(35) > -1) {
                    String[] toks = StringUtils.split((String)fName, (String)"#");
                    item.setFileName("help/" + toks[0]);
                    item.setAnchor(toks[1]);
                } else {
                    item.setFileName("help/" + (String)fName);
                }
                String fullName = item.getFileName();
                if (fileNameHash.get(fullName) != null) continue;
                fileNameList.add(fullName);
                fileNameHash.put(fullName, false);
            }
            int i = 0;
            for (TOCItem item : tocList) {
                if (item.getFileName() != null) {
                    System.out.println(String.valueOf(item.getTarget()) + "  " + item.getFileName());
                    Boolean used = (Boolean)fileNameHash.get(item.getFileName());
                    if (used == null || used.booleanValue()) continue;
                    if (i > 0) {
                        sb.append("<HR>\n");
                    }
                    sb.append(AppendHelp.getContents(new File(item.getFileName()), item.getTarget(), null));
                    fileNameHash.put(item.getFileName(), true);
                    ++i;
                    continue;
                }
                System.err.println("File Name is null for target[" + item.getTarget() + "]");
            }
            Hashtable<String, Boolean> fNameHash = new Hashtable<String, Boolean>();
            for (String url : this.urlToTargetHash.keySet()) {
                fNameHash.put(FilenameUtils.getName((String)url), true);
            }
            for (File file : FileUtils.listFiles((File)new File(path), (String[])new String[]{"html"}, (boolean)true)) {
                try {
                    String fName = FilenameUtils.getName((String)file.getAbsolutePath());
                    if (fNameHash.get(fName) != null) continue;
                    if (i > 0) {
                        sb.append("<HR>\n");
                    }
                    sb.append(AppendHelp.getContents(file, fName, null));
                    ++i;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            sb.append("</body></html>");
            FileUtils.writeStringToFile((File)new File("SpecifyHelp.html"), (String)sb.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AppendHelp appendHelp = new AppendHelp();
    }

    class TOCItem {
        protected String fileName;
        protected String target;
        protected String anchor;
        protected String title;

        public TOCItem(String target, String title) {
            this.target = target;
            this.title = title;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTarget() {
            return this.target;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public String getTitle() {
            return this.title;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public class TransparentFilter
    implements XMLFilter {
        private XMLReader parent;

        public TransparentFilter(XMLReader parent) {
            this.parent = parent;
        }

        @Override
        public void setParent(XMLReader parent) {
            this.parent = parent;
        }

        @Override
        public XMLReader getParent() {
            return this.parent;
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parent.getFeature(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parent.setFeature(name, value);
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parent.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parent.setProperty(name, value);
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.parent.setEntityResolver(resolver);
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.parent.getEntityResolver();
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.parent.setDTDHandler(handler);
        }

        @Override
        public DTDHandler getDTDHandler() {
            return new DTDHandler(){

                @Override
                public void notationDecl(String name, String publicId, String systemId) throws SAXException {
                }

                @Override
                public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
                }
            };
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.parent.setContentHandler(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.parent.getContentHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.parent.setErrorHandler(handler);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.parent.getErrorHandler();
        }

        @Override
        public void parse(InputSource input) throws SAXException, IOException {
            this.parent.parse(input);
        }

        @Override
        public void parse(String systemId) throws SAXException, IOException {
            this.parent.parse(systemId);
        }
    }
}

