/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.ViewSetMgr;
import edu.ku.brc.af.ui.forms.ViewSetMgrManager;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.FileCache;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ViewSetMgrTests
extends TestCase {
    private static final Logger log = Logger.getLogger(ViewSetMgrTests.class);
    private static String viewsetFileName = "fish.views.xml";
    private static String srcDirName = "srcTest";
    private static String dstDirName = "dstTest";

    protected void setUp() {
        File srcDir;
        UIRegistry.getInstance();
        if (UIRegistry.getAppName() == null) {
            System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
            System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
            System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
            UIRegistry.getInstance();
            UIRegistry.setAppName("Specify");
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.setDirPath(UIRegistry.getAppDataDir());
            localPrefs.load();
            FileCache.setDefaultPath(UIRegistry.getDefaultWorkingPath());
        }
        if ((srcDir = new File(srcDirName)).exists()) {
            try {
                FileUtils.deleteDirectory((File)srcDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ViewSetMgrTests.assertTrue((boolean)srcDir.mkdir());
        File dstDir = new File(dstDirName);
        if (dstDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dstDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ViewSetMgrTests.assertTrue((boolean)dstDir.mkdir());
        ViewSetMgr srcVM = new ViewSetMgr("", srcDir);
        srcVM.addViewSetDef("user", "Fish Views", "Fish Views Title", viewsetFileName, null);
        ViewSetMgrTests.assertTrue((boolean)this.copyTestViewSetFile(new File("config"), new File(srcDirName), viewsetFileName));
        File f = new File(srcDir.getAbsoluteFile() + File.separator + viewsetFileName);
        ViewSetMgrTests.assertTrue((boolean)f.exists());
        try {
            srcVM.save();
        }
        catch (IOException ex) {
            ViewSetMgrTests.assertTrue((boolean)false);
        }
    }

    protected void tearDown() {
        File dstDir;
        File srcDir = new File(srcDirName);
        if (srcDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)srcDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((dstDir = new File(dstDirName)).exists()) {
            try {
                FileUtils.deleteDirectory((File)dstDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean copyTestViewSetFile(File srcDir, File dstDir, String viewsetFileNameStr) {
        if (!srcDir.exists()) {
            throw new RuntimeException("Src Dir doesn't exist " + srcDir.getAbsolutePath());
        }
        if (!dstDir.exists()) {
            throw new RuntimeException("Dst Dir doesn't exist " + dstDir.getAbsolutePath());
        }
        try {
            FileUtils.copyFile((File)new File(srcDir + File.separator + viewsetFileNameStr), (File)new File(dstDir + File.separator + viewsetFileNameStr));
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testViewMgrCreation() {
        log.info((Object)"testViewMgrCreation");
        ViewSetMgr srcVM = new ViewSetMgr("", new File(srcDirName));
        ViewSetMgr dstVM = new ViewSetMgr("", new File(dstDirName));
        ViewSetMgrManager.copyViewSet(srcVM, dstVM, "Fish Views", true);
        try {
            dstVM.save();
        }
        catch (IOException ex) {
            ViewSetMgrTests.assertTrue((boolean)false);
        }
        dstVM = new ViewSetMgr("", new File(dstDirName));
        ViewSetMgrTests.assertTrue((boolean)dstVM.isViewInUse("Fish Views", "CollectionObject"));
    }

    public void testViewSetMgr() {
        ViewSetMgrManager.pushViewMgr(new ViewSetMgr("", new File(XMLHelper.getConfigDirPath(String.valueOf(File.separator) + "backstop")), false));
        ViewSetMgrManager.pushViewMgr(new ViewSetMgr("", new File(srcDirName)));
        ViewSetMgrTests.assertNotNull((Object)AppContextMgr.getInstance().getView("Fish Views", "CollectionObject"));
        ViewSetMgrTests.assertNotNull((Object)AppContextMgr.getInstance().getView("Search", "AgentSearch"));
    }
}

