/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.validation.ValFormattedTextField;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.dbsupport.CollectionAutoNumber;
import edu.ku.brc.specify.tools.SpecifySchemaGenerator;
import edu.ku.brc.specify.ui.CatalogNumberUIFieldFormatter;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileStoreAttachmentManager;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.File;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Before;

public class TestAutoNumbering
extends TestCase {
    private final Logger log = Logger.getLogger(TestAutoNumbering.class);
    protected static boolean doInit = true;
    protected static boolean fillDB = true;
    protected static Session session = null;
    protected static MyFmtMgr fmtMgr = null;

    protected void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
    }

    public static void persist(Object o) {
        if (session != null) {
            session.saveOrUpdate(o);
        }
    }

    public static void persist(List<?> oList) {
        for (Object o : oList) {
            TestAutoNumbering.persist(o);
        }
    }

    public boolean setupDatabase(DatabaseDriverInfo driverInfo, String hostName, String dbName, String username, String password, String firstName, String lastName, String email, DisciplineType disciplineType) {
        String actionStr = fillDB ? "Creating" : "Initializing";
        this.log.info((Object)(String.valueOf(actionStr) + " Specify Database Username[" + username + "]"));
        this.log.info((Object)(String.valueOf(actionStr) + " Database Schema for " + dbName));
        this.log.info((Object)(String.valueOf(actionStr) + " schema"));
        if (fillDB) {
            try {
                SpecifySchemaGenerator.generateSchema(driverInfo, hostName, dbName, username, password);
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(TestAutoNumbering.class, ex);
                ex.printStackTrace();
                return false;
            }
        }
        this.log.info((Object)("Logging into " + dbName + "...."));
        String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, hostName, dbName);
        if (connStr == null) {
            connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, dbName);
        }
        Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
        if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, (String)usernamePassword.first, (String)usernamePassword.second)) {
            this.log.info((Object)"Login Failed!");
            return false;
        }
        session = HibernateUtil.getCurrentSession();
        this.log.info((Object)("Creating database " + dbName + "...."));
        try {
            Thumbnailer thumb = new Thumbnailer();
            File thumbFile = XMLHelper.getConfigDir("thumbnail_generators.xml");
            thumb.registerThumbnailers(thumbFile);
            thumb.setQuality(0.5f);
            thumb.setMaxHeight(128);
            thumb.setMaxWidth(128);
            FileStoreAttachmentManager attachMgr = new FileStoreAttachmentManager(UIRegistry.getAppDataSubDir("AttachmentStorage", true));
            AttachmentUtils.setAttachmentManager(attachMgr);
            AttachmentUtils.setThumbnailer(thumb);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TestAutoNumbering.class, ex);
            ex.printStackTrace();
            return false;
        }
        if (fillDB) {
            this.log.info((Object)"Creating Empty Database");
            BuildSampleDatabase bsd = new BuildSampleDatabase();
            bsd.setSession(session);
            this.log.info((Object)("Saving data into " + dbName + "...."));
            this.log.info((Object)"Persisting Data...");
        }
        SpecifyAppPrefs.initialPrefs();
        fmtMgr = new MyFmtMgr();
        return true;
    }

    protected void myTester() {
        block6: {
            StringBuilder sql = new StringBuilder("From CollectionObject c Join c.collection col Join col.catalogNumberingScheme cns where cns.catalogNumberingSchemeId = 1");
            Session localSession = HibernateUtil.getNewSession();
            try {
                try {
                    System.out.println(sql.toString());
                    List list = localSession.createQuery(sql.toString()).setMaxResults(1).list();
                    if (list.size() == 1) {
                        Object[] obj = (Object[])list.get(0);
                        CollectionObject co = (CollectionObject)obj[0];
                        System.out.println(co.getCatalogNumber());
                    }
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TestAutoNumbering.class, ex);
                    ex.printStackTrace();
                    localSession.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                localSession.close();
                throw throwable;
            }
            localSession.close();
        }
        int x = 0;
        ++x;
    }

    @Before
    public void setUp() throws Exception {
        if (doInit) {
            UIRegistry.setAppName("Specify");
            this.setUpSystemProperties();
            DisciplineType disciplineType = DisciplineType.getDiscipline("fish");
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            this.setupDatabase(driverInfo, "localhost", "Test", "rods", "rods", "guest", "guest", "guest@ku.edu", disciplineType);
            doInit = false;
        }
    }

    public void testNumericNumWithEmptyDB() {
        this.log.info((Object)"testEmptyDBNumericNum");
        CatalogNumberUIFieldFormatter catalogNumber = new CatalogNumberUIFieldFormatter();
        catalogNumber.setAutoNumber(new CollectionAutoNumber());
        ValFormattedTextField valText = new ValFormattedTextField(catalogNumber, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)"000000001");
    }

    public void testNumericDBNum() {
        this.log.info((Object)"testNumericDBNum");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Collection collection = (Collection)session.createCriteria(Collection.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        CollectionObject colObj = DataBuilder.createCollectionObject("000000100", "RSC100", agent, collection, 3, null, Calendar.getInstance(), "BuildSampleDatabase");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj);
        HibernateUtil.commitTransaction();
        CatalogNumberUIFieldFormatter catalogNumber = new CatalogNumberUIFieldFormatter();
        catalogNumber.setAutoNumber(new CollectionAutoNumber());
        ValFormattedTextField valText = new ValFormattedTextField(catalogNumber, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info(valText.getValue());
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)"000000101");
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj);
        HibernateUtil.commitTransaction();
    }

    public void testNumericTwoCollDBNum() {
        this.log.info((Object)"testNumericTwoCollDBNum");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Collection collection = (Collection)session.createCriteria(Collection.class).list().get(0);
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        Collection collection2 = DataBuilder.createCollection("Fish", "Fish Tissue", null, collection.getNumberingSchemesByType(CollectionObject.getClassTableId()), discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection2);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        CollectionObject colObj1 = DataBuilder.createCollectionObject("000000100", "RSC100", agent, collection, 3, null, Calendar.getInstance(), "BuildSampleDatabase");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection2);
        CollectionObject colObj2 = DataBuilder.createCollectionObject("000000200", "RSC200", agent, collection2, 3, null, Calendar.getInstance(), "BuildSampleDatabase");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj1);
        TestAutoNumbering.persist(colObj2);
        HibernateUtil.commitTransaction();
        CatalogNumberUIFieldFormatter catalogNumber = new CatalogNumberUIFieldFormatter();
        catalogNumber.setAutoNumber(new CollectionAutoNumber());
        ValFormattedTextField valText = new ValFormattedTextField(catalogNumber, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info(valText.getValue());
        collection.getNumberingSchemesByType(CollectionObject.getClassTableId()).getCollections().remove(collection2);
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj1);
        session.delete((Object)colObj2);
        session.delete((Object)collection2);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)"000000201");
    }

    public void testAlphaNumCatNumEmptyDB() {
        this.log.info((Object)"testNumericDBNum");
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AutoNumberingScheme catNumSchemeAlphaNumeric = DataBuilder.createAutoNumberingScheme("CatalogNumberAN", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        Collection collection = DataBuilder.createCollection("Fish", "Fish Tissue", null, catNumSchemeAlphaNumeric, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        String currentYearCatNum = String.valueOf(Calendar.getInstance().get(1)) + "-000001";
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("CatalogNumber");
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info((Object)("[" + currentYearCatNum + "][" + valText.getValue() + "]"));
        AppContextMgr.getInstance().setClassObject(Collection.class, null);
        catNumSchemeAlphaNumeric.getCollections().remove(collection);
        HibernateUtil.beginTransaction();
        session.delete((Object)collection);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        session.delete((Object)catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearCatNum);
    }

    public void testAlphaNumCatNum() {
        this.log.info((Object)"testAlphaNumCatNum");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AutoNumberingScheme catNumSchemeAlphaNumeric = DataBuilder.createAutoNumberingScheme("CatalogNumberAN", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        Collection collection = DataBuilder.createCollection("Fish", "Fish Tissue", null, catNumSchemeAlphaNumeric, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection);
        int currentYear = Calendar.getInstance().get(1);
        String currentYearCatNum = String.valueOf(currentYear) + "-000001";
        String currentYearNext = String.valueOf(currentYear) + "-000002";
        CollectionObject colObj = DataBuilder.createCollectionObject(currentYearCatNum, "RSC100", agent, collection, 3, null, Calendar.getInstance(), "me");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj);
        HibernateUtil.commitTransaction();
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("CatalogNumber");
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info((Object)("[" + currentYearNext + "][" + valText.getValue() + "]"));
        AppContextMgr.getInstance().setClassObject(Collection.class, null);
        catNumSchemeAlphaNumeric.getCollections().remove(collection);
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj);
        session.delete((Object)collection);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        session.delete((Object)catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearNext);
    }

    public void testAlphaNumCatNumTwoColl() {
        this.log.info((Object)"testAlphaNumCatNumTwoColl");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AutoNumberingScheme catNumSchemeAlphaNumeric = DataBuilder.createAutoNumberingScheme("CatalogNumberAN", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        Collection collection1 = DataBuilder.createCollection("Fish", "Fish Two", null, catNumSchemeAlphaNumeric, discipline);
        Collection collection2 = DataBuilder.createCollection("Fish", "Fish Tissue Two", null, catNumSchemeAlphaNumeric, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection1);
        TestAutoNumbering.persist(collection2);
        HibernateUtil.commitTransaction();
        AutoNumberingScheme catNumSchemeAlphaNumeric3 = DataBuilder.createAutoNumberingScheme("CatalogNumber3", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        Collection collection3 = DataBuilder.createCollection("Fish", "Fish Three", null, catNumSchemeAlphaNumeric3, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection3);
        HibernateUtil.commitTransaction();
        int currentYear = Calendar.getInstance().get(1);
        String currentYearCatNum = String.valueOf(currentYear) + "-000001";
        String currentYearCatNum2 = String.valueOf(currentYear) + "-000002";
        String currentYearCatNum3 = String.valueOf(currentYear) + "-000300";
        String currentYearNext = String.valueOf(currentYear) + "-000003";
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        CollectionObject colObj = DataBuilder.createCollectionObject(currentYearCatNum, "RSC100", agent, collection1, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection2);
        CollectionObject colObj2 = DataBuilder.createCollectionObject(currentYearCatNum2, "RSC200", agent, collection2, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection3);
        CollectionObject colObj3 = DataBuilder.createCollectionObject(currentYearCatNum3, "RSC300", agent, collection3, 3, null, Calendar.getInstance(), "me");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj);
        TestAutoNumbering.persist(colObj2);
        TestAutoNumbering.persist(colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("CatalogNumber");
        TestAutoNumbering.assertNotNull((Object)fmt);
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info((Object)("[" + currentYearNext + "][" + valText.getValue() + "]"));
        collection1.removeReference(colObj, "collectionObjects");
        collection2.removeReference(colObj2, "collectionObjects");
        collection3.removeReference(colObj3, "collectionObjects");
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj);
        session.delete((Object)colObj2);
        session.delete((Object)colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, null);
        catNumSchemeAlphaNumeric.getCollections().remove(collection2);
        catNumSchemeAlphaNumeric.getCollections().remove(collection1);
        catNumSchemeAlphaNumeric3.getCollections().remove(collection3);
        HibernateUtil.beginTransaction();
        session.delete((Object)collection3);
        session.delete((Object)collection2);
        session.delete((Object)collection1);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        session.delete((Object)catNumSchemeAlphaNumeric);
        session.delete((Object)catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearNext);
    }

    public void testAlphaNumCatNumTwoCollByYearSameYear() {
        this.log.info((Object)"testAlphaNumCatNumTwoCollByYearSameYear");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AutoNumberingScheme catNumSchemeAlphaNumeric = DataBuilder.createAutoNumberingScheme("CatalogNumberAlphaNumByYear", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        Collection collection1 = DataBuilder.createCollection("Fish", "Fish Two", null, catNumSchemeAlphaNumeric, discipline);
        Collection collection2 = DataBuilder.createCollection("Fish", "Fish Tissue Two", null, catNumSchemeAlphaNumeric, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection1);
        TestAutoNumbering.persist(collection2);
        HibernateUtil.commitTransaction();
        AutoNumberingScheme catNumSchemeAlphaNumeric3 = DataBuilder.createAutoNumberingScheme("CatalogNumber3", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        Collection collection3 = DataBuilder.createCollection("Fish", "Fish Three", null, catNumSchemeAlphaNumeric3, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection3);
        HibernateUtil.commitTransaction();
        int currentYear = Calendar.getInstance().get(1);
        String currentYearCatNum = String.valueOf(currentYear) + "-000001";
        String currentYearCatNum2 = String.valueOf(currentYear) + "-000002";
        String currentYearCatNum3 = String.valueOf(currentYear) + "-000300";
        String currentYearNext = String.valueOf(currentYear) + "-000003";
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        CollectionObject colObj = DataBuilder.createCollectionObject(currentYearCatNum, "RSC100", agent, collection1, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection2);
        CollectionObject colObj2 = DataBuilder.createCollectionObject(currentYearCatNum2, "RSC200", agent, collection2, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection3);
        CollectionObject colObj3 = DataBuilder.createCollectionObject(currentYearCatNum3, "RSC300", agent, collection3, 3, null, Calendar.getInstance(), "me");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj);
        TestAutoNumbering.persist(colObj2);
        TestAutoNumbering.persist(colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("CatalogNumberAlphaNumByYear");
        TestAutoNumbering.assertNotNull((Object)fmt);
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info((Object)("[" + currentYearNext + "][" + valText.getValue() + "]"));
        collection1.removeReference(colObj, "collectionObjects");
        collection2.removeReference(colObj2, "collectionObjects");
        collection3.removeReference(colObj3, "collectionObjects");
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj);
        session.delete((Object)colObj2);
        session.delete((Object)colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, null);
        catNumSchemeAlphaNumeric.getCollections().remove(collection2);
        catNumSchemeAlphaNumeric.getCollections().remove(collection1);
        catNumSchemeAlphaNumeric3.getCollections().remove(collection3);
        HibernateUtil.beginTransaction();
        session.delete((Object)collection3);
        session.delete((Object)collection2);
        session.delete((Object)collection1);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        session.delete((Object)catNumSchemeAlphaNumeric);
        session.delete((Object)catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearNext);
    }

    public void testAlphaNumCatNumTwoCollByYearDiffYear() {
        this.log.info((Object)"testAlphaNumCatNumTwoCollByYearDiffYear");
        Agent agent = (Agent)session.createCriteria(Agent.class).list().get(0);
        Discipline discipline = (Discipline)session.createCriteria(Discipline.class).list().get(0);
        AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
        AutoNumberingScheme catNumSchemeAlphaNumeric = DataBuilder.createAutoNumberingScheme("CatalogNumberAlphaNumByYear", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric);
        HibernateUtil.commitTransaction();
        Collection collection1 = DataBuilder.createCollection("Fish", "Fish Two", null, catNumSchemeAlphaNumeric, discipline);
        Collection collection2 = DataBuilder.createCollection("Fish", "Fish Tissue Two", null, catNumSchemeAlphaNumeric, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection1);
        TestAutoNumbering.persist(collection2);
        HibernateUtil.commitTransaction();
        AutoNumberingScheme catNumSchemeAlphaNumeric3 = DataBuilder.createAutoNumberingScheme("CatalogNumber3", "", null, false, CollectionObject.getClassTableId());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        Collection collection3 = DataBuilder.createCollection("Fish", "Fish Three", null, catNumSchemeAlphaNumeric3, discipline);
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(collection3);
        HibernateUtil.commitTransaction();
        int currentYear = Calendar.getInstance().get(1);
        String currentYearCatNum = "2005-000001";
        String currentYearCatNum2 = "2005-000002";
        String currentYearCatNum3 = String.valueOf(currentYear) + "-000300";
        String currentYearNext = String.valueOf(currentYear) + "-000001";
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        CollectionObject colObj = DataBuilder.createCollectionObject(currentYearCatNum, "RSC100", agent, collection1, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection2);
        CollectionObject colObj2 = DataBuilder.createCollectionObject(currentYearCatNum2, "RSC200", agent, collection2, 3, null, Calendar.getInstance(), "me");
        AppContextMgr.getInstance().setClassObject(Collection.class, collection3);
        CollectionObject colObj3 = DataBuilder.createCollectionObject(currentYearCatNum3, "RSC300", agent, collection3, 3, null, Calendar.getInstance(), "me");
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(colObj);
        TestAutoNumbering.persist(colObj2);
        TestAutoNumbering.persist(colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, collection1);
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("CatalogNumberAlphaNumByYear");
        TestAutoNumbering.assertNotNull((Object)fmt);
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.updateAutoNumbers();
        this.log.info((Object)("[" + currentYearNext + "][" + valText.getValue() + "]"));
        collection1.removeReference(colObj, "collectionObjects");
        collection2.removeReference(colObj2, "collectionObjects");
        collection3.removeReference(colObj3, "collectionObjects");
        HibernateUtil.beginTransaction();
        session.delete((Object)colObj);
        session.delete((Object)colObj2);
        session.delete((Object)colObj3);
        HibernateUtil.commitTransaction();
        AppContextMgr.getInstance().setClassObject(Collection.class, null);
        catNumSchemeAlphaNumeric.getCollections().remove(collection2);
        catNumSchemeAlphaNumeric.getCollections().remove(collection1);
        catNumSchemeAlphaNumeric3.getCollections().remove(collection3);
        HibernateUtil.beginTransaction();
        session.delete((Object)collection3);
        session.delete((Object)collection2);
        session.delete((Object)collection1);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        session.delete((Object)catNumSchemeAlphaNumeric);
        session.delete((Object)catNumSchemeAlphaNumeric3);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearNext);
    }

    public void testAccessionAlphaNumericDBNumOldYear() {
        this.log.info((Object)"testAccessionAlphaNumericDBNumOldYear");
        Division div = (Division)session.createCriteria(Division.class).list().get(0);
        Accession accession = DataBuilder.createAccession(div, "XXX", "XXXX", "2005-IC-001", "XXXX", Calendar.getInstance(), Calendar.getInstance());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(accession);
        HibernateUtil.commitTransaction();
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("AccessionNumber");
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        try {
            valText.updateAutoNumbers();
            String currentYearCatNum = String.valueOf(Calendar.getInstance().get(1)) + "-AA-001";
            this.log.info((Object)currentYearCatNum);
            this.log.info(valText.getValue());
            TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)currentYearCatNum);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TestAutoNumbering.class, ex);
            ex.printStackTrace();
        }
        div.removeReference(accession, "accessions");
        HibernateUtil.beginTransaction();
        session.delete((Object)accession);
        HibernateUtil.commitTransaction();
    }

    public void testAccessionAlphaNumericDBNumOldYearWithEdit() {
        this.log.info((Object)"testAlphaNumericDBNumOldYear");
        Division div = (Division)session.createCriteria(Division.class).list().get(0);
        Accession accession = DataBuilder.createAccession(div, "XXX", "XXXX", "2005-IC-001", "XXXX", Calendar.getInstance(), Calendar.getInstance());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(accession);
        HibernateUtil.commitTransaction();
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("AccessionNumber");
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.setText("2005-IC-###");
        valText.updateAutoNumbers();
        this.log.info(valText.getValue());
        div.removeReference(accession, "accessions");
        HibernateUtil.beginTransaction();
        session.delete((Object)accession);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)"2005-IC-002");
    }

    public void testAlphaNumWithTwoCollections() {
        this.log.info((Object)"testAlphaNumericDBNumOldYear");
        Division div = (Division)session.createCriteria(Division.class).list().get(0);
        Accession accession = DataBuilder.createAccession(div, "XXX", "XXXX", "2005-IC-001", "XXXX", Calendar.getInstance(), Calendar.getInstance());
        HibernateUtil.beginTransaction();
        TestAutoNumbering.persist(accession);
        HibernateUtil.commitTransaction();
        UIFieldFormatterIFace fmt = fmtMgr.getFmt("AccessionNumber");
        ValFormattedTextField valText = new ValFormattedTextField(fmt, false);
        valText.setValue(null, null);
        valText.setText("2005-IC-###");
        valText.updateAutoNumbers();
        this.log.info(valText.getValue());
        div.removeReference(accession, "accessions");
        HibernateUtil.beginTransaction();
        session.delete((Object)accession);
        HibernateUtil.commitTransaction();
        TestAutoNumbering.assertEquals((Object)valText.getValue(), (Object)"2005-IC-002");
    }

    @After
    public void tearDown() throws Exception {
        this.log.info((Object)"tearDown");
    }

    class MyFmtMgr
    extends SpecifyUIFieldFormatterMgr {
        public MyFmtMgr() {
            this.load();
        }

        @Override
        protected Element getDOM() throws Exception {
            return XMLHelper.readDOMFromConfigDir("backstop/uiformatters.xml");
        }

        public UIFieldFormatterIFace getFmt(String name) {
            return this.getFormatterInternal(name);
        }
    }
}

