/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;

public class SpecifyUserTestHelper {
    private static final Logger log = Logger.getLogger(SpecifyUserTestHelper.class);

    public static boolean isSpecifyUserInDB(Integer userId) {
        log.info((Object)("isSpecifyUserInDB: " + userId));
        if (userId == null) {
            return false;
        }
        boolean found = false;
        Criteria criteria = HibernateUtil.getCurrentSession().createCriteria(SpecifyUser.class);
        List list = criteria.list();
        int i = 0;
        while (i < list.size()) {
            SpecifyUser user = (SpecifyUser)list.get(i);
            if (user.getId().equals(userId)) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public static boolean isUserGroupInDB(Integer groupId) {
        log.info((Object)("isUserGroupInDB: " + groupId));
        if (groupId == null) {
            return false;
        }
        boolean found = false;
        Criteria criteria = HibernateUtil.getCurrentSession().createCriteria(SpPrincipal.class);
        List list = criteria.list();
        int i = 0;
        while (i < list.size()) {
            SpPrincipal user = (SpPrincipal)list.get(i);
            if (user.getId().equals(groupId)) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public static boolean deleteUserGroupFromDB(Integer groupId) {
        log.info((Object)("deleteUserGroupFromDB(): " + groupId));
        boolean isDeleted = false;
        try {
            HibernateUtil.beginTransaction();
            Criteria criteria = HibernateUtil.getCurrentSession().createCriteria(SpPrincipal.class);
            List list = criteria.list();
            int i = 0;
            while (i < list.size()) {
                SpPrincipal group = (SpPrincipal)list.get(i);
                if (group.getUserGroupId().equals(groupId)) {
                    HibernateUtil.getCurrentSession().delete((Object)group);
                    isDeleted = true;
                }
                ++i;
            }
            HibernateUtil.commitTransaction();
            return isDeleted;
        }
        catch (Exception ex) {
            log.error((Object)("******* " + ex));
            ex.printStackTrace();
            HibernateUtil.rollbackTransaction();
            return false;
        }
    }

    public static boolean deleteSpecifyUserDB(Integer userId) {
        log.info((Object)("deleteSpecifyUserDB(): " + userId));
        boolean isDeleted = false;
        try {
            HibernateUtil.beginTransaction();
            Criteria criteria = HibernateUtil.getCurrentSession().createCriteria(SpecifyUser.class);
            List list = criteria.list();
            int i = 0;
            while (i < list.size()) {
                SpecifyUser user = (SpecifyUser)list.get(i);
                if (user.getId().equals(userId)) {
                    HibernateUtil.getCurrentSession().delete((Object)user);
                    isDeleted = true;
                }
                ++i;
            }
            HibernateUtil.commitTransaction();
            return isDeleted;
        }
        catch (Exception ex) {
            log.error((Object)("******* " + ex));
            ex.printStackTrace();
            HibernateUtil.rollbackTransaction();
            return false;
        }
    }
}

