/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.tests.AppPreferenceHelper;
import edu.ku.brc.specify.tests.SpecifyUserTestHelper;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class SpecifyUserTest
extends TestCase {
    private static final Logger log = Logger.getLogger(SpecifyUserTest.class);

    public SpecifyUserTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        AppPreferenceHelper.setupPreferences();
        HibernateUtil.beginTransaction();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        HibernateUtil.commitTransaction();
    }

    public void testCreateSingleUser() {
        log.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        log.info((Object)"Testing creating and deleting SpecifyUser");
        log.info((Object)"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        String testUserName = "testuser";
        String testUserPWd = "testpwd";
        String testUserEmail = "testuser@ku.edu";
        String testUserRole = "testType";
        try {
            log.info((Object)"Creating SpecifyUser");
            SpecifyUser testUser = DataBuilder.createSpecifyUser(testUserName, testUserEmail, testUserPWd, testUserRole);
            SpecifyUserTest.assertNotNull((String)"SpecifyUser created is null. ", (Object)testUser);
            log.info((Object)("checking if the SpecifyUser exists in the database ID: " + testUser.getId()));
            SpecifyUserTest.assertTrue((String)"SpecifyUser was not found in th database.", (boolean)SpecifyUserTestHelper.isSpecifyUserInDB(testUser.getId()));
            SpecifyUserTest.assertTrue((String)"SpecifyUser failed to be deleted from the database.", (boolean)SpecifyUserTestHelper.deleteSpecifyUserDB(testUser.getId()));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyUserTest.class, ex);
            log.error((Object)("******* " + ex));
            ex.printStackTrace();
            HibernateUtil.rollbackTransaction();
            SpecifyUserTest.assertTrue((boolean)false);
        }
    }

    public void testUserUniqueNames() {
        log.info((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        log.info((Object)"Testing creating 2 SpecifyUsers with the same name");
        log.info((Object)"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        String testUserName = "testuser";
        String testUserEmail = "testuser@ku.edu";
        String testUserRole = "Test Role";
        String testUserPwd = "testpwd";
        try {
            log.info((Object)"Creating SpecifyUser");
            SpecifyUser testUser = DataBuilder.createSpecifyUser(testUserName, testUserEmail, testUserPwd, testUserRole);
            SpecifyUserTest.assertNotNull((String)"SpecifyUser created is null. ", (Object)testUser);
            log.info((Object)("Checking if the SpecifyUser exists in the database ID: " + testUser.getId()));
            SpecifyUserTest.assertTrue((String)"SpecifyUser was not found in th database.", (boolean)SpecifyUserTestHelper.isSpecifyUserInDB(testUser.getId()));
            HibernateUtil.commitTransaction();
            HibernateUtil.beginTransaction();
            boolean shouldNotBeCreated = false;
            try {
                log.info((Object)"Creating 2nd SpecifyUser with same name - this should not be possible");
                SpecifyUser testUser2 = DataBuilder.createSpecifyUser(testUserName, testUserEmail, testUserPwd, testUserRole);
                if (testUser2 == null) {
                    shouldNotBeCreated = true;
                }
            }
            catch (Exception i) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyUserTest.class, i);
                HibernateUtil.rollbackTransaction();
                shouldNotBeCreated = true;
            }
            SpecifyUserTest.assertTrue((String)"SpecifyUser with duplicate name should not have been created in db", (boolean)shouldNotBeCreated);
            SpecifyUserTest.assertTrue((String)"SpecifyUser failed to be deleted from the database.", (boolean)SpecifyUserTestHelper.deleteSpecifyUserDB(testUser.getId()));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyUserTest.class, ex);
            log.error((Object)("******* " + ex));
            ex.printStackTrace();
            HibernateUtil.rollbackTransaction();
            SpecifyUserTest.assertTrue((String)"Some sort of exception was caught.", (boolean)false);
        }
    }
}

