/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class PreferenceTest
extends TestCase {
    private static final Logger log = Logger.getLogger(PreferenceTest.class);
    private static final String databaseName = "fish";
    protected AppPreferences appPrefs = null;

    protected void setUp() {
        UIRegistry.getInstance();
        if (UIRegistry.getAppName() == null) {
            System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
            System.setProperty("AppPrefsIOClassName", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
            UIRegistry.getInstance();
            UIRegistry.setAppName("Specify");
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.setDirPath(UIRegistry.getAppDataDir());
            localPrefs.load();
            Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
            String hostName = "localhost";
            if (!UIHelper.tryLogin("com.mysql.jdbc.Driver", "org.hibernate.dialect.MySQLDialect", databaseName, "jdbc:mysql://" + hostName + "/" + databaseName, (String)usernamePassword.first, (String)usernamePassword.second)) {
                throw new RuntimeException("Couldn't login into [fish] " + DBConnection.getInstance().getErrorMsg());
            }
            HibernateUtil.getCurrentSession();
            AppPreferences.getRemote().load();
        }
    }

    public void testLocalPrefs() {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.put("test", "test");
        try {
            localPrefs.flush();
        }
        catch (Exception ex) {
            PreferenceTest.assertTrue((boolean)false);
        }
        String test = localPrefs.get("test", null);
        PreferenceTest.assertNotNull((Object)test);
        PreferenceTest.assertTrue((boolean)test.equals("test"));
    }

    protected void updatePref(String section, String pref, String attr, String value) {
        AppPreferences.getRemote().put(String.valueOf(section) + "." + pref + "." + attr, value);
    }

    public void testStrings() {
        block6: {
            AppPreferences appPrefsMgr = AppPreferences.getRemote();
            appPrefsMgr.put("text.ui.str", "string value");
            appPrefsMgr.put("text.ui.formatting.str", "string value");
            appPrefsMgr.put("text.ui.formatting.xxx.str", "string value");
            String[] keys = appPrefsMgr.keys("text.ui");
            log.info((Object)"Keys:");
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                log.info((Object)s);
                ++n2;
            }
            assert (keys.length != 1);
            String[] names = appPrefsMgr.childrenNames("text.ui");
            log.info((Object)"Child Names:");
            String[] stringArray2 = names;
            int n3 = names.length;
            n = 0;
            while (n < n3) {
                String s = stringArray2[n];
                log.info((Object)s);
                ++n;
            }
            assert (names.length != 1);
            try {
                appPrefsMgr.flush();
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testSimpleDateFormat() {
        FastDateFormat fastDateFormat = FastDateFormat.getDateInstance((int)3);
        SimpleDateFormat df = new SimpleDateFormat(fastDateFormat.getPattern());
        log.info((Object)df.toPattern());
        log.info((Object)df.format(new Date()));
        fastDateFormat = FastDateFormat.getDateInstance((int)2);
        df = new SimpleDateFormat(fastDateFormat.getPattern());
        log.info((Object)df.toPattern());
        log.info((Object)df.format(new Date()));
        fastDateFormat = FastDateFormat.getDateInstance((int)1);
        df = new SimpleDateFormat(fastDateFormat.getPattern());
        log.info((Object)df.toPattern());
        log.info((Object)df.format(new Date()));
    }

    public void testColorWrapper() {
        ColorWrapper cw;
        try {
            cw = new ColorWrapper("xx, 1, 1");
            PreferenceTest.assertFalse((boolean)false);
        }
        catch (RuntimeException re) {
            PreferenceTest.assertTrue((boolean)true);
        }
        try {
            cw = new ColorWrapper("1, 1");
            PreferenceTest.assertFalse((boolean)false);
        }
        catch (RuntimeException re) {
            PreferenceTest.assertTrue((boolean)true);
        }
        try {
            cw = new ColorWrapper("");
            PreferenceTest.assertFalse((boolean)false);
        }
        catch (RuntimeException re) {
            PreferenceTest.assertTrue((boolean)true);
        }
        try {
            cw = new ColorWrapper(null);
            PreferenceTest.assertFalse((boolean)false);
        }
        catch (RuntimeException re) {
            PreferenceTest.assertTrue((boolean)true);
        }
        try {
            cw = new ColorWrapper(null);
            PreferenceTest.assertFalse((boolean)false);
        }
        catch (RuntimeException re) {
            PreferenceTest.assertTrue((boolean)true);
        }
        cw = new ColorWrapper("128, 255, 32");
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper(128, 255, 32);
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper(128, 999, 32);
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper("128,255,32");
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper("0,0,0");
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        cw.setRGB(128, 999, 32);
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper("0,0,0");
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        cw.setRGB("128,255,32");
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper(new Color(128, 255, 32));
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
        cw = new ColorWrapper(new Color(0, 0, 0));
        log.info((Object)(cw + "  " + cw.getColor().toString()));
        cw.setColor(new Color(128, 255, 32));
        PreferenceTest.assertTrue((cw.getColor().getRed() == 128 && cw.getColor().getGreen() == 255 && cw.getColor().getBlue() == 32 ? 1 : 0) != 0);
    }

    public void testDateFormatCache() {
        SimpleDateFormat format = new SimpleDateFormat("MM/DD/yyyy");
        Date date = Calendar.getInstance().getTime();
        AppPrefsCache.register(format, "ui", "formatting", "dateTest");
        String newFormat = "yyyy/MM/DD";
        AppPreferences.getRemote().put("ui.formatting.dateTest", newFormat);
        log.info((Object)("New Date Format: " + format.toPattern()));
        log.info((Object)format.format(date));
        log.info((Object)("Actual pref value[" + AppPrefsCache.getValue("ui", "formatting", "dateTest") + "]"));
        log.info((Object)("newFormat[" + newFormat + "]"));
        PreferenceTest.assertTrue((boolean)AppPrefsCache.getValue("ui", "formatting", "dateTest").equals(newFormat));
        PreferenceTest.assertTrue((boolean)format.toPattern().equals(newFormat));
    }

    public void testColorWrapperCache() {
        String attrName = "valErrColorTest";
        ColorWrapper colorWrapper = new ColorWrapper("255, 128, 64");
        Color oldColor = new Color(255, 128, 64);
        PreferenceTest.assertTrue((boolean)oldColor.toString().equals(colorWrapper.getColor().toString()));
        AppPrefsCache.register(colorWrapper, "ui", "formatting", attrName);
        String newColorStr = "64, 255, 128";
        AppPreferences.getRemote().put("ui.formatting." + attrName, newColorStr);
        log.info((Object)("New Color: " + colorWrapper.toString() + " [" + newColorStr + "]"));
        PreferenceTest.assertTrue((boolean)AppPrefsCache.getValue("ui", "formatting", attrName).equals(newColorStr));
        PreferenceTest.assertTrue((boolean)colorWrapper.toString().equals(newColorStr));
    }

    public void testPrefSetGet() {
        String rgb = "255, 0, 0";
        AppPrefsCache.register("ui", "formatting", "testColor", rgb);
        PreferenceTest.assertTrue((boolean)AppPrefsCache.getValue("ui", "formatting", "testColor").equals(rgb));
    }

    public void testPrefSetUpdateGet() {
        String rgb = "255, 0, 0";
        String newRGB = "255, 255, 255";
        AppPrefsCache.register("ui", "formatting", "testColor", rgb);
        this.updatePref("ui", "formatting", "testColor", newRGB);
        log.info((Object)("New RGB: " + AppPrefsCache.getValue("ui", "formatting", "testColor")));
        log.info((Object)("newRGB:  " + newRGB));
        PreferenceTest.assertTrue((boolean)AppPrefsCache.getValue("ui", "formatting", "testColor").equals(newRGB));
    }

    public void testRemovePrefs() {
        PreferenceTest.assertTrue((boolean)AppPrefsCache.remove("ui", "formatting", "testColor"));
        PreferenceTest.assertTrue((boolean)AppPrefsCache.remove("ui", "formatting", "dateTest"));
        PreferenceTest.assertTrue((boolean)AppPrefsCache.remove("ui", "formatting", "valErrColorTest"));
    }
}

