/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.PopupDlg;
import edu.ku.brc.af.ui.PopupDlgPrefsMgr;
import edu.ku.brc.specify.tests.AppPreferenceHelper;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class PopupDlgTests
extends TestCase {
    private static final Logger log = Logger.getLogger(PopupDlgTests.class);
    private Random generator = new Random();
    protected AppPreferences appPrefs = null;

    public PopupDlgTests(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        AppPreferenceHelper.setupPreferences();
    }

    public void testDisablingOfDialog() {
        log.info((Object)"JUNIT TEST - test Disabling Of Dialog");
        String message = "ABCDEFGHIJKLMNOPQRSTUVWXYZ?";
        String title = "Title";
        int dialogNumber = this.generator.nextInt();
        String callingClassname = ((Object)((Object)this)).getClass().toString();
        int userSelection = PopupDlg.YES_OPTION;
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogId = popupMgr.generatePopupDialogId(title, message, String.valueOf(callingClassname) + dialogNumber);
        PopupDlgTests.assertFalse((String)("FAILURE - Dialog should not be disabled yet [" + dialogId + "] User Selection: [" + userSelection + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
        popupMgr.disableDialog(dialogId, userSelection);
        PopupDlgTests.assertTrue((String)("FAILURE - did not disable dialog. DialogId: [" + dialogId + "] User Selection: [" + userSelection + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
        popupMgr.removeDialogFromPrefs(dialogId);
        PopupDlgTests.assertFalse((String)("FAILURE -Dialog failed to remove Dialog from prefs . DialogId: [" + dialogId + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
    }

    public void testRetrievalOfUserSelectionFromDisabledDialog() {
        log.info((Object)"JUNIT TEST - test Retrieval Of User Selection From Disabled Dialog");
        String message = "ABCDEFGHIJKLMNOPQRSTUVWXYZ?";
        String title = "Title";
        int dialogNumber = this.generator.nextInt();
        String callingClassname = ((Object)((Object)this)).getClass().toString();
        int userSelection = PopupDlg.YES_OPTION;
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogId = popupMgr.generatePopupDialogId(title, message, String.valueOf(callingClassname) + dialogNumber);
        PopupDlgTests.assertFalse((String)("FAILURE - Dialog should not be disabled yet [" + dialogId + "] User Selection: [" + userSelection + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
        popupMgr.disableDialog(dialogId, userSelection);
        PopupDlgTests.assertTrue((String)("FAILURE - did not disable dialog. DialogId: [" + dialogId + "] User Selection: [" + userSelection + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
        int foundVal = popupMgr.getDisabledDialogOptionSelection(dialogId);
        PopupDlgTests.assertEquals((String)("FAILURE - user selection value was not stored correctly. DialogId:" + dialogId + " Expected Value: [" + userSelection + "] Found value: [" + foundVal + "]"), (int)userSelection, (int)foundVal);
        popupMgr.removeDialogFromPrefs(dialogId);
        PopupDlgTests.assertFalse((String)("FAILURE - Dialog failed to remove Dialog from prefs. DialogId: [" + dialogId + "]"), (boolean)popupMgr.isDialogDisabled(dialogId));
    }

    public void testNonExistentDialog() {
        log.info((Object)"JUNIT TEST - test to make sure non existent dialog is not disabled.");
        PopupDlgPrefsMgr popupMgr = new PopupDlgPrefsMgr();
        int dialogNumber = this.generator.nextInt();
        PopupDlgTests.assertFalse((String)("FAILURE - Dialog found to be disabled when it was not disabled. DialogId: [" + dialogNumber + "]"), (boolean)popupMgr.isDialogDisabled(dialogNumber));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        log.info((Object)"Tearing down");
    }

    public static void main(String[] args) {
    }
}

